/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cleanroomsml.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cleanroomsml.model.CleanRoomsMlResponse;
import software.amazon.awssdk.services.cleanroomsml.model.CollaborationTrainedModelListCopier;
import software.amazon.awssdk.services.cleanroomsml.model.CollaborationTrainedModelSummary;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListCollaborationTrainedModelsResponse
extends CleanRoomsMlResponse
implements ToCopyableBuilder<Builder, ListCollaborationTrainedModelsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListCollaborationTrainedModelsResponse.getter(ListCollaborationTrainedModelsResponse::nextToken)).setter(ListCollaborationTrainedModelsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<List<CollaborationTrainedModelSummary>> COLLABORATION_TRAINED_MODELS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("collaborationTrainedModels").getter(ListCollaborationTrainedModelsResponse.getter(ListCollaborationTrainedModelsResponse::collaborationTrainedModels)).setter(ListCollaborationTrainedModelsResponse.setter(Builder::collaborationTrainedModels)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("collaborationTrainedModels").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CollaborationTrainedModelSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, COLLABORATION_TRAINED_MODELS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("nextToken", NEXT_TOKEN_FIELD);
            this.put("collaborationTrainedModels", COLLABORATION_TRAINED_MODELS_FIELD);
        }
    });
    private final String nextToken;
    private final List<CollaborationTrainedModelSummary> collaborationTrainedModels;

    private ListCollaborationTrainedModelsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.collaborationTrainedModels = builder.collaborationTrainedModels;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasCollaborationTrainedModels() {
        return this.collaborationTrainedModels != null && !(this.collaborationTrainedModels instanceof SdkAutoConstructList);
    }

    public final List<CollaborationTrainedModelSummary> collaborationTrainedModels() {
        return this.collaborationTrainedModels;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCollaborationTrainedModels() ? this.collaborationTrainedModels() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCollaborationTrainedModelsResponse)) {
            return false;
        }
        ListCollaborationTrainedModelsResponse other = (ListCollaborationTrainedModelsResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasCollaborationTrainedModels() == other.hasCollaborationTrainedModels() && Objects.equals(this.collaborationTrainedModels(), other.collaborationTrainedModels());
    }

    public final String toString() {
        return ToString.builder((String)"ListCollaborationTrainedModelsResponse").add("NextToken", (Object)this.nextToken()).add("CollaborationTrainedModels", this.hasCollaborationTrainedModels() ? this.collaborationTrainedModels() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "collaborationTrainedModels": {
                return Optional.ofNullable(clazz.cast(this.collaborationTrainedModels()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListCollaborationTrainedModelsResponse, T> g) {
        return obj -> g.apply((ListCollaborationTrainedModelsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CleanRoomsMlResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<CollaborationTrainedModelSummary> collaborationTrainedModels = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListCollaborationTrainedModelsResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.collaborationTrainedModels(model.collaborationTrainedModels);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<CollaborationTrainedModelSummary.Builder> getCollaborationTrainedModels() {
            List<CollaborationTrainedModelSummary.Builder> result = CollaborationTrainedModelListCopier.copyToBuilder(this.collaborationTrainedModels);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCollaborationTrainedModels(Collection<CollaborationTrainedModelSummary.BuilderImpl> collaborationTrainedModels) {
            this.collaborationTrainedModels = CollaborationTrainedModelListCopier.copyFromBuilder(collaborationTrainedModels);
        }

        @Override
        public final Builder collaborationTrainedModels(Collection<CollaborationTrainedModelSummary> collaborationTrainedModels) {
            this.collaborationTrainedModels = CollaborationTrainedModelListCopier.copy(collaborationTrainedModels);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder collaborationTrainedModels(CollaborationTrainedModelSummary ... collaborationTrainedModels) {
            this.collaborationTrainedModels(Arrays.asList(collaborationTrainedModels));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder collaborationTrainedModels(Consumer<CollaborationTrainedModelSummary.Builder> ... collaborationTrainedModels) {
            this.collaborationTrainedModels(Stream.of(collaborationTrainedModels).map(c -> (CollaborationTrainedModelSummary)((CollaborationTrainedModelSummary.Builder)CollaborationTrainedModelSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListCollaborationTrainedModelsResponse build() {
            return new ListCollaborationTrainedModelsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends CleanRoomsMlResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListCollaborationTrainedModelsResponse> {
        public Builder nextToken(String var1);

        public Builder collaborationTrainedModels(Collection<CollaborationTrainedModelSummary> var1);

        public Builder collaborationTrainedModels(CollaborationTrainedModelSummary ... var1);

        public Builder collaborationTrainedModels(Consumer<CollaborationTrainedModelSummary.Builder> ... var1);
    }
}

