/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cleanroomsml.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cleanroomsml.model.CleanRoomsMlRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetCollaborationTrainedModelRequest
extends CleanRoomsMlRequest
implements ToCopyableBuilder<Builder, GetCollaborationTrainedModelRequest> {
    private static final SdkField<String> TRAINED_MODEL_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("trainedModelArn").getter(GetCollaborationTrainedModelRequest.getter(GetCollaborationTrainedModelRequest::trainedModelArn)).setter(GetCollaborationTrainedModelRequest.setter(Builder::trainedModelArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("trainedModelArn").build()}).build();
    private static final SdkField<String> COLLABORATION_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("collaborationIdentifier").getter(GetCollaborationTrainedModelRequest.getter(GetCollaborationTrainedModelRequest::collaborationIdentifier)).setter(GetCollaborationTrainedModelRequest.setter(Builder::collaborationIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("collaborationIdentifier").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRAINED_MODEL_ARN_FIELD, COLLABORATION_IDENTIFIER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("trainedModelArn", TRAINED_MODEL_ARN_FIELD);
            this.put("collaborationIdentifier", COLLABORATION_IDENTIFIER_FIELD);
        }
    });
    private final String trainedModelArn;
    private final String collaborationIdentifier;

    private GetCollaborationTrainedModelRequest(BuilderImpl builder) {
        super(builder);
        this.trainedModelArn = builder.trainedModelArn;
        this.collaborationIdentifier = builder.collaborationIdentifier;
    }

    public final String trainedModelArn() {
        return this.trainedModelArn;
    }

    public final String collaborationIdentifier() {
        return this.collaborationIdentifier;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.trainedModelArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.collaborationIdentifier());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetCollaborationTrainedModelRequest)) {
            return false;
        }
        GetCollaborationTrainedModelRequest other = (GetCollaborationTrainedModelRequest)((Object)obj);
        return Objects.equals(this.trainedModelArn(), other.trainedModelArn()) && Objects.equals(this.collaborationIdentifier(), other.collaborationIdentifier());
    }

    public final String toString() {
        return ToString.builder((String)"GetCollaborationTrainedModelRequest").add("TrainedModelArn", (Object)this.trainedModelArn()).add("CollaborationIdentifier", (Object)this.collaborationIdentifier()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "trainedModelArn": {
                return Optional.ofNullable(clazz.cast(this.trainedModelArn()));
            }
            case "collaborationIdentifier": {
                return Optional.ofNullable(clazz.cast(this.collaborationIdentifier()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GetCollaborationTrainedModelRequest, T> g) {
        return obj -> g.apply((GetCollaborationTrainedModelRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CleanRoomsMlRequest.BuilderImpl
    implements Builder {
        private String trainedModelArn;
        private String collaborationIdentifier;

        private BuilderImpl() {
        }

        private BuilderImpl(GetCollaborationTrainedModelRequest model) {
            super(model);
            this.trainedModelArn(model.trainedModelArn);
            this.collaborationIdentifier(model.collaborationIdentifier);
        }

        public final String getTrainedModelArn() {
            return this.trainedModelArn;
        }

        public final void setTrainedModelArn(String trainedModelArn) {
            this.trainedModelArn = trainedModelArn;
        }

        @Override
        public final Builder trainedModelArn(String trainedModelArn) {
            this.trainedModelArn = trainedModelArn;
            return this;
        }

        public final String getCollaborationIdentifier() {
            return this.collaborationIdentifier;
        }

        public final void setCollaborationIdentifier(String collaborationIdentifier) {
            this.collaborationIdentifier = collaborationIdentifier;
        }

        @Override
        public final Builder collaborationIdentifier(String collaborationIdentifier) {
            this.collaborationIdentifier = collaborationIdentifier;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetCollaborationTrainedModelRequest build() {
            return new GetCollaborationTrainedModelRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends CleanRoomsMlRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetCollaborationTrainedModelRequest> {
        public Builder trainedModelArn(String var1);

        public Builder collaborationIdentifier(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

