/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cleanroomsml.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cleanroomsml.model.CleanRoomsMlResponse;
import software.amazon.awssdk.services.cleanroomsml.model.CollaborationMLInputChannelSummary;
import software.amazon.awssdk.services.cleanroomsml.model.CollaborationMLInputChannelsListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListCollaborationMlInputChannelsResponse
extends CleanRoomsMlResponse
implements ToCopyableBuilder<Builder, ListCollaborationMlInputChannelsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListCollaborationMlInputChannelsResponse.getter(ListCollaborationMlInputChannelsResponse::nextToken)).setter(ListCollaborationMlInputChannelsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<List<CollaborationMLInputChannelSummary>> COLLABORATION_ML_INPUT_CHANNELS_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("collaborationMLInputChannelsList").getter(ListCollaborationMlInputChannelsResponse.getter(ListCollaborationMlInputChannelsResponse::collaborationMLInputChannelsList)).setter(ListCollaborationMlInputChannelsResponse.setter(Builder::collaborationMLInputChannelsList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("collaborationMLInputChannelsList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CollaborationMLInputChannelSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, COLLABORATION_ML_INPUT_CHANNELS_LIST_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("nextToken", NEXT_TOKEN_FIELD);
            this.put("collaborationMLInputChannelsList", COLLABORATION_ML_INPUT_CHANNELS_LIST_FIELD);
        }
    });
    private final String nextToken;
    private final List<CollaborationMLInputChannelSummary> collaborationMLInputChannelsList;

    private ListCollaborationMlInputChannelsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.collaborationMLInputChannelsList = builder.collaborationMLInputChannelsList;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasCollaborationMLInputChannelsList() {
        return this.collaborationMLInputChannelsList != null && !(this.collaborationMLInputChannelsList instanceof SdkAutoConstructList);
    }

    public final List<CollaborationMLInputChannelSummary> collaborationMLInputChannelsList() {
        return this.collaborationMLInputChannelsList;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCollaborationMLInputChannelsList() ? this.collaborationMLInputChannelsList() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCollaborationMlInputChannelsResponse)) {
            return false;
        }
        ListCollaborationMlInputChannelsResponse other = (ListCollaborationMlInputChannelsResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasCollaborationMLInputChannelsList() == other.hasCollaborationMLInputChannelsList() && Objects.equals(this.collaborationMLInputChannelsList(), other.collaborationMLInputChannelsList());
    }

    public final String toString() {
        return ToString.builder((String)"ListCollaborationMlInputChannelsResponse").add("NextToken", (Object)this.nextToken()).add("CollaborationMLInputChannelsList", this.hasCollaborationMLInputChannelsList() ? this.collaborationMLInputChannelsList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "collaborationMLInputChannelsList": {
                return Optional.ofNullable(clazz.cast(this.collaborationMLInputChannelsList()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListCollaborationMlInputChannelsResponse, T> g) {
        return obj -> g.apply((ListCollaborationMlInputChannelsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CleanRoomsMlResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<CollaborationMLInputChannelSummary> collaborationMLInputChannelsList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListCollaborationMlInputChannelsResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.collaborationMLInputChannelsList(model.collaborationMLInputChannelsList);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<CollaborationMLInputChannelSummary.Builder> getCollaborationMLInputChannelsList() {
            List<CollaborationMLInputChannelSummary.Builder> result = CollaborationMLInputChannelsListCopier.copyToBuilder(this.collaborationMLInputChannelsList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCollaborationMLInputChannelsList(Collection<CollaborationMLInputChannelSummary.BuilderImpl> collaborationMLInputChannelsList) {
            this.collaborationMLInputChannelsList = CollaborationMLInputChannelsListCopier.copyFromBuilder(collaborationMLInputChannelsList);
        }

        @Override
        public final Builder collaborationMLInputChannelsList(Collection<CollaborationMLInputChannelSummary> collaborationMLInputChannelsList) {
            this.collaborationMLInputChannelsList = CollaborationMLInputChannelsListCopier.copy(collaborationMLInputChannelsList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder collaborationMLInputChannelsList(CollaborationMLInputChannelSummary ... collaborationMLInputChannelsList) {
            this.collaborationMLInputChannelsList(Arrays.asList(collaborationMLInputChannelsList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder collaborationMLInputChannelsList(Consumer<CollaborationMLInputChannelSummary.Builder> ... collaborationMLInputChannelsList) {
            this.collaborationMLInputChannelsList(Stream.of(collaborationMLInputChannelsList).map(c -> (CollaborationMLInputChannelSummary)((CollaborationMLInputChannelSummary.Builder)CollaborationMLInputChannelSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListCollaborationMlInputChannelsResponse build() {
            return new ListCollaborationMlInputChannelsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends CleanRoomsMlResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListCollaborationMlInputChannelsResponse> {
        public Builder nextToken(String var1);

        public Builder collaborationMLInputChannelsList(Collection<CollaborationMLInputChannelSummary> var1);

        public Builder collaborationMLInputChannelsList(CollaborationMLInputChannelSummary ... var1);

        public Builder collaborationMLInputChannelsList(Consumer<CollaborationMLInputChannelSummary.Builder> ... var1);
    }
}

