/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cleanroomsml.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cleanroomsml.model.CollaborationMLInputChannelSummaryConfiguredModelAlgorithmAssociationsListCopier;
import software.amazon.awssdk.services.cleanroomsml.model.MLInputChannelStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CollaborationMLInputChannelSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CollaborationMLInputChannelSummary> {
    private static final SdkField<Instant> CREATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createTime").getter(CollaborationMLInputChannelSummary.getter(CollaborationMLInputChannelSummary::createTime)).setter(CollaborationMLInputChannelSummary.setter(Builder::createTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Instant> UPDATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("updateTime").getter(CollaborationMLInputChannelSummary.getter(CollaborationMLInputChannelSummary::updateTime)).setter(CollaborationMLInputChannelSummary.setter(Builder::updateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updateTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> MEMBERSHIP_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("membershipIdentifier").getter(CollaborationMLInputChannelSummary.getter(CollaborationMLInputChannelSummary::membershipIdentifier)).setter(CollaborationMLInputChannelSummary.setter(Builder::membershipIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("membershipIdentifier").build()}).build();
    private static final SdkField<String> COLLABORATION_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("collaborationIdentifier").getter(CollaborationMLInputChannelSummary.getter(CollaborationMLInputChannelSummary::collaborationIdentifier)).setter(CollaborationMLInputChannelSummary.setter(Builder::collaborationIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("collaborationIdentifier").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(CollaborationMLInputChannelSummary.getter(CollaborationMLInputChannelSummary::name)).setter(CollaborationMLInputChannelSummary.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<List<String>> CONFIGURED_MODEL_ALGORITHM_ASSOCIATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("configuredModelAlgorithmAssociations").getter(CollaborationMLInputChannelSummary.getter(CollaborationMLInputChannelSummary::configuredModelAlgorithmAssociations)).setter(CollaborationMLInputChannelSummary.setter(Builder::configuredModelAlgorithmAssociations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configuredModelAlgorithmAssociations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> ML_INPUT_CHANNEL_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("mlInputChannelArn").getter(CollaborationMLInputChannelSummary.getter(CollaborationMLInputChannelSummary::mlInputChannelArn)).setter(CollaborationMLInputChannelSummary.setter(Builder::mlInputChannelArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mlInputChannelArn").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(CollaborationMLInputChannelSummary.getter(CollaborationMLInputChannelSummary::statusAsString)).setter(CollaborationMLInputChannelSummary.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> CREATOR_ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("creatorAccountId").getter(CollaborationMLInputChannelSummary.getter(CollaborationMLInputChannelSummary::creatorAccountId)).setter(CollaborationMLInputChannelSummary.setter(Builder::creatorAccountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creatorAccountId").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(CollaborationMLInputChannelSummary.getter(CollaborationMLInputChannelSummary::description)).setter(CollaborationMLInputChannelSummary.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATE_TIME_FIELD, UPDATE_TIME_FIELD, MEMBERSHIP_IDENTIFIER_FIELD, COLLABORATION_IDENTIFIER_FIELD, NAME_FIELD, CONFIGURED_MODEL_ALGORITHM_ASSOCIATIONS_FIELD, ML_INPUT_CHANNEL_ARN_FIELD, STATUS_FIELD, CREATOR_ACCOUNT_ID_FIELD, DESCRIPTION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("createTime", CREATE_TIME_FIELD);
            this.put("updateTime", UPDATE_TIME_FIELD);
            this.put("membershipIdentifier", MEMBERSHIP_IDENTIFIER_FIELD);
            this.put("collaborationIdentifier", COLLABORATION_IDENTIFIER_FIELD);
            this.put("name", NAME_FIELD);
            this.put("configuredModelAlgorithmAssociations", CONFIGURED_MODEL_ALGORITHM_ASSOCIATIONS_FIELD);
            this.put("mlInputChannelArn", ML_INPUT_CHANNEL_ARN_FIELD);
            this.put("status", STATUS_FIELD);
            this.put("creatorAccountId", CREATOR_ACCOUNT_ID_FIELD);
            this.put("description", DESCRIPTION_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final Instant createTime;
    private final Instant updateTime;
    private final String membershipIdentifier;
    private final String collaborationIdentifier;
    private final String name;
    private final List<String> configuredModelAlgorithmAssociations;
    private final String mlInputChannelArn;
    private final String status;
    private final String creatorAccountId;
    private final String description;

    private CollaborationMLInputChannelSummary(BuilderImpl builder) {
        this.createTime = builder.createTime;
        this.updateTime = builder.updateTime;
        this.membershipIdentifier = builder.membershipIdentifier;
        this.collaborationIdentifier = builder.collaborationIdentifier;
        this.name = builder.name;
        this.configuredModelAlgorithmAssociations = builder.configuredModelAlgorithmAssociations;
        this.mlInputChannelArn = builder.mlInputChannelArn;
        this.status = builder.status;
        this.creatorAccountId = builder.creatorAccountId;
        this.description = builder.description;
    }

    public final Instant createTime() {
        return this.createTime;
    }

    public final Instant updateTime() {
        return this.updateTime;
    }

    public final String membershipIdentifier() {
        return this.membershipIdentifier;
    }

    public final String collaborationIdentifier() {
        return this.collaborationIdentifier;
    }

    public final String name() {
        return this.name;
    }

    public final boolean hasConfiguredModelAlgorithmAssociations() {
        return this.configuredModelAlgorithmAssociations != null && !(this.configuredModelAlgorithmAssociations instanceof SdkAutoConstructList);
    }

    public final List<String> configuredModelAlgorithmAssociations() {
        return this.configuredModelAlgorithmAssociations;
    }

    public final String mlInputChannelArn() {
        return this.mlInputChannelArn;
    }

    public final MLInputChannelStatus status() {
        return MLInputChannelStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String creatorAccountId() {
        return this.creatorAccountId;
    }

    public final String description() {
        return this.description;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.createTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.updateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.membershipIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.collaborationIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasConfiguredModelAlgorithmAssociations() ? this.configuredModelAlgorithmAssociations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.mlInputChannelArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.creatorAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CollaborationMLInputChannelSummary)) {
            return false;
        }
        CollaborationMLInputChannelSummary other = (CollaborationMLInputChannelSummary)obj;
        return Objects.equals(this.createTime(), other.createTime()) && Objects.equals(this.updateTime(), other.updateTime()) && Objects.equals(this.membershipIdentifier(), other.membershipIdentifier()) && Objects.equals(this.collaborationIdentifier(), other.collaborationIdentifier()) && Objects.equals(this.name(), other.name()) && this.hasConfiguredModelAlgorithmAssociations() == other.hasConfiguredModelAlgorithmAssociations() && Objects.equals(this.configuredModelAlgorithmAssociations(), other.configuredModelAlgorithmAssociations()) && Objects.equals(this.mlInputChannelArn(), other.mlInputChannelArn()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.creatorAccountId(), other.creatorAccountId()) && Objects.equals(this.description(), other.description());
    }

    public final String toString() {
        return ToString.builder((String)"CollaborationMLInputChannelSummary").add("CreateTime", (Object)this.createTime()).add("UpdateTime", (Object)this.updateTime()).add("MembershipIdentifier", (Object)this.membershipIdentifier()).add("CollaborationIdentifier", (Object)this.collaborationIdentifier()).add("Name", (Object)this.name()).add("ConfiguredModelAlgorithmAssociations", this.hasConfiguredModelAlgorithmAssociations() ? this.configuredModelAlgorithmAssociations() : null).add("MlInputChannelArn", (Object)this.mlInputChannelArn()).add("Status", (Object)this.statusAsString()).add("CreatorAccountId", (Object)this.creatorAccountId()).add("Description", (Object)this.description()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "createTime": {
                return Optional.ofNullable(clazz.cast(this.createTime()));
            }
            case "updateTime": {
                return Optional.ofNullable(clazz.cast(this.updateTime()));
            }
            case "membershipIdentifier": {
                return Optional.ofNullable(clazz.cast(this.membershipIdentifier()));
            }
            case "collaborationIdentifier": {
                return Optional.ofNullable(clazz.cast(this.collaborationIdentifier()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "configuredModelAlgorithmAssociations": {
                return Optional.ofNullable(clazz.cast(this.configuredModelAlgorithmAssociations()));
            }
            case "mlInputChannelArn": {
                return Optional.ofNullable(clazz.cast(this.mlInputChannelArn()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "creatorAccountId": {
                return Optional.ofNullable(clazz.cast(this.creatorAccountId()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CollaborationMLInputChannelSummary, T> g) {
        return obj -> g.apply((CollaborationMLInputChannelSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Instant createTime;
        private Instant updateTime;
        private String membershipIdentifier;
        private String collaborationIdentifier;
        private String name;
        private List<String> configuredModelAlgorithmAssociations = DefaultSdkAutoConstructList.getInstance();
        private String mlInputChannelArn;
        private String status;
        private String creatorAccountId;
        private String description;

        private BuilderImpl() {
        }

        private BuilderImpl(CollaborationMLInputChannelSummary model) {
            this.createTime(model.createTime);
            this.updateTime(model.updateTime);
            this.membershipIdentifier(model.membershipIdentifier);
            this.collaborationIdentifier(model.collaborationIdentifier);
            this.name(model.name);
            this.configuredModelAlgorithmAssociations(model.configuredModelAlgorithmAssociations);
            this.mlInputChannelArn(model.mlInputChannelArn);
            this.status(model.status);
            this.creatorAccountId(model.creatorAccountId);
            this.description(model.description);
        }

        public final Instant getCreateTime() {
            return this.createTime;
        }

        public final void setCreateTime(Instant createTime) {
            this.createTime = createTime;
        }

        @Override
        public final Builder createTime(Instant createTime) {
            this.createTime = createTime;
            return this;
        }

        public final Instant getUpdateTime() {
            return this.updateTime;
        }

        public final void setUpdateTime(Instant updateTime) {
            this.updateTime = updateTime;
        }

        @Override
        public final Builder updateTime(Instant updateTime) {
            this.updateTime = updateTime;
            return this;
        }

        public final String getMembershipIdentifier() {
            return this.membershipIdentifier;
        }

        public final void setMembershipIdentifier(String membershipIdentifier) {
            this.membershipIdentifier = membershipIdentifier;
        }

        @Override
        public final Builder membershipIdentifier(String membershipIdentifier) {
            this.membershipIdentifier = membershipIdentifier;
            return this;
        }

        public final String getCollaborationIdentifier() {
            return this.collaborationIdentifier;
        }

        public final void setCollaborationIdentifier(String collaborationIdentifier) {
            this.collaborationIdentifier = collaborationIdentifier;
        }

        @Override
        public final Builder collaborationIdentifier(String collaborationIdentifier) {
            this.collaborationIdentifier = collaborationIdentifier;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Collection<String> getConfiguredModelAlgorithmAssociations() {
            if (this.configuredModelAlgorithmAssociations instanceof SdkAutoConstructList) {
                return null;
            }
            return this.configuredModelAlgorithmAssociations;
        }

        public final void setConfiguredModelAlgorithmAssociations(Collection<String> configuredModelAlgorithmAssociations) {
            this.configuredModelAlgorithmAssociations = CollaborationMLInputChannelSummaryConfiguredModelAlgorithmAssociationsListCopier.copy(configuredModelAlgorithmAssociations);
        }

        @Override
        public final Builder configuredModelAlgorithmAssociations(Collection<String> configuredModelAlgorithmAssociations) {
            this.configuredModelAlgorithmAssociations = CollaborationMLInputChannelSummaryConfiguredModelAlgorithmAssociationsListCopier.copy(configuredModelAlgorithmAssociations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder configuredModelAlgorithmAssociations(String ... configuredModelAlgorithmAssociations) {
            this.configuredModelAlgorithmAssociations(Arrays.asList(configuredModelAlgorithmAssociations));
            return this;
        }

        public final String getMlInputChannelArn() {
            return this.mlInputChannelArn;
        }

        public final void setMlInputChannelArn(String mlInputChannelArn) {
            this.mlInputChannelArn = mlInputChannelArn;
        }

        @Override
        public final Builder mlInputChannelArn(String mlInputChannelArn) {
            this.mlInputChannelArn = mlInputChannelArn;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(MLInputChannelStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getCreatorAccountId() {
            return this.creatorAccountId;
        }

        public final void setCreatorAccountId(String creatorAccountId) {
            this.creatorAccountId = creatorAccountId;
        }

        @Override
        public final Builder creatorAccountId(String creatorAccountId) {
            this.creatorAccountId = creatorAccountId;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public CollaborationMLInputChannelSummary build() {
            return new CollaborationMLInputChannelSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CollaborationMLInputChannelSummary> {
        public Builder createTime(Instant var1);

        public Builder updateTime(Instant var1);

        public Builder membershipIdentifier(String var1);

        public Builder collaborationIdentifier(String var1);

        public Builder name(String var1);

        public Builder configuredModelAlgorithmAssociations(Collection<String> var1);

        public Builder configuredModelAlgorithmAssociations(String ... var1);

        public Builder mlInputChannelArn(String var1);

        public Builder status(String var1);

        public Builder status(MLInputChannelStatus var1);

        public Builder creatorAccountId(String var1);

        public Builder description(String var1);
    }
}

