/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cleanroomsml.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cleanroomsml.model.CleanRoomsMlResponse;
import software.amazon.awssdk.services.cleanroomsml.model.MLOutputConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetMlConfigurationResponse
extends CleanRoomsMlResponse
implements ToCopyableBuilder<Builder, GetMlConfigurationResponse> {
    private static final SdkField<String> MEMBERSHIP_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("membershipIdentifier").getter(GetMlConfigurationResponse.getter(GetMlConfigurationResponse::membershipIdentifier)).setter(GetMlConfigurationResponse.setter(Builder::membershipIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("membershipIdentifier").build()}).build();
    private static final SdkField<MLOutputConfiguration> DEFAULT_OUTPUT_LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("defaultOutputLocation").getter(GetMlConfigurationResponse.getter(GetMlConfigurationResponse::defaultOutputLocation)).setter(GetMlConfigurationResponse.setter(Builder::defaultOutputLocation)).constructor(MLOutputConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("defaultOutputLocation").build()}).build();
    private static final SdkField<Instant> CREATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createTime").getter(GetMlConfigurationResponse.getter(GetMlConfigurationResponse::createTime)).setter(GetMlConfigurationResponse.setter(Builder::createTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Instant> UPDATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("updateTime").getter(GetMlConfigurationResponse.getter(GetMlConfigurationResponse::updateTime)).setter(GetMlConfigurationResponse.setter(Builder::updateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updateTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MEMBERSHIP_IDENTIFIER_FIELD, DEFAULT_OUTPUT_LOCATION_FIELD, CREATE_TIME_FIELD, UPDATE_TIME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("membershipIdentifier", MEMBERSHIP_IDENTIFIER_FIELD);
            this.put("defaultOutputLocation", DEFAULT_OUTPUT_LOCATION_FIELD);
            this.put("createTime", CREATE_TIME_FIELD);
            this.put("updateTime", UPDATE_TIME_FIELD);
        }
    });
    private final String membershipIdentifier;
    private final MLOutputConfiguration defaultOutputLocation;
    private final Instant createTime;
    private final Instant updateTime;

    private GetMlConfigurationResponse(BuilderImpl builder) {
        super(builder);
        this.membershipIdentifier = builder.membershipIdentifier;
        this.defaultOutputLocation = builder.defaultOutputLocation;
        this.createTime = builder.createTime;
        this.updateTime = builder.updateTime;
    }

    public final String membershipIdentifier() {
        return this.membershipIdentifier;
    }

    public final MLOutputConfiguration defaultOutputLocation() {
        return this.defaultOutputLocation;
    }

    public final Instant createTime() {
        return this.createTime;
    }

    public final Instant updateTime() {
        return this.updateTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.membershipIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultOutputLocation());
        hashCode = 31 * hashCode + Objects.hashCode(this.createTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.updateTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetMlConfigurationResponse)) {
            return false;
        }
        GetMlConfigurationResponse other = (GetMlConfigurationResponse)((Object)obj);
        return Objects.equals(this.membershipIdentifier(), other.membershipIdentifier()) && Objects.equals(this.defaultOutputLocation(), other.defaultOutputLocation()) && Objects.equals(this.createTime(), other.createTime()) && Objects.equals(this.updateTime(), other.updateTime());
    }

    public final String toString() {
        return ToString.builder((String)"GetMlConfigurationResponse").add("MembershipIdentifier", (Object)this.membershipIdentifier()).add("DefaultOutputLocation", (Object)this.defaultOutputLocation()).add("CreateTime", (Object)this.createTime()).add("UpdateTime", (Object)this.updateTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "membershipIdentifier": {
                return Optional.ofNullable(clazz.cast(this.membershipIdentifier()));
            }
            case "defaultOutputLocation": {
                return Optional.ofNullable(clazz.cast(this.defaultOutputLocation()));
            }
            case "createTime": {
                return Optional.ofNullable(clazz.cast(this.createTime()));
            }
            case "updateTime": {
                return Optional.ofNullable(clazz.cast(this.updateTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GetMlConfigurationResponse, T> g) {
        return obj -> g.apply((GetMlConfigurationResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CleanRoomsMlResponse.BuilderImpl
    implements Builder {
        private String membershipIdentifier;
        private MLOutputConfiguration defaultOutputLocation;
        private Instant createTime;
        private Instant updateTime;

        private BuilderImpl() {
        }

        private BuilderImpl(GetMlConfigurationResponse model) {
            super(model);
            this.membershipIdentifier(model.membershipIdentifier);
            this.defaultOutputLocation(model.defaultOutputLocation);
            this.createTime(model.createTime);
            this.updateTime(model.updateTime);
        }

        public final String getMembershipIdentifier() {
            return this.membershipIdentifier;
        }

        public final void setMembershipIdentifier(String membershipIdentifier) {
            this.membershipIdentifier = membershipIdentifier;
        }

        @Override
        public final Builder membershipIdentifier(String membershipIdentifier) {
            this.membershipIdentifier = membershipIdentifier;
            return this;
        }

        public final MLOutputConfiguration.Builder getDefaultOutputLocation() {
            return this.defaultOutputLocation != null ? this.defaultOutputLocation.toBuilder() : null;
        }

        public final void setDefaultOutputLocation(MLOutputConfiguration.BuilderImpl defaultOutputLocation) {
            this.defaultOutputLocation = defaultOutputLocation != null ? defaultOutputLocation.build() : null;
        }

        @Override
        public final Builder defaultOutputLocation(MLOutputConfiguration defaultOutputLocation) {
            this.defaultOutputLocation = defaultOutputLocation;
            return this;
        }

        public final Instant getCreateTime() {
            return this.createTime;
        }

        public final void setCreateTime(Instant createTime) {
            this.createTime = createTime;
        }

        @Override
        public final Builder createTime(Instant createTime) {
            this.createTime = createTime;
            return this;
        }

        public final Instant getUpdateTime() {
            return this.updateTime;
        }

        public final void setUpdateTime(Instant updateTime) {
            this.updateTime = updateTime;
        }

        @Override
        public final Builder updateTime(Instant updateTime) {
            this.updateTime = updateTime;
            return this;
        }

        @Override
        public GetMlConfigurationResponse build() {
            return new GetMlConfigurationResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends CleanRoomsMlResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetMlConfigurationResponse> {
        public Builder membershipIdentifier(String var1);

        public Builder defaultOutputLocation(MLOutputConfiguration var1);

        default public Builder defaultOutputLocation(Consumer<MLOutputConfiguration.Builder> defaultOutputLocation) {
            return this.defaultOutputLocation((MLOutputConfiguration)((MLOutputConfiguration.Builder)MLOutputConfiguration.builder().applyMutation(defaultOutputLocation)).build());
        }

        public Builder createTime(Instant var1);

        public Builder updateTime(Instant var1);
    }
}

