/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cleanroomsml.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.cleanroomsml.CleanRoomsMlAsyncClient;
import software.amazon.awssdk.services.cleanroomsml.internal.UserAgentUtils;
import software.amazon.awssdk.services.cleanroomsml.model.CollaborationMLInputChannelSummary;
import software.amazon.awssdk.services.cleanroomsml.model.ListCollaborationMlInputChannelsRequest;
import software.amazon.awssdk.services.cleanroomsml.model.ListCollaborationMlInputChannelsResponse;

public class ListCollaborationMLInputChannelsPublisher
implements SdkPublisher<ListCollaborationMlInputChannelsResponse> {
    private final CleanRoomsMlAsyncClient client;
    private final ListCollaborationMlInputChannelsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListCollaborationMLInputChannelsPublisher(CleanRoomsMlAsyncClient client, ListCollaborationMlInputChannelsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListCollaborationMLInputChannelsPublisher(CleanRoomsMlAsyncClient client, ListCollaborationMlInputChannelsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListCollaborationMlInputChannelsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListCollaborationMlInputChannelsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<CollaborationMLInputChannelSummary> collaborationMLInputChannelsList() {
        Function<ListCollaborationMlInputChannelsResponse, Iterator> getIterator = response -> {
            if (response != null && response.collaborationMLInputChannelsList() != null) {
                return response.collaborationMLInputChannelsList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListCollaborationMlInputChannelsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListCollaborationMlInputChannelsResponseFetcher
    implements AsyncPageFetcher<ListCollaborationMlInputChannelsResponse> {
        private ListCollaborationMlInputChannelsResponseFetcher() {
        }

        public boolean hasNextPage(ListCollaborationMlInputChannelsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListCollaborationMlInputChannelsResponse> nextPage(ListCollaborationMlInputChannelsResponse previousPage) {
            if (previousPage == null) {
                return ListCollaborationMLInputChannelsPublisher.this.client.listCollaborationMLInputChannels(ListCollaborationMLInputChannelsPublisher.this.firstRequest);
            }
            return ListCollaborationMLInputChannelsPublisher.this.client.listCollaborationMLInputChannels((ListCollaborationMlInputChannelsRequest)((Object)ListCollaborationMLInputChannelsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

