/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cleanroomsml.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cleanroomsml.model.AudienceSizeBinsCopier;
import software.amazon.awssdk.services.cleanroomsml.model.AudienceSizeType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AudienceSizeConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AudienceSizeConfig> {
    private static final SdkField<String> AUDIENCE_SIZE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("audienceSizeType").getter(AudienceSizeConfig.getter(AudienceSizeConfig::audienceSizeTypeAsString)).setter(AudienceSizeConfig.setter(Builder::audienceSizeType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("audienceSizeType").build()}).build();
    private static final SdkField<List<Integer>> AUDIENCE_SIZE_BINS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("audienceSizeBins").getter(AudienceSizeConfig.getter(AudienceSizeConfig::audienceSizeBins)).setter(AudienceSizeConfig.setter(Builder::audienceSizeBins)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("audienceSizeBins").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.INTEGER).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUDIENCE_SIZE_TYPE_FIELD, AUDIENCE_SIZE_BINS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String audienceSizeType;
    private final List<Integer> audienceSizeBins;

    private AudienceSizeConfig(BuilderImpl builder) {
        this.audienceSizeType = builder.audienceSizeType;
        this.audienceSizeBins = builder.audienceSizeBins;
    }

    public final AudienceSizeType audienceSizeType() {
        return AudienceSizeType.fromValue(this.audienceSizeType);
    }

    public final String audienceSizeTypeAsString() {
        return this.audienceSizeType;
    }

    public final boolean hasAudienceSizeBins() {
        return this.audienceSizeBins != null && !(this.audienceSizeBins instanceof SdkAutoConstructList);
    }

    public final List<Integer> audienceSizeBins() {
        return this.audienceSizeBins;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.audienceSizeTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAudienceSizeBins() ? this.audienceSizeBins() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AudienceSizeConfig)) {
            return false;
        }
        AudienceSizeConfig other = (AudienceSizeConfig)obj;
        return Objects.equals(this.audienceSizeTypeAsString(), other.audienceSizeTypeAsString()) && this.hasAudienceSizeBins() == other.hasAudienceSizeBins() && Objects.equals(this.audienceSizeBins(), other.audienceSizeBins());
    }

    public final String toString() {
        return ToString.builder((String)"AudienceSizeConfig").add("AudienceSizeType", (Object)this.audienceSizeTypeAsString()).add("AudienceSizeBins", this.hasAudienceSizeBins() ? this.audienceSizeBins() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "audienceSizeType": {
                return Optional.ofNullable(clazz.cast(this.audienceSizeTypeAsString()));
            }
            case "audienceSizeBins": {
                return Optional.ofNullable(clazz.cast(this.audienceSizeBins()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AudienceSizeConfig, T> g) {
        return obj -> g.apply((AudienceSizeConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String audienceSizeType;
        private List<Integer> audienceSizeBins = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AudienceSizeConfig model) {
            this.audienceSizeType(model.audienceSizeType);
            this.audienceSizeBins(model.audienceSizeBins);
        }

        public final String getAudienceSizeType() {
            return this.audienceSizeType;
        }

        public final void setAudienceSizeType(String audienceSizeType) {
            this.audienceSizeType = audienceSizeType;
        }

        @Override
        public final Builder audienceSizeType(String audienceSizeType) {
            this.audienceSizeType = audienceSizeType;
            return this;
        }

        @Override
        public final Builder audienceSizeType(AudienceSizeType audienceSizeType) {
            this.audienceSizeType(audienceSizeType == null ? null : audienceSizeType.toString());
            return this;
        }

        public final Collection<Integer> getAudienceSizeBins() {
            if (this.audienceSizeBins instanceof SdkAutoConstructList) {
                return null;
            }
            return this.audienceSizeBins;
        }

        public final void setAudienceSizeBins(Collection<Integer> audienceSizeBins) {
            this.audienceSizeBins = AudienceSizeBinsCopier.copy(audienceSizeBins);
        }

        @Override
        public final Builder audienceSizeBins(Collection<Integer> audienceSizeBins) {
            this.audienceSizeBins = AudienceSizeBinsCopier.copy(audienceSizeBins);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder audienceSizeBins(Integer ... audienceSizeBins) {
            this.audienceSizeBins(Arrays.asList(audienceSizeBins));
            return this;
        }

        public AudienceSizeConfig build() {
            return new AudienceSizeConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AudienceSizeConfig> {
        public Builder audienceSizeType(String var1);

        public Builder audienceSizeType(AudienceSizeType var1);

        public Builder audienceSizeBins(Collection<Integer> var1);

        public Builder audienceSizeBins(Integer ... var1);
    }
}

