/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cleanroomsml.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.cleanroomsml.CleanRoomsMlClient;
import software.amazon.awssdk.services.cleanroomsml.internal.UserAgentUtils;
import software.amazon.awssdk.services.cleanroomsml.model.AudienceGenerationJobSummary;
import software.amazon.awssdk.services.cleanroomsml.model.ListAudienceGenerationJobsRequest;
import software.amazon.awssdk.services.cleanroomsml.model.ListAudienceGenerationJobsResponse;

public class ListAudienceGenerationJobsIterable
implements SdkIterable<ListAudienceGenerationJobsResponse> {
    private final CleanRoomsMlClient client;
    private final ListAudienceGenerationJobsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListAudienceGenerationJobsIterable(CleanRoomsMlClient client, ListAudienceGenerationJobsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListAudienceGenerationJobsResponseFetcher();
    }

    public Iterator<ListAudienceGenerationJobsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<AudienceGenerationJobSummary> audienceGenerationJobs() {
        Function<ListAudienceGenerationJobsResponse, Iterator> getIterator = response -> {
            if (response != null && response.audienceGenerationJobs() != null) {
                return response.audienceGenerationJobs().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListAudienceGenerationJobsResponseFetcher
    implements SyncPageFetcher<ListAudienceGenerationJobsResponse> {
        private ListAudienceGenerationJobsResponseFetcher() {
        }

        public boolean hasNextPage(ListAudienceGenerationJobsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListAudienceGenerationJobsResponse nextPage(ListAudienceGenerationJobsResponse previousPage) {
            if (previousPage == null) {
                return ListAudienceGenerationJobsIterable.this.client.listAudienceGenerationJobs(ListAudienceGenerationJobsIterable.this.firstRequest);
            }
            return ListAudienceGenerationJobsIterable.this.client.listAudienceGenerationJobs((ListAudienceGenerationJobsRequest)((Object)ListAudienceGenerationJobsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

