/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cleanroomsml.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.cleanroomsml.CleanRoomsMlAsyncClient;
import software.amazon.awssdk.services.cleanroomsml.internal.UserAgentUtils;
import software.amazon.awssdk.services.cleanroomsml.model.AudienceExportJobSummary;
import software.amazon.awssdk.services.cleanroomsml.model.ListAudienceExportJobsRequest;
import software.amazon.awssdk.services.cleanroomsml.model.ListAudienceExportJobsResponse;

public class ListAudienceExportJobsPublisher
implements SdkPublisher<ListAudienceExportJobsResponse> {
    private final CleanRoomsMlAsyncClient client;
    private final ListAudienceExportJobsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListAudienceExportJobsPublisher(CleanRoomsMlAsyncClient client, ListAudienceExportJobsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListAudienceExportJobsPublisher(CleanRoomsMlAsyncClient client, ListAudienceExportJobsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListAudienceExportJobsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListAudienceExportJobsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<AudienceExportJobSummary> audienceExportJobs() {
        Function<ListAudienceExportJobsResponse, Iterator> getIterator = response -> {
            if (response != null && response.audienceExportJobs() != null) {
                return response.audienceExportJobs().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListAudienceExportJobsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListAudienceExportJobsResponseFetcher
    implements AsyncPageFetcher<ListAudienceExportJobsResponse> {
        private ListAudienceExportJobsResponseFetcher() {
        }

        public boolean hasNextPage(ListAudienceExportJobsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListAudienceExportJobsResponse> nextPage(ListAudienceExportJobsResponse previousPage) {
            if (previousPage == null) {
                return ListAudienceExportJobsPublisher.this.client.listAudienceExportJobs(ListAudienceExportJobsPublisher.this.firstRequest);
            }
            return ListAudienceExportJobsPublisher.this.client.listAudienceExportJobs((ListAudienceExportJobsRequest)((Object)ListAudienceExportJobsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

