/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cleanroomsml.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.cleanroomsml.model.AudienceModelStatus;
import software.amazon.awssdk.services.cleanroomsml.model.CleanRoomsMlResponse;
import software.amazon.awssdk.services.cleanroomsml.model.StatusDetails;
import software.amazon.awssdk.services.cleanroomsml.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetAudienceModelResponse
extends CleanRoomsMlResponse
implements ToCopyableBuilder<Builder, GetAudienceModelResponse> {
    private static final SdkField<Instant> CREATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createTime").getter(GetAudienceModelResponse.getter(GetAudienceModelResponse::createTime)).setter(GetAudienceModelResponse.setter(Builder::createTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Instant> UPDATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("updateTime").getter(GetAudienceModelResponse.getter(GetAudienceModelResponse::updateTime)).setter(GetAudienceModelResponse.setter(Builder::updateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updateTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Instant> TRAINING_DATA_START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("trainingDataStartTime").getter(GetAudienceModelResponse.getter(GetAudienceModelResponse::trainingDataStartTime)).setter(GetAudienceModelResponse.setter(Builder::trainingDataStartTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("trainingDataStartTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Instant> TRAINING_DATA_END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("trainingDataEndTime").getter(GetAudienceModelResponse.getter(GetAudienceModelResponse::trainingDataEndTime)).setter(GetAudienceModelResponse.setter(Builder::trainingDataEndTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("trainingDataEndTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> AUDIENCE_MODEL_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("audienceModelArn").getter(GetAudienceModelResponse.getter(GetAudienceModelResponse::audienceModelArn)).setter(GetAudienceModelResponse.setter(Builder::audienceModelArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("audienceModelArn").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(GetAudienceModelResponse.getter(GetAudienceModelResponse::name)).setter(GetAudienceModelResponse.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> TRAINING_DATASET_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("trainingDatasetArn").getter(GetAudienceModelResponse.getter(GetAudienceModelResponse::trainingDatasetArn)).setter(GetAudienceModelResponse.setter(Builder::trainingDatasetArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("trainingDatasetArn").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(GetAudienceModelResponse.getter(GetAudienceModelResponse::statusAsString)).setter(GetAudienceModelResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<StatusDetails> STATUS_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("statusDetails").getter(GetAudienceModelResponse.getter(GetAudienceModelResponse::statusDetails)).setter(GetAudienceModelResponse.setter(Builder::statusDetails)).constructor(StatusDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusDetails").build()}).build();
    private static final SdkField<String> KMS_KEY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("kmsKeyArn").getter(GetAudienceModelResponse.getter(GetAudienceModelResponse::kmsKeyArn)).setter(GetAudienceModelResponse.setter(Builder::kmsKeyArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kmsKeyArn").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(GetAudienceModelResponse.getter(GetAudienceModelResponse::tags)).setter(GetAudienceModelResponse.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(GetAudienceModelResponse.getter(GetAudienceModelResponse::description)).setter(GetAudienceModelResponse.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATE_TIME_FIELD, UPDATE_TIME_FIELD, TRAINING_DATA_START_TIME_FIELD, TRAINING_DATA_END_TIME_FIELD, AUDIENCE_MODEL_ARN_FIELD, NAME_FIELD, TRAINING_DATASET_ARN_FIELD, STATUS_FIELD, STATUS_DETAILS_FIELD, KMS_KEY_ARN_FIELD, TAGS_FIELD, DESCRIPTION_FIELD));
    private final Instant createTime;
    private final Instant updateTime;
    private final Instant trainingDataStartTime;
    private final Instant trainingDataEndTime;
    private final String audienceModelArn;
    private final String name;
    private final String trainingDatasetArn;
    private final String status;
    private final StatusDetails statusDetails;
    private final String kmsKeyArn;
    private final Map<String, String> tags;
    private final String description;

    private GetAudienceModelResponse(BuilderImpl builder) {
        super(builder);
        this.createTime = builder.createTime;
        this.updateTime = builder.updateTime;
        this.trainingDataStartTime = builder.trainingDataStartTime;
        this.trainingDataEndTime = builder.trainingDataEndTime;
        this.audienceModelArn = builder.audienceModelArn;
        this.name = builder.name;
        this.trainingDatasetArn = builder.trainingDatasetArn;
        this.status = builder.status;
        this.statusDetails = builder.statusDetails;
        this.kmsKeyArn = builder.kmsKeyArn;
        this.tags = builder.tags;
        this.description = builder.description;
    }

    public final Instant createTime() {
        return this.createTime;
    }

    public final Instant updateTime() {
        return this.updateTime;
    }

    public final Instant trainingDataStartTime() {
        return this.trainingDataStartTime;
    }

    public final Instant trainingDataEndTime() {
        return this.trainingDataEndTime;
    }

    public final String audienceModelArn() {
        return this.audienceModelArn;
    }

    public final String name() {
        return this.name;
    }

    public final String trainingDatasetArn() {
        return this.trainingDatasetArn;
    }

    public final AudienceModelStatus status() {
        return AudienceModelStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final StatusDetails statusDetails() {
        return this.statusDetails;
    }

    public final String kmsKeyArn() {
        return this.kmsKeyArn;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final String description() {
        return this.description;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.createTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.updateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.trainingDataStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.trainingDataEndTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.audienceModelArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.trainingDatasetArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetAudienceModelResponse)) {
            return false;
        }
        GetAudienceModelResponse other = (GetAudienceModelResponse)((Object)obj);
        return Objects.equals(this.createTime(), other.createTime()) && Objects.equals(this.updateTime(), other.updateTime()) && Objects.equals(this.trainingDataStartTime(), other.trainingDataStartTime()) && Objects.equals(this.trainingDataEndTime(), other.trainingDataEndTime()) && Objects.equals(this.audienceModelArn(), other.audienceModelArn()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.trainingDatasetArn(), other.trainingDatasetArn()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.statusDetails(), other.statusDetails()) && Objects.equals(this.kmsKeyArn(), other.kmsKeyArn()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.description(), other.description());
    }

    public final String toString() {
        return ToString.builder((String)"GetAudienceModelResponse").add("CreateTime", (Object)this.createTime()).add("UpdateTime", (Object)this.updateTime()).add("TrainingDataStartTime", (Object)this.trainingDataStartTime()).add("TrainingDataEndTime", (Object)this.trainingDataEndTime()).add("AudienceModelArn", (Object)this.audienceModelArn()).add("Name", (Object)this.name()).add("TrainingDatasetArn", (Object)this.trainingDatasetArn()).add("Status", (Object)this.statusAsString()).add("StatusDetails", (Object)this.statusDetails()).add("KmsKeyArn", (Object)this.kmsKeyArn()).add("Tags", this.hasTags() ? this.tags() : null).add("Description", (Object)this.description()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "createTime": {
                return Optional.ofNullable(clazz.cast(this.createTime()));
            }
            case "updateTime": {
                return Optional.ofNullable(clazz.cast(this.updateTime()));
            }
            case "trainingDataStartTime": {
                return Optional.ofNullable(clazz.cast(this.trainingDataStartTime()));
            }
            case "trainingDataEndTime": {
                return Optional.ofNullable(clazz.cast(this.trainingDataEndTime()));
            }
            case "audienceModelArn": {
                return Optional.ofNullable(clazz.cast(this.audienceModelArn()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "trainingDatasetArn": {
                return Optional.ofNullable(clazz.cast(this.trainingDatasetArn()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "statusDetails": {
                return Optional.ofNullable(clazz.cast(this.statusDetails()));
            }
            case "kmsKeyArn": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyArn()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetAudienceModelResponse, T> g) {
        return obj -> g.apply((GetAudienceModelResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CleanRoomsMlResponse.BuilderImpl
    implements Builder {
        private Instant createTime;
        private Instant updateTime;
        private Instant trainingDataStartTime;
        private Instant trainingDataEndTime;
        private String audienceModelArn;
        private String name;
        private String trainingDatasetArn;
        private String status;
        private StatusDetails statusDetails;
        private String kmsKeyArn;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private String description;

        private BuilderImpl() {
        }

        private BuilderImpl(GetAudienceModelResponse model) {
            super(model);
            this.createTime(model.createTime);
            this.updateTime(model.updateTime);
            this.trainingDataStartTime(model.trainingDataStartTime);
            this.trainingDataEndTime(model.trainingDataEndTime);
            this.audienceModelArn(model.audienceModelArn);
            this.name(model.name);
            this.trainingDatasetArn(model.trainingDatasetArn);
            this.status(model.status);
            this.statusDetails(model.statusDetails);
            this.kmsKeyArn(model.kmsKeyArn);
            this.tags(model.tags);
            this.description(model.description);
        }

        public final Instant getCreateTime() {
            return this.createTime;
        }

        public final void setCreateTime(Instant createTime) {
            this.createTime = createTime;
        }

        @Override
        public final Builder createTime(Instant createTime) {
            this.createTime = createTime;
            return this;
        }

        public final Instant getUpdateTime() {
            return this.updateTime;
        }

        public final void setUpdateTime(Instant updateTime) {
            this.updateTime = updateTime;
        }

        @Override
        public final Builder updateTime(Instant updateTime) {
            this.updateTime = updateTime;
            return this;
        }

        public final Instant getTrainingDataStartTime() {
            return this.trainingDataStartTime;
        }

        public final void setTrainingDataStartTime(Instant trainingDataStartTime) {
            this.trainingDataStartTime = trainingDataStartTime;
        }

        @Override
        public final Builder trainingDataStartTime(Instant trainingDataStartTime) {
            this.trainingDataStartTime = trainingDataStartTime;
            return this;
        }

        public final Instant getTrainingDataEndTime() {
            return this.trainingDataEndTime;
        }

        public final void setTrainingDataEndTime(Instant trainingDataEndTime) {
            this.trainingDataEndTime = trainingDataEndTime;
        }

        @Override
        public final Builder trainingDataEndTime(Instant trainingDataEndTime) {
            this.trainingDataEndTime = trainingDataEndTime;
            return this;
        }

        public final String getAudienceModelArn() {
            return this.audienceModelArn;
        }

        public final void setAudienceModelArn(String audienceModelArn) {
            this.audienceModelArn = audienceModelArn;
        }

        @Override
        public final Builder audienceModelArn(String audienceModelArn) {
            this.audienceModelArn = audienceModelArn;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getTrainingDatasetArn() {
            return this.trainingDatasetArn;
        }

        public final void setTrainingDatasetArn(String trainingDatasetArn) {
            this.trainingDatasetArn = trainingDatasetArn;
        }

        @Override
        public final Builder trainingDatasetArn(String trainingDatasetArn) {
            this.trainingDatasetArn = trainingDatasetArn;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(AudienceModelStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final StatusDetails.Builder getStatusDetails() {
            return this.statusDetails != null ? this.statusDetails.toBuilder() : null;
        }

        public final void setStatusDetails(StatusDetails.BuilderImpl statusDetails) {
            this.statusDetails = statusDetails != null ? statusDetails.build() : null;
        }

        @Override
        public final Builder statusDetails(StatusDetails statusDetails) {
            this.statusDetails = statusDetails;
            return this;
        }

        public final String getKmsKeyArn() {
            return this.kmsKeyArn;
        }

        public final void setKmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
        }

        @Override
        public final Builder kmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        @Override
        public GetAudienceModelResponse build() {
            return new GetAudienceModelResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CleanRoomsMlResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetAudienceModelResponse> {
        public Builder createTime(Instant var1);

        public Builder updateTime(Instant var1);

        public Builder trainingDataStartTime(Instant var1);

        public Builder trainingDataEndTime(Instant var1);

        public Builder audienceModelArn(String var1);

        public Builder name(String var1);

        public Builder trainingDatasetArn(String var1);

        public Builder status(String var1);

        public Builder status(AudienceModelStatus var1);

        public Builder statusDetails(StatusDetails var1);

        default public Builder statusDetails(Consumer<StatusDetails.Builder> statusDetails) {
            return this.statusDetails((StatusDetails)((StatusDetails.Builder)StatusDetails.builder().applyMutation(statusDetails)).build());
        }

        public Builder kmsKeyArn(String var1);

        public Builder tags(Map<String, String> var1);

        public Builder description(String var1);
    }
}

