/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cleanroomsml.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.cleanroomsml.CleanRoomsMlAsyncClient;
import software.amazon.awssdk.services.cleanroomsml.internal.UserAgentUtils;
import software.amazon.awssdk.services.cleanroomsml.model.ConfiguredAudienceModelSummary;
import software.amazon.awssdk.services.cleanroomsml.model.ListConfiguredAudienceModelsRequest;
import software.amazon.awssdk.services.cleanroomsml.model.ListConfiguredAudienceModelsResponse;

public class ListConfiguredAudienceModelsPublisher
implements SdkPublisher<ListConfiguredAudienceModelsResponse> {
    private final CleanRoomsMlAsyncClient client;
    private final ListConfiguredAudienceModelsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListConfiguredAudienceModelsPublisher(CleanRoomsMlAsyncClient client, ListConfiguredAudienceModelsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListConfiguredAudienceModelsPublisher(CleanRoomsMlAsyncClient client, ListConfiguredAudienceModelsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListConfiguredAudienceModelsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListConfiguredAudienceModelsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ConfiguredAudienceModelSummary> configuredAudienceModels() {
        Function<ListConfiguredAudienceModelsResponse, Iterator> getIterator = response -> {
            if (response != null && response.configuredAudienceModels() != null) {
                return response.configuredAudienceModels().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListConfiguredAudienceModelsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListConfiguredAudienceModelsResponseFetcher
    implements AsyncPageFetcher<ListConfiguredAudienceModelsResponse> {
        private ListConfiguredAudienceModelsResponseFetcher() {
        }

        public boolean hasNextPage(ListConfiguredAudienceModelsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListConfiguredAudienceModelsResponse> nextPage(ListConfiguredAudienceModelsResponse previousPage) {
            if (previousPage == null) {
                return ListConfiguredAudienceModelsPublisher.this.client.listConfiguredAudienceModels(ListConfiguredAudienceModelsPublisher.this.firstRequest);
            }
            return ListConfiguredAudienceModelsPublisher.this.client.listConfiguredAudienceModels((ListConfiguredAudienceModelsRequest)((Object)ListConfiguredAudienceModelsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

