/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cleanroomsml.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GlueDataSource
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, GlueDataSource> {
    private static final SdkField<String> CATALOG_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("catalogId").getter(GlueDataSource.getter(GlueDataSource::catalogId)).setter(GlueDataSource.setter(Builder::catalogId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("catalogId").build()}).build();
    private static final SdkField<String> DATABASE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("databaseName").getter(GlueDataSource.getter(GlueDataSource::databaseName)).setter(GlueDataSource.setter(Builder::databaseName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("databaseName").build()}).build();
    private static final SdkField<String> TABLE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("tableName").getter(GlueDataSource.getter(GlueDataSource::tableName)).setter(GlueDataSource.setter(Builder::tableName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tableName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CATALOG_ID_FIELD, DATABASE_NAME_FIELD, TABLE_NAME_FIELD));
    private static final long serialVersionUID = 1L;
    private final String catalogId;
    private final String databaseName;
    private final String tableName;

    private GlueDataSource(BuilderImpl builder) {
        this.catalogId = builder.catalogId;
        this.databaseName = builder.databaseName;
        this.tableName = builder.tableName;
    }

    public final String catalogId() {
        return this.catalogId;
    }

    public final String databaseName() {
        return this.databaseName;
    }

    public final String tableName() {
        return this.tableName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.catalogId());
        hashCode = 31 * hashCode + Objects.hashCode(this.databaseName());
        hashCode = 31 * hashCode + Objects.hashCode(this.tableName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GlueDataSource)) {
            return false;
        }
        GlueDataSource other = (GlueDataSource)obj;
        return Objects.equals(this.catalogId(), other.catalogId()) && Objects.equals(this.databaseName(), other.databaseName()) && Objects.equals(this.tableName(), other.tableName());
    }

    public final String toString() {
        return ToString.builder((String)"GlueDataSource").add("CatalogId", (Object)this.catalogId()).add("DatabaseName", (Object)this.databaseName()).add("TableName", (Object)this.tableName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "catalogId": {
                return Optional.ofNullable(clazz.cast(this.catalogId()));
            }
            case "databaseName": {
                return Optional.ofNullable(clazz.cast(this.databaseName()));
            }
            case "tableName": {
                return Optional.ofNullable(clazz.cast(this.tableName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GlueDataSource, T> g) {
        return obj -> g.apply((GlueDataSource)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String catalogId;
        private String databaseName;
        private String tableName;

        private BuilderImpl() {
        }

        private BuilderImpl(GlueDataSource model) {
            this.catalogId(model.catalogId);
            this.databaseName(model.databaseName);
            this.tableName(model.tableName);
        }

        public final String getCatalogId() {
            return this.catalogId;
        }

        public final void setCatalogId(String catalogId) {
            this.catalogId = catalogId;
        }

        @Override
        public final Builder catalogId(String catalogId) {
            this.catalogId = catalogId;
            return this;
        }

        public final String getDatabaseName() {
            return this.databaseName;
        }

        public final void setDatabaseName(String databaseName) {
            this.databaseName = databaseName;
        }

        @Override
        public final Builder databaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        public final String getTableName() {
            return this.tableName;
        }

        public final void setTableName(String tableName) {
            this.tableName = tableName;
        }

        @Override
        public final Builder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public GlueDataSource build() {
            return new GlueDataSource(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, GlueDataSource> {
        public Builder catalogId(String var1);

        public Builder databaseName(String var1);

        public Builder tableName(String var1);
    }
}

