/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cleanroomsml.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.cleanroomsml.model.CleanRoomsMlResponse;
import software.amazon.awssdk.services.cleanroomsml.model.Dataset;
import software.amazon.awssdk.services.cleanroomsml.model.DatasetListCopier;
import software.amazon.awssdk.services.cleanroomsml.model.TagMapCopier;
import software.amazon.awssdk.services.cleanroomsml.model.TrainingDatasetStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetTrainingDatasetResponse
extends CleanRoomsMlResponse
implements ToCopyableBuilder<Builder, GetTrainingDatasetResponse> {
    private static final SdkField<Instant> CREATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createTime").getter(GetTrainingDatasetResponse.getter(GetTrainingDatasetResponse::createTime)).setter(GetTrainingDatasetResponse.setter(Builder::createTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(GetTrainingDatasetResponse.getter(GetTrainingDatasetResponse::description)).setter(GetTrainingDatasetResponse.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(GetTrainingDatasetResponse.getter(GetTrainingDatasetResponse::name)).setter(GetTrainingDatasetResponse.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("roleArn").getter(GetTrainingDatasetResponse.getter(GetTrainingDatasetResponse::roleArn)).setter(GetTrainingDatasetResponse.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(GetTrainingDatasetResponse.getter(GetTrainingDatasetResponse::statusAsString)).setter(GetTrainingDatasetResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(GetTrainingDatasetResponse.getter(GetTrainingDatasetResponse::tags)).setter(GetTrainingDatasetResponse.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<List<Dataset>> TRAINING_DATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("trainingData").getter(GetTrainingDatasetResponse.getter(GetTrainingDatasetResponse::trainingData)).setter(GetTrainingDatasetResponse.setter(Builder::trainingData)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("trainingData").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Dataset::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> TRAINING_DATASET_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("trainingDatasetArn").getter(GetTrainingDatasetResponse.getter(GetTrainingDatasetResponse::trainingDatasetArn)).setter(GetTrainingDatasetResponse.setter(Builder::trainingDatasetArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("trainingDatasetArn").build()}).build();
    private static final SdkField<Instant> UPDATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("updateTime").getter(GetTrainingDatasetResponse.getter(GetTrainingDatasetResponse::updateTime)).setter(GetTrainingDatasetResponse.setter(Builder::updateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updateTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATE_TIME_FIELD, DESCRIPTION_FIELD, NAME_FIELD, ROLE_ARN_FIELD, STATUS_FIELD, TAGS_FIELD, TRAINING_DATA_FIELD, TRAINING_DATASET_ARN_FIELD, UPDATE_TIME_FIELD));
    private final Instant createTime;
    private final String description;
    private final String name;
    private final String roleArn;
    private final String status;
    private final Map<String, String> tags;
    private final List<Dataset> trainingData;
    private final String trainingDatasetArn;
    private final Instant updateTime;

    private GetTrainingDatasetResponse(BuilderImpl builder) {
        super(builder);
        this.createTime = builder.createTime;
        this.description = builder.description;
        this.name = builder.name;
        this.roleArn = builder.roleArn;
        this.status = builder.status;
        this.tags = builder.tags;
        this.trainingData = builder.trainingData;
        this.trainingDatasetArn = builder.trainingDatasetArn;
        this.updateTime = builder.updateTime;
    }

    public final Instant createTime() {
        return this.createTime;
    }

    public final String description() {
        return this.description;
    }

    public final String name() {
        return this.name;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public final TrainingDatasetStatus status() {
        return TrainingDatasetStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final boolean hasTrainingData() {
        return this.trainingData != null && !(this.trainingData instanceof SdkAutoConstructList);
    }

    public final List<Dataset> trainingData() {
        return this.trainingData;
    }

    public final String trainingDatasetArn() {
        return this.trainingDatasetArn;
    }

    public final Instant updateTime() {
        return this.updateTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.createTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTrainingData() ? this.trainingData() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.trainingDatasetArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.updateTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetTrainingDatasetResponse)) {
            return false;
        }
        GetTrainingDatasetResponse other = (GetTrainingDatasetResponse)((Object)obj);
        return Objects.equals(this.createTime(), other.createTime()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.statusAsString(), other.statusAsString()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && this.hasTrainingData() == other.hasTrainingData() && Objects.equals(this.trainingData(), other.trainingData()) && Objects.equals(this.trainingDatasetArn(), other.trainingDatasetArn()) && Objects.equals(this.updateTime(), other.updateTime());
    }

    public final String toString() {
        return ToString.builder((String)"GetTrainingDatasetResponse").add("CreateTime", (Object)this.createTime()).add("Description", (Object)this.description()).add("Name", (Object)this.name()).add("RoleArn", (Object)this.roleArn()).add("Status", (Object)this.statusAsString()).add("Tags", this.hasTags() ? this.tags() : null).add("TrainingData", this.hasTrainingData() ? this.trainingData() : null).add("TrainingDatasetArn", (Object)this.trainingDatasetArn()).add("UpdateTime", (Object)this.updateTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "createTime": {
                return Optional.ofNullable(clazz.cast(this.createTime()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "roleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "trainingData": {
                return Optional.ofNullable(clazz.cast(this.trainingData()));
            }
            case "trainingDatasetArn": {
                return Optional.ofNullable(clazz.cast(this.trainingDatasetArn()));
            }
            case "updateTime": {
                return Optional.ofNullable(clazz.cast(this.updateTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetTrainingDatasetResponse, T> g) {
        return obj -> g.apply((GetTrainingDatasetResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CleanRoomsMlResponse.BuilderImpl
    implements Builder {
        private Instant createTime;
        private String description;
        private String name;
        private String roleArn;
        private String status;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private List<Dataset> trainingData = DefaultSdkAutoConstructList.getInstance();
        private String trainingDatasetArn;
        private Instant updateTime;

        private BuilderImpl() {
        }

        private BuilderImpl(GetTrainingDatasetResponse model) {
            super(model);
            this.createTime(model.createTime);
            this.description(model.description);
            this.name(model.name);
            this.roleArn(model.roleArn);
            this.status(model.status);
            this.tags(model.tags);
            this.trainingData(model.trainingData);
            this.trainingDatasetArn(model.trainingDatasetArn);
            this.updateTime(model.updateTime);
        }

        public final Instant getCreateTime() {
            return this.createTime;
        }

        public final void setCreateTime(Instant createTime) {
            this.createTime = createTime;
        }

        @Override
        public final Builder createTime(Instant createTime) {
            this.createTime = createTime;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(TrainingDatasetStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final List<Dataset.Builder> getTrainingData() {
            List<Dataset.Builder> result = DatasetListCopier.copyToBuilder(this.trainingData);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTrainingData(Collection<Dataset.BuilderImpl> trainingData) {
            this.trainingData = DatasetListCopier.copyFromBuilder(trainingData);
        }

        @Override
        public final Builder trainingData(Collection<Dataset> trainingData) {
            this.trainingData = DatasetListCopier.copy(trainingData);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder trainingData(Dataset ... trainingData) {
            this.trainingData(Arrays.asList(trainingData));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder trainingData(Consumer<Dataset.Builder> ... trainingData) {
            this.trainingData(Stream.of(trainingData).map(c -> (Dataset)((Dataset.Builder)Dataset.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getTrainingDatasetArn() {
            return this.trainingDatasetArn;
        }

        public final void setTrainingDatasetArn(String trainingDatasetArn) {
            this.trainingDatasetArn = trainingDatasetArn;
        }

        @Override
        public final Builder trainingDatasetArn(String trainingDatasetArn) {
            this.trainingDatasetArn = trainingDatasetArn;
            return this;
        }

        public final Instant getUpdateTime() {
            return this.updateTime;
        }

        public final void setUpdateTime(Instant updateTime) {
            this.updateTime = updateTime;
        }

        @Override
        public final Builder updateTime(Instant updateTime) {
            this.updateTime = updateTime;
            return this;
        }

        @Override
        public GetTrainingDatasetResponse build() {
            return new GetTrainingDatasetResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CleanRoomsMlResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetTrainingDatasetResponse> {
        public Builder createTime(Instant var1);

        public Builder description(String var1);

        public Builder name(String var1);

        public Builder roleArn(String var1);

        public Builder status(String var1);

        public Builder status(TrainingDatasetStatus var1);

        public Builder tags(Map<String, String> var1);

        public Builder trainingData(Collection<Dataset> var1);

        public Builder trainingData(Dataset ... var1);

        public Builder trainingData(Consumer<Dataset.Builder> ... var1);

        public Builder trainingDatasetArn(String var1);

        public Builder updateTime(Instant var1);
    }
}

