/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cleanroomsml.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cleanroomsml.model.TrainingDatasetStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TrainingDatasetSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TrainingDatasetSummary> {
    private static final SdkField<Instant> CREATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createTime").getter(TrainingDatasetSummary.getter(TrainingDatasetSummary::createTime)).setter(TrainingDatasetSummary.setter(Builder::createTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(TrainingDatasetSummary.getter(TrainingDatasetSummary::description)).setter(TrainingDatasetSummary.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(TrainingDatasetSummary.getter(TrainingDatasetSummary::name)).setter(TrainingDatasetSummary.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(TrainingDatasetSummary.getter(TrainingDatasetSummary::statusAsString)).setter(TrainingDatasetSummary.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> TRAINING_DATASET_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("trainingDatasetArn").getter(TrainingDatasetSummary.getter(TrainingDatasetSummary::trainingDatasetArn)).setter(TrainingDatasetSummary.setter(Builder::trainingDatasetArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("trainingDatasetArn").build()}).build();
    private static final SdkField<Instant> UPDATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("updateTime").getter(TrainingDatasetSummary.getter(TrainingDatasetSummary::updateTime)).setter(TrainingDatasetSummary.setter(Builder::updateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updateTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATE_TIME_FIELD, DESCRIPTION_FIELD, NAME_FIELD, STATUS_FIELD, TRAINING_DATASET_ARN_FIELD, UPDATE_TIME_FIELD));
    private static final long serialVersionUID = 1L;
    private final Instant createTime;
    private final String description;
    private final String name;
    private final String status;
    private final String trainingDatasetArn;
    private final Instant updateTime;

    private TrainingDatasetSummary(BuilderImpl builder) {
        this.createTime = builder.createTime;
        this.description = builder.description;
        this.name = builder.name;
        this.status = builder.status;
        this.trainingDatasetArn = builder.trainingDatasetArn;
        this.updateTime = builder.updateTime;
    }

    public final Instant createTime() {
        return this.createTime;
    }

    public final String description() {
        return this.description;
    }

    public final String name() {
        return this.name;
    }

    public final TrainingDatasetStatus status() {
        return TrainingDatasetStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String trainingDatasetArn() {
        return this.trainingDatasetArn;
    }

    public final Instant updateTime() {
        return this.updateTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.createTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.trainingDatasetArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.updateTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TrainingDatasetSummary)) {
            return false;
        }
        TrainingDatasetSummary other = (TrainingDatasetSummary)obj;
        return Objects.equals(this.createTime(), other.createTime()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.trainingDatasetArn(), other.trainingDatasetArn()) && Objects.equals(this.updateTime(), other.updateTime());
    }

    public final String toString() {
        return ToString.builder((String)"TrainingDatasetSummary").add("CreateTime", (Object)this.createTime()).add("Description", (Object)this.description()).add("Name", (Object)this.name()).add("Status", (Object)this.statusAsString()).add("TrainingDatasetArn", (Object)this.trainingDatasetArn()).add("UpdateTime", (Object)this.updateTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "createTime": {
                return Optional.ofNullable(clazz.cast(this.createTime()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "trainingDatasetArn": {
                return Optional.ofNullable(clazz.cast(this.trainingDatasetArn()));
            }
            case "updateTime": {
                return Optional.ofNullable(clazz.cast(this.updateTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TrainingDatasetSummary, T> g) {
        return obj -> g.apply((TrainingDatasetSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Instant createTime;
        private String description;
        private String name;
        private String status;
        private String trainingDatasetArn;
        private Instant updateTime;

        private BuilderImpl() {
        }

        private BuilderImpl(TrainingDatasetSummary model) {
            this.createTime(model.createTime);
            this.description(model.description);
            this.name(model.name);
            this.status(model.status);
            this.trainingDatasetArn(model.trainingDatasetArn);
            this.updateTime(model.updateTime);
        }

        public final Instant getCreateTime() {
            return this.createTime;
        }

        public final void setCreateTime(Instant createTime) {
            this.createTime = createTime;
        }

        @Override
        public final Builder createTime(Instant createTime) {
            this.createTime = createTime;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(TrainingDatasetStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getTrainingDatasetArn() {
            return this.trainingDatasetArn;
        }

        public final void setTrainingDatasetArn(String trainingDatasetArn) {
            this.trainingDatasetArn = trainingDatasetArn;
        }

        @Override
        public final Builder trainingDatasetArn(String trainingDatasetArn) {
            this.trainingDatasetArn = trainingDatasetArn;
            return this;
        }

        public final Instant getUpdateTime() {
            return this.updateTime;
        }

        public final void setUpdateTime(Instant updateTime) {
            this.updateTime = updateTime;
        }

        @Override
        public final Builder updateTime(Instant updateTime) {
            this.updateTime = updateTime;
            return this;
        }

        public TrainingDatasetSummary build() {
            return new TrainingDatasetSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TrainingDatasetSummary> {
        public Builder createTime(Instant var1);

        public Builder description(String var1);

        public Builder name(String var1);

        public Builder status(String var1);

        public Builder status(TrainingDatasetStatus var1);

        public Builder trainingDatasetArn(String var1);

        public Builder updateTime(Instant var1);
    }
}

