/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cleanroomsml.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cleanroomsml.model.AudienceSizeConfig;
import software.amazon.awssdk.services.cleanroomsml.model.CleanRoomsMlRequest;
import software.amazon.awssdk.services.cleanroomsml.model.ConfiguredAudienceModelOutputConfig;
import software.amazon.awssdk.services.cleanroomsml.model.MetricsListCopier;
import software.amazon.awssdk.services.cleanroomsml.model.SharedAudienceMetrics;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateConfiguredAudienceModelRequest
extends CleanRoomsMlRequest
implements ToCopyableBuilder<Builder, UpdateConfiguredAudienceModelRequest> {
    private static final SdkField<String> AUDIENCE_MODEL_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("audienceModelArn").getter(UpdateConfiguredAudienceModelRequest.getter(UpdateConfiguredAudienceModelRequest::audienceModelArn)).setter(UpdateConfiguredAudienceModelRequest.setter(Builder::audienceModelArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("audienceModelArn").build()}).build();
    private static final SdkField<AudienceSizeConfig> AUDIENCE_SIZE_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("audienceSizeConfig").getter(UpdateConfiguredAudienceModelRequest.getter(UpdateConfiguredAudienceModelRequest::audienceSizeConfig)).setter(UpdateConfiguredAudienceModelRequest.setter(Builder::audienceSizeConfig)).constructor(AudienceSizeConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("audienceSizeConfig").build()}).build();
    private static final SdkField<String> CONFIGURED_AUDIENCE_MODEL_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("configuredAudienceModelArn").getter(UpdateConfiguredAudienceModelRequest.getter(UpdateConfiguredAudienceModelRequest::configuredAudienceModelArn)).setter(UpdateConfiguredAudienceModelRequest.setter(Builder::configuredAudienceModelArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("configuredAudienceModelArn").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(UpdateConfiguredAudienceModelRequest.getter(UpdateConfiguredAudienceModelRequest::description)).setter(UpdateConfiguredAudienceModelRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<Integer> MIN_MATCHING_SEED_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("minMatchingSeedSize").getter(UpdateConfiguredAudienceModelRequest.getter(UpdateConfiguredAudienceModelRequest::minMatchingSeedSize)).setter(UpdateConfiguredAudienceModelRequest.setter(Builder::minMatchingSeedSize)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("minMatchingSeedSize").build()}).build();
    private static final SdkField<ConfiguredAudienceModelOutputConfig> OUTPUT_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("outputConfig").getter(UpdateConfiguredAudienceModelRequest.getter(UpdateConfiguredAudienceModelRequest::outputConfig)).setter(UpdateConfiguredAudienceModelRequest.setter(Builder::outputConfig)).constructor(ConfiguredAudienceModelOutputConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputConfig").build()}).build();
    private static final SdkField<List<String>> SHARED_AUDIENCE_METRICS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("sharedAudienceMetrics").getter(UpdateConfiguredAudienceModelRequest.getter(UpdateConfiguredAudienceModelRequest::sharedAudienceMetricsAsStrings)).setter(UpdateConfiguredAudienceModelRequest.setter(Builder::sharedAudienceMetricsWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sharedAudienceMetrics").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUDIENCE_MODEL_ARN_FIELD, AUDIENCE_SIZE_CONFIG_FIELD, CONFIGURED_AUDIENCE_MODEL_ARN_FIELD, DESCRIPTION_FIELD, MIN_MATCHING_SEED_SIZE_FIELD, OUTPUT_CONFIG_FIELD, SHARED_AUDIENCE_METRICS_FIELD));
    private final String audienceModelArn;
    private final AudienceSizeConfig audienceSizeConfig;
    private final String configuredAudienceModelArn;
    private final String description;
    private final Integer minMatchingSeedSize;
    private final ConfiguredAudienceModelOutputConfig outputConfig;
    private final List<String> sharedAudienceMetrics;

    private UpdateConfiguredAudienceModelRequest(BuilderImpl builder) {
        super(builder);
        this.audienceModelArn = builder.audienceModelArn;
        this.audienceSizeConfig = builder.audienceSizeConfig;
        this.configuredAudienceModelArn = builder.configuredAudienceModelArn;
        this.description = builder.description;
        this.minMatchingSeedSize = builder.minMatchingSeedSize;
        this.outputConfig = builder.outputConfig;
        this.sharedAudienceMetrics = builder.sharedAudienceMetrics;
    }

    public final String audienceModelArn() {
        return this.audienceModelArn;
    }

    public final AudienceSizeConfig audienceSizeConfig() {
        return this.audienceSizeConfig;
    }

    public final String configuredAudienceModelArn() {
        return this.configuredAudienceModelArn;
    }

    public final String description() {
        return this.description;
    }

    public final Integer minMatchingSeedSize() {
        return this.minMatchingSeedSize;
    }

    public final ConfiguredAudienceModelOutputConfig outputConfig() {
        return this.outputConfig;
    }

    public final List<SharedAudienceMetrics> sharedAudienceMetrics() {
        return MetricsListCopier.copyStringToEnum(this.sharedAudienceMetrics);
    }

    public final boolean hasSharedAudienceMetrics() {
        return this.sharedAudienceMetrics != null && !(this.sharedAudienceMetrics instanceof SdkAutoConstructList);
    }

    public final List<String> sharedAudienceMetricsAsStrings() {
        return this.sharedAudienceMetrics;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.audienceModelArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.audienceSizeConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.configuredAudienceModelArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.minMatchingSeedSize());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSharedAudienceMetrics() ? this.sharedAudienceMetricsAsStrings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateConfiguredAudienceModelRequest)) {
            return false;
        }
        UpdateConfiguredAudienceModelRequest other = (UpdateConfiguredAudienceModelRequest)((Object)obj);
        return Objects.equals(this.audienceModelArn(), other.audienceModelArn()) && Objects.equals(this.audienceSizeConfig(), other.audienceSizeConfig()) && Objects.equals(this.configuredAudienceModelArn(), other.configuredAudienceModelArn()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.minMatchingSeedSize(), other.minMatchingSeedSize()) && Objects.equals(this.outputConfig(), other.outputConfig()) && this.hasSharedAudienceMetrics() == other.hasSharedAudienceMetrics() && Objects.equals(this.sharedAudienceMetricsAsStrings(), other.sharedAudienceMetricsAsStrings());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateConfiguredAudienceModelRequest").add("AudienceModelArn", (Object)this.audienceModelArn()).add("AudienceSizeConfig", (Object)this.audienceSizeConfig()).add("ConfiguredAudienceModelArn", (Object)this.configuredAudienceModelArn()).add("Description", (Object)this.description()).add("MinMatchingSeedSize", (Object)this.minMatchingSeedSize()).add("OutputConfig", (Object)this.outputConfig()).add("SharedAudienceMetrics", this.hasSharedAudienceMetrics() ? this.sharedAudienceMetricsAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "audienceModelArn": {
                return Optional.ofNullable(clazz.cast(this.audienceModelArn()));
            }
            case "audienceSizeConfig": {
                return Optional.ofNullable(clazz.cast(this.audienceSizeConfig()));
            }
            case "configuredAudienceModelArn": {
                return Optional.ofNullable(clazz.cast(this.configuredAudienceModelArn()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "minMatchingSeedSize": {
                return Optional.ofNullable(clazz.cast(this.minMatchingSeedSize()));
            }
            case "outputConfig": {
                return Optional.ofNullable(clazz.cast(this.outputConfig()));
            }
            case "sharedAudienceMetrics": {
                return Optional.ofNullable(clazz.cast(this.sharedAudienceMetricsAsStrings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateConfiguredAudienceModelRequest, T> g) {
        return obj -> g.apply((UpdateConfiguredAudienceModelRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CleanRoomsMlRequest.BuilderImpl
    implements Builder {
        private String audienceModelArn;
        private AudienceSizeConfig audienceSizeConfig;
        private String configuredAudienceModelArn;
        private String description;
        private Integer minMatchingSeedSize;
        private ConfiguredAudienceModelOutputConfig outputConfig;
        private List<String> sharedAudienceMetrics = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateConfiguredAudienceModelRequest model) {
            super(model);
            this.audienceModelArn(model.audienceModelArn);
            this.audienceSizeConfig(model.audienceSizeConfig);
            this.configuredAudienceModelArn(model.configuredAudienceModelArn);
            this.description(model.description);
            this.minMatchingSeedSize(model.minMatchingSeedSize);
            this.outputConfig(model.outputConfig);
            this.sharedAudienceMetricsWithStrings(model.sharedAudienceMetrics);
        }

        public final String getAudienceModelArn() {
            return this.audienceModelArn;
        }

        public final void setAudienceModelArn(String audienceModelArn) {
            this.audienceModelArn = audienceModelArn;
        }

        @Override
        public final Builder audienceModelArn(String audienceModelArn) {
            this.audienceModelArn = audienceModelArn;
            return this;
        }

        public final AudienceSizeConfig.Builder getAudienceSizeConfig() {
            return this.audienceSizeConfig != null ? this.audienceSizeConfig.toBuilder() : null;
        }

        public final void setAudienceSizeConfig(AudienceSizeConfig.BuilderImpl audienceSizeConfig) {
            this.audienceSizeConfig = audienceSizeConfig != null ? audienceSizeConfig.build() : null;
        }

        @Override
        public final Builder audienceSizeConfig(AudienceSizeConfig audienceSizeConfig) {
            this.audienceSizeConfig = audienceSizeConfig;
            return this;
        }

        public final String getConfiguredAudienceModelArn() {
            return this.configuredAudienceModelArn;
        }

        public final void setConfiguredAudienceModelArn(String configuredAudienceModelArn) {
            this.configuredAudienceModelArn = configuredAudienceModelArn;
        }

        @Override
        public final Builder configuredAudienceModelArn(String configuredAudienceModelArn) {
            this.configuredAudienceModelArn = configuredAudienceModelArn;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Integer getMinMatchingSeedSize() {
            return this.minMatchingSeedSize;
        }

        public final void setMinMatchingSeedSize(Integer minMatchingSeedSize) {
            this.minMatchingSeedSize = minMatchingSeedSize;
        }

        @Override
        public final Builder minMatchingSeedSize(Integer minMatchingSeedSize) {
            this.minMatchingSeedSize = minMatchingSeedSize;
            return this;
        }

        public final ConfiguredAudienceModelOutputConfig.Builder getOutputConfig() {
            return this.outputConfig != null ? this.outputConfig.toBuilder() : null;
        }

        public final void setOutputConfig(ConfiguredAudienceModelOutputConfig.BuilderImpl outputConfig) {
            this.outputConfig = outputConfig != null ? outputConfig.build() : null;
        }

        @Override
        public final Builder outputConfig(ConfiguredAudienceModelOutputConfig outputConfig) {
            this.outputConfig = outputConfig;
            return this;
        }

        public final Collection<String> getSharedAudienceMetrics() {
            if (this.sharedAudienceMetrics instanceof SdkAutoConstructList) {
                return null;
            }
            return this.sharedAudienceMetrics;
        }

        public final void setSharedAudienceMetrics(Collection<String> sharedAudienceMetrics) {
            this.sharedAudienceMetrics = MetricsListCopier.copy(sharedAudienceMetrics);
        }

        @Override
        public final Builder sharedAudienceMetricsWithStrings(Collection<String> sharedAudienceMetrics) {
            this.sharedAudienceMetrics = MetricsListCopier.copy(sharedAudienceMetrics);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sharedAudienceMetricsWithStrings(String ... sharedAudienceMetrics) {
            this.sharedAudienceMetricsWithStrings(Arrays.asList(sharedAudienceMetrics));
            return this;
        }

        @Override
        public final Builder sharedAudienceMetrics(Collection<SharedAudienceMetrics> sharedAudienceMetrics) {
            this.sharedAudienceMetrics = MetricsListCopier.copyEnumToString(sharedAudienceMetrics);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sharedAudienceMetrics(SharedAudienceMetrics ... sharedAudienceMetrics) {
            this.sharedAudienceMetrics(Arrays.asList(sharedAudienceMetrics));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateConfiguredAudienceModelRequest build() {
            return new UpdateConfiguredAudienceModelRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CleanRoomsMlRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateConfiguredAudienceModelRequest> {
        public Builder audienceModelArn(String var1);

        public Builder audienceSizeConfig(AudienceSizeConfig var1);

        default public Builder audienceSizeConfig(Consumer<AudienceSizeConfig.Builder> audienceSizeConfig) {
            return this.audienceSizeConfig((AudienceSizeConfig)((AudienceSizeConfig.Builder)AudienceSizeConfig.builder().applyMutation(audienceSizeConfig)).build());
        }

        public Builder configuredAudienceModelArn(String var1);

        public Builder description(String var1);

        public Builder minMatchingSeedSize(Integer var1);

        public Builder outputConfig(ConfiguredAudienceModelOutputConfig var1);

        default public Builder outputConfig(Consumer<ConfiguredAudienceModelOutputConfig.Builder> outputConfig) {
            return this.outputConfig((ConfiguredAudienceModelOutputConfig)((ConfiguredAudienceModelOutputConfig.Builder)ConfiguredAudienceModelOutputConfig.builder().applyMutation(outputConfig)).build());
        }

        public Builder sharedAudienceMetricsWithStrings(Collection<String> var1);

        public Builder sharedAudienceMetricsWithStrings(String ... var1);

        public Builder sharedAudienceMetrics(Collection<SharedAudienceMetrics> var1);

        public Builder sharedAudienceMetrics(SharedAudienceMetrics ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

