/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cleanroomsml.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum AudienceModelMetricType {
    NORMALIZED_DISCOUNTED_CUMULATIVE_GAIN("NORMALIZED_DISCOUNTED_CUMULATIVE_GAIN"),
    MEAN_RECIPROCAL_RANK("MEAN_RECIPROCAL_RANK"),
    PRECISION("PRECISION"),
    RECALL("RECALL"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, AudienceModelMetricType> VALUE_MAP;
    private final String value;

    private AudienceModelMetricType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static AudienceModelMetricType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<AudienceModelMetricType> knownValues() {
        EnumSet<AudienceModelMetricType> knownValues = EnumSet.allOf(AudienceModelMetricType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(AudienceModelMetricType.class, AudienceModelMetricType::toString);
    }
}

