/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cleanrooms.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cleanrooms.model.Change;
import software.amazon.awssdk.services.cleanrooms.model.ChangeListCopier;
import software.amazon.awssdk.services.cleanrooms.model.ChangeRequestStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CollaborationChangeRequestSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CollaborationChangeRequestSummary> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(CollaborationChangeRequestSummary.getter(CollaborationChangeRequestSummary::id)).setter(CollaborationChangeRequestSummary.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<String> COLLABORATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("collaborationId").getter(CollaborationChangeRequestSummary.getter(CollaborationChangeRequestSummary::collaborationId)).setter(CollaborationChangeRequestSummary.setter(Builder::collaborationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("collaborationId").build()}).build();
    private static final SdkField<Instant> CREATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createTime").getter(CollaborationChangeRequestSummary.getter(CollaborationChangeRequestSummary::createTime)).setter(CollaborationChangeRequestSummary.setter(Builder::createTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createTime").build()}).build();
    private static final SdkField<Instant> UPDATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("updateTime").getter(CollaborationChangeRequestSummary.getter(CollaborationChangeRequestSummary::updateTime)).setter(CollaborationChangeRequestSummary.setter(Builder::updateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updateTime").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(CollaborationChangeRequestSummary.getter(CollaborationChangeRequestSummary::statusAsString)).setter(CollaborationChangeRequestSummary.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<Boolean> IS_AUTO_APPROVED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("isAutoApproved").getter(CollaborationChangeRequestSummary.getter(CollaborationChangeRequestSummary::isAutoApproved)).setter(CollaborationChangeRequestSummary.setter(Builder::isAutoApproved)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isAutoApproved").build()}).build();
    private static final SdkField<List<Change>> CHANGES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("changes").getter(CollaborationChangeRequestSummary.getter(CollaborationChangeRequestSummary::changes)).setter(CollaborationChangeRequestSummary.setter(Builder::changes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("changes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Change::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, COLLABORATION_ID_FIELD, CREATE_TIME_FIELD, UPDATE_TIME_FIELD, STATUS_FIELD, IS_AUTO_APPROVED_FIELD, CHANGES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CollaborationChangeRequestSummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String id;
    private final String collaborationId;
    private final Instant createTime;
    private final Instant updateTime;
    private final String status;
    private final Boolean isAutoApproved;
    private final List<Change> changes;

    private CollaborationChangeRequestSummary(BuilderImpl builder) {
        this.id = builder.id;
        this.collaborationId = builder.collaborationId;
        this.createTime = builder.createTime;
        this.updateTime = builder.updateTime;
        this.status = builder.status;
        this.isAutoApproved = builder.isAutoApproved;
        this.changes = builder.changes;
    }

    public final String id() {
        return this.id;
    }

    public final String collaborationId() {
        return this.collaborationId;
    }

    public final Instant createTime() {
        return this.createTime;
    }

    public final Instant updateTime() {
        return this.updateTime;
    }

    public final ChangeRequestStatus status() {
        return ChangeRequestStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final Boolean isAutoApproved() {
        return this.isAutoApproved;
    }

    public final boolean hasChanges() {
        return this.changes != null && !(this.changes instanceof SdkAutoConstructList);
    }

    public final List<Change> changes() {
        return this.changes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.collaborationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.createTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.updateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.isAutoApproved());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasChanges() ? this.changes() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CollaborationChangeRequestSummary)) {
            return false;
        }
        CollaborationChangeRequestSummary other = (CollaborationChangeRequestSummary)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.collaborationId(), other.collaborationId()) && Objects.equals(this.createTime(), other.createTime()) && Objects.equals(this.updateTime(), other.updateTime()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.isAutoApproved(), other.isAutoApproved()) && this.hasChanges() == other.hasChanges() && Objects.equals(this.changes(), other.changes());
    }

    public final String toString() {
        return ToString.builder((String)"CollaborationChangeRequestSummary").add("Id", (Object)this.id()).add("CollaborationId", (Object)this.collaborationId()).add("CreateTime", (Object)this.createTime()).add("UpdateTime", (Object)this.updateTime()).add("Status", (Object)this.statusAsString()).add("IsAutoApproved", (Object)this.isAutoApproved()).add("Changes", this.hasChanges() ? this.changes() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "collaborationId": {
                return Optional.ofNullable(clazz.cast(this.collaborationId()));
            }
            case "createTime": {
                return Optional.ofNullable(clazz.cast(this.createTime()));
            }
            case "updateTime": {
                return Optional.ofNullable(clazz.cast(this.updateTime()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "isAutoApproved": {
                return Optional.ofNullable(clazz.cast(this.isAutoApproved()));
            }
            case "changes": {
                return Optional.ofNullable(clazz.cast(this.changes()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("id", ID_FIELD);
        map.put("collaborationId", COLLABORATION_ID_FIELD);
        map.put("createTime", CREATE_TIME_FIELD);
        map.put("updateTime", UPDATE_TIME_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("isAutoApproved", IS_AUTO_APPROVED_FIELD);
        map.put("changes", CHANGES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CollaborationChangeRequestSummary, T> g) {
        return obj -> g.apply((CollaborationChangeRequestSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private String collaborationId;
        private Instant createTime;
        private Instant updateTime;
        private String status;
        private Boolean isAutoApproved;
        private List<Change> changes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CollaborationChangeRequestSummary model) {
            this.id(model.id);
            this.collaborationId(model.collaborationId);
            this.createTime(model.createTime);
            this.updateTime(model.updateTime);
            this.status(model.status);
            this.isAutoApproved(model.isAutoApproved);
            this.changes(model.changes);
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getCollaborationId() {
            return this.collaborationId;
        }

        public final void setCollaborationId(String collaborationId) {
            this.collaborationId = collaborationId;
        }

        @Override
        public final Builder collaborationId(String collaborationId) {
            this.collaborationId = collaborationId;
            return this;
        }

        public final Instant getCreateTime() {
            return this.createTime;
        }

        public final void setCreateTime(Instant createTime) {
            this.createTime = createTime;
        }

        @Override
        public final Builder createTime(Instant createTime) {
            this.createTime = createTime;
            return this;
        }

        public final Instant getUpdateTime() {
            return this.updateTime;
        }

        public final void setUpdateTime(Instant updateTime) {
            this.updateTime = updateTime;
        }

        @Override
        public final Builder updateTime(Instant updateTime) {
            this.updateTime = updateTime;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ChangeRequestStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Boolean getIsAutoApproved() {
            return this.isAutoApproved;
        }

        public final void setIsAutoApproved(Boolean isAutoApproved) {
            this.isAutoApproved = isAutoApproved;
        }

        @Override
        public final Builder isAutoApproved(Boolean isAutoApproved) {
            this.isAutoApproved = isAutoApproved;
            return this;
        }

        public final List<Change.Builder> getChanges() {
            List<Change.Builder> result = ChangeListCopier.copyToBuilder(this.changes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setChanges(Collection<Change.BuilderImpl> changes) {
            this.changes = ChangeListCopier.copyFromBuilder(changes);
        }

        @Override
        public final Builder changes(Collection<Change> changes) {
            this.changes = ChangeListCopier.copy(changes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder changes(Change ... changes) {
            this.changes(Arrays.asList(changes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder changes(Consumer<Change.Builder> ... changes) {
            this.changes(Stream.of(changes).map(c -> (Change)((Change.Builder)Change.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public CollaborationChangeRequestSummary build() {
            return new CollaborationChangeRequestSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CollaborationChangeRequestSummary> {
        public Builder id(String var1);

        public Builder collaborationId(String var1);

        public Builder createTime(Instant var1);

        public Builder updateTime(Instant var1);

        public Builder status(String var1);

        public Builder status(ChangeRequestStatus var1);

        public Builder isAutoApproved(Boolean var1);

        public Builder changes(Collection<Change> var1);

        public Builder changes(Change ... var1);

        public Builder changes(Consumer<Change.Builder> ... var1);
    }
}

