/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cleanrooms.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configuration of the compute resources for workers running an analysis with the Clean Rooms SQL analytics engine.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class WorkerComputeConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<WorkerComputeConfiguration.Builder, WorkerComputeConfiguration> {
    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(WorkerComputeConfiguration::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final SdkField<Integer> NUMBER_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("number").getter(getter(WorkerComputeConfiguration::number)).setter(setter(Builder::number))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("number").build()).build();

    private static final SdkField<WorkerComputeConfigurationProperties> PROPERTIES_FIELD = SdkField
            .<WorkerComputeConfigurationProperties> builder(MarshallingType.SDK_POJO).memberName("properties")
            .getter(getter(WorkerComputeConfiguration::properties)).setter(setter(Builder::properties))
            .constructor(WorkerComputeConfigurationProperties::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("properties").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, NUMBER_FIELD,
            PROPERTIES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String type;

    private final Integer number;

    private final WorkerComputeConfigurationProperties properties;

    private WorkerComputeConfiguration(BuilderImpl builder) {
        this.type = builder.type;
        this.number = builder.number;
        this.properties = builder.properties;
    }

    /**
     * <p>
     * The worker compute configuration type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link WorkerComputeType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The worker compute configuration type.
     * @see WorkerComputeType
     */
    public final WorkerComputeType type() {
        return WorkerComputeType.fromValue(type);
    }

    /**
     * <p>
     * The worker compute configuration type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link WorkerComputeType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The worker compute configuration type.
     * @see WorkerComputeType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The number of workers.
     * </p>
     * <p>
     * SQL queries support a minimum value of 2 and a maximum value of 400.
     * </p>
     * <p>
     * PySpark jobs support a minimum value of 4 and a maximum value of 128.
     * </p>
     * 
     * @return The number of workers.</p>
     *         <p>
     *         SQL queries support a minimum value of 2 and a maximum value of 400.
     *         </p>
     *         <p>
     *         PySpark jobs support a minimum value of 4 and a maximum value of 128.
     */
    public final Integer number() {
        return number;
    }

    /**
     * <p>
     * The configuration properties for the worker compute environment. These properties allow you to customize the
     * compute settings for your Clean Rooms workloads.
     * </p>
     * 
     * @return The configuration properties for the worker compute environment. These properties allow you to customize
     *         the compute settings for your Clean Rooms workloads.
     */
    public final WorkerComputeConfigurationProperties properties() {
        return properties;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(number());
        hashCode = 31 * hashCode + Objects.hashCode(properties());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WorkerComputeConfiguration)) {
            return false;
        }
        WorkerComputeConfiguration other = (WorkerComputeConfiguration) obj;
        return Objects.equals(typeAsString(), other.typeAsString()) && Objects.equals(number(), other.number())
                && Objects.equals(properties(), other.properties());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("WorkerComputeConfiguration").add("Type", typeAsString()).add("Number", number())
                .add("Properties", properties()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "number":
            return Optional.ofNullable(clazz.cast(number()));
        case "properties":
            return Optional.ofNullable(clazz.cast(properties()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("type", TYPE_FIELD);
        map.put("number", NUMBER_FIELD);
        map.put("properties", PROPERTIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<WorkerComputeConfiguration, T> g) {
        return obj -> g.apply((WorkerComputeConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, WorkerComputeConfiguration> {
        /**
         * <p>
         * The worker compute configuration type.
         * </p>
         * 
         * @param type
         *        The worker compute configuration type.
         * @see WorkerComputeType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WorkerComputeType
         */
        Builder type(String type);

        /**
         * <p>
         * The worker compute configuration type.
         * </p>
         * 
         * @param type
         *        The worker compute configuration type.
         * @see WorkerComputeType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WorkerComputeType
         */
        Builder type(WorkerComputeType type);

        /**
         * <p>
         * The number of workers.
         * </p>
         * <p>
         * SQL queries support a minimum value of 2 and a maximum value of 400.
         * </p>
         * <p>
         * PySpark jobs support a minimum value of 4 and a maximum value of 128.
         * </p>
         * 
         * @param number
         *        The number of workers.</p>
         *        <p>
         *        SQL queries support a minimum value of 2 and a maximum value of 400.
         *        </p>
         *        <p>
         *        PySpark jobs support a minimum value of 4 and a maximum value of 128.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder number(Integer number);

        /**
         * <p>
         * The configuration properties for the worker compute environment. These properties allow you to customize the
         * compute settings for your Clean Rooms workloads.
         * </p>
         * 
         * @param properties
         *        The configuration properties for the worker compute environment. These properties allow you to
         *        customize the compute settings for your Clean Rooms workloads.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder properties(WorkerComputeConfigurationProperties properties);

        /**
         * <p>
         * The configuration properties for the worker compute environment. These properties allow you to customize the
         * compute settings for your Clean Rooms workloads.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link WorkerComputeConfigurationProperties.Builder} avoiding the need to create one manually via
         * {@link WorkerComputeConfigurationProperties#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link WorkerComputeConfigurationProperties.Builder#build()} is called
         * immediately and its result is passed to {@link #properties(WorkerComputeConfigurationProperties)}.
         * 
         * @param properties
         *        a consumer that will call methods on {@link WorkerComputeConfigurationProperties.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #properties(WorkerComputeConfigurationProperties)
         */
        default Builder properties(Consumer<WorkerComputeConfigurationProperties.Builder> properties) {
            return properties(WorkerComputeConfigurationProperties.builder().applyMutation(properties).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String type;

        private Integer number;

        private WorkerComputeConfigurationProperties properties;

        private BuilderImpl() {
        }

        private BuilderImpl(WorkerComputeConfiguration model) {
            type(model.type);
            number(model.number);
            properties(model.properties);
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(WorkerComputeType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final Integer getNumber() {
            return number;
        }

        public final void setNumber(Integer number) {
            this.number = number;
        }

        @Override
        public final Builder number(Integer number) {
            this.number = number;
            return this;
        }

        public final WorkerComputeConfigurationProperties.Builder getProperties() {
            return properties != null ? properties.toBuilder() : null;
        }

        public final void setProperties(WorkerComputeConfigurationProperties.BuilderImpl properties) {
            this.properties = properties != null ? properties.build() : null;
        }

        @Override
        public final Builder properties(WorkerComputeConfigurationProperties properties) {
            this.properties = properties;
            return this;
        }

        @Override
        public WorkerComputeConfiguration build() {
            return new WorkerComputeConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
