/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cleanrooms.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateIdNamespaceAssociationRequest extends CleanRoomsRequest implements
        ToCopyableBuilder<UpdateIdNamespaceAssociationRequest.Builder, UpdateIdNamespaceAssociationRequest> {
    private static final SdkField<String> ID_NAMESPACE_ASSOCIATION_IDENTIFIER_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("idNamespaceAssociationIdentifier")
            .getter(getter(UpdateIdNamespaceAssociationRequest::idNamespaceAssociationIdentifier))
            .setter(setter(Builder::idNamespaceAssociationIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("idNamespaceAssociationIdentifier")
                    .build()).build();

    private static final SdkField<String> MEMBERSHIP_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("membershipIdentifier").getter(getter(UpdateIdNamespaceAssociationRequest::membershipIdentifier))
            .setter(setter(Builder::membershipIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("membershipIdentifier").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(UpdateIdNamespaceAssociationRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(UpdateIdNamespaceAssociationRequest::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<IdMappingConfig> ID_MAPPING_CONFIG_FIELD = SdkField
            .<IdMappingConfig> builder(MarshallingType.SDK_POJO).memberName("idMappingConfig")
            .getter(getter(UpdateIdNamespaceAssociationRequest::idMappingConfig)).setter(setter(Builder::idMappingConfig))
            .constructor(IdMappingConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("idMappingConfig").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            ID_NAMESPACE_ASSOCIATION_IDENTIFIER_FIELD, MEMBERSHIP_IDENTIFIER_FIELD, NAME_FIELD, DESCRIPTION_FIELD,
            ID_MAPPING_CONFIG_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String idNamespaceAssociationIdentifier;

    private final String membershipIdentifier;

    private final String name;

    private final String description;

    private final IdMappingConfig idMappingConfig;

    private UpdateIdNamespaceAssociationRequest(BuilderImpl builder) {
        super(builder);
        this.idNamespaceAssociationIdentifier = builder.idNamespaceAssociationIdentifier;
        this.membershipIdentifier = builder.membershipIdentifier;
        this.name = builder.name;
        this.description = builder.description;
        this.idMappingConfig = builder.idMappingConfig;
    }

    /**
     * <p>
     * The unique identifier of the ID namespace association that you want to update.
     * </p>
     * 
     * @return The unique identifier of the ID namespace association that you want to update.
     */
    public final String idNamespaceAssociationIdentifier() {
        return idNamespaceAssociationIdentifier;
    }

    /**
     * <p>
     * The unique identifier of the membership that contains the ID namespace association that you want to update.
     * </p>
     * 
     * @return The unique identifier of the membership that contains the ID namespace association that you want to
     *         update.
     */
    public final String membershipIdentifier() {
        return membershipIdentifier;
    }

    /**
     * <p>
     * A new name for the ID namespace association.
     * </p>
     * 
     * @return A new name for the ID namespace association.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * A new description for the ID namespace association.
     * </p>
     * 
     * @return A new description for the ID namespace association.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The configuration settings for the ID mapping table.
     * </p>
     * 
     * @return The configuration settings for the ID mapping table.
     */
    public final IdMappingConfig idMappingConfig() {
        return idMappingConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(idNamespaceAssociationIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(membershipIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(idMappingConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateIdNamespaceAssociationRequest)) {
            return false;
        }
        UpdateIdNamespaceAssociationRequest other = (UpdateIdNamespaceAssociationRequest) obj;
        return Objects.equals(idNamespaceAssociationIdentifier(), other.idNamespaceAssociationIdentifier())
                && Objects.equals(membershipIdentifier(), other.membershipIdentifier()) && Objects.equals(name(), other.name())
                && Objects.equals(description(), other.description())
                && Objects.equals(idMappingConfig(), other.idMappingConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateIdNamespaceAssociationRequest")
                .add("IdNamespaceAssociationIdentifier", idNamespaceAssociationIdentifier())
                .add("MembershipIdentifier", membershipIdentifier()).add("Name", name()).add("Description", description())
                .add("IdMappingConfig", idMappingConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "idNamespaceAssociationIdentifier":
            return Optional.ofNullable(clazz.cast(idNamespaceAssociationIdentifier()));
        case "membershipIdentifier":
            return Optional.ofNullable(clazz.cast(membershipIdentifier()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "idMappingConfig":
            return Optional.ofNullable(clazz.cast(idMappingConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("idNamespaceAssociationIdentifier", ID_NAMESPACE_ASSOCIATION_IDENTIFIER_FIELD);
        map.put("membershipIdentifier", MEMBERSHIP_IDENTIFIER_FIELD);
        map.put("name", NAME_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("idMappingConfig", ID_MAPPING_CONFIG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateIdNamespaceAssociationRequest, T> g) {
        return obj -> g.apply((UpdateIdNamespaceAssociationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends CleanRoomsRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateIdNamespaceAssociationRequest> {
        /**
         * <p>
         * The unique identifier of the ID namespace association that you want to update.
         * </p>
         * 
         * @param idNamespaceAssociationIdentifier
         *        The unique identifier of the ID namespace association that you want to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder idNamespaceAssociationIdentifier(String idNamespaceAssociationIdentifier);

        /**
         * <p>
         * The unique identifier of the membership that contains the ID namespace association that you want to update.
         * </p>
         * 
         * @param membershipIdentifier
         *        The unique identifier of the membership that contains the ID namespace association that you want to
         *        update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder membershipIdentifier(String membershipIdentifier);

        /**
         * <p>
         * A new name for the ID namespace association.
         * </p>
         * 
         * @param name
         *        A new name for the ID namespace association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * A new description for the ID namespace association.
         * </p>
         * 
         * @param description
         *        A new description for the ID namespace association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The configuration settings for the ID mapping table.
         * </p>
         * 
         * @param idMappingConfig
         *        The configuration settings for the ID mapping table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder idMappingConfig(IdMappingConfig idMappingConfig);

        /**
         * <p>
         * The configuration settings for the ID mapping table.
         * </p>
         * This is a convenience method that creates an instance of the {@link IdMappingConfig.Builder} avoiding the
         * need to create one manually via {@link IdMappingConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link IdMappingConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #idMappingConfig(IdMappingConfig)}.
         * 
         * @param idMappingConfig
         *        a consumer that will call methods on {@link IdMappingConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #idMappingConfig(IdMappingConfig)
         */
        default Builder idMappingConfig(Consumer<IdMappingConfig.Builder> idMappingConfig) {
            return idMappingConfig(IdMappingConfig.builder().applyMutation(idMappingConfig).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CleanRoomsRequest.BuilderImpl implements Builder {
        private String idNamespaceAssociationIdentifier;

        private String membershipIdentifier;

        private String name;

        private String description;

        private IdMappingConfig idMappingConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateIdNamespaceAssociationRequest model) {
            super(model);
            idNamespaceAssociationIdentifier(model.idNamespaceAssociationIdentifier);
            membershipIdentifier(model.membershipIdentifier);
            name(model.name);
            description(model.description);
            idMappingConfig(model.idMappingConfig);
        }

        public final String getIdNamespaceAssociationIdentifier() {
            return idNamespaceAssociationIdentifier;
        }

        public final void setIdNamespaceAssociationIdentifier(String idNamespaceAssociationIdentifier) {
            this.idNamespaceAssociationIdentifier = idNamespaceAssociationIdentifier;
        }

        @Override
        public final Builder idNamespaceAssociationIdentifier(String idNamespaceAssociationIdentifier) {
            this.idNamespaceAssociationIdentifier = idNamespaceAssociationIdentifier;
            return this;
        }

        public final String getMembershipIdentifier() {
            return membershipIdentifier;
        }

        public final void setMembershipIdentifier(String membershipIdentifier) {
            this.membershipIdentifier = membershipIdentifier;
        }

        @Override
        public final Builder membershipIdentifier(String membershipIdentifier) {
            this.membershipIdentifier = membershipIdentifier;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final IdMappingConfig.Builder getIdMappingConfig() {
            return idMappingConfig != null ? idMappingConfig.toBuilder() : null;
        }

        public final void setIdMappingConfig(IdMappingConfig.BuilderImpl idMappingConfig) {
            this.idMappingConfig = idMappingConfig != null ? idMappingConfig.build() : null;
        }

        @Override
        public final Builder idMappingConfig(IdMappingConfig idMappingConfig) {
            this.idMappingConfig = idMappingConfig;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateIdNamespaceAssociationRequest build() {
            return new UpdateIdNamespaceAssociationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
