/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cleanrooms.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateConfiguredTableAssociationResponse extends CleanRoomsResponse implements
        ToCopyableBuilder<UpdateConfiguredTableAssociationResponse.Builder, UpdateConfiguredTableAssociationResponse> {
    private static final SdkField<ConfiguredTableAssociation> CONFIGURED_TABLE_ASSOCIATION_FIELD = SdkField
            .<ConfiguredTableAssociation> builder(MarshallingType.SDK_POJO)
            .memberName("configuredTableAssociation")
            .getter(getter(UpdateConfiguredTableAssociationResponse::configuredTableAssociation))
            .setter(setter(Builder::configuredTableAssociation))
            .constructor(ConfiguredTableAssociation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configuredTableAssociation").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(CONFIGURED_TABLE_ASSOCIATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final ConfiguredTableAssociation configuredTableAssociation;

    private UpdateConfiguredTableAssociationResponse(BuilderImpl builder) {
        super(builder);
        this.configuredTableAssociation = builder.configuredTableAssociation;
    }

    /**
     * <p>
     * The entire updated configured table association.
     * </p>
     * 
     * @return The entire updated configured table association.
     */
    public final ConfiguredTableAssociation configuredTableAssociation() {
        return configuredTableAssociation;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(configuredTableAssociation());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateConfiguredTableAssociationResponse)) {
            return false;
        }
        UpdateConfiguredTableAssociationResponse other = (UpdateConfiguredTableAssociationResponse) obj;
        return Objects.equals(configuredTableAssociation(), other.configuredTableAssociation());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateConfiguredTableAssociationResponse")
                .add("ConfiguredTableAssociation", configuredTableAssociation()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "configuredTableAssociation":
            return Optional.ofNullable(clazz.cast(configuredTableAssociation()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("configuredTableAssociation", CONFIGURED_TABLE_ASSOCIATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateConfiguredTableAssociationResponse, T> g) {
        return obj -> g.apply((UpdateConfiguredTableAssociationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends CleanRoomsResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateConfiguredTableAssociationResponse> {
        /**
         * <p>
         * The entire updated configured table association.
         * </p>
         * 
         * @param configuredTableAssociation
         *        The entire updated configured table association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configuredTableAssociation(ConfiguredTableAssociation configuredTableAssociation);

        /**
         * <p>
         * The entire updated configured table association.
         * </p>
         * This is a convenience method that creates an instance of the {@link ConfiguredTableAssociation.Builder}
         * avoiding the need to create one manually via {@link ConfiguredTableAssociation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ConfiguredTableAssociation.Builder#build()} is called immediately
         * and its result is passed to {@link #configuredTableAssociation(ConfiguredTableAssociation)}.
         * 
         * @param configuredTableAssociation
         *        a consumer that will call methods on {@link ConfiguredTableAssociation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #configuredTableAssociation(ConfiguredTableAssociation)
         */
        default Builder configuredTableAssociation(Consumer<ConfiguredTableAssociation.Builder> configuredTableAssociation) {
            return configuredTableAssociation(ConfiguredTableAssociation.builder().applyMutation(configuredTableAssociation)
                    .build());
        }
    }

    static final class BuilderImpl extends CleanRoomsResponse.BuilderImpl implements Builder {
        private ConfiguredTableAssociation configuredTableAssociation;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateConfiguredTableAssociationResponse model) {
            super(model);
            configuredTableAssociation(model.configuredTableAssociation);
        }

        public final ConfiguredTableAssociation.Builder getConfiguredTableAssociation() {
            return configuredTableAssociation != null ? configuredTableAssociation.toBuilder() : null;
        }

        public final void setConfiguredTableAssociation(ConfiguredTableAssociation.BuilderImpl configuredTableAssociation) {
            this.configuredTableAssociation = configuredTableAssociation != null ? configuredTableAssociation.build() : null;
        }

        @Override
        public final Builder configuredTableAssociation(ConfiguredTableAssociation configuredTableAssociation) {
            this.configuredTableAssociation = configuredTableAssociation;
            return this;
        }

        @Override
        public UpdateConfiguredTableAssociationResponse build() {
            return new UpdateConfiguredTableAssociationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
