/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cleanrooms.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateCollaborationRequest extends CleanRoomsRequest implements
        ToCopyableBuilder<UpdateCollaborationRequest.Builder, UpdateCollaborationRequest> {
    private static final SdkField<String> COLLABORATION_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("collaborationIdentifier").getter(getter(UpdateCollaborationRequest::collaborationIdentifier))
            .setter(setter(Builder::collaborationIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("collaborationIdentifier").build())
            .build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(UpdateCollaborationRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(UpdateCollaborationRequest::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> ANALYTICS_ENGINE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("analyticsEngine").getter(getter(UpdateCollaborationRequest::analyticsEngineAsString))
            .setter(setter(Builder::analyticsEngine))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("analyticsEngine").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            COLLABORATION_IDENTIFIER_FIELD, NAME_FIELD, DESCRIPTION_FIELD, ANALYTICS_ENGINE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String collaborationIdentifier;

    private final String name;

    private final String description;

    private final String analyticsEngine;

    private UpdateCollaborationRequest(BuilderImpl builder) {
        super(builder);
        this.collaborationIdentifier = builder.collaborationIdentifier;
        this.name = builder.name;
        this.description = builder.description;
        this.analyticsEngine = builder.analyticsEngine;
    }

    /**
     * <p>
     * The identifier for the collaboration.
     * </p>
     * 
     * @return The identifier for the collaboration.
     */
    public final String collaborationIdentifier() {
        return collaborationIdentifier;
    }

    /**
     * <p>
     * A human-readable identifier provided by the collaboration owner. Display names are not unique.
     * </p>
     * 
     * @return A human-readable identifier provided by the collaboration owner. Display names are not unique.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * A description of the collaboration.
     * </p>
     * 
     * @return A description of the collaboration.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The analytics engine.
     * </p>
     * <note>
     * <p>
     * After July 16, 2025, the <code>CLEAN_ROOMS_SQL</code> parameter will no longer be available.
     * </p>
     * </note>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #analyticsEngine}
     * will return {@link AnalyticsEngine#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #analyticsEngineAsString}.
     * </p>
     * 
     * @return The analytics engine.</p> <note>
     *         <p>
     *         After July 16, 2025, the <code>CLEAN_ROOMS_SQL</code> parameter will no longer be available.
     *         </p>
     * @see AnalyticsEngine
     */
    public final AnalyticsEngine analyticsEngine() {
        return AnalyticsEngine.fromValue(analyticsEngine);
    }

    /**
     * <p>
     * The analytics engine.
     * </p>
     * <note>
     * <p>
     * After July 16, 2025, the <code>CLEAN_ROOMS_SQL</code> parameter will no longer be available.
     * </p>
     * </note>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #analyticsEngine}
     * will return {@link AnalyticsEngine#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #analyticsEngineAsString}.
     * </p>
     * 
     * @return The analytics engine.</p> <note>
     *         <p>
     *         After July 16, 2025, the <code>CLEAN_ROOMS_SQL</code> parameter will no longer be available.
     *         </p>
     * @see AnalyticsEngine
     */
    public final String analyticsEngineAsString() {
        return analyticsEngine;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(collaborationIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(analyticsEngineAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateCollaborationRequest)) {
            return false;
        }
        UpdateCollaborationRequest other = (UpdateCollaborationRequest) obj;
        return Objects.equals(collaborationIdentifier(), other.collaborationIdentifier()) && Objects.equals(name(), other.name())
                && Objects.equals(description(), other.description())
                && Objects.equals(analyticsEngineAsString(), other.analyticsEngineAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateCollaborationRequest").add("CollaborationIdentifier", collaborationIdentifier())
                .add("Name", name()).add("Description", description()).add("AnalyticsEngine", analyticsEngineAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "collaborationIdentifier":
            return Optional.ofNullable(clazz.cast(collaborationIdentifier()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "analyticsEngine":
            return Optional.ofNullable(clazz.cast(analyticsEngineAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("collaborationIdentifier", COLLABORATION_IDENTIFIER_FIELD);
        map.put("name", NAME_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("analyticsEngine", ANALYTICS_ENGINE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateCollaborationRequest, T> g) {
        return obj -> g.apply((UpdateCollaborationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends CleanRoomsRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateCollaborationRequest> {
        /**
         * <p>
         * The identifier for the collaboration.
         * </p>
         * 
         * @param collaborationIdentifier
         *        The identifier for the collaboration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder collaborationIdentifier(String collaborationIdentifier);

        /**
         * <p>
         * A human-readable identifier provided by the collaboration owner. Display names are not unique.
         * </p>
         * 
         * @param name
         *        A human-readable identifier provided by the collaboration owner. Display names are not unique.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * A description of the collaboration.
         * </p>
         * 
         * @param description
         *        A description of the collaboration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The analytics engine.
         * </p>
         * <note>
         * <p>
         * After July 16, 2025, the <code>CLEAN_ROOMS_SQL</code> parameter will no longer be available.
         * </p>
         * </note>
         * 
         * @param analyticsEngine
         *        The analytics engine.</p> <note>
         *        <p>
         *        After July 16, 2025, the <code>CLEAN_ROOMS_SQL</code> parameter will no longer be available.
         *        </p>
         * @see AnalyticsEngine
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AnalyticsEngine
         */
        Builder analyticsEngine(String analyticsEngine);

        /**
         * <p>
         * The analytics engine.
         * </p>
         * <note>
         * <p>
         * After July 16, 2025, the <code>CLEAN_ROOMS_SQL</code> parameter will no longer be available.
         * </p>
         * </note>
         * 
         * @param analyticsEngine
         *        The analytics engine.</p> <note>
         *        <p>
         *        After July 16, 2025, the <code>CLEAN_ROOMS_SQL</code> parameter will no longer be available.
         *        </p>
         * @see AnalyticsEngine
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AnalyticsEngine
         */
        Builder analyticsEngine(AnalyticsEngine analyticsEngine);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CleanRoomsRequest.BuilderImpl implements Builder {
        private String collaborationIdentifier;

        private String name;

        private String description;

        private String analyticsEngine;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateCollaborationRequest model) {
            super(model);
            collaborationIdentifier(model.collaborationIdentifier);
            name(model.name);
            description(model.description);
            analyticsEngine(model.analyticsEngine);
        }

        public final String getCollaborationIdentifier() {
            return collaborationIdentifier;
        }

        public final void setCollaborationIdentifier(String collaborationIdentifier) {
            this.collaborationIdentifier = collaborationIdentifier;
        }

        @Override
        public final Builder collaborationIdentifier(String collaborationIdentifier) {
            this.collaborationIdentifier = collaborationIdentifier;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getAnalyticsEngine() {
            return analyticsEngine;
        }

        public final void setAnalyticsEngine(String analyticsEngine) {
            this.analyticsEngine = analyticsEngine;
        }

        @Override
        public final Builder analyticsEngine(String analyticsEngine) {
            this.analyticsEngine = analyticsEngine;
            return this;
        }

        @Override
        public final Builder analyticsEngine(AnalyticsEngine analyticsEngine) {
            this.analyticsEngine(analyticsEngine == null ? null : analyticsEngine.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateCollaborationRequest build() {
            return new UpdateCollaborationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
