/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cleanrooms.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartProtectedJobRequest extends CleanRoomsRequest implements
        ToCopyableBuilder<StartProtectedJobRequest.Builder, StartProtectedJobRequest> {
    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(StartProtectedJobRequest::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final SdkField<String> MEMBERSHIP_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("membershipIdentifier").getter(getter(StartProtectedJobRequest::membershipIdentifier))
            .setter(setter(Builder::membershipIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("membershipIdentifier").build()).build();

    private static final SdkField<ProtectedJobParameters> JOB_PARAMETERS_FIELD = SdkField
            .<ProtectedJobParameters> builder(MarshallingType.SDK_POJO).memberName("jobParameters")
            .getter(getter(StartProtectedJobRequest::jobParameters)).setter(setter(Builder::jobParameters))
            .constructor(ProtectedJobParameters::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobParameters").build()).build();

    private static final SdkField<ProtectedJobResultConfigurationInput> RESULT_CONFIGURATION_FIELD = SdkField
            .<ProtectedJobResultConfigurationInput> builder(MarshallingType.SDK_POJO).memberName("resultConfiguration")
            .getter(getter(StartProtectedJobRequest::resultConfiguration)).setter(setter(Builder::resultConfiguration))
            .constructor(ProtectedJobResultConfigurationInput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resultConfiguration").build())
            .build();

    private static final SdkField<ProtectedJobComputeConfiguration> COMPUTE_CONFIGURATION_FIELD = SdkField
            .<ProtectedJobComputeConfiguration> builder(MarshallingType.SDK_POJO).memberName("computeConfiguration")
            .getter(getter(StartProtectedJobRequest::computeConfiguration)).setter(setter(Builder::computeConfiguration))
            .constructor(ProtectedJobComputeConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("computeConfiguration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD,
            MEMBERSHIP_IDENTIFIER_FIELD, JOB_PARAMETERS_FIELD, RESULT_CONFIGURATION_FIELD, COMPUTE_CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String type;

    private final String membershipIdentifier;

    private final ProtectedJobParameters jobParameters;

    private final ProtectedJobResultConfigurationInput resultConfiguration;

    private final ProtectedJobComputeConfiguration computeConfiguration;

    private StartProtectedJobRequest(BuilderImpl builder) {
        super(builder);
        this.type = builder.type;
        this.membershipIdentifier = builder.membershipIdentifier;
        this.jobParameters = builder.jobParameters;
        this.resultConfiguration = builder.resultConfiguration;
        this.computeConfiguration = builder.computeConfiguration;
    }

    /**
     * <p>
     * The type of protected job to start.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link ProtectedJobType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of protected job to start.
     * @see ProtectedJobType
     */
    public final ProtectedJobType type() {
        return ProtectedJobType.fromValue(type);
    }

    /**
     * <p>
     * The type of protected job to start.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link ProtectedJobType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of protected job to start.
     * @see ProtectedJobType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * A unique identifier for the membership to run this job against. Currently accepts a membership ID.
     * </p>
     * 
     * @return A unique identifier for the membership to run this job against. Currently accepts a membership ID.
     */
    public final String membershipIdentifier() {
        return membershipIdentifier;
    }

    /**
     * <p>
     * The job parameters.
     * </p>
     * 
     * @return The job parameters.
     */
    public final ProtectedJobParameters jobParameters() {
        return jobParameters;
    }

    /**
     * <p>
     * The details needed to write the job results.
     * </p>
     * 
     * @return The details needed to write the job results.
     */
    public final ProtectedJobResultConfigurationInput resultConfiguration() {
        return resultConfiguration;
    }

    /**
     * <p>
     * The compute configuration for the protected job.
     * </p>
     * 
     * @return The compute configuration for the protected job.
     */
    public final ProtectedJobComputeConfiguration computeConfiguration() {
        return computeConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(membershipIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(jobParameters());
        hashCode = 31 * hashCode + Objects.hashCode(resultConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(computeConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartProtectedJobRequest)) {
            return false;
        }
        StartProtectedJobRequest other = (StartProtectedJobRequest) obj;
        return Objects.equals(typeAsString(), other.typeAsString())
                && Objects.equals(membershipIdentifier(), other.membershipIdentifier())
                && Objects.equals(jobParameters(), other.jobParameters())
                && Objects.equals(resultConfiguration(), other.resultConfiguration())
                && Objects.equals(computeConfiguration(), other.computeConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartProtectedJobRequest").add("Type", typeAsString())
                .add("MembershipIdentifier", membershipIdentifier()).add("JobParameters", jobParameters())
                .add("ResultConfiguration", resultConfiguration()).add("ComputeConfiguration", computeConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "membershipIdentifier":
            return Optional.ofNullable(clazz.cast(membershipIdentifier()));
        case "jobParameters":
            return Optional.ofNullable(clazz.cast(jobParameters()));
        case "resultConfiguration":
            return Optional.ofNullable(clazz.cast(resultConfiguration()));
        case "computeConfiguration":
            return Optional.ofNullable(clazz.cast(computeConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("type", TYPE_FIELD);
        map.put("membershipIdentifier", MEMBERSHIP_IDENTIFIER_FIELD);
        map.put("jobParameters", JOB_PARAMETERS_FIELD);
        map.put("resultConfiguration", RESULT_CONFIGURATION_FIELD);
        map.put("computeConfiguration", COMPUTE_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StartProtectedJobRequest, T> g) {
        return obj -> g.apply((StartProtectedJobRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends CleanRoomsRequest.Builder, SdkPojo, CopyableBuilder<Builder, StartProtectedJobRequest> {
        /**
         * <p>
         * The type of protected job to start.
         * </p>
         * 
         * @param type
         *        The type of protected job to start.
         * @see ProtectedJobType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProtectedJobType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of protected job to start.
         * </p>
         * 
         * @param type
         *        The type of protected job to start.
         * @see ProtectedJobType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProtectedJobType
         */
        Builder type(ProtectedJobType type);

        /**
         * <p>
         * A unique identifier for the membership to run this job against. Currently accepts a membership ID.
         * </p>
         * 
         * @param membershipIdentifier
         *        A unique identifier for the membership to run this job against. Currently accepts a membership ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder membershipIdentifier(String membershipIdentifier);

        /**
         * <p>
         * The job parameters.
         * </p>
         * 
         * @param jobParameters
         *        The job parameters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobParameters(ProtectedJobParameters jobParameters);

        /**
         * <p>
         * The job parameters.
         * </p>
         * This is a convenience method that creates an instance of the {@link ProtectedJobParameters.Builder} avoiding
         * the need to create one manually via {@link ProtectedJobParameters#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ProtectedJobParameters.Builder#build()} is called immediately and
         * its result is passed to {@link #jobParameters(ProtectedJobParameters)}.
         * 
         * @param jobParameters
         *        a consumer that will call methods on {@link ProtectedJobParameters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #jobParameters(ProtectedJobParameters)
         */
        default Builder jobParameters(Consumer<ProtectedJobParameters.Builder> jobParameters) {
            return jobParameters(ProtectedJobParameters.builder().applyMutation(jobParameters).build());
        }

        /**
         * <p>
         * The details needed to write the job results.
         * </p>
         * 
         * @param resultConfiguration
         *        The details needed to write the job results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resultConfiguration(ProtectedJobResultConfigurationInput resultConfiguration);

        /**
         * <p>
         * The details needed to write the job results.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link ProtectedJobResultConfigurationInput.Builder} avoiding the need to create one manually via
         * {@link ProtectedJobResultConfigurationInput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ProtectedJobResultConfigurationInput.Builder#build()} is called
         * immediately and its result is passed to {@link #resultConfiguration(ProtectedJobResultConfigurationInput)}.
         * 
         * @param resultConfiguration
         *        a consumer that will call methods on {@link ProtectedJobResultConfigurationInput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resultConfiguration(ProtectedJobResultConfigurationInput)
         */
        default Builder resultConfiguration(Consumer<ProtectedJobResultConfigurationInput.Builder> resultConfiguration) {
            return resultConfiguration(ProtectedJobResultConfigurationInput.builder().applyMutation(resultConfiguration).build());
        }

        /**
         * <p>
         * The compute configuration for the protected job.
         * </p>
         * 
         * @param computeConfiguration
         *        The compute configuration for the protected job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder computeConfiguration(ProtectedJobComputeConfiguration computeConfiguration);

        /**
         * <p>
         * The compute configuration for the protected job.
         * </p>
         * This is a convenience method that creates an instance of the {@link ProtectedJobComputeConfiguration.Builder}
         * avoiding the need to create one manually via {@link ProtectedJobComputeConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ProtectedJobComputeConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #computeConfiguration(ProtectedJobComputeConfiguration)}.
         * 
         * @param computeConfiguration
         *        a consumer that will call methods on {@link ProtectedJobComputeConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #computeConfiguration(ProtectedJobComputeConfiguration)
         */
        default Builder computeConfiguration(Consumer<ProtectedJobComputeConfiguration.Builder> computeConfiguration) {
            return computeConfiguration(ProtectedJobComputeConfiguration.builder().applyMutation(computeConfiguration).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CleanRoomsRequest.BuilderImpl implements Builder {
        private String type;

        private String membershipIdentifier;

        private ProtectedJobParameters jobParameters;

        private ProtectedJobResultConfigurationInput resultConfiguration;

        private ProtectedJobComputeConfiguration computeConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(StartProtectedJobRequest model) {
            super(model);
            type(model.type);
            membershipIdentifier(model.membershipIdentifier);
            jobParameters(model.jobParameters);
            resultConfiguration(model.resultConfiguration);
            computeConfiguration(model.computeConfiguration);
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(ProtectedJobType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getMembershipIdentifier() {
            return membershipIdentifier;
        }

        public final void setMembershipIdentifier(String membershipIdentifier) {
            this.membershipIdentifier = membershipIdentifier;
        }

        @Override
        public final Builder membershipIdentifier(String membershipIdentifier) {
            this.membershipIdentifier = membershipIdentifier;
            return this;
        }

        public final ProtectedJobParameters.Builder getJobParameters() {
            return jobParameters != null ? jobParameters.toBuilder() : null;
        }

        public final void setJobParameters(ProtectedJobParameters.BuilderImpl jobParameters) {
            this.jobParameters = jobParameters != null ? jobParameters.build() : null;
        }

        @Override
        public final Builder jobParameters(ProtectedJobParameters jobParameters) {
            this.jobParameters = jobParameters;
            return this;
        }

        public final ProtectedJobResultConfigurationInput.Builder getResultConfiguration() {
            return resultConfiguration != null ? resultConfiguration.toBuilder() : null;
        }

        public final void setResultConfiguration(ProtectedJobResultConfigurationInput.BuilderImpl resultConfiguration) {
            this.resultConfiguration = resultConfiguration != null ? resultConfiguration.build() : null;
        }

        @Override
        public final Builder resultConfiguration(ProtectedJobResultConfigurationInput resultConfiguration) {
            this.resultConfiguration = resultConfiguration;
            return this;
        }

        public final ProtectedJobComputeConfiguration.Builder getComputeConfiguration() {
            return computeConfiguration != null ? computeConfiguration.toBuilder() : null;
        }

        public final void setComputeConfiguration(ProtectedJobComputeConfiguration.BuilderImpl computeConfiguration) {
            this.computeConfiguration = computeConfiguration != null ? computeConfiguration.build() : null;
        }

        @Override
        public final Builder computeConfiguration(ProtectedJobComputeConfiguration computeConfiguration) {
            this.computeConfiguration = computeConfiguration;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartProtectedJobRequest build() {
            return new StartProtectedJobRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
