/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cleanrooms.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The schema of a Snowflake table.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SnowflakeTableSchema implements SdkPojo, Serializable,
        ToCopyableBuilder<SnowflakeTableSchema.Builder, SnowflakeTableSchema> {
    private static final SdkField<List<SnowflakeTableSchemaV1>> V1_FIELD = SdkField
            .<List<SnowflakeTableSchemaV1>> builder(MarshallingType.LIST)
            .memberName("v1")
            .getter(getter(SnowflakeTableSchema::v1))
            .setter(setter(Builder::v1))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("v1").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SnowflakeTableSchemaV1> builder(MarshallingType.SDK_POJO)
                                            .constructor(SnowflakeTableSchemaV1::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(V1_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<SnowflakeTableSchemaV1> v1;

    private final Type type;

    private SnowflakeTableSchema(BuilderImpl builder) {
        this.v1 = builder.v1;
        this.type = builder.type;
    }

    /**
     * For responses, this returns true if the service returned a value for the V1 property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasV1() {
        return v1 != null && !(v1 instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The schema of a Snowflake table.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasV1} method.
     * </p>
     * 
     * @return The schema of a Snowflake table.
     */
    public final List<SnowflakeTableSchemaV1> v1() {
        return v1;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasV1() ? v1() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SnowflakeTableSchema)) {
            return false;
        }
        SnowflakeTableSchema other = (SnowflakeTableSchema) obj;
        return hasV1() == other.hasV1() && Objects.equals(v1(), other.v1());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SnowflakeTableSchema").add("V1", hasV1() ? v1() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "v1":
            return Optional.ofNullable(clazz.cast(v1()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #v1()} initialized to the given value.
     *
     * <p>
     * The schema of a Snowflake table.
     * </p>
     * 
     * @param v1
     *        The schema of a Snowflake table.
     */
    public static SnowflakeTableSchema fromV1(List<SnowflakeTableSchemaV1> v1) {
        return builder().v1(v1).build();
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("v1", V1_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SnowflakeTableSchema, T> g) {
        return obj -> g.apply((SnowflakeTableSchema) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SnowflakeTableSchema> {
        /**
         * <p>
         * The schema of a Snowflake table.
         * </p>
         * 
         * @param v1
         *        The schema of a Snowflake table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder v1(Collection<SnowflakeTableSchemaV1> v1);

        /**
         * <p>
         * The schema of a Snowflake table.
         * </p>
         * 
         * @param v1
         *        The schema of a Snowflake table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder v1(SnowflakeTableSchemaV1... v1);

        /**
         * <p>
         * The schema of a Snowflake table.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.cleanrooms.model.SnowflakeTableSchemaV1.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.cleanrooms.model.SnowflakeTableSchemaV1#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.cleanrooms.model.SnowflakeTableSchemaV1.Builder#build()} is called
         * immediately and its result is passed to {@link #v1(List<SnowflakeTableSchemaV1>)}.
         * 
         * @param v1
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.cleanrooms.model.SnowflakeTableSchemaV1.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #v1(java.util.Collection<SnowflakeTableSchemaV1>)
         */
        Builder v1(Consumer<SnowflakeTableSchemaV1.Builder>... v1);
    }

    static final class BuilderImpl implements Builder {
        private List<SnowflakeTableSchemaV1> v1 = DefaultSdkAutoConstructList.getInstance();

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(SnowflakeTableSchema model) {
            v1(model.v1);
        }

        public final List<SnowflakeTableSchemaV1.Builder> getV1() {
            List<SnowflakeTableSchemaV1.Builder> result = SnowflakeTableSchemaListCopier.copyToBuilder(this.v1);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setV1(Collection<SnowflakeTableSchemaV1.BuilderImpl> v1) {
            Object oldValue = this.v1;
            this.v1 = SnowflakeTableSchemaListCopier.copyFromBuilder(v1);
            handleUnionValueChange(Type.V1, oldValue, this.v1);
        }

        @Override
        public final Builder v1(Collection<SnowflakeTableSchemaV1> v1) {
            Object oldValue = this.v1;
            this.v1 = SnowflakeTableSchemaListCopier.copy(v1);
            handleUnionValueChange(Type.V1, oldValue, this.v1);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder v1(SnowflakeTableSchemaV1... v1) {
            v1(Arrays.asList(v1));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder v1(Consumer<SnowflakeTableSchemaV1.Builder>... v1) {
            v1(Stream.of(v1).map(c -> SnowflakeTableSchemaV1.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public SnowflakeTableSchema build() {
            return new SnowflakeTableSchema(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see SnowflakeTableSchema#type()
     */
    public enum Type {
        V1,

        UNKNOWN_TO_SDK_VERSION
    }
}
