/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cleanrooms.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the schema status.
 * </p>
 * <p>
 * A status of <code>READY</code> means that based on the schema analysis rule, queries of the given analysis rule type
 * are properly configured to run queries on this schema.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SchemaStatusDetail implements SdkPojo, Serializable,
        ToCopyableBuilder<SchemaStatusDetail.Builder, SchemaStatusDetail> {
    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(SchemaStatusDetail::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<List<SchemaStatusReason>> REASONS_FIELD = SdkField
            .<List<SchemaStatusReason>> builder(MarshallingType.LIST)
            .memberName("reasons")
            .getter(getter(SchemaStatusDetail::reasons))
            .setter(setter(Builder::reasons))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reasons").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SchemaStatusReason> builder(MarshallingType.SDK_POJO)
                                            .constructor(SchemaStatusReason::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> ANALYSIS_RULE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("analysisRuleType").getter(getter(SchemaStatusDetail::analysisRuleTypeAsString))
            .setter(setter(Builder::analysisRuleType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("analysisRuleType").build()).build();

    private static final SdkField<List<String>> CONFIGURATIONS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("configurations")
            .getter(getter(SchemaStatusDetail::configurationsAsStrings))
            .setter(setter(Builder::configurationsWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configurations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> ANALYSIS_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("analysisType").getter(getter(SchemaStatusDetail::analysisTypeAsString))
            .setter(setter(Builder::analysisType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("analysisType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_FIELD, REASONS_FIELD,
            ANALYSIS_RULE_TYPE_FIELD, CONFIGURATIONS_FIELD, ANALYSIS_TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String status;

    private final List<SchemaStatusReason> reasons;

    private final String analysisRuleType;

    private final List<String> configurations;

    private final String analysisType;

    private SchemaStatusDetail(BuilderImpl builder) {
        this.status = builder.status;
        this.reasons = builder.reasons;
        this.analysisRuleType = builder.analysisRuleType;
        this.configurations = builder.configurations;
        this.analysisType = builder.analysisType;
    }

    /**
     * <p>
     * The status of the schema, indicating if it is ready to query.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link SchemaStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the schema, indicating if it is ready to query.
     * @see SchemaStatus
     */
    public final SchemaStatus status() {
        return SchemaStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the schema, indicating if it is ready to query.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link SchemaStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the schema, indicating if it is ready to query.
     * @see SchemaStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * For responses, this returns true if the service returned a value for the Reasons property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasReasons() {
        return reasons != null && !(reasons instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The reasons why the schema status is set to its current state.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasReasons} method.
     * </p>
     * 
     * @return The reasons why the schema status is set to its current state.
     */
    public final List<SchemaStatusReason> reasons() {
        return reasons;
    }

    /**
     * <p>
     * The analysis rule type for which the schema status has been evaluated.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #analysisRuleType}
     * will return {@link AnalysisRuleType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #analysisRuleTypeAsString}.
     * </p>
     * 
     * @return The analysis rule type for which the schema status has been evaluated.
     * @see AnalysisRuleType
     */
    public final AnalysisRuleType analysisRuleType() {
        return AnalysisRuleType.fromValue(analysisRuleType);
    }

    /**
     * <p>
     * The analysis rule type for which the schema status has been evaluated.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #analysisRuleType}
     * will return {@link AnalysisRuleType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #analysisRuleTypeAsString}.
     * </p>
     * 
     * @return The analysis rule type for which the schema status has been evaluated.
     * @see AnalysisRuleType
     */
    public final String analysisRuleTypeAsString() {
        return analysisRuleType;
    }

    /**
     * <p>
     * The configuration details of the schema analysis rule for the given type.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasConfigurations} method.
     * </p>
     * 
     * @return The configuration details of the schema analysis rule for the given type.
     */
    public final List<SchemaConfiguration> configurations() {
        return SchemaConfigurationListCopier.copyStringToEnum(configurations);
    }

    /**
     * For responses, this returns true if the service returned a value for the Configurations property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasConfigurations() {
        return configurations != null && !(configurations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The configuration details of the schema analysis rule for the given type.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasConfigurations} method.
     * </p>
     * 
     * @return The configuration details of the schema analysis rule for the given type.
     */
    public final List<String> configurationsAsStrings() {
        return configurations;
    }

    /**
     * <p>
     * The type of analysis that can be performed on the schema.
     * </p>
     * <p>
     * A schema can have an <code>analysisType</code> of <code>DIRECT_ANALYSIS</code>,
     * <code>ADDITIONAL_ANALYSIS_FOR_AUDIENCE_GENERATION</code>, or both.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #analysisType} will
     * return {@link AnalysisType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #analysisTypeAsString}.
     * </p>
     * 
     * @return The type of analysis that can be performed on the schema.</p>
     *         <p>
     *         A schema can have an <code>analysisType</code> of <code>DIRECT_ANALYSIS</code>,
     *         <code>ADDITIONAL_ANALYSIS_FOR_AUDIENCE_GENERATION</code>, or both.
     * @see AnalysisType
     */
    public final AnalysisType analysisType() {
        return AnalysisType.fromValue(analysisType);
    }

    /**
     * <p>
     * The type of analysis that can be performed on the schema.
     * </p>
     * <p>
     * A schema can have an <code>analysisType</code> of <code>DIRECT_ANALYSIS</code>,
     * <code>ADDITIONAL_ANALYSIS_FOR_AUDIENCE_GENERATION</code>, or both.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #analysisType} will
     * return {@link AnalysisType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #analysisTypeAsString}.
     * </p>
     * 
     * @return The type of analysis that can be performed on the schema.</p>
     *         <p>
     *         A schema can have an <code>analysisType</code> of <code>DIRECT_ANALYSIS</code>,
     *         <code>ADDITIONAL_ANALYSIS_FOR_AUDIENCE_GENERATION</code>, or both.
     * @see AnalysisType
     */
    public final String analysisTypeAsString() {
        return analysisType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasReasons() ? reasons() : null);
        hashCode = 31 * hashCode + Objects.hashCode(analysisRuleTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasConfigurations() ? configurationsAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(analysisTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SchemaStatusDetail)) {
            return false;
        }
        SchemaStatusDetail other = (SchemaStatusDetail) obj;
        return Objects.equals(statusAsString(), other.statusAsString()) && hasReasons() == other.hasReasons()
                && Objects.equals(reasons(), other.reasons())
                && Objects.equals(analysisRuleTypeAsString(), other.analysisRuleTypeAsString())
                && hasConfigurations() == other.hasConfigurations()
                && Objects.equals(configurationsAsStrings(), other.configurationsAsStrings())
                && Objects.equals(analysisTypeAsString(), other.analysisTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SchemaStatusDetail").add("Status", statusAsString())
                .add("Reasons", hasReasons() ? reasons() : null).add("AnalysisRuleType", analysisRuleTypeAsString())
                .add("Configurations", hasConfigurations() ? configurationsAsStrings() : null)
                .add("AnalysisType", analysisTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "reasons":
            return Optional.ofNullable(clazz.cast(reasons()));
        case "analysisRuleType":
            return Optional.ofNullable(clazz.cast(analysisRuleTypeAsString()));
        case "configurations":
            return Optional.ofNullable(clazz.cast(configurationsAsStrings()));
        case "analysisType":
            return Optional.ofNullable(clazz.cast(analysisTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("status", STATUS_FIELD);
        map.put("reasons", REASONS_FIELD);
        map.put("analysisRuleType", ANALYSIS_RULE_TYPE_FIELD);
        map.put("configurations", CONFIGURATIONS_FIELD);
        map.put("analysisType", ANALYSIS_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SchemaStatusDetail, T> g) {
        return obj -> g.apply((SchemaStatusDetail) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SchemaStatusDetail> {
        /**
         * <p>
         * The status of the schema, indicating if it is ready to query.
         * </p>
         * 
         * @param status
         *        The status of the schema, indicating if it is ready to query.
         * @see SchemaStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SchemaStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the schema, indicating if it is ready to query.
         * </p>
         * 
         * @param status
         *        The status of the schema, indicating if it is ready to query.
         * @see SchemaStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SchemaStatus
         */
        Builder status(SchemaStatus status);

        /**
         * <p>
         * The reasons why the schema status is set to its current state.
         * </p>
         * 
         * @param reasons
         *        The reasons why the schema status is set to its current state.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reasons(Collection<SchemaStatusReason> reasons);

        /**
         * <p>
         * The reasons why the schema status is set to its current state.
         * </p>
         * 
         * @param reasons
         *        The reasons why the schema status is set to its current state.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reasons(SchemaStatusReason... reasons);

        /**
         * <p>
         * The reasons why the schema status is set to its current state.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.cleanrooms.model.SchemaStatusReason.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.cleanrooms.model.SchemaStatusReason#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.cleanrooms.model.SchemaStatusReason.Builder#build()} is called
         * immediately and its result is passed to {@link #reasons(List<SchemaStatusReason>)}.
         * 
         * @param reasons
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.cleanrooms.model.SchemaStatusReason.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #reasons(java.util.Collection<SchemaStatusReason>)
         */
        Builder reasons(Consumer<SchemaStatusReason.Builder>... reasons);

        /**
         * <p>
         * The analysis rule type for which the schema status has been evaluated.
         * </p>
         * 
         * @param analysisRuleType
         *        The analysis rule type for which the schema status has been evaluated.
         * @see AnalysisRuleType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AnalysisRuleType
         */
        Builder analysisRuleType(String analysisRuleType);

        /**
         * <p>
         * The analysis rule type for which the schema status has been evaluated.
         * </p>
         * 
         * @param analysisRuleType
         *        The analysis rule type for which the schema status has been evaluated.
         * @see AnalysisRuleType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AnalysisRuleType
         */
        Builder analysisRuleType(AnalysisRuleType analysisRuleType);

        /**
         * <p>
         * The configuration details of the schema analysis rule for the given type.
         * </p>
         * 
         * @param configurations
         *        The configuration details of the schema analysis rule for the given type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configurationsWithStrings(Collection<String> configurations);

        /**
         * <p>
         * The configuration details of the schema analysis rule for the given type.
         * </p>
         * 
         * @param configurations
         *        The configuration details of the schema analysis rule for the given type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configurationsWithStrings(String... configurations);

        /**
         * <p>
         * The configuration details of the schema analysis rule for the given type.
         * </p>
         * 
         * @param configurations
         *        The configuration details of the schema analysis rule for the given type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configurations(Collection<SchemaConfiguration> configurations);

        /**
         * <p>
         * The configuration details of the schema analysis rule for the given type.
         * </p>
         * 
         * @param configurations
         *        The configuration details of the schema analysis rule for the given type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configurations(SchemaConfiguration... configurations);

        /**
         * <p>
         * The type of analysis that can be performed on the schema.
         * </p>
         * <p>
         * A schema can have an <code>analysisType</code> of <code>DIRECT_ANALYSIS</code>,
         * <code>ADDITIONAL_ANALYSIS_FOR_AUDIENCE_GENERATION</code>, or both.
         * </p>
         * 
         * @param analysisType
         *        The type of analysis that can be performed on the schema.</p>
         *        <p>
         *        A schema can have an <code>analysisType</code> of <code>DIRECT_ANALYSIS</code>,
         *        <code>ADDITIONAL_ANALYSIS_FOR_AUDIENCE_GENERATION</code>, or both.
         * @see AnalysisType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AnalysisType
         */
        Builder analysisType(String analysisType);

        /**
         * <p>
         * The type of analysis that can be performed on the schema.
         * </p>
         * <p>
         * A schema can have an <code>analysisType</code> of <code>DIRECT_ANALYSIS</code>,
         * <code>ADDITIONAL_ANALYSIS_FOR_AUDIENCE_GENERATION</code>, or both.
         * </p>
         * 
         * @param analysisType
         *        The type of analysis that can be performed on the schema.</p>
         *        <p>
         *        A schema can have an <code>analysisType</code> of <code>DIRECT_ANALYSIS</code>,
         *        <code>ADDITIONAL_ANALYSIS_FOR_AUDIENCE_GENERATION</code>, or both.
         * @see AnalysisType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AnalysisType
         */
        Builder analysisType(AnalysisType analysisType);
    }

    static final class BuilderImpl implements Builder {
        private String status;

        private List<SchemaStatusReason> reasons = DefaultSdkAutoConstructList.getInstance();

        private String analysisRuleType;

        private List<String> configurations = DefaultSdkAutoConstructList.getInstance();

        private String analysisType;

        private BuilderImpl() {
        }

        private BuilderImpl(SchemaStatusDetail model) {
            status(model.status);
            reasons(model.reasons);
            analysisRuleType(model.analysisRuleType);
            configurationsWithStrings(model.configurations);
            analysisType(model.analysisType);
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(SchemaStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final List<SchemaStatusReason.Builder> getReasons() {
            List<SchemaStatusReason.Builder> result = SchemaStatusReasonListCopier.copyToBuilder(this.reasons);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setReasons(Collection<SchemaStatusReason.BuilderImpl> reasons) {
            this.reasons = SchemaStatusReasonListCopier.copyFromBuilder(reasons);
        }

        @Override
        public final Builder reasons(Collection<SchemaStatusReason> reasons) {
            this.reasons = SchemaStatusReasonListCopier.copy(reasons);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reasons(SchemaStatusReason... reasons) {
            reasons(Arrays.asList(reasons));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reasons(Consumer<SchemaStatusReason.Builder>... reasons) {
            reasons(Stream.of(reasons).map(c -> SchemaStatusReason.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getAnalysisRuleType() {
            return analysisRuleType;
        }

        public final void setAnalysisRuleType(String analysisRuleType) {
            this.analysisRuleType = analysisRuleType;
        }

        @Override
        public final Builder analysisRuleType(String analysisRuleType) {
            this.analysisRuleType = analysisRuleType;
            return this;
        }

        @Override
        public final Builder analysisRuleType(AnalysisRuleType analysisRuleType) {
            this.analysisRuleType(analysisRuleType == null ? null : analysisRuleType.toString());
            return this;
        }

        public final Collection<String> getConfigurations() {
            if (configurations instanceof SdkAutoConstructList) {
                return null;
            }
            return configurations;
        }

        public final void setConfigurations(Collection<String> configurations) {
            this.configurations = SchemaConfigurationListCopier.copy(configurations);
        }

        @Override
        public final Builder configurationsWithStrings(Collection<String> configurations) {
            this.configurations = SchemaConfigurationListCopier.copy(configurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder configurationsWithStrings(String... configurations) {
            configurationsWithStrings(Arrays.asList(configurations));
            return this;
        }

        @Override
        public final Builder configurations(Collection<SchemaConfiguration> configurations) {
            this.configurations = SchemaConfigurationListCopier.copyEnumToString(configurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder configurations(SchemaConfiguration... configurations) {
            configurations(Arrays.asList(configurations));
            return this;
        }

        public final String getAnalysisType() {
            return analysisType;
        }

        public final void setAnalysisType(String analysisType) {
            this.analysisType = analysisType;
        }

        @Override
        public final Builder analysisType(String analysisType) {
            this.analysisType = analysisType;
            return this;
        }

        @Override
        public final Builder analysisType(AnalysisType analysisType) {
            this.analysisType(analysisType == null ? null : analysisType.toString());
            return this;
        }

        @Override
        public SchemaStatusDetail build() {
            return new SchemaStatusDetail(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
