/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cleanrooms.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the configuration to write the query results to S3.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ProtectedQueryS3OutputConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<ProtectedQueryS3OutputConfiguration.Builder, ProtectedQueryS3OutputConfiguration> {
    private static final SdkField<String> RESULT_FORMAT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("resultFormat").getter(getter(ProtectedQueryS3OutputConfiguration::resultFormatAsString))
            .setter(setter(Builder::resultFormat))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resultFormat").build()).build();

    private static final SdkField<String> BUCKET_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("bucket")
            .getter(getter(ProtectedQueryS3OutputConfiguration::bucket)).setter(setter(Builder::bucket))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bucket").build()).build();

    private static final SdkField<String> KEY_PREFIX_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("keyPrefix").getter(getter(ProtectedQueryS3OutputConfiguration::keyPrefix))
            .setter(setter(Builder::keyPrefix))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("keyPrefix").build()).build();

    private static final SdkField<Boolean> SINGLE_FILE_OUTPUT_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("singleFileOutput").getter(getter(ProtectedQueryS3OutputConfiguration::singleFileOutput))
            .setter(setter(Builder::singleFileOutput))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("singleFileOutput").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESULT_FORMAT_FIELD,
            BUCKET_FIELD, KEY_PREFIX_FIELD, SINGLE_FILE_OUTPUT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String resultFormat;

    private final String bucket;

    private final String keyPrefix;

    private final Boolean singleFileOutput;

    private ProtectedQueryS3OutputConfiguration(BuilderImpl builder) {
        this.resultFormat = builder.resultFormat;
        this.bucket = builder.bucket;
        this.keyPrefix = builder.keyPrefix;
        this.singleFileOutput = builder.singleFileOutput;
    }

    /**
     * <p>
     * Intended file format of the result.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resultFormat} will
     * return {@link ResultFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #resultFormatAsString}.
     * </p>
     * 
     * @return Intended file format of the result.
     * @see ResultFormat
     */
    public final ResultFormat resultFormat() {
        return ResultFormat.fromValue(resultFormat);
    }

    /**
     * <p>
     * Intended file format of the result.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resultFormat} will
     * return {@link ResultFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #resultFormatAsString}.
     * </p>
     * 
     * @return Intended file format of the result.
     * @see ResultFormat
     */
    public final String resultFormatAsString() {
        return resultFormat;
    }

    /**
     * <p>
     * The S3 bucket to unload the protected query results.
     * </p>
     * 
     * @return The S3 bucket to unload the protected query results.
     */
    public final String bucket() {
        return bucket;
    }

    /**
     * <p>
     * The S3 prefix to unload the protected query results.
     * </p>
     * 
     * @return The S3 prefix to unload the protected query results.
     */
    public final String keyPrefix() {
        return keyPrefix;
    }

    /**
     * <p>
     * Indicates whether files should be output as a single file (<code>TRUE</code>) or output as multiple files (
     * <code>FALSE</code>). This parameter is only supported for analyses with the Spark analytics engine.
     * </p>
     * 
     * @return Indicates whether files should be output as a single file (<code>TRUE</code>) or output as multiple files
     *         (<code>FALSE</code>). This parameter is only supported for analyses with the Spark analytics engine.
     */
    public final Boolean singleFileOutput() {
        return singleFileOutput;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(resultFormatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(bucket());
        hashCode = 31 * hashCode + Objects.hashCode(keyPrefix());
        hashCode = 31 * hashCode + Objects.hashCode(singleFileOutput());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProtectedQueryS3OutputConfiguration)) {
            return false;
        }
        ProtectedQueryS3OutputConfiguration other = (ProtectedQueryS3OutputConfiguration) obj;
        return Objects.equals(resultFormatAsString(), other.resultFormatAsString()) && Objects.equals(bucket(), other.bucket())
                && Objects.equals(keyPrefix(), other.keyPrefix()) && Objects.equals(singleFileOutput(), other.singleFileOutput());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ProtectedQueryS3OutputConfiguration").add("ResultFormat", resultFormatAsString())
                .add("Bucket", bucket()).add("KeyPrefix", keyPrefix()).add("SingleFileOutput", singleFileOutput()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "resultFormat":
            return Optional.ofNullable(clazz.cast(resultFormatAsString()));
        case "bucket":
            return Optional.ofNullable(clazz.cast(bucket()));
        case "keyPrefix":
            return Optional.ofNullable(clazz.cast(keyPrefix()));
        case "singleFileOutput":
            return Optional.ofNullable(clazz.cast(singleFileOutput()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("resultFormat", RESULT_FORMAT_FIELD);
        map.put("bucket", BUCKET_FIELD);
        map.put("keyPrefix", KEY_PREFIX_FIELD);
        map.put("singleFileOutput", SINGLE_FILE_OUTPUT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ProtectedQueryS3OutputConfiguration, T> g) {
        return obj -> g.apply((ProtectedQueryS3OutputConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ProtectedQueryS3OutputConfiguration> {
        /**
         * <p>
         * Intended file format of the result.
         * </p>
         * 
         * @param resultFormat
         *        Intended file format of the result.
         * @see ResultFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResultFormat
         */
        Builder resultFormat(String resultFormat);

        /**
         * <p>
         * Intended file format of the result.
         * </p>
         * 
         * @param resultFormat
         *        Intended file format of the result.
         * @see ResultFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResultFormat
         */
        Builder resultFormat(ResultFormat resultFormat);

        /**
         * <p>
         * The S3 bucket to unload the protected query results.
         * </p>
         * 
         * @param bucket
         *        The S3 bucket to unload the protected query results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bucket(String bucket);

        /**
         * <p>
         * The S3 prefix to unload the protected query results.
         * </p>
         * 
         * @param keyPrefix
         *        The S3 prefix to unload the protected query results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyPrefix(String keyPrefix);

        /**
         * <p>
         * Indicates whether files should be output as a single file (<code>TRUE</code>) or output as multiple files (
         * <code>FALSE</code>). This parameter is only supported for analyses with the Spark analytics engine.
         * </p>
         * 
         * @param singleFileOutput
         *        Indicates whether files should be output as a single file (<code>TRUE</code>) or output as multiple
         *        files (<code>FALSE</code>). This parameter is only supported for analyses with the Spark analytics
         *        engine.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder singleFileOutput(Boolean singleFileOutput);
    }

    static final class BuilderImpl implements Builder {
        private String resultFormat;

        private String bucket;

        private String keyPrefix;

        private Boolean singleFileOutput;

        private BuilderImpl() {
        }

        private BuilderImpl(ProtectedQueryS3OutputConfiguration model) {
            resultFormat(model.resultFormat);
            bucket(model.bucket);
            keyPrefix(model.keyPrefix);
            singleFileOutput(model.singleFileOutput);
        }

        public final String getResultFormat() {
            return resultFormat;
        }

        public final void setResultFormat(String resultFormat) {
            this.resultFormat = resultFormat;
        }

        @Override
        public final Builder resultFormat(String resultFormat) {
            this.resultFormat = resultFormat;
            return this;
        }

        @Override
        public final Builder resultFormat(ResultFormat resultFormat) {
            this.resultFormat(resultFormat == null ? null : resultFormat.toString());
            return this;
        }

        public final String getBucket() {
            return bucket;
        }

        public final void setBucket(String bucket) {
            this.bucket = bucket;
        }

        @Override
        public final Builder bucket(String bucket) {
            this.bucket = bucket;
            return this;
        }

        public final String getKeyPrefix() {
            return keyPrefix;
        }

        public final void setKeyPrefix(String keyPrefix) {
            this.keyPrefix = keyPrefix;
        }

        @Override
        public final Builder keyPrefix(String keyPrefix) {
            this.keyPrefix = keyPrefix;
            return this;
        }

        public final Boolean getSingleFileOutput() {
            return singleFileOutput;
        }

        public final void setSingleFileOutput(Boolean singleFileOutput) {
            this.singleFileOutput = singleFileOutput;
        }

        @Override
        public final Builder singleFileOutput(Boolean singleFileOutput) {
            this.singleFileOutput = singleFileOutput;
            return this;
        }

        @Override
        public ProtectedQueryS3OutputConfiguration build() {
            return new ProtectedQueryS3OutputConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
