/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cleanrooms.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the configuration for distributing protected query results to multiple receivers, including S3 and
 * collaboration members.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ProtectedQueryDistributeOutputConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<ProtectedQueryDistributeOutputConfiguration.Builder, ProtectedQueryDistributeOutputConfiguration> {
    private static final SdkField<List<ProtectedQueryDistributeOutputConfigurationLocation>> LOCATIONS_FIELD = SdkField
            .<List<ProtectedQueryDistributeOutputConfigurationLocation>> builder(MarshallingType.LIST)
            .memberName("locations")
            .getter(getter(ProtectedQueryDistributeOutputConfiguration::locations))
            .setter(setter(Builder::locations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("locations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ProtectedQueryDistributeOutputConfigurationLocation> builder(
                                            MarshallingType.SDK_POJO)
                                            .constructor(ProtectedQueryDistributeOutputConfigurationLocation::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOCATIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<ProtectedQueryDistributeOutputConfigurationLocation> locations;

    private ProtectedQueryDistributeOutputConfiguration(BuilderImpl builder) {
        this.locations = builder.locations;
    }

    /**
     * For responses, this returns true if the service returned a value for the Locations property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasLocations() {
        return locations != null && !(locations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of locations where you want to distribute the protected query results. Each location must specify either
     * an S3 destination or a collaboration member destination.
     * </p>
     * <important>
     * <p>
     * You can't specify more than one S3 location.
     * </p>
     * <p>
     * You can't specify the query runner's account as a member location.
     * </p>
     * <p>
     * You must include either an S3 or member output configuration for each location, but not both.
     * </p>
     * </important>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLocations} method.
     * </p>
     * 
     * @return A list of locations where you want to distribute the protected query results. Each location must specify
     *         either an S3 destination or a collaboration member destination.</p> <important>
     *         <p>
     *         You can't specify more than one S3 location.
     *         </p>
     *         <p>
     *         You can't specify the query runner's account as a member location.
     *         </p>
     *         <p>
     *         You must include either an S3 or member output configuration for each location, but not both.
     *         </p>
     */
    public final List<ProtectedQueryDistributeOutputConfigurationLocation> locations() {
        return locations;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasLocations() ? locations() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProtectedQueryDistributeOutputConfiguration)) {
            return false;
        }
        ProtectedQueryDistributeOutputConfiguration other = (ProtectedQueryDistributeOutputConfiguration) obj;
        return hasLocations() == other.hasLocations() && Objects.equals(locations(), other.locations());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ProtectedQueryDistributeOutputConfiguration")
                .add("Locations", hasLocations() ? locations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "locations":
            return Optional.ofNullable(clazz.cast(locations()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("locations", LOCATIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ProtectedQueryDistributeOutputConfiguration, T> g) {
        return obj -> g.apply((ProtectedQueryDistributeOutputConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ProtectedQueryDistributeOutputConfiguration> {
        /**
         * <p>
         * A list of locations where you want to distribute the protected query results. Each location must specify
         * either an S3 destination or a collaboration member destination.
         * </p>
         * <important>
         * <p>
         * You can't specify more than one S3 location.
         * </p>
         * <p>
         * You can't specify the query runner's account as a member location.
         * </p>
         * <p>
         * You must include either an S3 or member output configuration for each location, but not both.
         * </p>
         * </important>
         * 
         * @param locations
         *        A list of locations where you want to distribute the protected query results. Each location must
         *        specify either an S3 destination or a collaboration member destination.</p> <important>
         *        <p>
         *        You can't specify more than one S3 location.
         *        </p>
         *        <p>
         *        You can't specify the query runner's account as a member location.
         *        </p>
         *        <p>
         *        You must include either an S3 or member output configuration for each location, but not both.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder locations(Collection<ProtectedQueryDistributeOutputConfigurationLocation> locations);

        /**
         * <p>
         * A list of locations where you want to distribute the protected query results. Each location must specify
         * either an S3 destination or a collaboration member destination.
         * </p>
         * <important>
         * <p>
         * You can't specify more than one S3 location.
         * </p>
         * <p>
         * You can't specify the query runner's account as a member location.
         * </p>
         * <p>
         * You must include either an S3 or member output configuration for each location, but not both.
         * </p>
         * </important>
         * 
         * @param locations
         *        A list of locations where you want to distribute the protected query results. Each location must
         *        specify either an S3 destination or a collaboration member destination.</p> <important>
         *        <p>
         *        You can't specify more than one S3 location.
         *        </p>
         *        <p>
         *        You can't specify the query runner's account as a member location.
         *        </p>
         *        <p>
         *        You must include either an S3 or member output configuration for each location, but not both.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder locations(ProtectedQueryDistributeOutputConfigurationLocation... locations);

        /**
         * <p>
         * A list of locations where you want to distribute the protected query results. Each location must specify
         * either an S3 destination or a collaboration member destination.
         * </p>
         * <important>
         * <p>
         * You can't specify more than one S3 location.
         * </p>
         * <p>
         * You can't specify the query runner's account as a member location.
         * </p>
         * <p>
         * You must include either an S3 or member output configuration for each location, but not both.
         * </p>
         * </important> This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.cleanrooms.model.ProtectedQueryDistributeOutputConfigurationLocation.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.cleanrooms.model.ProtectedQueryDistributeOutputConfigurationLocation#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.cleanrooms.model.ProtectedQueryDistributeOutputConfigurationLocation.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #locations(List<ProtectedQueryDistributeOutputConfigurationLocation>)}.
         * 
         * @param locations
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.cleanrooms.model.ProtectedQueryDistributeOutputConfigurationLocation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #locations(java.util.Collection<ProtectedQueryDistributeOutputConfigurationLocation>)
         */
        Builder locations(Consumer<ProtectedQueryDistributeOutputConfigurationLocation.Builder>... locations);
    }

    static final class BuilderImpl implements Builder {
        private List<ProtectedQueryDistributeOutputConfigurationLocation> locations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ProtectedQueryDistributeOutputConfiguration model) {
            locations(model.locations);
        }

        public final List<ProtectedQueryDistributeOutputConfigurationLocation.Builder> getLocations() {
            List<ProtectedQueryDistributeOutputConfigurationLocation.Builder> result = ProtectedQueryDistributeOutputConfigurationLocationsListCopier
                    .copyToBuilder(this.locations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLocations(Collection<ProtectedQueryDistributeOutputConfigurationLocation.BuilderImpl> locations) {
            this.locations = ProtectedQueryDistributeOutputConfigurationLocationsListCopier.copyFromBuilder(locations);
        }

        @Override
        public final Builder locations(Collection<ProtectedQueryDistributeOutputConfigurationLocation> locations) {
            this.locations = ProtectedQueryDistributeOutputConfigurationLocationsListCopier.copy(locations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder locations(ProtectedQueryDistributeOutputConfigurationLocation... locations) {
            locations(Arrays.asList(locations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder locations(Consumer<ProtectedQueryDistributeOutputConfigurationLocation.Builder>... locations) {
            locations(Stream.of(locations)
                    .map(c -> ProtectedQueryDistributeOutputConfigurationLocation.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public ProtectedQueryDistributeOutputConfiguration build() {
            return new ProtectedQueryDistributeOutputConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
