/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cleanrooms.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The output configuration for a protected job result.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ProtectedJobResultConfigurationOutput implements SdkPojo, Serializable,
        ToCopyableBuilder<ProtectedJobResultConfigurationOutput.Builder, ProtectedJobResultConfigurationOutput> {
    private static final SdkField<ProtectedJobOutputConfigurationOutput> OUTPUT_CONFIGURATION_FIELD = SdkField
            .<ProtectedJobOutputConfigurationOutput> builder(MarshallingType.SDK_POJO).memberName("outputConfiguration")
            .getter(getter(ProtectedJobResultConfigurationOutput::outputConfiguration))
            .setter(setter(Builder::outputConfiguration)).constructor(ProtectedJobOutputConfigurationOutput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputConfiguration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OUTPUT_CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final ProtectedJobOutputConfigurationOutput outputConfiguration;

    private ProtectedJobResultConfigurationOutput(BuilderImpl builder) {
        this.outputConfiguration = builder.outputConfiguration;
    }

    /**
     * <p>
     * The output configuration.
     * </p>
     * 
     * @return The output configuration.
     */
    public final ProtectedJobOutputConfigurationOutput outputConfiguration() {
        return outputConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(outputConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProtectedJobResultConfigurationOutput)) {
            return false;
        }
        ProtectedJobResultConfigurationOutput other = (ProtectedJobResultConfigurationOutput) obj;
        return Objects.equals(outputConfiguration(), other.outputConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ProtectedJobResultConfigurationOutput").add("OutputConfiguration", outputConfiguration())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "outputConfiguration":
            return Optional.ofNullable(clazz.cast(outputConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("outputConfiguration", OUTPUT_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ProtectedJobResultConfigurationOutput, T> g) {
        return obj -> g.apply((ProtectedJobResultConfigurationOutput) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ProtectedJobResultConfigurationOutput> {
        /**
         * <p>
         * The output configuration.
         * </p>
         * 
         * @param outputConfiguration
         *        The output configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputConfiguration(ProtectedJobOutputConfigurationOutput outputConfiguration);

        /**
         * <p>
         * The output configuration.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link ProtectedJobOutputConfigurationOutput.Builder} avoiding the need to create one manually via
         * {@link ProtectedJobOutputConfigurationOutput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ProtectedJobOutputConfigurationOutput.Builder#build()} is called
         * immediately and its result is passed to {@link #outputConfiguration(ProtectedJobOutputConfigurationOutput)}.
         * 
         * @param outputConfiguration
         *        a consumer that will call methods on {@link ProtectedJobOutputConfigurationOutput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #outputConfiguration(ProtectedJobOutputConfigurationOutput)
         */
        default Builder outputConfiguration(Consumer<ProtectedJobOutputConfigurationOutput.Builder> outputConfiguration) {
            return outputConfiguration(ProtectedJobOutputConfigurationOutput.builder().applyMutation(outputConfiguration).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private ProtectedJobOutputConfigurationOutput outputConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(ProtectedJobResultConfigurationOutput model) {
            outputConfiguration(model.outputConfiguration);
        }

        public final ProtectedJobOutputConfigurationOutput.Builder getOutputConfiguration() {
            return outputConfiguration != null ? outputConfiguration.toBuilder() : null;
        }

        public final void setOutputConfiguration(ProtectedJobOutputConfigurationOutput.BuilderImpl outputConfiguration) {
            this.outputConfiguration = outputConfiguration != null ? outputConfiguration.build() : null;
        }

        @Override
        public final Builder outputConfiguration(ProtectedJobOutputConfigurationOutput outputConfiguration) {
            this.outputConfiguration = outputConfiguration;
            return this;
        }

        @Override
        public ProtectedJobResultConfigurationOutput build() {
            return new ProtectedJobResultConfigurationOutput(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
