/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cleanrooms.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details about the job results.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ProtectedJobResult implements SdkPojo, Serializable,
        ToCopyableBuilder<ProtectedJobResult.Builder, ProtectedJobResult> {
    private static final SdkField<ProtectedJobOutput> OUTPUT_FIELD = SdkField
            .<ProtectedJobOutput> builder(MarshallingType.SDK_POJO).memberName("output")
            .getter(getter(ProtectedJobResult::output)).setter(setter(Builder::output)).constructor(ProtectedJobOutput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("output").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OUTPUT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final ProtectedJobOutput output;

    private ProtectedJobResult(BuilderImpl builder) {
        this.output = builder.output;
    }

    /**
     * <p>
     * The output of the protected job.
     * </p>
     * 
     * @return The output of the protected job.
     */
    public final ProtectedJobOutput output() {
        return output;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(output());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProtectedJobResult)) {
            return false;
        }
        ProtectedJobResult other = (ProtectedJobResult) obj;
        return Objects.equals(output(), other.output());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ProtectedJobResult").add("Output", output()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "output":
            return Optional.ofNullable(clazz.cast(output()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("output", OUTPUT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ProtectedJobResult, T> g) {
        return obj -> g.apply((ProtectedJobResult) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ProtectedJobResult> {
        /**
         * <p>
         * The output of the protected job.
         * </p>
         * 
         * @param output
         *        The output of the protected job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder output(ProtectedJobOutput output);

        /**
         * <p>
         * The output of the protected job.
         * </p>
         * This is a convenience method that creates an instance of the {@link ProtectedJobOutput.Builder} avoiding the
         * need to create one manually via {@link ProtectedJobOutput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ProtectedJobOutput.Builder#build()} is called immediately and its
         * result is passed to {@link #output(ProtectedJobOutput)}.
         * 
         * @param output
         *        a consumer that will call methods on {@link ProtectedJobOutput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #output(ProtectedJobOutput)
         */
        default Builder output(Consumer<ProtectedJobOutput.Builder> output) {
            return output(ProtectedJobOutput.builder().applyMutation(output).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private ProtectedJobOutput output;

        private BuilderImpl() {
        }

        private BuilderImpl(ProtectedJobResult model) {
            output(model.output);
        }

        public final ProtectedJobOutput.Builder getOutput() {
            return output != null ? output.toBuilder() : null;
        }

        public final void setOutput(ProtectedJobOutput.BuilderImpl output) {
            this.output = output != null ? output.build() : null;
        }

        @Override
        public final Builder output(ProtectedJobOutput output) {
            this.output = output;
            return this;
        }

        @Override
        public ProtectedJobResult build() {
            return new ProtectedJobResult(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
