/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cleanrooms.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The parameters for an Clean Rooms protected job.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ProtectedJob implements SdkPojo, Serializable, ToCopyableBuilder<ProtectedJob.Builder, ProtectedJob> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(ProtectedJob::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> MEMBERSHIP_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("membershipId").getter(getter(ProtectedJob::membershipId)).setter(setter(Builder::membershipId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("membershipId").build()).build();

    private static final SdkField<String> MEMBERSHIP_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("membershipArn").getter(getter(ProtectedJob::membershipArn)).setter(setter(Builder::membershipArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("membershipArn").build()).build();

    private static final SdkField<Instant> CREATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("createTime").getter(getter(ProtectedJob::createTime)).setter(setter(Builder::createTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createTime").build()).build();

    private static final SdkField<ProtectedJobParameters> JOB_PARAMETERS_FIELD = SdkField
            .<ProtectedJobParameters> builder(MarshallingType.SDK_POJO).memberName("jobParameters")
            .getter(getter(ProtectedJob::jobParameters)).setter(setter(Builder::jobParameters))
            .constructor(ProtectedJobParameters::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobParameters").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(ProtectedJob::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<ProtectedJobResultConfigurationOutput> RESULT_CONFIGURATION_FIELD = SdkField
            .<ProtectedJobResultConfigurationOutput> builder(MarshallingType.SDK_POJO).memberName("resultConfiguration")
            .getter(getter(ProtectedJob::resultConfiguration)).setter(setter(Builder::resultConfiguration))
            .constructor(ProtectedJobResultConfigurationOutput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resultConfiguration").build())
            .build();

    private static final SdkField<ProtectedJobStatistics> STATISTICS_FIELD = SdkField
            .<ProtectedJobStatistics> builder(MarshallingType.SDK_POJO).memberName("statistics")
            .getter(getter(ProtectedJob::statistics)).setter(setter(Builder::statistics))
            .constructor(ProtectedJobStatistics::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statistics").build()).build();

    private static final SdkField<ProtectedJobResult> RESULT_FIELD = SdkField
            .<ProtectedJobResult> builder(MarshallingType.SDK_POJO).memberName("result").getter(getter(ProtectedJob::result))
            .setter(setter(Builder::result)).constructor(ProtectedJobResult::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("result").build()).build();

    private static final SdkField<ProtectedJobError> ERROR_FIELD = SdkField.<ProtectedJobError> builder(MarshallingType.SDK_POJO)
            .memberName("error").getter(getter(ProtectedJob::error)).setter(setter(Builder::error))
            .constructor(ProtectedJobError::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("error").build()).build();

    private static final SdkField<ProtectedJobComputeConfiguration> COMPUTE_CONFIGURATION_FIELD = SdkField
            .<ProtectedJobComputeConfiguration> builder(MarshallingType.SDK_POJO).memberName("computeConfiguration")
            .getter(getter(ProtectedJob::computeConfiguration)).setter(setter(Builder::computeConfiguration))
            .constructor(ProtectedJobComputeConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("computeConfiguration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, MEMBERSHIP_ID_FIELD,
            MEMBERSHIP_ARN_FIELD, CREATE_TIME_FIELD, JOB_PARAMETERS_FIELD, STATUS_FIELD, RESULT_CONFIGURATION_FIELD,
            STATISTICS_FIELD, RESULT_FIELD, ERROR_FIELD, COMPUTE_CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String id;

    private final String membershipId;

    private final String membershipArn;

    private final Instant createTime;

    private final ProtectedJobParameters jobParameters;

    private final String status;

    private final ProtectedJobResultConfigurationOutput resultConfiguration;

    private final ProtectedJobStatistics statistics;

    private final ProtectedJobResult result;

    private final ProtectedJobError error;

    private final ProtectedJobComputeConfiguration computeConfiguration;

    private ProtectedJob(BuilderImpl builder) {
        this.id = builder.id;
        this.membershipId = builder.membershipId;
        this.membershipArn = builder.membershipArn;
        this.createTime = builder.createTime;
        this.jobParameters = builder.jobParameters;
        this.status = builder.status;
        this.resultConfiguration = builder.resultConfiguration;
        this.statistics = builder.statistics;
        this.result = builder.result;
        this.error = builder.error;
        this.computeConfiguration = builder.computeConfiguration;
    }

    /**
     * <p>
     * The identifier for a protected job instance.
     * </p>
     * 
     * @return The identifier for a protected job instance.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * he identifier for the membership.
     * </p>
     * 
     * @return he identifier for the membership.
     */
    public final String membershipId() {
        return membershipId;
    }

    /**
     * <p>
     * The ARN of the membership.
     * </p>
     * 
     * @return The ARN of the membership.
     */
    public final String membershipArn() {
        return membershipArn;
    }

    /**
     * <p>
     * The creation time of the protected job.
     * </p>
     * 
     * @return The creation time of the protected job.
     */
    public final Instant createTime() {
        return createTime;
    }

    /**
     * <p>
     * The job parameters for the protected job.
     * </p>
     * 
     * @return The job parameters for the protected job.
     */
    public final ProtectedJobParameters jobParameters() {
        return jobParameters;
    }

    /**
     * <p>
     * The status of the protected job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ProtectedJobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the protected job.
     * @see ProtectedJobStatus
     */
    public final ProtectedJobStatus status() {
        return ProtectedJobStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the protected job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ProtectedJobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the protected job.
     * @see ProtectedJobStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * Contains any details needed to write the job results.
     * </p>
     * 
     * @return Contains any details needed to write the job results.
     */
    public final ProtectedJobResultConfigurationOutput resultConfiguration() {
        return resultConfiguration;
    }

    /**
     * <p>
     * The statistics of the protected job.
     * </p>
     * 
     * @return The statistics of the protected job.
     */
    public final ProtectedJobStatistics statistics() {
        return statistics;
    }

    /**
     * <p>
     * The result of the protected job.
     * </p>
     * 
     * @return The result of the protected job.
     */
    public final ProtectedJobResult result() {
        return result;
    }

    /**
     * <p>
     * The error from the protected job.
     * </p>
     * 
     * @return The error from the protected job.
     */
    public final ProtectedJobError error() {
        return error;
    }

    /**
     * <p>
     * The compute configuration for the protected job.
     * </p>
     * 
     * @return The compute configuration for the protected job.
     */
    public final ProtectedJobComputeConfiguration computeConfiguration() {
        return computeConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(membershipId());
        hashCode = 31 * hashCode + Objects.hashCode(membershipArn());
        hashCode = 31 * hashCode + Objects.hashCode(createTime());
        hashCode = 31 * hashCode + Objects.hashCode(jobParameters());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(resultConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(statistics());
        hashCode = 31 * hashCode + Objects.hashCode(result());
        hashCode = 31 * hashCode + Objects.hashCode(error());
        hashCode = 31 * hashCode + Objects.hashCode(computeConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProtectedJob)) {
            return false;
        }
        ProtectedJob other = (ProtectedJob) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(membershipId(), other.membershipId())
                && Objects.equals(membershipArn(), other.membershipArn()) && Objects.equals(createTime(), other.createTime())
                && Objects.equals(jobParameters(), other.jobParameters())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(resultConfiguration(), other.resultConfiguration())
                && Objects.equals(statistics(), other.statistics()) && Objects.equals(result(), other.result())
                && Objects.equals(error(), other.error()) && Objects.equals(computeConfiguration(), other.computeConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ProtectedJob").add("Id", id()).add("MembershipId", membershipId())
                .add("MembershipArn", membershipArn()).add("CreateTime", createTime()).add("JobParameters", jobParameters())
                .add("Status", statusAsString()).add("ResultConfiguration", resultConfiguration())
                .add("Statistics", statistics()).add("Result", result()).add("Error", error())
                .add("ComputeConfiguration", computeConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "membershipId":
            return Optional.ofNullable(clazz.cast(membershipId()));
        case "membershipArn":
            return Optional.ofNullable(clazz.cast(membershipArn()));
        case "createTime":
            return Optional.ofNullable(clazz.cast(createTime()));
        case "jobParameters":
            return Optional.ofNullable(clazz.cast(jobParameters()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "resultConfiguration":
            return Optional.ofNullable(clazz.cast(resultConfiguration()));
        case "statistics":
            return Optional.ofNullable(clazz.cast(statistics()));
        case "result":
            return Optional.ofNullable(clazz.cast(result()));
        case "error":
            return Optional.ofNullable(clazz.cast(error()));
        case "computeConfiguration":
            return Optional.ofNullable(clazz.cast(computeConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("id", ID_FIELD);
        map.put("membershipId", MEMBERSHIP_ID_FIELD);
        map.put("membershipArn", MEMBERSHIP_ARN_FIELD);
        map.put("createTime", CREATE_TIME_FIELD);
        map.put("jobParameters", JOB_PARAMETERS_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("resultConfiguration", RESULT_CONFIGURATION_FIELD);
        map.put("statistics", STATISTICS_FIELD);
        map.put("result", RESULT_FIELD);
        map.put("error", ERROR_FIELD);
        map.put("computeConfiguration", COMPUTE_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ProtectedJob, T> g) {
        return obj -> g.apply((ProtectedJob) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ProtectedJob> {
        /**
         * <p>
         * The identifier for a protected job instance.
         * </p>
         * 
         * @param id
         *        The identifier for a protected job instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * he identifier for the membership.
         * </p>
         * 
         * @param membershipId
         *        he identifier for the membership.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder membershipId(String membershipId);

        /**
         * <p>
         * The ARN of the membership.
         * </p>
         * 
         * @param membershipArn
         *        The ARN of the membership.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder membershipArn(String membershipArn);

        /**
         * <p>
         * The creation time of the protected job.
         * </p>
         * 
         * @param createTime
         *        The creation time of the protected job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createTime(Instant createTime);

        /**
         * <p>
         * The job parameters for the protected job.
         * </p>
         * 
         * @param jobParameters
         *        The job parameters for the protected job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobParameters(ProtectedJobParameters jobParameters);

        /**
         * <p>
         * The job parameters for the protected job.
         * </p>
         * This is a convenience method that creates an instance of the {@link ProtectedJobParameters.Builder} avoiding
         * the need to create one manually via {@link ProtectedJobParameters#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ProtectedJobParameters.Builder#build()} is called immediately and
         * its result is passed to {@link #jobParameters(ProtectedJobParameters)}.
         * 
         * @param jobParameters
         *        a consumer that will call methods on {@link ProtectedJobParameters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #jobParameters(ProtectedJobParameters)
         */
        default Builder jobParameters(Consumer<ProtectedJobParameters.Builder> jobParameters) {
            return jobParameters(ProtectedJobParameters.builder().applyMutation(jobParameters).build());
        }

        /**
         * <p>
         * The status of the protected job.
         * </p>
         * 
         * @param status
         *        The status of the protected job.
         * @see ProtectedJobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProtectedJobStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the protected job.
         * </p>
         * 
         * @param status
         *        The status of the protected job.
         * @see ProtectedJobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProtectedJobStatus
         */
        Builder status(ProtectedJobStatus status);

        /**
         * <p>
         * Contains any details needed to write the job results.
         * </p>
         * 
         * @param resultConfiguration
         *        Contains any details needed to write the job results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resultConfiguration(ProtectedJobResultConfigurationOutput resultConfiguration);

        /**
         * <p>
         * Contains any details needed to write the job results.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link ProtectedJobResultConfigurationOutput.Builder} avoiding the need to create one manually via
         * {@link ProtectedJobResultConfigurationOutput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ProtectedJobResultConfigurationOutput.Builder#build()} is called
         * immediately and its result is passed to {@link #resultConfiguration(ProtectedJobResultConfigurationOutput)}.
         * 
         * @param resultConfiguration
         *        a consumer that will call methods on {@link ProtectedJobResultConfigurationOutput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resultConfiguration(ProtectedJobResultConfigurationOutput)
         */
        default Builder resultConfiguration(Consumer<ProtectedJobResultConfigurationOutput.Builder> resultConfiguration) {
            return resultConfiguration(ProtectedJobResultConfigurationOutput.builder().applyMutation(resultConfiguration).build());
        }

        /**
         * <p>
         * The statistics of the protected job.
         * </p>
         * 
         * @param statistics
         *        The statistics of the protected job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statistics(ProtectedJobStatistics statistics);

        /**
         * <p>
         * The statistics of the protected job.
         * </p>
         * This is a convenience method that creates an instance of the {@link ProtectedJobStatistics.Builder} avoiding
         * the need to create one manually via {@link ProtectedJobStatistics#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ProtectedJobStatistics.Builder#build()} is called immediately and
         * its result is passed to {@link #statistics(ProtectedJobStatistics)}.
         * 
         * @param statistics
         *        a consumer that will call methods on {@link ProtectedJobStatistics.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #statistics(ProtectedJobStatistics)
         */
        default Builder statistics(Consumer<ProtectedJobStatistics.Builder> statistics) {
            return statistics(ProtectedJobStatistics.builder().applyMutation(statistics).build());
        }

        /**
         * <p>
         * The result of the protected job.
         * </p>
         * 
         * @param result
         *        The result of the protected job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder result(ProtectedJobResult result);

        /**
         * <p>
         * The result of the protected job.
         * </p>
         * This is a convenience method that creates an instance of the {@link ProtectedJobResult.Builder} avoiding the
         * need to create one manually via {@link ProtectedJobResult#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ProtectedJobResult.Builder#build()} is called immediately and its
         * result is passed to {@link #result(ProtectedJobResult)}.
         * 
         * @param result
         *        a consumer that will call methods on {@link ProtectedJobResult.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #result(ProtectedJobResult)
         */
        default Builder result(Consumer<ProtectedJobResult.Builder> result) {
            return result(ProtectedJobResult.builder().applyMutation(result).build());
        }

        /**
         * <p>
         * The error from the protected job.
         * </p>
         * 
         * @param error
         *        The error from the protected job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder error(ProtectedJobError error);

        /**
         * <p>
         * The error from the protected job.
         * </p>
         * This is a convenience method that creates an instance of the {@link ProtectedJobError.Builder} avoiding the
         * need to create one manually via {@link ProtectedJobError#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ProtectedJobError.Builder#build()} is called immediately and its
         * result is passed to {@link #error(ProtectedJobError)}.
         * 
         * @param error
         *        a consumer that will call methods on {@link ProtectedJobError.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #error(ProtectedJobError)
         */
        default Builder error(Consumer<ProtectedJobError.Builder> error) {
            return error(ProtectedJobError.builder().applyMutation(error).build());
        }

        /**
         * <p>
         * The compute configuration for the protected job.
         * </p>
         * 
         * @param computeConfiguration
         *        The compute configuration for the protected job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder computeConfiguration(ProtectedJobComputeConfiguration computeConfiguration);

        /**
         * <p>
         * The compute configuration for the protected job.
         * </p>
         * This is a convenience method that creates an instance of the {@link ProtectedJobComputeConfiguration.Builder}
         * avoiding the need to create one manually via {@link ProtectedJobComputeConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ProtectedJobComputeConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #computeConfiguration(ProtectedJobComputeConfiguration)}.
         * 
         * @param computeConfiguration
         *        a consumer that will call methods on {@link ProtectedJobComputeConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #computeConfiguration(ProtectedJobComputeConfiguration)
         */
        default Builder computeConfiguration(Consumer<ProtectedJobComputeConfiguration.Builder> computeConfiguration) {
            return computeConfiguration(ProtectedJobComputeConfiguration.builder().applyMutation(computeConfiguration).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private String membershipId;

        private String membershipArn;

        private Instant createTime;

        private ProtectedJobParameters jobParameters;

        private String status;

        private ProtectedJobResultConfigurationOutput resultConfiguration;

        private ProtectedJobStatistics statistics;

        private ProtectedJobResult result;

        private ProtectedJobError error;

        private ProtectedJobComputeConfiguration computeConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(ProtectedJob model) {
            id(model.id);
            membershipId(model.membershipId);
            membershipArn(model.membershipArn);
            createTime(model.createTime);
            jobParameters(model.jobParameters);
            status(model.status);
            resultConfiguration(model.resultConfiguration);
            statistics(model.statistics);
            result(model.result);
            error(model.error);
            computeConfiguration(model.computeConfiguration);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getMembershipId() {
            return membershipId;
        }

        public final void setMembershipId(String membershipId) {
            this.membershipId = membershipId;
        }

        @Override
        public final Builder membershipId(String membershipId) {
            this.membershipId = membershipId;
            return this;
        }

        public final String getMembershipArn() {
            return membershipArn;
        }

        public final void setMembershipArn(String membershipArn) {
            this.membershipArn = membershipArn;
        }

        @Override
        public final Builder membershipArn(String membershipArn) {
            this.membershipArn = membershipArn;
            return this;
        }

        public final Instant getCreateTime() {
            return createTime;
        }

        public final void setCreateTime(Instant createTime) {
            this.createTime = createTime;
        }

        @Override
        public final Builder createTime(Instant createTime) {
            this.createTime = createTime;
            return this;
        }

        public final ProtectedJobParameters.Builder getJobParameters() {
            return jobParameters != null ? jobParameters.toBuilder() : null;
        }

        public final void setJobParameters(ProtectedJobParameters.BuilderImpl jobParameters) {
            this.jobParameters = jobParameters != null ? jobParameters.build() : null;
        }

        @Override
        public final Builder jobParameters(ProtectedJobParameters jobParameters) {
            this.jobParameters = jobParameters;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ProtectedJobStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final ProtectedJobResultConfigurationOutput.Builder getResultConfiguration() {
            return resultConfiguration != null ? resultConfiguration.toBuilder() : null;
        }

        public final void setResultConfiguration(ProtectedJobResultConfigurationOutput.BuilderImpl resultConfiguration) {
            this.resultConfiguration = resultConfiguration != null ? resultConfiguration.build() : null;
        }

        @Override
        public final Builder resultConfiguration(ProtectedJobResultConfigurationOutput resultConfiguration) {
            this.resultConfiguration = resultConfiguration;
            return this;
        }

        public final ProtectedJobStatistics.Builder getStatistics() {
            return statistics != null ? statistics.toBuilder() : null;
        }

        public final void setStatistics(ProtectedJobStatistics.BuilderImpl statistics) {
            this.statistics = statistics != null ? statistics.build() : null;
        }

        @Override
        public final Builder statistics(ProtectedJobStatistics statistics) {
            this.statistics = statistics;
            return this;
        }

        public final ProtectedJobResult.Builder getResult() {
            return result != null ? result.toBuilder() : null;
        }

        public final void setResult(ProtectedJobResult.BuilderImpl result) {
            this.result = result != null ? result.build() : null;
        }

        @Override
        public final Builder result(ProtectedJobResult result) {
            this.result = result;
            return this;
        }

        public final ProtectedJobError.Builder getError() {
            return error != null ? error.toBuilder() : null;
        }

        public final void setError(ProtectedJobError.BuilderImpl error) {
            this.error = error != null ? error.build() : null;
        }

        @Override
        public final Builder error(ProtectedJobError error) {
            this.error = error;
            return this;
        }

        public final ProtectedJobComputeConfiguration.Builder getComputeConfiguration() {
            return computeConfiguration != null ? computeConfiguration.toBuilder() : null;
        }

        public final void setComputeConfiguration(ProtectedJobComputeConfiguration.BuilderImpl computeConfiguration) {
            this.computeConfiguration = computeConfiguration != null ? computeConfiguration.build() : null;
        }

        @Override
        public final Builder computeConfiguration(ProtectedJobComputeConfiguration computeConfiguration) {
            this.computeConfiguration = computeConfiguration;
            return this;
        }

        @Override
        public ProtectedJob build() {
            return new ProtectedJob(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
