/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cleanrooms.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PreviewPrivacyImpactRequest extends CleanRoomsRequest implements
        ToCopyableBuilder<PreviewPrivacyImpactRequest.Builder, PreviewPrivacyImpactRequest> {
    private static final SdkField<String> MEMBERSHIP_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("membershipIdentifier").getter(getter(PreviewPrivacyImpactRequest::membershipIdentifier))
            .setter(setter(Builder::membershipIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("membershipIdentifier").build()).build();

    private static final SdkField<PreviewPrivacyImpactParametersInput> PARAMETERS_FIELD = SdkField
            .<PreviewPrivacyImpactParametersInput> builder(MarshallingType.SDK_POJO).memberName("parameters")
            .getter(getter(PreviewPrivacyImpactRequest::parameters)).setter(setter(Builder::parameters))
            .constructor(PreviewPrivacyImpactParametersInput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parameters").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MEMBERSHIP_IDENTIFIER_FIELD,
            PARAMETERS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String membershipIdentifier;

    private final PreviewPrivacyImpactParametersInput parameters;

    private PreviewPrivacyImpactRequest(BuilderImpl builder) {
        super(builder);
        this.membershipIdentifier = builder.membershipIdentifier;
        this.parameters = builder.parameters;
    }

    /**
     * <p>
     * A unique identifier for one of your memberships for a collaboration. Accepts a membership ID.
     * </p>
     * 
     * @return A unique identifier for one of your memberships for a collaboration. Accepts a membership ID.
     */
    public final String membershipIdentifier() {
        return membershipIdentifier;
    }

    /**
     * <p>
     * Specifies the desired epsilon and noise parameters to preview.
     * </p>
     * 
     * @return Specifies the desired epsilon and noise parameters to preview.
     */
    public final PreviewPrivacyImpactParametersInput parameters() {
        return parameters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(membershipIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(parameters());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PreviewPrivacyImpactRequest)) {
            return false;
        }
        PreviewPrivacyImpactRequest other = (PreviewPrivacyImpactRequest) obj;
        return Objects.equals(membershipIdentifier(), other.membershipIdentifier())
                && Objects.equals(parameters(), other.parameters());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PreviewPrivacyImpactRequest").add("MembershipIdentifier", membershipIdentifier())
                .add("Parameters", parameters()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "membershipIdentifier":
            return Optional.ofNullable(clazz.cast(membershipIdentifier()));
        case "parameters":
            return Optional.ofNullable(clazz.cast(parameters()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("membershipIdentifier", MEMBERSHIP_IDENTIFIER_FIELD);
        map.put("parameters", PARAMETERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PreviewPrivacyImpactRequest, T> g) {
        return obj -> g.apply((PreviewPrivacyImpactRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends CleanRoomsRequest.Builder, SdkPojo, CopyableBuilder<Builder, PreviewPrivacyImpactRequest> {
        /**
         * <p>
         * A unique identifier for one of your memberships for a collaboration. Accepts a membership ID.
         * </p>
         * 
         * @param membershipIdentifier
         *        A unique identifier for one of your memberships for a collaboration. Accepts a membership ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder membershipIdentifier(String membershipIdentifier);

        /**
         * <p>
         * Specifies the desired epsilon and noise parameters to preview.
         * </p>
         * 
         * @param parameters
         *        Specifies the desired epsilon and noise parameters to preview.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameters(PreviewPrivacyImpactParametersInput parameters);

        /**
         * <p>
         * Specifies the desired epsilon and noise parameters to preview.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link PreviewPrivacyImpactParametersInput.Builder} avoiding the need to create one manually via
         * {@link PreviewPrivacyImpactParametersInput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PreviewPrivacyImpactParametersInput.Builder#build()} is called
         * immediately and its result is passed to {@link #parameters(PreviewPrivacyImpactParametersInput)}.
         * 
         * @param parameters
         *        a consumer that will call methods on {@link PreviewPrivacyImpactParametersInput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #parameters(PreviewPrivacyImpactParametersInput)
         */
        default Builder parameters(Consumer<PreviewPrivacyImpactParametersInput.Builder> parameters) {
            return parameters(PreviewPrivacyImpactParametersInput.builder().applyMutation(parameters).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CleanRoomsRequest.BuilderImpl implements Builder {
        private String membershipIdentifier;

        private PreviewPrivacyImpactParametersInput parameters;

        private BuilderImpl() {
        }

        private BuilderImpl(PreviewPrivacyImpactRequest model) {
            super(model);
            membershipIdentifier(model.membershipIdentifier);
            parameters(model.parameters);
        }

        public final String getMembershipIdentifier() {
            return membershipIdentifier;
        }

        public final void setMembershipIdentifier(String membershipIdentifier) {
            this.membershipIdentifier = membershipIdentifier;
        }

        @Override
        public final Builder membershipIdentifier(String membershipIdentifier) {
            this.membershipIdentifier = membershipIdentifier;
            return this;
        }

        public final PreviewPrivacyImpactParametersInput.Builder getParameters() {
            return parameters != null ? parameters.toBuilder() : null;
        }

        public final void setParameters(PreviewPrivacyImpactParametersInput.BuilderImpl parameters) {
            this.parameters = parameters != null ? parameters.build() : null;
        }

        @Override
        public final Builder parameters(PreviewPrivacyImpactParametersInput parameters) {
            this.parameters = parameters;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PreviewPrivacyImpactRequest build() {
            return new PreviewPrivacyImpactRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
