/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cleanrooms.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object representing the payment responsibilities accepted by the collaboration member for query and job compute
 * costs.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MembershipJobComputePaymentConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<MembershipJobComputePaymentConfig.Builder, MembershipJobComputePaymentConfig> {
    private static final SdkField<Boolean> IS_RESPONSIBLE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("isResponsible").getter(getter(MembershipJobComputePaymentConfig::isResponsible))
            .setter(setter(Builder::isResponsible))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isResponsible").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IS_RESPONSIBLE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Boolean isResponsible;

    private MembershipJobComputePaymentConfig(BuilderImpl builder) {
        this.isResponsible = builder.isResponsible;
    }

    /**
     * <p>
     * Indicates whether the collaboration member has accepted to pay for job compute costs (<code>TRUE</code>) or has
     * not accepted to pay for query and job compute costs (<code>FALSE</code>).
     * </p>
     * <p>
     * There is only one member who pays for queries and jobs.
     * </p>
     * <p>
     * An error message is returned for the following reasons:
     * </p>
     * <ul>
     * <li>
     * <p>
     * If you set the value to <code>FALSE</code> but you are responsible to pay for query and job compute costs.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you set the value to <code>TRUE</code> but you are not responsible to pay for query and job compute costs.
     * </p>
     * </li>
     * </ul>
     * 
     * @return Indicates whether the collaboration member has accepted to pay for job compute costs (<code>TRUE</code>)
     *         or has not accepted to pay for query and job compute costs (<code>FALSE</code>).</p>
     *         <p>
     *         There is only one member who pays for queries and jobs.
     *         </p>
     *         <p>
     *         An error message is returned for the following reasons:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         If you set the value to <code>FALSE</code> but you are responsible to pay for query and job compute
     *         costs.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         If you set the value to <code>TRUE</code> but you are not responsible to pay for query and job compute
     *         costs.
     *         </p>
     *         </li>
     */
    public final Boolean isResponsible() {
        return isResponsible;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(isResponsible());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MembershipJobComputePaymentConfig)) {
            return false;
        }
        MembershipJobComputePaymentConfig other = (MembershipJobComputePaymentConfig) obj;
        return Objects.equals(isResponsible(), other.isResponsible());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MembershipJobComputePaymentConfig").add("IsResponsible", isResponsible()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "isResponsible":
            return Optional.ofNullable(clazz.cast(isResponsible()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("isResponsible", IS_RESPONSIBLE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MembershipJobComputePaymentConfig, T> g) {
        return obj -> g.apply((MembershipJobComputePaymentConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MembershipJobComputePaymentConfig> {
        /**
         * <p>
         * Indicates whether the collaboration member has accepted to pay for job compute costs (<code>TRUE</code>) or
         * has not accepted to pay for query and job compute costs (<code>FALSE</code>).
         * </p>
         * <p>
         * There is only one member who pays for queries and jobs.
         * </p>
         * <p>
         * An error message is returned for the following reasons:
         * </p>
         * <ul>
         * <li>
         * <p>
         * If you set the value to <code>FALSE</code> but you are responsible to pay for query and job compute costs.
         * </p>
         * </li>
         * <li>
         * <p>
         * If you set the value to <code>TRUE</code> but you are not responsible to pay for query and job compute costs.
         * </p>
         * </li>
         * </ul>
         * 
         * @param isResponsible
         *        Indicates whether the collaboration member has accepted to pay for job compute costs (
         *        <code>TRUE</code>) or has not accepted to pay for query and job compute costs (<code>FALSE</code>
         *        ).</p>
         *        <p>
         *        There is only one member who pays for queries and jobs.
         *        </p>
         *        <p>
         *        An error message is returned for the following reasons:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        If you set the value to <code>FALSE</code> but you are responsible to pay for query and job compute
         *        costs.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If you set the value to <code>TRUE</code> but you are not responsible to pay for query and job compute
         *        costs.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isResponsible(Boolean isResponsible);
    }

    static final class BuilderImpl implements Builder {
        private Boolean isResponsible;

        private BuilderImpl() {
        }

        private BuilderImpl(MembershipJobComputePaymentConfig model) {
            isResponsible(model.isResponsible);
        }

        public final Boolean getIsResponsible() {
            return isResponsible;
        }

        public final void setIsResponsible(Boolean isResponsible) {
            this.isResponsible = isResponsible;
        }

        @Override
        public final Builder isResponsible(Boolean isResponsible) {
            this.isResponsible = isResponsible;
            return this;
        }

        @Override
        public MembershipJobComputePaymentConfig build() {
            return new MembershipJobComputePaymentConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
