/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cleanrooms.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The membership object.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Membership implements SdkPojo, Serializable, ToCopyableBuilder<Membership.Builder, Membership> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(Membership::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(Membership::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<String> COLLABORATION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("collaborationArn").getter(getter(Membership::collaborationArn))
            .setter(setter(Builder::collaborationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("collaborationArn").build()).build();

    private static final SdkField<String> COLLABORATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("collaborationId").getter(getter(Membership::collaborationId)).setter(setter(Builder::collaborationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("collaborationId").build()).build();

    private static final SdkField<String> COLLABORATION_CREATOR_ACCOUNT_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("collaborationCreatorAccountId")
            .getter(getter(Membership::collaborationCreatorAccountId))
            .setter(setter(Builder::collaborationCreatorAccountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("collaborationCreatorAccountId")
                    .build()).build();

    private static final SdkField<String> COLLABORATION_CREATOR_DISPLAY_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("collaborationCreatorDisplayName")
            .getter(getter(Membership::collaborationCreatorDisplayName))
            .setter(setter(Builder::collaborationCreatorDisplayName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("collaborationCreatorDisplayName")
                    .build()).build();

    private static final SdkField<String> COLLABORATION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("collaborationName").getter(getter(Membership::collaborationName))
            .setter(setter(Builder::collaborationName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("collaborationName").build()).build();

    private static final SdkField<Instant> CREATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("createTime").getter(getter(Membership::createTime)).setter(setter(Builder::createTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createTime").build()).build();

    private static final SdkField<Instant> UPDATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("updateTime").getter(getter(Membership::updateTime)).setter(setter(Builder::updateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updateTime").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(Membership::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<List<String>> MEMBER_ABILITIES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("memberAbilities")
            .getter(getter(Membership::memberAbilitiesAsStrings))
            .setter(setter(Builder::memberAbilitiesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("memberAbilities").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<MLMemberAbilities> ML_MEMBER_ABILITIES_FIELD = SdkField
            .<MLMemberAbilities> builder(MarshallingType.SDK_POJO).memberName("mlMemberAbilities")
            .getter(getter(Membership::mlMemberAbilities)).setter(setter(Builder::mlMemberAbilities))
            .constructor(MLMemberAbilities::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mlMemberAbilities").build()).build();

    private static final SdkField<String> QUERY_LOG_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("queryLogStatus").getter(getter(Membership::queryLogStatusAsString))
            .setter(setter(Builder::queryLogStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("queryLogStatus").build()).build();

    private static final SdkField<String> JOB_LOG_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("jobLogStatus").getter(getter(Membership::jobLogStatusAsString)).setter(setter(Builder::jobLogStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobLogStatus").build()).build();

    private static final SdkField<MembershipProtectedQueryResultConfiguration> DEFAULT_RESULT_CONFIGURATION_FIELD = SdkField
            .<MembershipProtectedQueryResultConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("defaultResultConfiguration")
            .getter(getter(Membership::defaultResultConfiguration))
            .setter(setter(Builder::defaultResultConfiguration))
            .constructor(MembershipProtectedQueryResultConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("defaultResultConfiguration").build())
            .build();

    private static final SdkField<MembershipProtectedJobResultConfiguration> DEFAULT_JOB_RESULT_CONFIGURATION_FIELD = SdkField
            .<MembershipProtectedJobResultConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("defaultJobResultConfiguration")
            .getter(getter(Membership::defaultJobResultConfiguration))
            .setter(setter(Builder::defaultJobResultConfiguration))
            .constructor(MembershipProtectedJobResultConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("defaultJobResultConfiguration")
                    .build()).build();

    private static final SdkField<MembershipPaymentConfiguration> PAYMENT_CONFIGURATION_FIELD = SdkField
            .<MembershipPaymentConfiguration> builder(MarshallingType.SDK_POJO).memberName("paymentConfiguration")
            .getter(getter(Membership::paymentConfiguration)).setter(setter(Builder::paymentConfiguration))
            .constructor(MembershipPaymentConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("paymentConfiguration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, ARN_FIELD,
            COLLABORATION_ARN_FIELD, COLLABORATION_ID_FIELD, COLLABORATION_CREATOR_ACCOUNT_ID_FIELD,
            COLLABORATION_CREATOR_DISPLAY_NAME_FIELD, COLLABORATION_NAME_FIELD, CREATE_TIME_FIELD, UPDATE_TIME_FIELD,
            STATUS_FIELD, MEMBER_ABILITIES_FIELD, ML_MEMBER_ABILITIES_FIELD, QUERY_LOG_STATUS_FIELD, JOB_LOG_STATUS_FIELD,
            DEFAULT_RESULT_CONFIGURATION_FIELD, DEFAULT_JOB_RESULT_CONFIGURATION_FIELD, PAYMENT_CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String id;

    private final String arn;

    private final String collaborationArn;

    private final String collaborationId;

    private final String collaborationCreatorAccountId;

    private final String collaborationCreatorDisplayName;

    private final String collaborationName;

    private final Instant createTime;

    private final Instant updateTime;

    private final String status;

    private final List<String> memberAbilities;

    private final MLMemberAbilities mlMemberAbilities;

    private final String queryLogStatus;

    private final String jobLogStatus;

    private final MembershipProtectedQueryResultConfiguration defaultResultConfiguration;

    private final MembershipProtectedJobResultConfiguration defaultJobResultConfiguration;

    private final MembershipPaymentConfiguration paymentConfiguration;

    private Membership(BuilderImpl builder) {
        this.id = builder.id;
        this.arn = builder.arn;
        this.collaborationArn = builder.collaborationArn;
        this.collaborationId = builder.collaborationId;
        this.collaborationCreatorAccountId = builder.collaborationCreatorAccountId;
        this.collaborationCreatorDisplayName = builder.collaborationCreatorDisplayName;
        this.collaborationName = builder.collaborationName;
        this.createTime = builder.createTime;
        this.updateTime = builder.updateTime;
        this.status = builder.status;
        this.memberAbilities = builder.memberAbilities;
        this.mlMemberAbilities = builder.mlMemberAbilities;
        this.queryLogStatus = builder.queryLogStatus;
        this.jobLogStatus = builder.jobLogStatus;
        this.defaultResultConfiguration = builder.defaultResultConfiguration;
        this.defaultJobResultConfiguration = builder.defaultJobResultConfiguration;
        this.paymentConfiguration = builder.paymentConfiguration;
    }

    /**
     * <p>
     * The unique ID of the membership.
     * </p>
     * 
     * @return The unique ID of the membership.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The unique ARN for the membership.
     * </p>
     * 
     * @return The unique ARN for the membership.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The unique ARN for the membership's associated collaboration.
     * </p>
     * 
     * @return The unique ARN for the membership's associated collaboration.
     */
    public final String collaborationArn() {
        return collaborationArn;
    }

    /**
     * <p>
     * The unique ID for the membership's collaboration.
     * </p>
     * 
     * @return The unique ID for the membership's collaboration.
     */
    public final String collaborationId() {
        return collaborationId;
    }

    /**
     * <p>
     * The identifier used to reference members of the collaboration. Currently only supports Amazon Web Services
     * account ID.
     * </p>
     * 
     * @return The identifier used to reference members of the collaboration. Currently only supports Amazon Web
     *         Services account ID.
     */
    public final String collaborationCreatorAccountId() {
        return collaborationCreatorAccountId;
    }

    /**
     * <p>
     * The display name of the collaboration creator.
     * </p>
     * 
     * @return The display name of the collaboration creator.
     */
    public final String collaborationCreatorDisplayName() {
        return collaborationCreatorDisplayName;
    }

    /**
     * <p>
     * The name of the membership's collaboration.
     * </p>
     * 
     * @return The name of the membership's collaboration.
     */
    public final String collaborationName() {
        return collaborationName;
    }

    /**
     * <p>
     * The time when the membership was created.
     * </p>
     * 
     * @return The time when the membership was created.
     */
    public final Instant createTime() {
        return createTime;
    }

    /**
     * <p>
     * The time the membership metadata was last updated.
     * </p>
     * 
     * @return The time the membership metadata was last updated.
     */
    public final Instant updateTime() {
        return updateTime;
    }

    /**
     * <p>
     * The status of the membership.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link MembershipStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the membership.
     * @see MembershipStatus
     */
    public final MembershipStatus status() {
        return MembershipStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the membership.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link MembershipStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the membership.
     * @see MembershipStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The abilities granted to the collaboration member.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMemberAbilities} method.
     * </p>
     * 
     * @return The abilities granted to the collaboration member.
     */
    public final List<MemberAbility> memberAbilities() {
        return MemberAbilitiesCopier.copyStringToEnum(memberAbilities);
    }

    /**
     * For responses, this returns true if the service returned a value for the MemberAbilities property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasMemberAbilities() {
        return memberAbilities != null && !(memberAbilities instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The abilities granted to the collaboration member.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMemberAbilities} method.
     * </p>
     * 
     * @return The abilities granted to the collaboration member.
     */
    public final List<String> memberAbilitiesAsStrings() {
        return memberAbilities;
    }

    /**
     * <p>
     * Specifies the ML member abilities that are granted to a collaboration member.
     * </p>
     * 
     * @return Specifies the ML member abilities that are granted to a collaboration member.
     */
    public final MLMemberAbilities mlMemberAbilities() {
        return mlMemberAbilities;
    }

    /**
     * <p>
     * An indicator as to whether query logging has been enabled or disabled for the membership.
     * </p>
     * <p>
     * When <code>ENABLED</code>, Clean Rooms logs details about queries run within this collaboration and those logs
     * can be viewed in Amazon CloudWatch Logs. The default value is <code>DISABLED</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #queryLogStatus}
     * will return {@link MembershipQueryLogStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #queryLogStatusAsString}.
     * </p>
     * 
     * @return An indicator as to whether query logging has been enabled or disabled for the membership.</p>
     *         <p>
     *         When <code>ENABLED</code>, Clean Rooms logs details about queries run within this collaboration and those
     *         logs can be viewed in Amazon CloudWatch Logs. The default value is <code>DISABLED</code>.
     * @see MembershipQueryLogStatus
     */
    public final MembershipQueryLogStatus queryLogStatus() {
        return MembershipQueryLogStatus.fromValue(queryLogStatus);
    }

    /**
     * <p>
     * An indicator as to whether query logging has been enabled or disabled for the membership.
     * </p>
     * <p>
     * When <code>ENABLED</code>, Clean Rooms logs details about queries run within this collaboration and those logs
     * can be viewed in Amazon CloudWatch Logs. The default value is <code>DISABLED</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #queryLogStatus}
     * will return {@link MembershipQueryLogStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #queryLogStatusAsString}.
     * </p>
     * 
     * @return An indicator as to whether query logging has been enabled or disabled for the membership.</p>
     *         <p>
     *         When <code>ENABLED</code>, Clean Rooms logs details about queries run within this collaboration and those
     *         logs can be viewed in Amazon CloudWatch Logs. The default value is <code>DISABLED</code>.
     * @see MembershipQueryLogStatus
     */
    public final String queryLogStatusAsString() {
        return queryLogStatus;
    }

    /**
     * <p>
     * An indicator as to whether job logging has been enabled or disabled for the collaboration.
     * </p>
     * <p>
     * When <code>ENABLED</code>, Clean Rooms logs details about jobs run within this collaboration and those logs can
     * be viewed in Amazon CloudWatch Logs. The default value is <code>DISABLED</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #jobLogStatus} will
     * return {@link MembershipJobLogStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #jobLogStatusAsString}.
     * </p>
     * 
     * @return An indicator as to whether job logging has been enabled or disabled for the collaboration. </p>
     *         <p>
     *         When <code>ENABLED</code>, Clean Rooms logs details about jobs run within this collaboration and those
     *         logs can be viewed in Amazon CloudWatch Logs. The default value is <code>DISABLED</code>.
     * @see MembershipJobLogStatus
     */
    public final MembershipJobLogStatus jobLogStatus() {
        return MembershipJobLogStatus.fromValue(jobLogStatus);
    }

    /**
     * <p>
     * An indicator as to whether job logging has been enabled or disabled for the collaboration.
     * </p>
     * <p>
     * When <code>ENABLED</code>, Clean Rooms logs details about jobs run within this collaboration and those logs can
     * be viewed in Amazon CloudWatch Logs. The default value is <code>DISABLED</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #jobLogStatus} will
     * return {@link MembershipJobLogStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #jobLogStatusAsString}.
     * </p>
     * 
     * @return An indicator as to whether job logging has been enabled or disabled for the collaboration. </p>
     *         <p>
     *         When <code>ENABLED</code>, Clean Rooms logs details about jobs run within this collaboration and those
     *         logs can be viewed in Amazon CloudWatch Logs. The default value is <code>DISABLED</code>.
     * @see MembershipJobLogStatus
     */
    public final String jobLogStatusAsString() {
        return jobLogStatus;
    }

    /**
     * <p>
     * The default protected query result configuration as specified by the member who can receive results.
     * </p>
     * 
     * @return The default protected query result configuration as specified by the member who can receive results.
     */
    public final MembershipProtectedQueryResultConfiguration defaultResultConfiguration() {
        return defaultResultConfiguration;
    }

    /**
     * <p>
     * The default job result configuration for the membership.
     * </p>
     * 
     * @return The default job result configuration for the membership.
     */
    public final MembershipProtectedJobResultConfiguration defaultJobResultConfiguration() {
        return defaultJobResultConfiguration;
    }

    /**
     * <p>
     * The payment responsibilities accepted by the collaboration member.
     * </p>
     * 
     * @return The payment responsibilities accepted by the collaboration member.
     */
    public final MembershipPaymentConfiguration paymentConfiguration() {
        return paymentConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(collaborationArn());
        hashCode = 31 * hashCode + Objects.hashCode(collaborationId());
        hashCode = 31 * hashCode + Objects.hashCode(collaborationCreatorAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(collaborationCreatorDisplayName());
        hashCode = 31 * hashCode + Objects.hashCode(collaborationName());
        hashCode = 31 * hashCode + Objects.hashCode(createTime());
        hashCode = 31 * hashCode + Objects.hashCode(updateTime());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasMemberAbilities() ? memberAbilitiesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(mlMemberAbilities());
        hashCode = 31 * hashCode + Objects.hashCode(queryLogStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(jobLogStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(defaultResultConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(defaultJobResultConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(paymentConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Membership)) {
            return false;
        }
        Membership other = (Membership) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(arn(), other.arn())
                && Objects.equals(collaborationArn(), other.collaborationArn())
                && Objects.equals(collaborationId(), other.collaborationId())
                && Objects.equals(collaborationCreatorAccountId(), other.collaborationCreatorAccountId())
                && Objects.equals(collaborationCreatorDisplayName(), other.collaborationCreatorDisplayName())
                && Objects.equals(collaborationName(), other.collaborationName())
                && Objects.equals(createTime(), other.createTime()) && Objects.equals(updateTime(), other.updateTime())
                && Objects.equals(statusAsString(), other.statusAsString()) && hasMemberAbilities() == other.hasMemberAbilities()
                && Objects.equals(memberAbilitiesAsStrings(), other.memberAbilitiesAsStrings())
                && Objects.equals(mlMemberAbilities(), other.mlMemberAbilities())
                && Objects.equals(queryLogStatusAsString(), other.queryLogStatusAsString())
                && Objects.equals(jobLogStatusAsString(), other.jobLogStatusAsString())
                && Objects.equals(defaultResultConfiguration(), other.defaultResultConfiguration())
                && Objects.equals(defaultJobResultConfiguration(), other.defaultJobResultConfiguration())
                && Objects.equals(paymentConfiguration(), other.paymentConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Membership").add("Id", id()).add("Arn", arn()).add("CollaborationArn", collaborationArn())
                .add("CollaborationId", collaborationId()).add("CollaborationCreatorAccountId", collaborationCreatorAccountId())
                .add("CollaborationCreatorDisplayName", collaborationCreatorDisplayName())
                .add("CollaborationName", collaborationName()).add("CreateTime", createTime()).add("UpdateTime", updateTime())
                .add("Status", statusAsString()).add("MemberAbilities", hasMemberAbilities() ? memberAbilitiesAsStrings() : null)
                .add("MlMemberAbilities", mlMemberAbilities()).add("QueryLogStatus", queryLogStatusAsString())
                .add("JobLogStatus", jobLogStatusAsString()).add("DefaultResultConfiguration", defaultResultConfiguration())
                .add("DefaultJobResultConfiguration", defaultJobResultConfiguration())
                .add("PaymentConfiguration", paymentConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "collaborationArn":
            return Optional.ofNullable(clazz.cast(collaborationArn()));
        case "collaborationId":
            return Optional.ofNullable(clazz.cast(collaborationId()));
        case "collaborationCreatorAccountId":
            return Optional.ofNullable(clazz.cast(collaborationCreatorAccountId()));
        case "collaborationCreatorDisplayName":
            return Optional.ofNullable(clazz.cast(collaborationCreatorDisplayName()));
        case "collaborationName":
            return Optional.ofNullable(clazz.cast(collaborationName()));
        case "createTime":
            return Optional.ofNullable(clazz.cast(createTime()));
        case "updateTime":
            return Optional.ofNullable(clazz.cast(updateTime()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "memberAbilities":
            return Optional.ofNullable(clazz.cast(memberAbilitiesAsStrings()));
        case "mlMemberAbilities":
            return Optional.ofNullable(clazz.cast(mlMemberAbilities()));
        case "queryLogStatus":
            return Optional.ofNullable(clazz.cast(queryLogStatusAsString()));
        case "jobLogStatus":
            return Optional.ofNullable(clazz.cast(jobLogStatusAsString()));
        case "defaultResultConfiguration":
            return Optional.ofNullable(clazz.cast(defaultResultConfiguration()));
        case "defaultJobResultConfiguration":
            return Optional.ofNullable(clazz.cast(defaultJobResultConfiguration()));
        case "paymentConfiguration":
            return Optional.ofNullable(clazz.cast(paymentConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("id", ID_FIELD);
        map.put("arn", ARN_FIELD);
        map.put("collaborationArn", COLLABORATION_ARN_FIELD);
        map.put("collaborationId", COLLABORATION_ID_FIELD);
        map.put("collaborationCreatorAccountId", COLLABORATION_CREATOR_ACCOUNT_ID_FIELD);
        map.put("collaborationCreatorDisplayName", COLLABORATION_CREATOR_DISPLAY_NAME_FIELD);
        map.put("collaborationName", COLLABORATION_NAME_FIELD);
        map.put("createTime", CREATE_TIME_FIELD);
        map.put("updateTime", UPDATE_TIME_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("memberAbilities", MEMBER_ABILITIES_FIELD);
        map.put("mlMemberAbilities", ML_MEMBER_ABILITIES_FIELD);
        map.put("queryLogStatus", QUERY_LOG_STATUS_FIELD);
        map.put("jobLogStatus", JOB_LOG_STATUS_FIELD);
        map.put("defaultResultConfiguration", DEFAULT_RESULT_CONFIGURATION_FIELD);
        map.put("defaultJobResultConfiguration", DEFAULT_JOB_RESULT_CONFIGURATION_FIELD);
        map.put("paymentConfiguration", PAYMENT_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Membership, T> g) {
        return obj -> g.apply((Membership) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Membership> {
        /**
         * <p>
         * The unique ID of the membership.
         * </p>
         * 
         * @param id
         *        The unique ID of the membership.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The unique ARN for the membership.
         * </p>
         * 
         * @param arn
         *        The unique ARN for the membership.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The unique ARN for the membership's associated collaboration.
         * </p>
         * 
         * @param collaborationArn
         *        The unique ARN for the membership's associated collaboration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder collaborationArn(String collaborationArn);

        /**
         * <p>
         * The unique ID for the membership's collaboration.
         * </p>
         * 
         * @param collaborationId
         *        The unique ID for the membership's collaboration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder collaborationId(String collaborationId);

        /**
         * <p>
         * The identifier used to reference members of the collaboration. Currently only supports Amazon Web Services
         * account ID.
         * </p>
         * 
         * @param collaborationCreatorAccountId
         *        The identifier used to reference members of the collaboration. Currently only supports Amazon Web
         *        Services account ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder collaborationCreatorAccountId(String collaborationCreatorAccountId);

        /**
         * <p>
         * The display name of the collaboration creator.
         * </p>
         * 
         * @param collaborationCreatorDisplayName
         *        The display name of the collaboration creator.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder collaborationCreatorDisplayName(String collaborationCreatorDisplayName);

        /**
         * <p>
         * The name of the membership's collaboration.
         * </p>
         * 
         * @param collaborationName
         *        The name of the membership's collaboration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder collaborationName(String collaborationName);

        /**
         * <p>
         * The time when the membership was created.
         * </p>
         * 
         * @param createTime
         *        The time when the membership was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createTime(Instant createTime);

        /**
         * <p>
         * The time the membership metadata was last updated.
         * </p>
         * 
         * @param updateTime
         *        The time the membership metadata was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updateTime(Instant updateTime);

        /**
         * <p>
         * The status of the membership.
         * </p>
         * 
         * @param status
         *        The status of the membership.
         * @see MembershipStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MembershipStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the membership.
         * </p>
         * 
         * @param status
         *        The status of the membership.
         * @see MembershipStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MembershipStatus
         */
        Builder status(MembershipStatus status);

        /**
         * <p>
         * The abilities granted to the collaboration member.
         * </p>
         * 
         * @param memberAbilities
         *        The abilities granted to the collaboration member.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder memberAbilitiesWithStrings(Collection<String> memberAbilities);

        /**
         * <p>
         * The abilities granted to the collaboration member.
         * </p>
         * 
         * @param memberAbilities
         *        The abilities granted to the collaboration member.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder memberAbilitiesWithStrings(String... memberAbilities);

        /**
         * <p>
         * The abilities granted to the collaboration member.
         * </p>
         * 
         * @param memberAbilities
         *        The abilities granted to the collaboration member.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder memberAbilities(Collection<MemberAbility> memberAbilities);

        /**
         * <p>
         * The abilities granted to the collaboration member.
         * </p>
         * 
         * @param memberAbilities
         *        The abilities granted to the collaboration member.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder memberAbilities(MemberAbility... memberAbilities);

        /**
         * <p>
         * Specifies the ML member abilities that are granted to a collaboration member.
         * </p>
         * 
         * @param mlMemberAbilities
         *        Specifies the ML member abilities that are granted to a collaboration member.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mlMemberAbilities(MLMemberAbilities mlMemberAbilities);

        /**
         * <p>
         * Specifies the ML member abilities that are granted to a collaboration member.
         * </p>
         * This is a convenience method that creates an instance of the {@link MLMemberAbilities.Builder} avoiding the
         * need to create one manually via {@link MLMemberAbilities#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MLMemberAbilities.Builder#build()} is called immediately and its
         * result is passed to {@link #mlMemberAbilities(MLMemberAbilities)}.
         * 
         * @param mlMemberAbilities
         *        a consumer that will call methods on {@link MLMemberAbilities.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #mlMemberAbilities(MLMemberAbilities)
         */
        default Builder mlMemberAbilities(Consumer<MLMemberAbilities.Builder> mlMemberAbilities) {
            return mlMemberAbilities(MLMemberAbilities.builder().applyMutation(mlMemberAbilities).build());
        }

        /**
         * <p>
         * An indicator as to whether query logging has been enabled or disabled for the membership.
         * </p>
         * <p>
         * When <code>ENABLED</code>, Clean Rooms logs details about queries run within this collaboration and those
         * logs can be viewed in Amazon CloudWatch Logs. The default value is <code>DISABLED</code>.
         * </p>
         * 
         * @param queryLogStatus
         *        An indicator as to whether query logging has been enabled or disabled for the membership.</p>
         *        <p>
         *        When <code>ENABLED</code>, Clean Rooms logs details about queries run within this collaboration and
         *        those logs can be viewed in Amazon CloudWatch Logs. The default value is <code>DISABLED</code>.
         * @see MembershipQueryLogStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MembershipQueryLogStatus
         */
        Builder queryLogStatus(String queryLogStatus);

        /**
         * <p>
         * An indicator as to whether query logging has been enabled or disabled for the membership.
         * </p>
         * <p>
         * When <code>ENABLED</code>, Clean Rooms logs details about queries run within this collaboration and those
         * logs can be viewed in Amazon CloudWatch Logs. The default value is <code>DISABLED</code>.
         * </p>
         * 
         * @param queryLogStatus
         *        An indicator as to whether query logging has been enabled or disabled for the membership.</p>
         *        <p>
         *        When <code>ENABLED</code>, Clean Rooms logs details about queries run within this collaboration and
         *        those logs can be viewed in Amazon CloudWatch Logs. The default value is <code>DISABLED</code>.
         * @see MembershipQueryLogStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MembershipQueryLogStatus
         */
        Builder queryLogStatus(MembershipQueryLogStatus queryLogStatus);

        /**
         * <p>
         * An indicator as to whether job logging has been enabled or disabled for the collaboration.
         * </p>
         * <p>
         * When <code>ENABLED</code>, Clean Rooms logs details about jobs run within this collaboration and those logs
         * can be viewed in Amazon CloudWatch Logs. The default value is <code>DISABLED</code>.
         * </p>
         * 
         * @param jobLogStatus
         *        An indicator as to whether job logging has been enabled or disabled for the collaboration. </p>
         *        <p>
         *        When <code>ENABLED</code>, Clean Rooms logs details about jobs run within this collaboration and those
         *        logs can be viewed in Amazon CloudWatch Logs. The default value is <code>DISABLED</code>.
         * @see MembershipJobLogStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MembershipJobLogStatus
         */
        Builder jobLogStatus(String jobLogStatus);

        /**
         * <p>
         * An indicator as to whether job logging has been enabled or disabled for the collaboration.
         * </p>
         * <p>
         * When <code>ENABLED</code>, Clean Rooms logs details about jobs run within this collaboration and those logs
         * can be viewed in Amazon CloudWatch Logs. The default value is <code>DISABLED</code>.
         * </p>
         * 
         * @param jobLogStatus
         *        An indicator as to whether job logging has been enabled or disabled for the collaboration. </p>
         *        <p>
         *        When <code>ENABLED</code>, Clean Rooms logs details about jobs run within this collaboration and those
         *        logs can be viewed in Amazon CloudWatch Logs. The default value is <code>DISABLED</code>.
         * @see MembershipJobLogStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MembershipJobLogStatus
         */
        Builder jobLogStatus(MembershipJobLogStatus jobLogStatus);

        /**
         * <p>
         * The default protected query result configuration as specified by the member who can receive results.
         * </p>
         * 
         * @param defaultResultConfiguration
         *        The default protected query result configuration as specified by the member who can receive results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultResultConfiguration(MembershipProtectedQueryResultConfiguration defaultResultConfiguration);

        /**
         * <p>
         * The default protected query result configuration as specified by the member who can receive results.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link MembershipProtectedQueryResultConfiguration.Builder} avoiding the need to create one manually via
         * {@link MembershipProtectedQueryResultConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MembershipProtectedQueryResultConfiguration.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #defaultResultConfiguration(MembershipProtectedQueryResultConfiguration)}.
         * 
         * @param defaultResultConfiguration
         *        a consumer that will call methods on {@link MembershipProtectedQueryResultConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #defaultResultConfiguration(MembershipProtectedQueryResultConfiguration)
         */
        default Builder defaultResultConfiguration(
                Consumer<MembershipProtectedQueryResultConfiguration.Builder> defaultResultConfiguration) {
            return defaultResultConfiguration(MembershipProtectedQueryResultConfiguration.builder()
                    .applyMutation(defaultResultConfiguration).build());
        }

        /**
         * <p>
         * The default job result configuration for the membership.
         * </p>
         * 
         * @param defaultJobResultConfiguration
         *        The default job result configuration for the membership.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultJobResultConfiguration(MembershipProtectedJobResultConfiguration defaultJobResultConfiguration);

        /**
         * <p>
         * The default job result configuration for the membership.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link MembershipProtectedJobResultConfiguration.Builder} avoiding the need to create one manually via
         * {@link MembershipProtectedJobResultConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MembershipProtectedJobResultConfiguration.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #defaultJobResultConfiguration(MembershipProtectedJobResultConfiguration)}.
         * 
         * @param defaultJobResultConfiguration
         *        a consumer that will call methods on {@link MembershipProtectedJobResultConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #defaultJobResultConfiguration(MembershipProtectedJobResultConfiguration)
         */
        default Builder defaultJobResultConfiguration(
                Consumer<MembershipProtectedJobResultConfiguration.Builder> defaultJobResultConfiguration) {
            return defaultJobResultConfiguration(MembershipProtectedJobResultConfiguration.builder()
                    .applyMutation(defaultJobResultConfiguration).build());
        }

        /**
         * <p>
         * The payment responsibilities accepted by the collaboration member.
         * </p>
         * 
         * @param paymentConfiguration
         *        The payment responsibilities accepted by the collaboration member.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder paymentConfiguration(MembershipPaymentConfiguration paymentConfiguration);

        /**
         * <p>
         * The payment responsibilities accepted by the collaboration member.
         * </p>
         * This is a convenience method that creates an instance of the {@link MembershipPaymentConfiguration.Builder}
         * avoiding the need to create one manually via {@link MembershipPaymentConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MembershipPaymentConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #paymentConfiguration(MembershipPaymentConfiguration)}.
         * 
         * @param paymentConfiguration
         *        a consumer that will call methods on {@link MembershipPaymentConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #paymentConfiguration(MembershipPaymentConfiguration)
         */
        default Builder paymentConfiguration(Consumer<MembershipPaymentConfiguration.Builder> paymentConfiguration) {
            return paymentConfiguration(MembershipPaymentConfiguration.builder().applyMutation(paymentConfiguration).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private String arn;

        private String collaborationArn;

        private String collaborationId;

        private String collaborationCreatorAccountId;

        private String collaborationCreatorDisplayName;

        private String collaborationName;

        private Instant createTime;

        private Instant updateTime;

        private String status;

        private List<String> memberAbilities = DefaultSdkAutoConstructList.getInstance();

        private MLMemberAbilities mlMemberAbilities;

        private String queryLogStatus;

        private String jobLogStatus;

        private MembershipProtectedQueryResultConfiguration defaultResultConfiguration;

        private MembershipProtectedJobResultConfiguration defaultJobResultConfiguration;

        private MembershipPaymentConfiguration paymentConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(Membership model) {
            id(model.id);
            arn(model.arn);
            collaborationArn(model.collaborationArn);
            collaborationId(model.collaborationId);
            collaborationCreatorAccountId(model.collaborationCreatorAccountId);
            collaborationCreatorDisplayName(model.collaborationCreatorDisplayName);
            collaborationName(model.collaborationName);
            createTime(model.createTime);
            updateTime(model.updateTime);
            status(model.status);
            memberAbilitiesWithStrings(model.memberAbilities);
            mlMemberAbilities(model.mlMemberAbilities);
            queryLogStatus(model.queryLogStatus);
            jobLogStatus(model.jobLogStatus);
            defaultResultConfiguration(model.defaultResultConfiguration);
            defaultJobResultConfiguration(model.defaultJobResultConfiguration);
            paymentConfiguration(model.paymentConfiguration);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getCollaborationArn() {
            return collaborationArn;
        }

        public final void setCollaborationArn(String collaborationArn) {
            this.collaborationArn = collaborationArn;
        }

        @Override
        public final Builder collaborationArn(String collaborationArn) {
            this.collaborationArn = collaborationArn;
            return this;
        }

        public final String getCollaborationId() {
            return collaborationId;
        }

        public final void setCollaborationId(String collaborationId) {
            this.collaborationId = collaborationId;
        }

        @Override
        public final Builder collaborationId(String collaborationId) {
            this.collaborationId = collaborationId;
            return this;
        }

        public final String getCollaborationCreatorAccountId() {
            return collaborationCreatorAccountId;
        }

        public final void setCollaborationCreatorAccountId(String collaborationCreatorAccountId) {
            this.collaborationCreatorAccountId = collaborationCreatorAccountId;
        }

        @Override
        public final Builder collaborationCreatorAccountId(String collaborationCreatorAccountId) {
            this.collaborationCreatorAccountId = collaborationCreatorAccountId;
            return this;
        }

        public final String getCollaborationCreatorDisplayName() {
            return collaborationCreatorDisplayName;
        }

        public final void setCollaborationCreatorDisplayName(String collaborationCreatorDisplayName) {
            this.collaborationCreatorDisplayName = collaborationCreatorDisplayName;
        }

        @Override
        public final Builder collaborationCreatorDisplayName(String collaborationCreatorDisplayName) {
            this.collaborationCreatorDisplayName = collaborationCreatorDisplayName;
            return this;
        }

        public final String getCollaborationName() {
            return collaborationName;
        }

        public final void setCollaborationName(String collaborationName) {
            this.collaborationName = collaborationName;
        }

        @Override
        public final Builder collaborationName(String collaborationName) {
            this.collaborationName = collaborationName;
            return this;
        }

        public final Instant getCreateTime() {
            return createTime;
        }

        public final void setCreateTime(Instant createTime) {
            this.createTime = createTime;
        }

        @Override
        public final Builder createTime(Instant createTime) {
            this.createTime = createTime;
            return this;
        }

        public final Instant getUpdateTime() {
            return updateTime;
        }

        public final void setUpdateTime(Instant updateTime) {
            this.updateTime = updateTime;
        }

        @Override
        public final Builder updateTime(Instant updateTime) {
            this.updateTime = updateTime;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(MembershipStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Collection<String> getMemberAbilities() {
            if (memberAbilities instanceof SdkAutoConstructList) {
                return null;
            }
            return memberAbilities;
        }

        public final void setMemberAbilities(Collection<String> memberAbilities) {
            this.memberAbilities = MemberAbilitiesCopier.copy(memberAbilities);
        }

        @Override
        public final Builder memberAbilitiesWithStrings(Collection<String> memberAbilities) {
            this.memberAbilities = MemberAbilitiesCopier.copy(memberAbilities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder memberAbilitiesWithStrings(String... memberAbilities) {
            memberAbilitiesWithStrings(Arrays.asList(memberAbilities));
            return this;
        }

        @Override
        public final Builder memberAbilities(Collection<MemberAbility> memberAbilities) {
            this.memberAbilities = MemberAbilitiesCopier.copyEnumToString(memberAbilities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder memberAbilities(MemberAbility... memberAbilities) {
            memberAbilities(Arrays.asList(memberAbilities));
            return this;
        }

        public final MLMemberAbilities.Builder getMlMemberAbilities() {
            return mlMemberAbilities != null ? mlMemberAbilities.toBuilder() : null;
        }

        public final void setMlMemberAbilities(MLMemberAbilities.BuilderImpl mlMemberAbilities) {
            this.mlMemberAbilities = mlMemberAbilities != null ? mlMemberAbilities.build() : null;
        }

        @Override
        public final Builder mlMemberAbilities(MLMemberAbilities mlMemberAbilities) {
            this.mlMemberAbilities = mlMemberAbilities;
            return this;
        }

        public final String getQueryLogStatus() {
            return queryLogStatus;
        }

        public final void setQueryLogStatus(String queryLogStatus) {
            this.queryLogStatus = queryLogStatus;
        }

        @Override
        public final Builder queryLogStatus(String queryLogStatus) {
            this.queryLogStatus = queryLogStatus;
            return this;
        }

        @Override
        public final Builder queryLogStatus(MembershipQueryLogStatus queryLogStatus) {
            this.queryLogStatus(queryLogStatus == null ? null : queryLogStatus.toString());
            return this;
        }

        public final String getJobLogStatus() {
            return jobLogStatus;
        }

        public final void setJobLogStatus(String jobLogStatus) {
            this.jobLogStatus = jobLogStatus;
        }

        @Override
        public final Builder jobLogStatus(String jobLogStatus) {
            this.jobLogStatus = jobLogStatus;
            return this;
        }

        @Override
        public final Builder jobLogStatus(MembershipJobLogStatus jobLogStatus) {
            this.jobLogStatus(jobLogStatus == null ? null : jobLogStatus.toString());
            return this;
        }

        public final MembershipProtectedQueryResultConfiguration.Builder getDefaultResultConfiguration() {
            return defaultResultConfiguration != null ? defaultResultConfiguration.toBuilder() : null;
        }

        public final void setDefaultResultConfiguration(
                MembershipProtectedQueryResultConfiguration.BuilderImpl defaultResultConfiguration) {
            this.defaultResultConfiguration = defaultResultConfiguration != null ? defaultResultConfiguration.build() : null;
        }

        @Override
        public final Builder defaultResultConfiguration(MembershipProtectedQueryResultConfiguration defaultResultConfiguration) {
            this.defaultResultConfiguration = defaultResultConfiguration;
            return this;
        }

        public final MembershipProtectedJobResultConfiguration.Builder getDefaultJobResultConfiguration() {
            return defaultJobResultConfiguration != null ? defaultJobResultConfiguration.toBuilder() : null;
        }

        public final void setDefaultJobResultConfiguration(
                MembershipProtectedJobResultConfiguration.BuilderImpl defaultJobResultConfiguration) {
            this.defaultJobResultConfiguration = defaultJobResultConfiguration != null ? defaultJobResultConfiguration.build()
                    : null;
        }

        @Override
        public final Builder defaultJobResultConfiguration(MembershipProtectedJobResultConfiguration defaultJobResultConfiguration) {
            this.defaultJobResultConfiguration = defaultJobResultConfiguration;
            return this;
        }

        public final MembershipPaymentConfiguration.Builder getPaymentConfiguration() {
            return paymentConfiguration != null ? paymentConfiguration.toBuilder() : null;
        }

        public final void setPaymentConfiguration(MembershipPaymentConfiguration.BuilderImpl paymentConfiguration) {
            this.paymentConfiguration = paymentConfiguration != null ? paymentConfiguration.build() : null;
        }

        @Override
        public final Builder paymentConfiguration(MembershipPaymentConfiguration paymentConfiguration) {
            this.paymentConfiguration = paymentConfiguration;
            return this;
        }

        @Override
        public Membership build() {
            return new Membership(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
