/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cleanrooms.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object representing the collaboration member's machine learning payment responsibilities set by the collaboration
 * creator.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MLPaymentConfig implements SdkPojo, Serializable, ToCopyableBuilder<MLPaymentConfig.Builder, MLPaymentConfig> {
    private static final SdkField<ModelTrainingPaymentConfig> MODEL_TRAINING_FIELD = SdkField
            .<ModelTrainingPaymentConfig> builder(MarshallingType.SDK_POJO).memberName("modelTraining")
            .getter(getter(MLPaymentConfig::modelTraining)).setter(setter(Builder::modelTraining))
            .constructor(ModelTrainingPaymentConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modelTraining").build()).build();

    private static final SdkField<ModelInferencePaymentConfig> MODEL_INFERENCE_FIELD = SdkField
            .<ModelInferencePaymentConfig> builder(MarshallingType.SDK_POJO).memberName("modelInference")
            .getter(getter(MLPaymentConfig::modelInference)).setter(setter(Builder::modelInference))
            .constructor(ModelInferencePaymentConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modelInference").build()).build();

    private static final SdkField<SyntheticDataGenerationPaymentConfig> SYNTHETIC_DATA_GENERATION_FIELD = SdkField
            .<SyntheticDataGenerationPaymentConfig> builder(MarshallingType.SDK_POJO).memberName("syntheticDataGeneration")
            .getter(getter(MLPaymentConfig::syntheticDataGeneration)).setter(setter(Builder::syntheticDataGeneration))
            .constructor(SyntheticDataGenerationPaymentConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("syntheticDataGeneration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MODEL_TRAINING_FIELD,
            MODEL_INFERENCE_FIELD, SYNTHETIC_DATA_GENERATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final ModelTrainingPaymentConfig modelTraining;

    private final ModelInferencePaymentConfig modelInference;

    private final SyntheticDataGenerationPaymentConfig syntheticDataGeneration;

    private MLPaymentConfig(BuilderImpl builder) {
        this.modelTraining = builder.modelTraining;
        this.modelInference = builder.modelInference;
        this.syntheticDataGeneration = builder.syntheticDataGeneration;
    }

    /**
     * <p>
     * The payment responsibilities accepted by the member for model training.
     * </p>
     * 
     * @return The payment responsibilities accepted by the member for model training.
     */
    public final ModelTrainingPaymentConfig modelTraining() {
        return modelTraining;
    }

    /**
     * <p>
     * The payment responsibilities accepted by the member for model inference.
     * </p>
     * 
     * @return The payment responsibilities accepted by the member for model inference.
     */
    public final ModelInferencePaymentConfig modelInference() {
        return modelInference;
    }

    /**
     * <p>
     * The payment configuration for machine learning synthetic data generation.
     * </p>
     * 
     * @return The payment configuration for machine learning synthetic data generation.
     */
    public final SyntheticDataGenerationPaymentConfig syntheticDataGeneration() {
        return syntheticDataGeneration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(modelTraining());
        hashCode = 31 * hashCode + Objects.hashCode(modelInference());
        hashCode = 31 * hashCode + Objects.hashCode(syntheticDataGeneration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MLPaymentConfig)) {
            return false;
        }
        MLPaymentConfig other = (MLPaymentConfig) obj;
        return Objects.equals(modelTraining(), other.modelTraining()) && Objects.equals(modelInference(), other.modelInference())
                && Objects.equals(syntheticDataGeneration(), other.syntheticDataGeneration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MLPaymentConfig").add("ModelTraining", modelTraining()).add("ModelInference", modelInference())
                .add("SyntheticDataGeneration", syntheticDataGeneration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "modelTraining":
            return Optional.ofNullable(clazz.cast(modelTraining()));
        case "modelInference":
            return Optional.ofNullable(clazz.cast(modelInference()));
        case "syntheticDataGeneration":
            return Optional.ofNullable(clazz.cast(syntheticDataGeneration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("modelTraining", MODEL_TRAINING_FIELD);
        map.put("modelInference", MODEL_INFERENCE_FIELD);
        map.put("syntheticDataGeneration", SYNTHETIC_DATA_GENERATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MLPaymentConfig, T> g) {
        return obj -> g.apply((MLPaymentConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MLPaymentConfig> {
        /**
         * <p>
         * The payment responsibilities accepted by the member for model training.
         * </p>
         * 
         * @param modelTraining
         *        The payment responsibilities accepted by the member for model training.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelTraining(ModelTrainingPaymentConfig modelTraining);

        /**
         * <p>
         * The payment responsibilities accepted by the member for model training.
         * </p>
         * This is a convenience method that creates an instance of the {@link ModelTrainingPaymentConfig.Builder}
         * avoiding the need to create one manually via {@link ModelTrainingPaymentConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ModelTrainingPaymentConfig.Builder#build()} is called immediately
         * and its result is passed to {@link #modelTraining(ModelTrainingPaymentConfig)}.
         * 
         * @param modelTraining
         *        a consumer that will call methods on {@link ModelTrainingPaymentConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #modelTraining(ModelTrainingPaymentConfig)
         */
        default Builder modelTraining(Consumer<ModelTrainingPaymentConfig.Builder> modelTraining) {
            return modelTraining(ModelTrainingPaymentConfig.builder().applyMutation(modelTraining).build());
        }

        /**
         * <p>
         * The payment responsibilities accepted by the member for model inference.
         * </p>
         * 
         * @param modelInference
         *        The payment responsibilities accepted by the member for model inference.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelInference(ModelInferencePaymentConfig modelInference);

        /**
         * <p>
         * The payment responsibilities accepted by the member for model inference.
         * </p>
         * This is a convenience method that creates an instance of the {@link ModelInferencePaymentConfig.Builder}
         * avoiding the need to create one manually via {@link ModelInferencePaymentConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ModelInferencePaymentConfig.Builder#build()} is called
         * immediately and its result is passed to {@link #modelInference(ModelInferencePaymentConfig)}.
         * 
         * @param modelInference
         *        a consumer that will call methods on {@link ModelInferencePaymentConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #modelInference(ModelInferencePaymentConfig)
         */
        default Builder modelInference(Consumer<ModelInferencePaymentConfig.Builder> modelInference) {
            return modelInference(ModelInferencePaymentConfig.builder().applyMutation(modelInference).build());
        }

        /**
         * <p>
         * The payment configuration for machine learning synthetic data generation.
         * </p>
         * 
         * @param syntheticDataGeneration
         *        The payment configuration for machine learning synthetic data generation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder syntheticDataGeneration(SyntheticDataGenerationPaymentConfig syntheticDataGeneration);

        /**
         * <p>
         * The payment configuration for machine learning synthetic data generation.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link SyntheticDataGenerationPaymentConfig.Builder} avoiding the need to create one manually via
         * {@link SyntheticDataGenerationPaymentConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SyntheticDataGenerationPaymentConfig.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #syntheticDataGeneration(SyntheticDataGenerationPaymentConfig)}.
         * 
         * @param syntheticDataGeneration
         *        a consumer that will call methods on {@link SyntheticDataGenerationPaymentConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #syntheticDataGeneration(SyntheticDataGenerationPaymentConfig)
         */
        default Builder syntheticDataGeneration(Consumer<SyntheticDataGenerationPaymentConfig.Builder> syntheticDataGeneration) {
            return syntheticDataGeneration(SyntheticDataGenerationPaymentConfig.builder().applyMutation(syntheticDataGeneration)
                    .build());
        }
    }

    static final class BuilderImpl implements Builder {
        private ModelTrainingPaymentConfig modelTraining;

        private ModelInferencePaymentConfig modelInference;

        private SyntheticDataGenerationPaymentConfig syntheticDataGeneration;

        private BuilderImpl() {
        }

        private BuilderImpl(MLPaymentConfig model) {
            modelTraining(model.modelTraining);
            modelInference(model.modelInference);
            syntheticDataGeneration(model.syntheticDataGeneration);
        }

        public final ModelTrainingPaymentConfig.Builder getModelTraining() {
            return modelTraining != null ? modelTraining.toBuilder() : null;
        }

        public final void setModelTraining(ModelTrainingPaymentConfig.BuilderImpl modelTraining) {
            this.modelTraining = modelTraining != null ? modelTraining.build() : null;
        }

        @Override
        public final Builder modelTraining(ModelTrainingPaymentConfig modelTraining) {
            this.modelTraining = modelTraining;
            return this;
        }

        public final ModelInferencePaymentConfig.Builder getModelInference() {
            return modelInference != null ? modelInference.toBuilder() : null;
        }

        public final void setModelInference(ModelInferencePaymentConfig.BuilderImpl modelInference) {
            this.modelInference = modelInference != null ? modelInference.build() : null;
        }

        @Override
        public final Builder modelInference(ModelInferencePaymentConfig modelInference) {
            this.modelInference = modelInference;
            return this;
        }

        public final SyntheticDataGenerationPaymentConfig.Builder getSyntheticDataGeneration() {
            return syntheticDataGeneration != null ? syntheticDataGeneration.toBuilder() : null;
        }

        public final void setSyntheticDataGeneration(SyntheticDataGenerationPaymentConfig.BuilderImpl syntheticDataGeneration) {
            this.syntheticDataGeneration = syntheticDataGeneration != null ? syntheticDataGeneration.build() : null;
        }

        @Override
        public final Builder syntheticDataGeneration(SyntheticDataGenerationPaymentConfig syntheticDataGeneration) {
            this.syntheticDataGeneration = syntheticDataGeneration;
            return this;
        }

        @Override
        public MLPaymentConfig build() {
            return new MLPaymentConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
