/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cleanrooms.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListCollaborationPrivacyBudgetsRequest extends CleanRoomsRequest implements
        ToCopyableBuilder<ListCollaborationPrivacyBudgetsRequest.Builder, ListCollaborationPrivacyBudgetsRequest> {
    private static final SdkField<String> COLLABORATION_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("collaborationIdentifier")
            .getter(getter(ListCollaborationPrivacyBudgetsRequest::collaborationIdentifier))
            .setter(setter(Builder::collaborationIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("collaborationIdentifier").build())
            .build();

    private static final SdkField<String> PRIVACY_BUDGET_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("privacyBudgetType").getter(getter(ListCollaborationPrivacyBudgetsRequest::privacyBudgetTypeAsString))
            .setter(setter(Builder::privacyBudgetType))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("privacyBudgetType").build())
            .build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxResults").getter(getter(ListCollaborationPrivacyBudgetsRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListCollaborationPrivacyBudgetsRequest::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()).build();

    private static final SdkField<String> ACCESS_BUDGET_RESOURCE_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("accessBudgetResourceArn")
            .getter(getter(ListCollaborationPrivacyBudgetsRequest::accessBudgetResourceArn))
            .setter(setter(Builder::accessBudgetResourceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("accessBudgetResourceArn")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            COLLABORATION_IDENTIFIER_FIELD, PRIVACY_BUDGET_TYPE_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD,
            ACCESS_BUDGET_RESOURCE_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String collaborationIdentifier;

    private final String privacyBudgetType;

    private final Integer maxResults;

    private final String nextToken;

    private final String accessBudgetResourceArn;

    private ListCollaborationPrivacyBudgetsRequest(BuilderImpl builder) {
        super(builder);
        this.collaborationIdentifier = builder.collaborationIdentifier;
        this.privacyBudgetType = builder.privacyBudgetType;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.accessBudgetResourceArn = builder.accessBudgetResourceArn;
    }

    /**
     * <p>
     * A unique identifier for one of your collaborations.
     * </p>
     * 
     * @return A unique identifier for one of your collaborations.
     */
    public final String collaborationIdentifier() {
        return collaborationIdentifier;
    }

    /**
     * <p>
     * Specifies the type of the privacy budget.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #privacyBudgetType}
     * will return {@link PrivacyBudgetType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #privacyBudgetTypeAsString}.
     * </p>
     * 
     * @return Specifies the type of the privacy budget.
     * @see PrivacyBudgetType
     */
    public final PrivacyBudgetType privacyBudgetType() {
        return PrivacyBudgetType.fromValue(privacyBudgetType);
    }

    /**
     * <p>
     * Specifies the type of the privacy budget.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #privacyBudgetType}
     * will return {@link PrivacyBudgetType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #privacyBudgetTypeAsString}.
     * </p>
     * 
     * @return Specifies the type of the privacy budget.
     * @see PrivacyBudgetType
     */
    public final String privacyBudgetTypeAsString() {
        return privacyBudgetType;
    }

    /**
     * <p>
     * The maximum number of results that are returned for an API request call. The service chooses a default number if
     * you don't set one. The service might return a `nextToken` even if the `maxResults` value has not been met.
     * </p>
     * 
     * @return The maximum number of results that are returned for an API request call. The service chooses a default
     *         number if you don't set one. The service might return a `nextToken` even if the `maxResults` value has
     *         not been met.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * The pagination token that's used to fetch the next set of results.
     * </p>
     * 
     * @return The pagination token that's used to fetch the next set of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Configured Table Association (ConfiguredTableAssociation) used to filter
     * privacy budgets.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the Configured Table Association (ConfiguredTableAssociation) used to
     *         filter privacy budgets.
     */
    public final String accessBudgetResourceArn() {
        return accessBudgetResourceArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(collaborationIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(privacyBudgetTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(accessBudgetResourceArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCollaborationPrivacyBudgetsRequest)) {
            return false;
        }
        ListCollaborationPrivacyBudgetsRequest other = (ListCollaborationPrivacyBudgetsRequest) obj;
        return Objects.equals(collaborationIdentifier(), other.collaborationIdentifier())
                && Objects.equals(privacyBudgetTypeAsString(), other.privacyBudgetTypeAsString())
                && Objects.equals(maxResults(), other.maxResults()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(accessBudgetResourceArn(), other.accessBudgetResourceArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListCollaborationPrivacyBudgetsRequest")
                .add("CollaborationIdentifier", collaborationIdentifier()).add("PrivacyBudgetType", privacyBudgetTypeAsString())
                .add("MaxResults", maxResults()).add("NextToken", nextToken())
                .add("AccessBudgetResourceArn", accessBudgetResourceArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "collaborationIdentifier":
            return Optional.ofNullable(clazz.cast(collaborationIdentifier()));
        case "privacyBudgetType":
            return Optional.ofNullable(clazz.cast(privacyBudgetTypeAsString()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "accessBudgetResourceArn":
            return Optional.ofNullable(clazz.cast(accessBudgetResourceArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("collaborationIdentifier", COLLABORATION_IDENTIFIER_FIELD);
        map.put("privacyBudgetType", PRIVACY_BUDGET_TYPE_FIELD);
        map.put("maxResults", MAX_RESULTS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("accessBudgetResourceArn", ACCESS_BUDGET_RESOURCE_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListCollaborationPrivacyBudgetsRequest, T> g) {
        return obj -> g.apply((ListCollaborationPrivacyBudgetsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends CleanRoomsRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, ListCollaborationPrivacyBudgetsRequest> {
        /**
         * <p>
         * A unique identifier for one of your collaborations.
         * </p>
         * 
         * @param collaborationIdentifier
         *        A unique identifier for one of your collaborations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder collaborationIdentifier(String collaborationIdentifier);

        /**
         * <p>
         * Specifies the type of the privacy budget.
         * </p>
         * 
         * @param privacyBudgetType
         *        Specifies the type of the privacy budget.
         * @see PrivacyBudgetType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PrivacyBudgetType
         */
        Builder privacyBudgetType(String privacyBudgetType);

        /**
         * <p>
         * Specifies the type of the privacy budget.
         * </p>
         * 
         * @param privacyBudgetType
         *        Specifies the type of the privacy budget.
         * @see PrivacyBudgetType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PrivacyBudgetType
         */
        Builder privacyBudgetType(PrivacyBudgetType privacyBudgetType);

        /**
         * <p>
         * The maximum number of results that are returned for an API request call. The service chooses a default number
         * if you don't set one. The service might return a `nextToken` even if the `maxResults` value has not been met.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results that are returned for an API request call. The service chooses a default
         *        number if you don't set one. The service might return a `nextToken` even if the `maxResults` value has
         *        not been met.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * The pagination token that's used to fetch the next set of results.
         * </p>
         * 
         * @param nextToken
         *        The pagination token that's used to fetch the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the Configured Table Association (ConfiguredTableAssociation) used to
         * filter privacy budgets.
         * </p>
         * 
         * @param accessBudgetResourceArn
         *        The Amazon Resource Name (ARN) of the Configured Table Association (ConfiguredTableAssociation) used
         *        to filter privacy budgets.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accessBudgetResourceArn(String accessBudgetResourceArn);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CleanRoomsRequest.BuilderImpl implements Builder {
        private String collaborationIdentifier;

        private String privacyBudgetType;

        private Integer maxResults;

        private String nextToken;

        private String accessBudgetResourceArn;

        private BuilderImpl() {
        }

        private BuilderImpl(ListCollaborationPrivacyBudgetsRequest model) {
            super(model);
            collaborationIdentifier(model.collaborationIdentifier);
            privacyBudgetType(model.privacyBudgetType);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
            accessBudgetResourceArn(model.accessBudgetResourceArn);
        }

        public final String getCollaborationIdentifier() {
            return collaborationIdentifier;
        }

        public final void setCollaborationIdentifier(String collaborationIdentifier) {
            this.collaborationIdentifier = collaborationIdentifier;
        }

        @Override
        public final Builder collaborationIdentifier(String collaborationIdentifier) {
            this.collaborationIdentifier = collaborationIdentifier;
            return this;
        }

        public final String getPrivacyBudgetType() {
            return privacyBudgetType;
        }

        public final void setPrivacyBudgetType(String privacyBudgetType) {
            this.privacyBudgetType = privacyBudgetType;
        }

        @Override
        public final Builder privacyBudgetType(String privacyBudgetType) {
            this.privacyBudgetType = privacyBudgetType;
            return this;
        }

        @Override
        public final Builder privacyBudgetType(PrivacyBudgetType privacyBudgetType) {
            this.privacyBudgetType(privacyBudgetType == null ? null : privacyBudgetType.toString());
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final String getAccessBudgetResourceArn() {
            return accessBudgetResourceArn;
        }

        public final void setAccessBudgetResourceArn(String accessBudgetResourceArn) {
            this.accessBudgetResourceArn = accessBudgetResourceArn;
        }

        @Override
        public final Builder accessBudgetResourceArn(String accessBudgetResourceArn) {
            this.accessBudgetResourceArn = accessBudgetResourceArn;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListCollaborationPrivacyBudgetsRequest build() {
            return new ListCollaborationPrivacyBudgetsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
