/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cleanrooms.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides the information for the ID namespace association input reference configuration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class IdNamespaceAssociationInputReferenceConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<IdNamespaceAssociationInputReferenceConfig.Builder, IdNamespaceAssociationInputReferenceConfig> {
    private static final SdkField<String> INPUT_REFERENCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("inputReferenceArn").getter(getter(IdNamespaceAssociationInputReferenceConfig::inputReferenceArn))
            .setter(setter(Builder::inputReferenceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputReferenceArn").build()).build();

    private static final SdkField<Boolean> MANAGE_RESOURCE_POLICIES_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("manageResourcePolicies")
            .getter(getter(IdNamespaceAssociationInputReferenceConfig::manageResourcePolicies))
            .setter(setter(Builder::manageResourcePolicies))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("manageResourcePolicies").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INPUT_REFERENCE_ARN_FIELD,
            MANAGE_RESOURCE_POLICIES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String inputReferenceArn;

    private final Boolean manageResourcePolicies;

    private IdNamespaceAssociationInputReferenceConfig(BuilderImpl builder) {
        this.inputReferenceArn = builder.inputReferenceArn;
        this.manageResourcePolicies = builder.manageResourcePolicies;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Entity Resolution resource that is being associated to the collaboration.
     * Valid resource ARNs are from the ID namespaces that you own.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the Entity Resolution resource that is being associated to the
     *         collaboration. Valid resource ARNs are from the ID namespaces that you own.
     */
    public final String inputReferenceArn() {
        return inputReferenceArn;
    }

    /**
     * <p>
     * When <code>TRUE</code>, Clean Rooms manages permissions for the ID namespace association resource.
     * </p>
     * <p>
     * When <code>FALSE</code>, the resource owner manages permissions for the ID namespace association resource.
     * </p>
     * 
     * @return When <code>TRUE</code>, Clean Rooms manages permissions for the ID namespace association resource.</p>
     *         <p>
     *         When <code>FALSE</code>, the resource owner manages permissions for the ID namespace association
     *         resource.
     */
    public final Boolean manageResourcePolicies() {
        return manageResourcePolicies;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(inputReferenceArn());
        hashCode = 31 * hashCode + Objects.hashCode(manageResourcePolicies());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IdNamespaceAssociationInputReferenceConfig)) {
            return false;
        }
        IdNamespaceAssociationInputReferenceConfig other = (IdNamespaceAssociationInputReferenceConfig) obj;
        return Objects.equals(inputReferenceArn(), other.inputReferenceArn())
                && Objects.equals(manageResourcePolicies(), other.manageResourcePolicies());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("IdNamespaceAssociationInputReferenceConfig").add("InputReferenceArn", inputReferenceArn())
                .add("ManageResourcePolicies", manageResourcePolicies()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "inputReferenceArn":
            return Optional.ofNullable(clazz.cast(inputReferenceArn()));
        case "manageResourcePolicies":
            return Optional.ofNullable(clazz.cast(manageResourcePolicies()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("inputReferenceArn", INPUT_REFERENCE_ARN_FIELD);
        map.put("manageResourcePolicies", MANAGE_RESOURCE_POLICIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<IdNamespaceAssociationInputReferenceConfig, T> g) {
        return obj -> g.apply((IdNamespaceAssociationInputReferenceConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, IdNamespaceAssociationInputReferenceConfig> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the Entity Resolution resource that is being associated to the
         * collaboration. Valid resource ARNs are from the ID namespaces that you own.
         * </p>
         * 
         * @param inputReferenceArn
         *        The Amazon Resource Name (ARN) of the Entity Resolution resource that is being associated to the
         *        collaboration. Valid resource ARNs are from the ID namespaces that you own.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputReferenceArn(String inputReferenceArn);

        /**
         * <p>
         * When <code>TRUE</code>, Clean Rooms manages permissions for the ID namespace association resource.
         * </p>
         * <p>
         * When <code>FALSE</code>, the resource owner manages permissions for the ID namespace association resource.
         * </p>
         * 
         * @param manageResourcePolicies
         *        When <code>TRUE</code>, Clean Rooms manages permissions for the ID namespace association resource.</p>
         *        <p>
         *        When <code>FALSE</code>, the resource owner manages permissions for the ID namespace association
         *        resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder manageResourcePolicies(Boolean manageResourcePolicies);
    }

    static final class BuilderImpl implements Builder {
        private String inputReferenceArn;

        private Boolean manageResourcePolicies;

        private BuilderImpl() {
        }

        private BuilderImpl(IdNamespaceAssociationInputReferenceConfig model) {
            inputReferenceArn(model.inputReferenceArn);
            manageResourcePolicies(model.manageResourcePolicies);
        }

        public final String getInputReferenceArn() {
            return inputReferenceArn;
        }

        public final void setInputReferenceArn(String inputReferenceArn) {
            this.inputReferenceArn = inputReferenceArn;
        }

        @Override
        public final Builder inputReferenceArn(String inputReferenceArn) {
            this.inputReferenceArn = inputReferenceArn;
            return this;
        }

        public final Boolean getManageResourcePolicies() {
            return manageResourcePolicies;
        }

        public final void setManageResourcePolicies(Boolean manageResourcePolicies) {
            this.manageResourcePolicies = manageResourcePolicies;
        }

        @Override
        public final Builder manageResourcePolicies(Boolean manageResourcePolicies) {
            this.manageResourcePolicies = manageResourcePolicies;
            return this;
        }

        @Override
        public IdNamespaceAssociationInputReferenceConfig build() {
            return new IdNamespaceAssociationInputReferenceConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
