/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cleanrooms.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A reference to a table within an Glue data catalog.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GlueTableReference implements SdkPojo, Serializable,
        ToCopyableBuilder<GlueTableReference.Builder, GlueTableReference> {
    private static final SdkField<String> REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("region")
            .getter(getter(GlueTableReference::regionAsString)).setter(setter(Builder::region))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("region").build()).build();

    private static final SdkField<String> TABLE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("tableName").getter(getter(GlueTableReference::tableName)).setter(setter(Builder::tableName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tableName").build()).build();

    private static final SdkField<String> DATABASE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("databaseName").getter(getter(GlueTableReference::databaseName)).setter(setter(Builder::databaseName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("databaseName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REGION_FIELD,
            TABLE_NAME_FIELD, DATABASE_NAME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String region;

    private final String tableName;

    private final String databaseName;

    private GlueTableReference(BuilderImpl builder) {
        this.region = builder.region;
        this.tableName = builder.tableName;
        this.databaseName = builder.databaseName;
    }

    /**
     * <p>
     * The Amazon Web Services Region where the Glue table is located. This parameter is required to uniquely identify
     * and access tables across different Regions.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #region} will
     * return {@link CommercialRegion#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #regionAsString}.
     * </p>
     * 
     * @return The Amazon Web Services Region where the Glue table is located. This parameter is required to uniquely
     *         identify and access tables across different Regions.
     * @see CommercialRegion
     */
    public final CommercialRegion region() {
        return CommercialRegion.fromValue(region);
    }

    /**
     * <p>
     * The Amazon Web Services Region where the Glue table is located. This parameter is required to uniquely identify
     * and access tables across different Regions.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #region} will
     * return {@link CommercialRegion#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #regionAsString}.
     * </p>
     * 
     * @return The Amazon Web Services Region where the Glue table is located. This parameter is required to uniquely
     *         identify and access tables across different Regions.
     * @see CommercialRegion
     */
    public final String regionAsString() {
        return region;
    }

    /**
     * <p>
     * The name of the Glue table.
     * </p>
     * 
     * @return The name of the Glue table.
     */
    public final String tableName() {
        return tableName;
    }

    /**
     * <p>
     * The name of the database the Glue table belongs to.
     * </p>
     * 
     * @return The name of the database the Glue table belongs to.
     */
    public final String databaseName() {
        return databaseName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(regionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(tableName());
        hashCode = 31 * hashCode + Objects.hashCode(databaseName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GlueTableReference)) {
            return false;
        }
        GlueTableReference other = (GlueTableReference) obj;
        return Objects.equals(regionAsString(), other.regionAsString()) && Objects.equals(tableName(), other.tableName())
                && Objects.equals(databaseName(), other.databaseName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GlueTableReference").add("Region", regionAsString()).add("TableName", tableName())
                .add("DatabaseName", databaseName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "region":
            return Optional.ofNullable(clazz.cast(regionAsString()));
        case "tableName":
            return Optional.ofNullable(clazz.cast(tableName()));
        case "databaseName":
            return Optional.ofNullable(clazz.cast(databaseName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("region", REGION_FIELD);
        map.put("tableName", TABLE_NAME_FIELD);
        map.put("databaseName", DATABASE_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GlueTableReference, T> g) {
        return obj -> g.apply((GlueTableReference) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, GlueTableReference> {
        /**
         * <p>
         * The Amazon Web Services Region where the Glue table is located. This parameter is required to uniquely
         * identify and access tables across different Regions.
         * </p>
         * 
         * @param region
         *        The Amazon Web Services Region where the Glue table is located. This parameter is required to uniquely
         *        identify and access tables across different Regions.
         * @see CommercialRegion
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CommercialRegion
         */
        Builder region(String region);

        /**
         * <p>
         * The Amazon Web Services Region where the Glue table is located. This parameter is required to uniquely
         * identify and access tables across different Regions.
         * </p>
         * 
         * @param region
         *        The Amazon Web Services Region where the Glue table is located. This parameter is required to uniquely
         *        identify and access tables across different Regions.
         * @see CommercialRegion
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CommercialRegion
         */
        Builder region(CommercialRegion region);

        /**
         * <p>
         * The name of the Glue table.
         * </p>
         * 
         * @param tableName
         *        The name of the Glue table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tableName(String tableName);

        /**
         * <p>
         * The name of the database the Glue table belongs to.
         * </p>
         * 
         * @param databaseName
         *        The name of the database the Glue table belongs to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder databaseName(String databaseName);
    }

    static final class BuilderImpl implements Builder {
        private String region;

        private String tableName;

        private String databaseName;

        private BuilderImpl() {
        }

        private BuilderImpl(GlueTableReference model) {
            region(model.region);
            tableName(model.tableName);
            databaseName(model.databaseName);
        }

        public final String getRegion() {
            return region;
        }

        public final void setRegion(String region) {
            this.region = region;
        }

        @Override
        public final Builder region(String region) {
            this.region = region;
            return this;
        }

        @Override
        public final Builder region(CommercialRegion region) {
            this.region(region == null ? null : region.toString());
            return this;
        }

        public final String getTableName() {
            return tableName;
        }

        public final void setTableName(String tableName) {
            this.tableName = tableName;
        }

        @Override
        public final Builder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public final String getDatabaseName() {
            return databaseName;
        }

        public final void setDatabaseName(String databaseName) {
            this.databaseName = databaseName;
        }

        @Override
        public final Builder databaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        @Override
        public GlueTableReference build() {
            return new GlueTableReference(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
