/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cleanrooms.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetCollaborationConfiguredAudienceModelAssociationResponse extends CleanRoomsResponse
        implements
        ToCopyableBuilder<GetCollaborationConfiguredAudienceModelAssociationResponse.Builder, GetCollaborationConfiguredAudienceModelAssociationResponse> {
    private static final SdkField<CollaborationConfiguredAudienceModelAssociation> COLLABORATION_CONFIGURED_AUDIENCE_MODEL_ASSOCIATION_FIELD = SdkField
            .<CollaborationConfiguredAudienceModelAssociation> builder(MarshallingType.SDK_POJO)
            .memberName("collaborationConfiguredAudienceModelAssociation")
            .getter(getter(GetCollaborationConfiguredAudienceModelAssociationResponse::collaborationConfiguredAudienceModelAssociation))
            .setter(setter(Builder::collaborationConfiguredAudienceModelAssociation))
            .constructor(CollaborationConfiguredAudienceModelAssociation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("collaborationConfiguredAudienceModelAssociation").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(COLLABORATION_CONFIGURED_AUDIENCE_MODEL_ASSOCIATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final CollaborationConfiguredAudienceModelAssociation collaborationConfiguredAudienceModelAssociation;

    private GetCollaborationConfiguredAudienceModelAssociationResponse(BuilderImpl builder) {
        super(builder);
        this.collaborationConfiguredAudienceModelAssociation = builder.collaborationConfiguredAudienceModelAssociation;
    }

    /**
     * <p>
     * The metadata of the configured audience model association.
     * </p>
     * 
     * @return The metadata of the configured audience model association.
     */
    public final CollaborationConfiguredAudienceModelAssociation collaborationConfiguredAudienceModelAssociation() {
        return collaborationConfiguredAudienceModelAssociation;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(collaborationConfiguredAudienceModelAssociation());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetCollaborationConfiguredAudienceModelAssociationResponse)) {
            return false;
        }
        GetCollaborationConfiguredAudienceModelAssociationResponse other = (GetCollaborationConfiguredAudienceModelAssociationResponse) obj;
        return Objects.equals(collaborationConfiguredAudienceModelAssociation(),
                other.collaborationConfiguredAudienceModelAssociation());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetCollaborationConfiguredAudienceModelAssociationResponse")
                .add("CollaborationConfiguredAudienceModelAssociation", collaborationConfiguredAudienceModelAssociation())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "collaborationConfiguredAudienceModelAssociation":
            return Optional.ofNullable(clazz.cast(collaborationConfiguredAudienceModelAssociation()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("collaborationConfiguredAudienceModelAssociation", COLLABORATION_CONFIGURED_AUDIENCE_MODEL_ASSOCIATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetCollaborationConfiguredAudienceModelAssociationResponse, T> g) {
        return obj -> g.apply((GetCollaborationConfiguredAudienceModelAssociationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends CleanRoomsResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetCollaborationConfiguredAudienceModelAssociationResponse> {
        /**
         * <p>
         * The metadata of the configured audience model association.
         * </p>
         * 
         * @param collaborationConfiguredAudienceModelAssociation
         *        The metadata of the configured audience model association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder collaborationConfiguredAudienceModelAssociation(
                CollaborationConfiguredAudienceModelAssociation collaborationConfiguredAudienceModelAssociation);

        /**
         * <p>
         * The metadata of the configured audience model association.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link CollaborationConfiguredAudienceModelAssociation.Builder} avoiding the need to create one manually via
         * {@link CollaborationConfiguredAudienceModelAssociation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CollaborationConfiguredAudienceModelAssociation.Builder#build()}
         * is called immediately and its result is passed to
         * {@link #collaborationConfiguredAudienceModelAssociation(CollaborationConfiguredAudienceModelAssociation)}.
         * 
         * @param collaborationConfiguredAudienceModelAssociation
         *        a consumer that will call methods on {@link CollaborationConfiguredAudienceModelAssociation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #collaborationConfiguredAudienceModelAssociation(CollaborationConfiguredAudienceModelAssociation)
         */
        default Builder collaborationConfiguredAudienceModelAssociation(
                Consumer<CollaborationConfiguredAudienceModelAssociation.Builder> collaborationConfiguredAudienceModelAssociation) {
            return collaborationConfiguredAudienceModelAssociation(CollaborationConfiguredAudienceModelAssociation.builder()
                    .applyMutation(collaborationConfiguredAudienceModelAssociation).build());
        }
    }

    static final class BuilderImpl extends CleanRoomsResponse.BuilderImpl implements Builder {
        private CollaborationConfiguredAudienceModelAssociation collaborationConfiguredAudienceModelAssociation;

        private BuilderImpl() {
        }

        private BuilderImpl(GetCollaborationConfiguredAudienceModelAssociationResponse model) {
            super(model);
            collaborationConfiguredAudienceModelAssociation(model.collaborationConfiguredAudienceModelAssociation);
        }

        public final CollaborationConfiguredAudienceModelAssociation.Builder getCollaborationConfiguredAudienceModelAssociation() {
            return collaborationConfiguredAudienceModelAssociation != null ? collaborationConfiguredAudienceModelAssociation
                    .toBuilder() : null;
        }

        public final void setCollaborationConfiguredAudienceModelAssociation(
                CollaborationConfiguredAudienceModelAssociation.BuilderImpl collaborationConfiguredAudienceModelAssociation) {
            this.collaborationConfiguredAudienceModelAssociation = collaborationConfiguredAudienceModelAssociation != null ? collaborationConfiguredAudienceModelAssociation
                    .build() : null;
        }

        @Override
        public final Builder collaborationConfiguredAudienceModelAssociation(
                CollaborationConfiguredAudienceModelAssociation collaborationConfiguredAudienceModelAssociation) {
            this.collaborationConfiguredAudienceModelAssociation = collaborationConfiguredAudienceModelAssociation;
            return this;
        }

        @Override
        public GetCollaborationConfiguredAudienceModelAssociationResponse build() {
            return new GetCollaborationConfiguredAudienceModelAssociationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
