/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cleanrooms.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides the sensitivity parameters.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DifferentialPrivacySensitivityParameters implements SdkPojo, Serializable,
        ToCopyableBuilder<DifferentialPrivacySensitivityParameters.Builder, DifferentialPrivacySensitivityParameters> {
    private static final SdkField<String> AGGREGATION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("aggregationType").getter(getter(DifferentialPrivacySensitivityParameters::aggregationTypeAsString))
            .setter(setter(Builder::aggregationType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("aggregationType").build()).build();

    private static final SdkField<String> AGGREGATION_EXPRESSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("aggregationExpression").getter(getter(DifferentialPrivacySensitivityParameters::aggregationExpression))
            .setter(setter(Builder::aggregationExpression))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("aggregationExpression").build())
            .build();

    private static final SdkField<Integer> USER_CONTRIBUTION_LIMIT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("userContributionLimit").getter(getter(DifferentialPrivacySensitivityParameters::userContributionLimit))
            .setter(setter(Builder::userContributionLimit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userContributionLimit").build())
            .build();

    private static final SdkField<Float> MIN_COLUMN_VALUE_FIELD = SdkField.<Float> builder(MarshallingType.FLOAT)
            .memberName("minColumnValue").getter(getter(DifferentialPrivacySensitivityParameters::minColumnValue))
            .setter(setter(Builder::minColumnValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("minColumnValue").build()).build();

    private static final SdkField<Float> MAX_COLUMN_VALUE_FIELD = SdkField.<Float> builder(MarshallingType.FLOAT)
            .memberName("maxColumnValue").getter(getter(DifferentialPrivacySensitivityParameters::maxColumnValue))
            .setter(setter(Builder::maxColumnValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxColumnValue").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AGGREGATION_TYPE_FIELD,
            AGGREGATION_EXPRESSION_FIELD, USER_CONTRIBUTION_LIMIT_FIELD, MIN_COLUMN_VALUE_FIELD, MAX_COLUMN_VALUE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String aggregationType;

    private final String aggregationExpression;

    private final Integer userContributionLimit;

    private final Float minColumnValue;

    private final Float maxColumnValue;

    private DifferentialPrivacySensitivityParameters(BuilderImpl builder) {
        this.aggregationType = builder.aggregationType;
        this.aggregationExpression = builder.aggregationExpression;
        this.userContributionLimit = builder.userContributionLimit;
        this.minColumnValue = builder.minColumnValue;
        this.maxColumnValue = builder.maxColumnValue;
    }

    /**
     * <p>
     * The type of aggregation function that was run.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #aggregationType}
     * will return {@link DifferentialPrivacyAggregationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #aggregationTypeAsString}.
     * </p>
     * 
     * @return The type of aggregation function that was run.
     * @see DifferentialPrivacyAggregationType
     */
    public final DifferentialPrivacyAggregationType aggregationType() {
        return DifferentialPrivacyAggregationType.fromValue(aggregationType);
    }

    /**
     * <p>
     * The type of aggregation function that was run.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #aggregationType}
     * will return {@link DifferentialPrivacyAggregationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #aggregationTypeAsString}.
     * </p>
     * 
     * @return The type of aggregation function that was run.
     * @see DifferentialPrivacyAggregationType
     */
    public final String aggregationTypeAsString() {
        return aggregationType;
    }

    /**
     * <p>
     * The aggregation expression that was run.
     * </p>
     * 
     * @return The aggregation expression that was run.
     */
    public final String aggregationExpression() {
        return aggregationExpression;
    }

    /**
     * <p>
     * The maximum number of rows contributed by a user in a SQL query.
     * </p>
     * 
     * @return The maximum number of rows contributed by a user in a SQL query.
     */
    public final Integer userContributionLimit() {
        return userContributionLimit;
    }

    /**
     * <p>
     * The lower bound of the aggregation expression.
     * </p>
     * 
     * @return The lower bound of the aggregation expression.
     */
    public final Float minColumnValue() {
        return minColumnValue;
    }

    /**
     * <p>
     * The upper bound of the aggregation expression.
     * </p>
     * 
     * @return The upper bound of the aggregation expression.
     */
    public final Float maxColumnValue() {
        return maxColumnValue;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(aggregationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(aggregationExpression());
        hashCode = 31 * hashCode + Objects.hashCode(userContributionLimit());
        hashCode = 31 * hashCode + Objects.hashCode(minColumnValue());
        hashCode = 31 * hashCode + Objects.hashCode(maxColumnValue());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DifferentialPrivacySensitivityParameters)) {
            return false;
        }
        DifferentialPrivacySensitivityParameters other = (DifferentialPrivacySensitivityParameters) obj;
        return Objects.equals(aggregationTypeAsString(), other.aggregationTypeAsString())
                && Objects.equals(aggregationExpression(), other.aggregationExpression())
                && Objects.equals(userContributionLimit(), other.userContributionLimit())
                && Objects.equals(minColumnValue(), other.minColumnValue())
                && Objects.equals(maxColumnValue(), other.maxColumnValue());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DifferentialPrivacySensitivityParameters").add("AggregationType", aggregationTypeAsString())
                .add("AggregationExpression", aggregationExpression()).add("UserContributionLimit", userContributionLimit())
                .add("MinColumnValue", minColumnValue()).add("MaxColumnValue", maxColumnValue()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "aggregationType":
            return Optional.ofNullable(clazz.cast(aggregationTypeAsString()));
        case "aggregationExpression":
            return Optional.ofNullable(clazz.cast(aggregationExpression()));
        case "userContributionLimit":
            return Optional.ofNullable(clazz.cast(userContributionLimit()));
        case "minColumnValue":
            return Optional.ofNullable(clazz.cast(minColumnValue()));
        case "maxColumnValue":
            return Optional.ofNullable(clazz.cast(maxColumnValue()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("aggregationType", AGGREGATION_TYPE_FIELD);
        map.put("aggregationExpression", AGGREGATION_EXPRESSION_FIELD);
        map.put("userContributionLimit", USER_CONTRIBUTION_LIMIT_FIELD);
        map.put("minColumnValue", MIN_COLUMN_VALUE_FIELD);
        map.put("maxColumnValue", MAX_COLUMN_VALUE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DifferentialPrivacySensitivityParameters, T> g) {
        return obj -> g.apply((DifferentialPrivacySensitivityParameters) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DifferentialPrivacySensitivityParameters> {
        /**
         * <p>
         * The type of aggregation function that was run.
         * </p>
         * 
         * @param aggregationType
         *        The type of aggregation function that was run.
         * @see DifferentialPrivacyAggregationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DifferentialPrivacyAggregationType
         */
        Builder aggregationType(String aggregationType);

        /**
         * <p>
         * The type of aggregation function that was run.
         * </p>
         * 
         * @param aggregationType
         *        The type of aggregation function that was run.
         * @see DifferentialPrivacyAggregationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DifferentialPrivacyAggregationType
         */
        Builder aggregationType(DifferentialPrivacyAggregationType aggregationType);

        /**
         * <p>
         * The aggregation expression that was run.
         * </p>
         * 
         * @param aggregationExpression
         *        The aggregation expression that was run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder aggregationExpression(String aggregationExpression);

        /**
         * <p>
         * The maximum number of rows contributed by a user in a SQL query.
         * </p>
         * 
         * @param userContributionLimit
         *        The maximum number of rows contributed by a user in a SQL query.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userContributionLimit(Integer userContributionLimit);

        /**
         * <p>
         * The lower bound of the aggregation expression.
         * </p>
         * 
         * @param minColumnValue
         *        The lower bound of the aggregation expression.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minColumnValue(Float minColumnValue);

        /**
         * <p>
         * The upper bound of the aggregation expression.
         * </p>
         * 
         * @param maxColumnValue
         *        The upper bound of the aggregation expression.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxColumnValue(Float maxColumnValue);
    }

    static final class BuilderImpl implements Builder {
        private String aggregationType;

        private String aggregationExpression;

        private Integer userContributionLimit;

        private Float minColumnValue;

        private Float maxColumnValue;

        private BuilderImpl() {
        }

        private BuilderImpl(DifferentialPrivacySensitivityParameters model) {
            aggregationType(model.aggregationType);
            aggregationExpression(model.aggregationExpression);
            userContributionLimit(model.userContributionLimit);
            minColumnValue(model.minColumnValue);
            maxColumnValue(model.maxColumnValue);
        }

        public final String getAggregationType() {
            return aggregationType;
        }

        public final void setAggregationType(String aggregationType) {
            this.aggregationType = aggregationType;
        }

        @Override
        public final Builder aggregationType(String aggregationType) {
            this.aggregationType = aggregationType;
            return this;
        }

        @Override
        public final Builder aggregationType(DifferentialPrivacyAggregationType aggregationType) {
            this.aggregationType(aggregationType == null ? null : aggregationType.toString());
            return this;
        }

        public final String getAggregationExpression() {
            return aggregationExpression;
        }

        public final void setAggregationExpression(String aggregationExpression) {
            this.aggregationExpression = aggregationExpression;
        }

        @Override
        public final Builder aggregationExpression(String aggregationExpression) {
            this.aggregationExpression = aggregationExpression;
            return this;
        }

        public final Integer getUserContributionLimit() {
            return userContributionLimit;
        }

        public final void setUserContributionLimit(Integer userContributionLimit) {
            this.userContributionLimit = userContributionLimit;
        }

        @Override
        public final Builder userContributionLimit(Integer userContributionLimit) {
            this.userContributionLimit = userContributionLimit;
            return this;
        }

        public final Float getMinColumnValue() {
            return minColumnValue;
        }

        public final void setMinColumnValue(Float minColumnValue) {
            this.minColumnValue = minColumnValue;
        }

        @Override
        public final Builder minColumnValue(Float minColumnValue) {
            this.minColumnValue = minColumnValue;
            return this;
        }

        public final Float getMaxColumnValue() {
            return maxColumnValue;
        }

        public final void setMaxColumnValue(Float maxColumnValue) {
            this.maxColumnValue = maxColumnValue;
        }

        @Override
        public final Builder maxColumnValue(Float maxColumnValue) {
            this.maxColumnValue = maxColumnValue;
            return this;
        }

        @Override
        public DifferentialPrivacySensitivityParameters build() {
            return new DifferentialPrivacySensitivityParameters(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
