/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cleanrooms.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreatePrivacyBudgetTemplateRequest extends CleanRoomsRequest implements
        ToCopyableBuilder<CreatePrivacyBudgetTemplateRequest.Builder, CreatePrivacyBudgetTemplateRequest> {
    private static final SdkField<String> MEMBERSHIP_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("membershipIdentifier").getter(getter(CreatePrivacyBudgetTemplateRequest::membershipIdentifier))
            .setter(setter(Builder::membershipIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("membershipIdentifier").build()).build();

    private static final SdkField<String> AUTO_REFRESH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("autoRefresh").getter(getter(CreatePrivacyBudgetTemplateRequest::autoRefreshAsString))
            .setter(setter(Builder::autoRefresh))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("autoRefresh").build()).build();

    private static final SdkField<String> PRIVACY_BUDGET_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("privacyBudgetType").getter(getter(CreatePrivacyBudgetTemplateRequest::privacyBudgetTypeAsString))
            .setter(setter(Builder::privacyBudgetType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("privacyBudgetType").build()).build();

    private static final SdkField<PrivacyBudgetTemplateParametersInput> PARAMETERS_FIELD = SdkField
            .<PrivacyBudgetTemplateParametersInput> builder(MarshallingType.SDK_POJO).memberName("parameters")
            .getter(getter(CreatePrivacyBudgetTemplateRequest::parameters)).setter(setter(Builder::parameters))
            .constructor(PrivacyBudgetTemplateParametersInput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parameters").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(CreatePrivacyBudgetTemplateRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MEMBERSHIP_IDENTIFIER_FIELD,
            AUTO_REFRESH_FIELD, PRIVACY_BUDGET_TYPE_FIELD, PARAMETERS_FIELD, TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String membershipIdentifier;

    private final String autoRefresh;

    private final String privacyBudgetType;

    private final PrivacyBudgetTemplateParametersInput parameters;

    private final Map<String, String> tags;

    private CreatePrivacyBudgetTemplateRequest(BuilderImpl builder) {
        super(builder);
        this.membershipIdentifier = builder.membershipIdentifier;
        this.autoRefresh = builder.autoRefresh;
        this.privacyBudgetType = builder.privacyBudgetType;
        this.parameters = builder.parameters;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * A unique identifier for one of your memberships for a collaboration. The privacy budget template is created in
     * the collaboration that this membership belongs to. Accepts a membership ID.
     * </p>
     * 
     * @return A unique identifier for one of your memberships for a collaboration. The privacy budget template is
     *         created in the collaboration that this membership belongs to. Accepts a membership ID.
     */
    public final String membershipIdentifier() {
        return membershipIdentifier;
    }

    /**
     * <p>
     * How often the privacy budget refreshes.
     * </p>
     * <important>
     * <p>
     * If you plan to regularly bring new data into the collaboration, you can use <code>CALENDAR_MONTH</code> to
     * automatically get a new privacy budget for the collaboration every calendar month. Choosing this option allows
     * arbitrary amounts of information to be revealed about rows of the data when repeatedly queries across refreshes.
     * Avoid choosing this if the same rows will be repeatedly queried between privacy budget refreshes.
     * </p>
     * </important>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #autoRefresh} will
     * return {@link PrivacyBudgetTemplateAutoRefresh#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #autoRefreshAsString}.
     * </p>
     * 
     * @return How often the privacy budget refreshes.</p> <important>
     *         <p>
     *         If you plan to regularly bring new data into the collaboration, you can use <code>CALENDAR_MONTH</code>
     *         to automatically get a new privacy budget for the collaboration every calendar month. Choosing this
     *         option allows arbitrary amounts of information to be revealed about rows of the data when repeatedly
     *         queries across refreshes. Avoid choosing this if the same rows will be repeatedly queried between privacy
     *         budget refreshes.
     *         </p>
     * @see PrivacyBudgetTemplateAutoRefresh
     */
    public final PrivacyBudgetTemplateAutoRefresh autoRefresh() {
        return PrivacyBudgetTemplateAutoRefresh.fromValue(autoRefresh);
    }

    /**
     * <p>
     * How often the privacy budget refreshes.
     * </p>
     * <important>
     * <p>
     * If you plan to regularly bring new data into the collaboration, you can use <code>CALENDAR_MONTH</code> to
     * automatically get a new privacy budget for the collaboration every calendar month. Choosing this option allows
     * arbitrary amounts of information to be revealed about rows of the data when repeatedly queries across refreshes.
     * Avoid choosing this if the same rows will be repeatedly queried between privacy budget refreshes.
     * </p>
     * </important>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #autoRefresh} will
     * return {@link PrivacyBudgetTemplateAutoRefresh#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #autoRefreshAsString}.
     * </p>
     * 
     * @return How often the privacy budget refreshes.</p> <important>
     *         <p>
     *         If you plan to regularly bring new data into the collaboration, you can use <code>CALENDAR_MONTH</code>
     *         to automatically get a new privacy budget for the collaboration every calendar month. Choosing this
     *         option allows arbitrary amounts of information to be revealed about rows of the data when repeatedly
     *         queries across refreshes. Avoid choosing this if the same rows will be repeatedly queried between privacy
     *         budget refreshes.
     *         </p>
     * @see PrivacyBudgetTemplateAutoRefresh
     */
    public final String autoRefreshAsString() {
        return autoRefresh;
    }

    /**
     * <p>
     * Specifies the type of the privacy budget template.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #privacyBudgetType}
     * will return {@link PrivacyBudgetType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #privacyBudgetTypeAsString}.
     * </p>
     * 
     * @return Specifies the type of the privacy budget template.
     * @see PrivacyBudgetType
     */
    public final PrivacyBudgetType privacyBudgetType() {
        return PrivacyBudgetType.fromValue(privacyBudgetType);
    }

    /**
     * <p>
     * Specifies the type of the privacy budget template.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #privacyBudgetType}
     * will return {@link PrivacyBudgetType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #privacyBudgetTypeAsString}.
     * </p>
     * 
     * @return Specifies the type of the privacy budget template.
     * @see PrivacyBudgetType
     */
    public final String privacyBudgetTypeAsString() {
        return privacyBudgetType;
    }

    /**
     * <p>
     * Specifies your parameters for the privacy budget template.
     * </p>
     * 
     * @return Specifies your parameters for the privacy budget template.
     */
    public final PrivacyBudgetTemplateParametersInput parameters() {
        return parameters;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * An optional label that you can assign to a resource when you create it. Each tag consists of a key and an
     * optional value, both of which you define. When you use tagging, you can also use tag-based access control in IAM
     * policies to control access to this resource.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return An optional label that you can assign to a resource when you create it. Each tag consists of a key and an
     *         optional value, both of which you define. When you use tagging, you can also use tag-based access control
     *         in IAM policies to control access to this resource.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(membershipIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(autoRefreshAsString());
        hashCode = 31 * hashCode + Objects.hashCode(privacyBudgetTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(parameters());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreatePrivacyBudgetTemplateRequest)) {
            return false;
        }
        CreatePrivacyBudgetTemplateRequest other = (CreatePrivacyBudgetTemplateRequest) obj;
        return Objects.equals(membershipIdentifier(), other.membershipIdentifier())
                && Objects.equals(autoRefreshAsString(), other.autoRefreshAsString())
                && Objects.equals(privacyBudgetTypeAsString(), other.privacyBudgetTypeAsString())
                && Objects.equals(parameters(), other.parameters()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreatePrivacyBudgetTemplateRequest").add("MembershipIdentifier", membershipIdentifier())
                .add("AutoRefresh", autoRefreshAsString()).add("PrivacyBudgetType", privacyBudgetTypeAsString())
                .add("Parameters", parameters()).add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "membershipIdentifier":
            return Optional.ofNullable(clazz.cast(membershipIdentifier()));
        case "autoRefresh":
            return Optional.ofNullable(clazz.cast(autoRefreshAsString()));
        case "privacyBudgetType":
            return Optional.ofNullable(clazz.cast(privacyBudgetTypeAsString()));
        case "parameters":
            return Optional.ofNullable(clazz.cast(parameters()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("membershipIdentifier", MEMBERSHIP_IDENTIFIER_FIELD);
        map.put("autoRefresh", AUTO_REFRESH_FIELD);
        map.put("privacyBudgetType", PRIVACY_BUDGET_TYPE_FIELD);
        map.put("parameters", PARAMETERS_FIELD);
        map.put("tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreatePrivacyBudgetTemplateRequest, T> g) {
        return obj -> g.apply((CreatePrivacyBudgetTemplateRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends CleanRoomsRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CreatePrivacyBudgetTemplateRequest> {
        /**
         * <p>
         * A unique identifier for one of your memberships for a collaboration. The privacy budget template is created
         * in the collaboration that this membership belongs to. Accepts a membership ID.
         * </p>
         * 
         * @param membershipIdentifier
         *        A unique identifier for one of your memberships for a collaboration. The privacy budget template is
         *        created in the collaboration that this membership belongs to. Accepts a membership ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder membershipIdentifier(String membershipIdentifier);

        /**
         * <p>
         * How often the privacy budget refreshes.
         * </p>
         * <important>
         * <p>
         * If you plan to regularly bring new data into the collaboration, you can use <code>CALENDAR_MONTH</code> to
         * automatically get a new privacy budget for the collaboration every calendar month. Choosing this option
         * allows arbitrary amounts of information to be revealed about rows of the data when repeatedly queries across
         * refreshes. Avoid choosing this if the same rows will be repeatedly queried between privacy budget refreshes.
         * </p>
         * </important>
         * 
         * @param autoRefresh
         *        How often the privacy budget refreshes.</p> <important>
         *        <p>
         *        If you plan to regularly bring new data into the collaboration, you can use
         *        <code>CALENDAR_MONTH</code> to automatically get a new privacy budget for the collaboration every
         *        calendar month. Choosing this option allows arbitrary amounts of information to be revealed about rows
         *        of the data when repeatedly queries across refreshes. Avoid choosing this if the same rows will be
         *        repeatedly queried between privacy budget refreshes.
         *        </p>
         * @see PrivacyBudgetTemplateAutoRefresh
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PrivacyBudgetTemplateAutoRefresh
         */
        Builder autoRefresh(String autoRefresh);

        /**
         * <p>
         * How often the privacy budget refreshes.
         * </p>
         * <important>
         * <p>
         * If you plan to regularly bring new data into the collaboration, you can use <code>CALENDAR_MONTH</code> to
         * automatically get a new privacy budget for the collaboration every calendar month. Choosing this option
         * allows arbitrary amounts of information to be revealed about rows of the data when repeatedly queries across
         * refreshes. Avoid choosing this if the same rows will be repeatedly queried between privacy budget refreshes.
         * </p>
         * </important>
         * 
         * @param autoRefresh
         *        How often the privacy budget refreshes.</p> <important>
         *        <p>
         *        If you plan to regularly bring new data into the collaboration, you can use
         *        <code>CALENDAR_MONTH</code> to automatically get a new privacy budget for the collaboration every
         *        calendar month. Choosing this option allows arbitrary amounts of information to be revealed about rows
         *        of the data when repeatedly queries across refreshes. Avoid choosing this if the same rows will be
         *        repeatedly queried between privacy budget refreshes.
         *        </p>
         * @see PrivacyBudgetTemplateAutoRefresh
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PrivacyBudgetTemplateAutoRefresh
         */
        Builder autoRefresh(PrivacyBudgetTemplateAutoRefresh autoRefresh);

        /**
         * <p>
         * Specifies the type of the privacy budget template.
         * </p>
         * 
         * @param privacyBudgetType
         *        Specifies the type of the privacy budget template.
         * @see PrivacyBudgetType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PrivacyBudgetType
         */
        Builder privacyBudgetType(String privacyBudgetType);

        /**
         * <p>
         * Specifies the type of the privacy budget template.
         * </p>
         * 
         * @param privacyBudgetType
         *        Specifies the type of the privacy budget template.
         * @see PrivacyBudgetType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PrivacyBudgetType
         */
        Builder privacyBudgetType(PrivacyBudgetType privacyBudgetType);

        /**
         * <p>
         * Specifies your parameters for the privacy budget template.
         * </p>
         * 
         * @param parameters
         *        Specifies your parameters for the privacy budget template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameters(PrivacyBudgetTemplateParametersInput parameters);

        /**
         * <p>
         * Specifies your parameters for the privacy budget template.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link PrivacyBudgetTemplateParametersInput.Builder} avoiding the need to create one manually via
         * {@link PrivacyBudgetTemplateParametersInput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PrivacyBudgetTemplateParametersInput.Builder#build()} is called
         * immediately and its result is passed to {@link #parameters(PrivacyBudgetTemplateParametersInput)}.
         * 
         * @param parameters
         *        a consumer that will call methods on {@link PrivacyBudgetTemplateParametersInput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #parameters(PrivacyBudgetTemplateParametersInput)
         */
        default Builder parameters(Consumer<PrivacyBudgetTemplateParametersInput.Builder> parameters) {
            return parameters(PrivacyBudgetTemplateParametersInput.builder().applyMutation(parameters).build());
        }

        /**
         * <p>
         * An optional label that you can assign to a resource when you create it. Each tag consists of a key and an
         * optional value, both of which you define. When you use tagging, you can also use tag-based access control in
         * IAM policies to control access to this resource.
         * </p>
         * 
         * @param tags
         *        An optional label that you can assign to a resource when you create it. Each tag consists of a key and
         *        an optional value, both of which you define. When you use tagging, you can also use tag-based access
         *        control in IAM policies to control access to this resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CleanRoomsRequest.BuilderImpl implements Builder {
        private String membershipIdentifier;

        private String autoRefresh;

        private String privacyBudgetType;

        private PrivacyBudgetTemplateParametersInput parameters;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreatePrivacyBudgetTemplateRequest model) {
            super(model);
            membershipIdentifier(model.membershipIdentifier);
            autoRefresh(model.autoRefresh);
            privacyBudgetType(model.privacyBudgetType);
            parameters(model.parameters);
            tags(model.tags);
        }

        public final String getMembershipIdentifier() {
            return membershipIdentifier;
        }

        public final void setMembershipIdentifier(String membershipIdentifier) {
            this.membershipIdentifier = membershipIdentifier;
        }

        @Override
        public final Builder membershipIdentifier(String membershipIdentifier) {
            this.membershipIdentifier = membershipIdentifier;
            return this;
        }

        public final String getAutoRefresh() {
            return autoRefresh;
        }

        public final void setAutoRefresh(String autoRefresh) {
            this.autoRefresh = autoRefresh;
        }

        @Override
        public final Builder autoRefresh(String autoRefresh) {
            this.autoRefresh = autoRefresh;
            return this;
        }

        @Override
        public final Builder autoRefresh(PrivacyBudgetTemplateAutoRefresh autoRefresh) {
            this.autoRefresh(autoRefresh == null ? null : autoRefresh.toString());
            return this;
        }

        public final String getPrivacyBudgetType() {
            return privacyBudgetType;
        }

        public final void setPrivacyBudgetType(String privacyBudgetType) {
            this.privacyBudgetType = privacyBudgetType;
        }

        @Override
        public final Builder privacyBudgetType(String privacyBudgetType) {
            this.privacyBudgetType = privacyBudgetType;
            return this;
        }

        @Override
        public final Builder privacyBudgetType(PrivacyBudgetType privacyBudgetType) {
            this.privacyBudgetType(privacyBudgetType == null ? null : privacyBudgetType.toString());
            return this;
        }

        public final PrivacyBudgetTemplateParametersInput.Builder getParameters() {
            return parameters != null ? parameters.toBuilder() : null;
        }

        public final void setParameters(PrivacyBudgetTemplateParametersInput.BuilderImpl parameters) {
            this.parameters = parameters != null ? parameters.build() : null;
        }

        @Override
        public final Builder parameters(PrivacyBudgetTemplateParametersInput parameters) {
            this.parameters = parameters;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreatePrivacyBudgetTemplateRequest build() {
            return new CreatePrivacyBudgetTemplateRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
