/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cleanrooms.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Controls on the analysis specifications that can be run on a configured table.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ConsolidatedPolicyV1 implements SdkPojo, Serializable,
        ToCopyableBuilder<ConsolidatedPolicyV1.Builder, ConsolidatedPolicyV1> {
    private static final SdkField<ConsolidatedPolicyList> LIST_FIELD = SdkField
            .<ConsolidatedPolicyList> builder(MarshallingType.SDK_POJO).memberName("list")
            .getter(getter(ConsolidatedPolicyV1::list)).setter(setter(Builder::list))
            .constructor(ConsolidatedPolicyList::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("list").build()).build();

    private static final SdkField<ConsolidatedPolicyAggregation> AGGREGATION_FIELD = SdkField
            .<ConsolidatedPolicyAggregation> builder(MarshallingType.SDK_POJO).memberName("aggregation")
            .getter(getter(ConsolidatedPolicyV1::aggregation)).setter(setter(Builder::aggregation))
            .constructor(ConsolidatedPolicyAggregation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("aggregation").build()).build();

    private static final SdkField<ConsolidatedPolicyCustom> CUSTOM_FIELD = SdkField
            .<ConsolidatedPolicyCustom> builder(MarshallingType.SDK_POJO).memberName("custom")
            .getter(getter(ConsolidatedPolicyV1::custom)).setter(setter(Builder::custom))
            .constructor(ConsolidatedPolicyCustom::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("custom").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LIST_FIELD, AGGREGATION_FIELD,
            CUSTOM_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final ConsolidatedPolicyList list;

    private final ConsolidatedPolicyAggregation aggregation;

    private final ConsolidatedPolicyCustom custom;

    private final Type type;

    private ConsolidatedPolicyV1(BuilderImpl builder) {
        this.list = builder.list;
        this.aggregation = builder.aggregation;
        this.custom = builder.custom;
        this.type = builder.type;
    }

    /**
     * <p>
     * The list of consolidated policies.
     * </p>
     * 
     * @return The list of consolidated policies.
     */
    public final ConsolidatedPolicyList list() {
        return list;
    }

    /**
     * <p>
     * The aggregation setting for the consolidated policy.
     * </p>
     * 
     * @return The aggregation setting for the consolidated policy.
     */
    public final ConsolidatedPolicyAggregation aggregation() {
        return aggregation;
    }

    /**
     * <p>
     * Custom policy
     * </p>
     * 
     * @return Custom policy
     */
    public final ConsolidatedPolicyCustom custom() {
        return custom;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(list());
        hashCode = 31 * hashCode + Objects.hashCode(aggregation());
        hashCode = 31 * hashCode + Objects.hashCode(custom());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConsolidatedPolicyV1)) {
            return false;
        }
        ConsolidatedPolicyV1 other = (ConsolidatedPolicyV1) obj;
        return Objects.equals(list(), other.list()) && Objects.equals(aggregation(), other.aggregation())
                && Objects.equals(custom(), other.custom());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ConsolidatedPolicyV1").add("List", list()).add("Aggregation", aggregation())
                .add("Custom", custom()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "list":
            return Optional.ofNullable(clazz.cast(list()));
        case "aggregation":
            return Optional.ofNullable(clazz.cast(aggregation()));
        case "custom":
            return Optional.ofNullable(clazz.cast(custom()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #list()} initialized to the given value.
     *
     * <p>
     * The list of consolidated policies.
     * </p>
     * 
     * @param list
     *        The list of consolidated policies.
     */
    public static ConsolidatedPolicyV1 fromList(ConsolidatedPolicyList list) {
        return builder().list(list).build();
    }

    /**
     * Create an instance of this class with {@link #list()} initialized to the given value.
     *
     * <p>
     * The list of consolidated policies.
     * </p>
     * 
     * @param list
     *        The list of consolidated policies.
     */
    public static ConsolidatedPolicyV1 fromList(Consumer<ConsolidatedPolicyList.Builder> list) {
        ConsolidatedPolicyList.Builder builder = ConsolidatedPolicyList.builder();
        list.accept(builder);
        return fromList(builder.build());
    }

    /**
     * Create an instance of this class with {@link #aggregation()} initialized to the given value.
     *
     * <p>
     * The aggregation setting for the consolidated policy.
     * </p>
     * 
     * @param aggregation
     *        The aggregation setting for the consolidated policy.
     */
    public static ConsolidatedPolicyV1 fromAggregation(ConsolidatedPolicyAggregation aggregation) {
        return builder().aggregation(aggregation).build();
    }

    /**
     * Create an instance of this class with {@link #aggregation()} initialized to the given value.
     *
     * <p>
     * The aggregation setting for the consolidated policy.
     * </p>
     * 
     * @param aggregation
     *        The aggregation setting for the consolidated policy.
     */
    public static ConsolidatedPolicyV1 fromAggregation(Consumer<ConsolidatedPolicyAggregation.Builder> aggregation) {
        ConsolidatedPolicyAggregation.Builder builder = ConsolidatedPolicyAggregation.builder();
        aggregation.accept(builder);
        return fromAggregation(builder.build());
    }

    /**
     * Create an instance of this class with {@link #custom()} initialized to the given value.
     *
     * <p>
     * Custom policy
     * </p>
     * 
     * @param custom
     *        Custom policy
     */
    public static ConsolidatedPolicyV1 fromCustom(ConsolidatedPolicyCustom custom) {
        return builder().custom(custom).build();
    }

    /**
     * Create an instance of this class with {@link #custom()} initialized to the given value.
     *
     * <p>
     * Custom policy
     * </p>
     * 
     * @param custom
     *        Custom policy
     */
    public static ConsolidatedPolicyV1 fromCustom(Consumer<ConsolidatedPolicyCustom.Builder> custom) {
        ConsolidatedPolicyCustom.Builder builder = ConsolidatedPolicyCustom.builder();
        custom.accept(builder);
        return fromCustom(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("list", LIST_FIELD);
        map.put("aggregation", AGGREGATION_FIELD);
        map.put("custom", CUSTOM_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ConsolidatedPolicyV1, T> g) {
        return obj -> g.apply((ConsolidatedPolicyV1) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ConsolidatedPolicyV1> {
        /**
         * <p>
         * The list of consolidated policies.
         * </p>
         * 
         * @param list
         *        The list of consolidated policies.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder list(ConsolidatedPolicyList list);

        /**
         * <p>
         * The list of consolidated policies.
         * </p>
         * This is a convenience method that creates an instance of the {@link ConsolidatedPolicyList.Builder} avoiding
         * the need to create one manually via {@link ConsolidatedPolicyList#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ConsolidatedPolicyList.Builder#build()} is called immediately and
         * its result is passed to {@link #list(ConsolidatedPolicyList)}.
         * 
         * @param list
         *        a consumer that will call methods on {@link ConsolidatedPolicyList.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #list(ConsolidatedPolicyList)
         */
        default Builder list(Consumer<ConsolidatedPolicyList.Builder> list) {
            return list(ConsolidatedPolicyList.builder().applyMutation(list).build());
        }

        /**
         * <p>
         * The aggregation setting for the consolidated policy.
         * </p>
         * 
         * @param aggregation
         *        The aggregation setting for the consolidated policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder aggregation(ConsolidatedPolicyAggregation aggregation);

        /**
         * <p>
         * The aggregation setting for the consolidated policy.
         * </p>
         * This is a convenience method that creates an instance of the {@link ConsolidatedPolicyAggregation.Builder}
         * avoiding the need to create one manually via {@link ConsolidatedPolicyAggregation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ConsolidatedPolicyAggregation.Builder#build()} is called
         * immediately and its result is passed to {@link #aggregation(ConsolidatedPolicyAggregation)}.
         * 
         * @param aggregation
         *        a consumer that will call methods on {@link ConsolidatedPolicyAggregation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #aggregation(ConsolidatedPolicyAggregation)
         */
        default Builder aggregation(Consumer<ConsolidatedPolicyAggregation.Builder> aggregation) {
            return aggregation(ConsolidatedPolicyAggregation.builder().applyMutation(aggregation).build());
        }

        /**
         * <p>
         * Custom policy
         * </p>
         * 
         * @param custom
         *        Custom policy
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder custom(ConsolidatedPolicyCustom custom);

        /**
         * <p>
         * Custom policy
         * </p>
         * This is a convenience method that creates an instance of the {@link ConsolidatedPolicyCustom.Builder}
         * avoiding the need to create one manually via {@link ConsolidatedPolicyCustom#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ConsolidatedPolicyCustom.Builder#build()} is called immediately
         * and its result is passed to {@link #custom(ConsolidatedPolicyCustom)}.
         * 
         * @param custom
         *        a consumer that will call methods on {@link ConsolidatedPolicyCustom.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #custom(ConsolidatedPolicyCustom)
         */
        default Builder custom(Consumer<ConsolidatedPolicyCustom.Builder> custom) {
            return custom(ConsolidatedPolicyCustom.builder().applyMutation(custom).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private ConsolidatedPolicyList list;

        private ConsolidatedPolicyAggregation aggregation;

        private ConsolidatedPolicyCustom custom;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(ConsolidatedPolicyV1 model) {
            list(model.list);
            aggregation(model.aggregation);
            custom(model.custom);
        }

        public final ConsolidatedPolicyList.Builder getList() {
            return list != null ? list.toBuilder() : null;
        }

        public final void setList(ConsolidatedPolicyList.BuilderImpl list) {
            Object oldValue = this.list;
            this.list = list != null ? list.build() : null;
            handleUnionValueChange(Type.LIST, oldValue, this.list);
        }

        @Override
        public final Builder list(ConsolidatedPolicyList list) {
            Object oldValue = this.list;
            this.list = list;
            handleUnionValueChange(Type.LIST, oldValue, this.list);
            return this;
        }

        public final ConsolidatedPolicyAggregation.Builder getAggregation() {
            return aggregation != null ? aggregation.toBuilder() : null;
        }

        public final void setAggregation(ConsolidatedPolicyAggregation.BuilderImpl aggregation) {
            Object oldValue = this.aggregation;
            this.aggregation = aggregation != null ? aggregation.build() : null;
            handleUnionValueChange(Type.AGGREGATION, oldValue, this.aggregation);
        }

        @Override
        public final Builder aggregation(ConsolidatedPolicyAggregation aggregation) {
            Object oldValue = this.aggregation;
            this.aggregation = aggregation;
            handleUnionValueChange(Type.AGGREGATION, oldValue, this.aggregation);
            return this;
        }

        public final ConsolidatedPolicyCustom.Builder getCustom() {
            return custom != null ? custom.toBuilder() : null;
        }

        public final void setCustom(ConsolidatedPolicyCustom.BuilderImpl custom) {
            Object oldValue = this.custom;
            this.custom = custom != null ? custom.build() : null;
            handleUnionValueChange(Type.CUSTOM, oldValue, this.custom);
        }

        @Override
        public final Builder custom(ConsolidatedPolicyCustom custom) {
            Object oldValue = this.custom;
            this.custom = custom;
            handleUnionValueChange(Type.CUSTOM, oldValue, this.custom);
            return this;
        }

        @Override
        public ConsolidatedPolicyV1 build() {
            return new ConsolidatedPolicyV1(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see ConsolidatedPolicyV1#type()
     */
    public enum Type {
        LIST,

        AGGREGATION,

        CUSTOM,

        UNKNOWN_TO_SDK_VERSION
    }
}
