/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cleanrooms.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Controls on the analysis specifications that can be run on a configured table.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ConsolidatedPolicyCustom implements SdkPojo, Serializable,
        ToCopyableBuilder<ConsolidatedPolicyCustom.Builder, ConsolidatedPolicyCustom> {
    private static final SdkField<List<String>> ALLOWED_ANALYSES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("allowedAnalyses")
            .getter(getter(ConsolidatedPolicyCustom::allowedAnalyses))
            .setter(setter(Builder::allowedAnalyses))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("allowedAnalyses").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> ALLOWED_ANALYSIS_PROVIDERS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("allowedAnalysisProviders")
            .getter(getter(ConsolidatedPolicyCustom::allowedAnalysisProviders))
            .setter(setter(Builder::allowedAnalysisProviders))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("allowedAnalysisProviders").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> ADDITIONAL_ANALYSES_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("additionalAnalyses").getter(getter(ConsolidatedPolicyCustom::additionalAnalysesAsString))
            .setter(setter(Builder::additionalAnalyses))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("additionalAnalyses").build())
            .build();

    private static final SdkField<List<String>> DISALLOWED_OUTPUT_COLUMNS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("disallowedOutputColumns")
            .getter(getter(ConsolidatedPolicyCustom::disallowedOutputColumns))
            .setter(setter(Builder::disallowedOutputColumns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("disallowedOutputColumns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<DifferentialPrivacyConfiguration> DIFFERENTIAL_PRIVACY_FIELD = SdkField
            .<DifferentialPrivacyConfiguration> builder(MarshallingType.SDK_POJO).memberName("differentialPrivacy")
            .getter(getter(ConsolidatedPolicyCustom::differentialPrivacy)).setter(setter(Builder::differentialPrivacy))
            .constructor(DifferentialPrivacyConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("differentialPrivacy").build())
            .build();

    private static final SdkField<List<String>> ALLOWED_RESULT_RECEIVERS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("allowedResultReceivers")
            .getter(getter(ConsolidatedPolicyCustom::allowedResultReceivers))
            .setter(setter(Builder::allowedResultReceivers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("allowedResultReceivers").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> ALLOWED_ADDITIONAL_ANALYSES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("allowedAdditionalAnalyses")
            .getter(getter(ConsolidatedPolicyCustom::allowedAdditionalAnalyses))
            .setter(setter(Builder::allowedAdditionalAnalyses))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("allowedAdditionalAnalyses").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALLOWED_ANALYSES_FIELD,
            ALLOWED_ANALYSIS_PROVIDERS_FIELD, ADDITIONAL_ANALYSES_FIELD, DISALLOWED_OUTPUT_COLUMNS_FIELD,
            DIFFERENTIAL_PRIVACY_FIELD, ALLOWED_RESULT_RECEIVERS_FIELD, ALLOWED_ADDITIONAL_ANALYSES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<String> allowedAnalyses;

    private final List<String> allowedAnalysisProviders;

    private final String additionalAnalyses;

    private final List<String> disallowedOutputColumns;

    private final DifferentialPrivacyConfiguration differentialPrivacy;

    private final List<String> allowedResultReceivers;

    private final List<String> allowedAdditionalAnalyses;

    private ConsolidatedPolicyCustom(BuilderImpl builder) {
        this.allowedAnalyses = builder.allowedAnalyses;
        this.allowedAnalysisProviders = builder.allowedAnalysisProviders;
        this.additionalAnalyses = builder.additionalAnalyses;
        this.disallowedOutputColumns = builder.disallowedOutputColumns;
        this.differentialPrivacy = builder.differentialPrivacy;
        this.allowedResultReceivers = builder.allowedResultReceivers;
        this.allowedAdditionalAnalyses = builder.allowedAdditionalAnalyses;
    }

    /**
     * For responses, this returns true if the service returned a value for the AllowedAnalyses property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAllowedAnalyses() {
        return allowedAnalyses != null && !(allowedAnalyses instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The allowed analyses.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAllowedAnalyses} method.
     * </p>
     * 
     * @return The allowed analyses.
     */
    public final List<String> allowedAnalyses() {
        return allowedAnalyses;
    }

    /**
     * For responses, this returns true if the service returned a value for the AllowedAnalysisProviders property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasAllowedAnalysisProviders() {
        return allowedAnalysisProviders != null && !(allowedAnalysisProviders instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The allowed analysis providers.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAllowedAnalysisProviders} method.
     * </p>
     * 
     * @return The allowed analysis providers.
     */
    public final List<String> allowedAnalysisProviders() {
        return allowedAnalysisProviders;
    }

    /**
     * <p>
     * Additional analyses for the consolidated policy.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #additionalAnalyses} will return {@link AdditionalAnalyses#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #additionalAnalysesAsString}.
     * </p>
     * 
     * @return Additional analyses for the consolidated policy.
     * @see AdditionalAnalyses
     */
    public final AdditionalAnalyses additionalAnalyses() {
        return AdditionalAnalyses.fromValue(additionalAnalyses);
    }

    /**
     * <p>
     * Additional analyses for the consolidated policy.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #additionalAnalyses} will return {@link AdditionalAnalyses#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #additionalAnalysesAsString}.
     * </p>
     * 
     * @return Additional analyses for the consolidated policy.
     * @see AdditionalAnalyses
     */
    public final String additionalAnalysesAsString() {
        return additionalAnalyses;
    }

    /**
     * For responses, this returns true if the service returned a value for the DisallowedOutputColumns property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasDisallowedOutputColumns() {
        return disallowedOutputColumns != null && !(disallowedOutputColumns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Disallowed output columns
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDisallowedOutputColumns} method.
     * </p>
     * 
     * @return Disallowed output columns
     */
    public final List<String> disallowedOutputColumns() {
        return disallowedOutputColumns;
    }

    /**
     * Returns the value of the DifferentialPrivacy property for this object.
     * 
     * @return The value of the DifferentialPrivacy property for this object.
     */
    public final DifferentialPrivacyConfiguration differentialPrivacy() {
        return differentialPrivacy;
    }

    /**
     * For responses, this returns true if the service returned a value for the AllowedResultReceivers property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasAllowedResultReceivers() {
        return allowedResultReceivers != null && !(allowedResultReceivers instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The allowed result receivers.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAllowedResultReceivers} method.
     * </p>
     * 
     * @return The allowed result receivers.
     */
    public final List<String> allowedResultReceivers() {
        return allowedResultReceivers;
    }

    /**
     * For responses, this returns true if the service returned a value for the AllowedAdditionalAnalyses property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasAllowedAdditionalAnalyses() {
        return allowedAdditionalAnalyses != null && !(allowedAdditionalAnalyses instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The additional analyses allowed by the consolidated policy.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAllowedAdditionalAnalyses} method.
     * </p>
     * 
     * @return The additional analyses allowed by the consolidated policy.
     */
    public final List<String> allowedAdditionalAnalyses() {
        return allowedAdditionalAnalyses;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasAllowedAnalyses() ? allowedAnalyses() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasAllowedAnalysisProviders() ? allowedAnalysisProviders() : null);
        hashCode = 31 * hashCode + Objects.hashCode(additionalAnalysesAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasDisallowedOutputColumns() ? disallowedOutputColumns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(differentialPrivacy());
        hashCode = 31 * hashCode + Objects.hashCode(hasAllowedResultReceivers() ? allowedResultReceivers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasAllowedAdditionalAnalyses() ? allowedAdditionalAnalyses() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConsolidatedPolicyCustom)) {
            return false;
        }
        ConsolidatedPolicyCustom other = (ConsolidatedPolicyCustom) obj;
        return hasAllowedAnalyses() == other.hasAllowedAnalyses() && Objects.equals(allowedAnalyses(), other.allowedAnalyses())
                && hasAllowedAnalysisProviders() == other.hasAllowedAnalysisProviders()
                && Objects.equals(allowedAnalysisProviders(), other.allowedAnalysisProviders())
                && Objects.equals(additionalAnalysesAsString(), other.additionalAnalysesAsString())
                && hasDisallowedOutputColumns() == other.hasDisallowedOutputColumns()
                && Objects.equals(disallowedOutputColumns(), other.disallowedOutputColumns())
                && Objects.equals(differentialPrivacy(), other.differentialPrivacy())
                && hasAllowedResultReceivers() == other.hasAllowedResultReceivers()
                && Objects.equals(allowedResultReceivers(), other.allowedResultReceivers())
                && hasAllowedAdditionalAnalyses() == other.hasAllowedAdditionalAnalyses()
                && Objects.equals(allowedAdditionalAnalyses(), other.allowedAdditionalAnalyses());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ConsolidatedPolicyCustom")
                .add("AllowedAnalyses", hasAllowedAnalyses() ? allowedAnalyses() : null)
                .add("AllowedAnalysisProviders", hasAllowedAnalysisProviders() ? allowedAnalysisProviders() : null)
                .add("AdditionalAnalyses", additionalAnalysesAsString())
                .add("DisallowedOutputColumns", hasDisallowedOutputColumns() ? disallowedOutputColumns() : null)
                .add("DifferentialPrivacy", differentialPrivacy())
                .add("AllowedResultReceivers", hasAllowedResultReceivers() ? allowedResultReceivers() : null)
                .add("AllowedAdditionalAnalyses", hasAllowedAdditionalAnalyses() ? allowedAdditionalAnalyses() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "allowedAnalyses":
            return Optional.ofNullable(clazz.cast(allowedAnalyses()));
        case "allowedAnalysisProviders":
            return Optional.ofNullable(clazz.cast(allowedAnalysisProviders()));
        case "additionalAnalyses":
            return Optional.ofNullable(clazz.cast(additionalAnalysesAsString()));
        case "disallowedOutputColumns":
            return Optional.ofNullable(clazz.cast(disallowedOutputColumns()));
        case "differentialPrivacy":
            return Optional.ofNullable(clazz.cast(differentialPrivacy()));
        case "allowedResultReceivers":
            return Optional.ofNullable(clazz.cast(allowedResultReceivers()));
        case "allowedAdditionalAnalyses":
            return Optional.ofNullable(clazz.cast(allowedAdditionalAnalyses()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("allowedAnalyses", ALLOWED_ANALYSES_FIELD);
        map.put("allowedAnalysisProviders", ALLOWED_ANALYSIS_PROVIDERS_FIELD);
        map.put("additionalAnalyses", ADDITIONAL_ANALYSES_FIELD);
        map.put("disallowedOutputColumns", DISALLOWED_OUTPUT_COLUMNS_FIELD);
        map.put("differentialPrivacy", DIFFERENTIAL_PRIVACY_FIELD);
        map.put("allowedResultReceivers", ALLOWED_RESULT_RECEIVERS_FIELD);
        map.put("allowedAdditionalAnalyses", ALLOWED_ADDITIONAL_ANALYSES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ConsolidatedPolicyCustom, T> g) {
        return obj -> g.apply((ConsolidatedPolicyCustom) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ConsolidatedPolicyCustom> {
        /**
         * <p>
         * The allowed analyses.
         * </p>
         * 
         * @param allowedAnalyses
         *        The allowed analyses.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowedAnalyses(Collection<String> allowedAnalyses);

        /**
         * <p>
         * The allowed analyses.
         * </p>
         * 
         * @param allowedAnalyses
         *        The allowed analyses.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowedAnalyses(String... allowedAnalyses);

        /**
         * <p>
         * The allowed analysis providers.
         * </p>
         * 
         * @param allowedAnalysisProviders
         *        The allowed analysis providers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowedAnalysisProviders(Collection<String> allowedAnalysisProviders);

        /**
         * <p>
         * The allowed analysis providers.
         * </p>
         * 
         * @param allowedAnalysisProviders
         *        The allowed analysis providers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowedAnalysisProviders(String... allowedAnalysisProviders);

        /**
         * <p>
         * Additional analyses for the consolidated policy.
         * </p>
         * 
         * @param additionalAnalyses
         *        Additional analyses for the consolidated policy.
         * @see AdditionalAnalyses
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AdditionalAnalyses
         */
        Builder additionalAnalyses(String additionalAnalyses);

        /**
         * <p>
         * Additional analyses for the consolidated policy.
         * </p>
         * 
         * @param additionalAnalyses
         *        Additional analyses for the consolidated policy.
         * @see AdditionalAnalyses
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AdditionalAnalyses
         */
        Builder additionalAnalyses(AdditionalAnalyses additionalAnalyses);

        /**
         * <p>
         * Disallowed output columns
         * </p>
         * 
         * @param disallowedOutputColumns
         *        Disallowed output columns
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder disallowedOutputColumns(Collection<String> disallowedOutputColumns);

        /**
         * <p>
         * Disallowed output columns
         * </p>
         * 
         * @param disallowedOutputColumns
         *        Disallowed output columns
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder disallowedOutputColumns(String... disallowedOutputColumns);

        /**
         * Sets the value of the DifferentialPrivacy property for this object.
         *
         * @param differentialPrivacy
         *        The new value for the DifferentialPrivacy property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder differentialPrivacy(DifferentialPrivacyConfiguration differentialPrivacy);

        /**
         * Sets the value of the DifferentialPrivacy property for this object.
         *
         * This is a convenience method that creates an instance of the {@link DifferentialPrivacyConfiguration.Builder}
         * avoiding the need to create one manually via {@link DifferentialPrivacyConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DifferentialPrivacyConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #differentialPrivacy(DifferentialPrivacyConfiguration)}.
         * 
         * @param differentialPrivacy
         *        a consumer that will call methods on {@link DifferentialPrivacyConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #differentialPrivacy(DifferentialPrivacyConfiguration)
         */
        default Builder differentialPrivacy(Consumer<DifferentialPrivacyConfiguration.Builder> differentialPrivacy) {
            return differentialPrivacy(DifferentialPrivacyConfiguration.builder().applyMutation(differentialPrivacy).build());
        }

        /**
         * <p>
         * The allowed result receivers.
         * </p>
         * 
         * @param allowedResultReceivers
         *        The allowed result receivers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowedResultReceivers(Collection<String> allowedResultReceivers);

        /**
         * <p>
         * The allowed result receivers.
         * </p>
         * 
         * @param allowedResultReceivers
         *        The allowed result receivers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowedResultReceivers(String... allowedResultReceivers);

        /**
         * <p>
         * The additional analyses allowed by the consolidated policy.
         * </p>
         * 
         * @param allowedAdditionalAnalyses
         *        The additional analyses allowed by the consolidated policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowedAdditionalAnalyses(Collection<String> allowedAdditionalAnalyses);

        /**
         * <p>
         * The additional analyses allowed by the consolidated policy.
         * </p>
         * 
         * @param allowedAdditionalAnalyses
         *        The additional analyses allowed by the consolidated policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowedAdditionalAnalyses(String... allowedAdditionalAnalyses);
    }

    static final class BuilderImpl implements Builder {
        private List<String> allowedAnalyses = DefaultSdkAutoConstructList.getInstance();

        private List<String> allowedAnalysisProviders = DefaultSdkAutoConstructList.getInstance();

        private String additionalAnalyses;

        private List<String> disallowedOutputColumns = DefaultSdkAutoConstructList.getInstance();

        private DifferentialPrivacyConfiguration differentialPrivacy;

        private List<String> allowedResultReceivers = DefaultSdkAutoConstructList.getInstance();

        private List<String> allowedAdditionalAnalyses = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ConsolidatedPolicyCustom model) {
            allowedAnalyses(model.allowedAnalyses);
            allowedAnalysisProviders(model.allowedAnalysisProviders);
            additionalAnalyses(model.additionalAnalyses);
            disallowedOutputColumns(model.disallowedOutputColumns);
            differentialPrivacy(model.differentialPrivacy);
            allowedResultReceivers(model.allowedResultReceivers);
            allowedAdditionalAnalyses(model.allowedAdditionalAnalyses);
        }

        public final Collection<String> getAllowedAnalyses() {
            if (allowedAnalyses instanceof SdkAutoConstructList) {
                return null;
            }
            return allowedAnalyses;
        }

        public final void setAllowedAnalyses(Collection<String> allowedAnalyses) {
            this.allowedAnalyses = ConsolidatedPolicyCustomAllowedAnalysesListCopier.copy(allowedAnalyses);
        }

        @Override
        public final Builder allowedAnalyses(Collection<String> allowedAnalyses) {
            this.allowedAnalyses = ConsolidatedPolicyCustomAllowedAnalysesListCopier.copy(allowedAnalyses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder allowedAnalyses(String... allowedAnalyses) {
            allowedAnalyses(Arrays.asList(allowedAnalyses));
            return this;
        }

        public final Collection<String> getAllowedAnalysisProviders() {
            if (allowedAnalysisProviders instanceof SdkAutoConstructList) {
                return null;
            }
            return allowedAnalysisProviders;
        }

        public final void setAllowedAnalysisProviders(Collection<String> allowedAnalysisProviders) {
            this.allowedAnalysisProviders = ConsolidatedPolicyCustomAllowedAnalysisProvidersListCopier
                    .copy(allowedAnalysisProviders);
        }

        @Override
        public final Builder allowedAnalysisProviders(Collection<String> allowedAnalysisProviders) {
            this.allowedAnalysisProviders = ConsolidatedPolicyCustomAllowedAnalysisProvidersListCopier
                    .copy(allowedAnalysisProviders);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder allowedAnalysisProviders(String... allowedAnalysisProviders) {
            allowedAnalysisProviders(Arrays.asList(allowedAnalysisProviders));
            return this;
        }

        public final String getAdditionalAnalyses() {
            return additionalAnalyses;
        }

        public final void setAdditionalAnalyses(String additionalAnalyses) {
            this.additionalAnalyses = additionalAnalyses;
        }

        @Override
        public final Builder additionalAnalyses(String additionalAnalyses) {
            this.additionalAnalyses = additionalAnalyses;
            return this;
        }

        @Override
        public final Builder additionalAnalyses(AdditionalAnalyses additionalAnalyses) {
            this.additionalAnalyses(additionalAnalyses == null ? null : additionalAnalyses.toString());
            return this;
        }

        public final Collection<String> getDisallowedOutputColumns() {
            if (disallowedOutputColumns instanceof SdkAutoConstructList) {
                return null;
            }
            return disallowedOutputColumns;
        }

        public final void setDisallowedOutputColumns(Collection<String> disallowedOutputColumns) {
            this.disallowedOutputColumns = AnalysisRuleColumnListCopier.copy(disallowedOutputColumns);
        }

        @Override
        public final Builder disallowedOutputColumns(Collection<String> disallowedOutputColumns) {
            this.disallowedOutputColumns = AnalysisRuleColumnListCopier.copy(disallowedOutputColumns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder disallowedOutputColumns(String... disallowedOutputColumns) {
            disallowedOutputColumns(Arrays.asList(disallowedOutputColumns));
            return this;
        }

        public final DifferentialPrivacyConfiguration.Builder getDifferentialPrivacy() {
            return differentialPrivacy != null ? differentialPrivacy.toBuilder() : null;
        }

        public final void setDifferentialPrivacy(DifferentialPrivacyConfiguration.BuilderImpl differentialPrivacy) {
            this.differentialPrivacy = differentialPrivacy != null ? differentialPrivacy.build() : null;
        }

        @Override
        public final Builder differentialPrivacy(DifferentialPrivacyConfiguration differentialPrivacy) {
            this.differentialPrivacy = differentialPrivacy;
            return this;
        }

        public final Collection<String> getAllowedResultReceivers() {
            if (allowedResultReceivers instanceof SdkAutoConstructList) {
                return null;
            }
            return allowedResultReceivers;
        }

        public final void setAllowedResultReceivers(Collection<String> allowedResultReceivers) {
            this.allowedResultReceivers = AllowedResultReceiversCopier.copy(allowedResultReceivers);
        }

        @Override
        public final Builder allowedResultReceivers(Collection<String> allowedResultReceivers) {
            this.allowedResultReceivers = AllowedResultReceiversCopier.copy(allowedResultReceivers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder allowedResultReceivers(String... allowedResultReceivers) {
            allowedResultReceivers(Arrays.asList(allowedResultReceivers));
            return this;
        }

        public final Collection<String> getAllowedAdditionalAnalyses() {
            if (allowedAdditionalAnalyses instanceof SdkAutoConstructList) {
                return null;
            }
            return allowedAdditionalAnalyses;
        }

        public final void setAllowedAdditionalAnalyses(Collection<String> allowedAdditionalAnalyses) {
            this.allowedAdditionalAnalyses = AllowedAdditionalAnalysesCopier.copy(allowedAdditionalAnalyses);
        }

        @Override
        public final Builder allowedAdditionalAnalyses(Collection<String> allowedAdditionalAnalyses) {
            this.allowedAdditionalAnalyses = AllowedAdditionalAnalysesCopier.copy(allowedAdditionalAnalyses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder allowedAdditionalAnalyses(String... allowedAdditionalAnalyses) {
            allowedAdditionalAnalyses(Arrays.asList(allowedAdditionalAnalyses));
            return this;
        }

        @Override
        public ConsolidatedPolicyCustom build() {
            return new ConsolidatedPolicyCustom(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
