/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cleanrooms.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Controls on the analysis specifications that can be run on a configured table.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ConsolidatedPolicyAggregation implements SdkPojo, Serializable,
        ToCopyableBuilder<ConsolidatedPolicyAggregation.Builder, ConsolidatedPolicyAggregation> {
    private static final SdkField<List<AggregateColumn>> AGGREGATE_COLUMNS_FIELD = SdkField
            .<List<AggregateColumn>> builder(MarshallingType.LIST)
            .memberName("aggregateColumns")
            .getter(getter(ConsolidatedPolicyAggregation::aggregateColumns))
            .setter(setter(Builder::aggregateColumns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("aggregateColumns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AggregateColumn> builder(MarshallingType.SDK_POJO)
                                            .constructor(AggregateColumn::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> JOIN_COLUMNS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("joinColumns")
            .getter(getter(ConsolidatedPolicyAggregation::joinColumns))
            .setter(setter(Builder::joinColumns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("joinColumns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> JOIN_REQUIRED_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("joinRequired").getter(getter(ConsolidatedPolicyAggregation::joinRequiredAsString))
            .setter(setter(Builder::joinRequired))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("joinRequired").build()).build();

    private static final SdkField<List<String>> ALLOWED_JOIN_OPERATORS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("allowedJoinOperators")
            .getter(getter(ConsolidatedPolicyAggregation::allowedJoinOperatorsAsStrings))
            .setter(setter(Builder::allowedJoinOperatorsWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("allowedJoinOperators").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> DIMENSION_COLUMNS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("dimensionColumns")
            .getter(getter(ConsolidatedPolicyAggregation::dimensionColumns))
            .setter(setter(Builder::dimensionColumns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dimensionColumns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> SCALAR_FUNCTIONS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("scalarFunctions")
            .getter(getter(ConsolidatedPolicyAggregation::scalarFunctionsAsStrings))
            .setter(setter(Builder::scalarFunctionsWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scalarFunctions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<AggregationConstraint>> OUTPUT_CONSTRAINTS_FIELD = SdkField
            .<List<AggregationConstraint>> builder(MarshallingType.LIST)
            .memberName("outputConstraints")
            .getter(getter(ConsolidatedPolicyAggregation::outputConstraints))
            .setter(setter(Builder::outputConstraints))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputConstraints").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AggregationConstraint> builder(MarshallingType.SDK_POJO)
                                            .constructor(AggregationConstraint::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> ADDITIONAL_ANALYSES_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("additionalAnalyses").getter(getter(ConsolidatedPolicyAggregation::additionalAnalysesAsString))
            .setter(setter(Builder::additionalAnalyses))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("additionalAnalyses").build())
            .build();

    private static final SdkField<List<String>> ALLOWED_RESULT_RECEIVERS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("allowedResultReceivers")
            .getter(getter(ConsolidatedPolicyAggregation::allowedResultReceivers))
            .setter(setter(Builder::allowedResultReceivers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("allowedResultReceivers").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> ALLOWED_ADDITIONAL_ANALYSES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("allowedAdditionalAnalyses")
            .getter(getter(ConsolidatedPolicyAggregation::allowedAdditionalAnalyses))
            .setter(setter(Builder::allowedAdditionalAnalyses))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("allowedAdditionalAnalyses").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AGGREGATE_COLUMNS_FIELD,
            JOIN_COLUMNS_FIELD, JOIN_REQUIRED_FIELD, ALLOWED_JOIN_OPERATORS_FIELD, DIMENSION_COLUMNS_FIELD,
            SCALAR_FUNCTIONS_FIELD, OUTPUT_CONSTRAINTS_FIELD, ADDITIONAL_ANALYSES_FIELD, ALLOWED_RESULT_RECEIVERS_FIELD,
            ALLOWED_ADDITIONAL_ANALYSES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<AggregateColumn> aggregateColumns;

    private final List<String> joinColumns;

    private final String joinRequired;

    private final List<String> allowedJoinOperators;

    private final List<String> dimensionColumns;

    private final List<String> scalarFunctions;

    private final List<AggregationConstraint> outputConstraints;

    private final String additionalAnalyses;

    private final List<String> allowedResultReceivers;

    private final List<String> allowedAdditionalAnalyses;

    private ConsolidatedPolicyAggregation(BuilderImpl builder) {
        this.aggregateColumns = builder.aggregateColumns;
        this.joinColumns = builder.joinColumns;
        this.joinRequired = builder.joinRequired;
        this.allowedJoinOperators = builder.allowedJoinOperators;
        this.dimensionColumns = builder.dimensionColumns;
        this.scalarFunctions = builder.scalarFunctions;
        this.outputConstraints = builder.outputConstraints;
        this.additionalAnalyses = builder.additionalAnalyses;
        this.allowedResultReceivers = builder.allowedResultReceivers;
        this.allowedAdditionalAnalyses = builder.allowedAdditionalAnalyses;
    }

    /**
     * For responses, this returns true if the service returned a value for the AggregateColumns property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAggregateColumns() {
        return aggregateColumns != null && !(aggregateColumns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Aggregate columns in consolidated policy aggregation.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAggregateColumns} method.
     * </p>
     * 
     * @return Aggregate columns in consolidated policy aggregation.
     */
    public final List<AggregateColumn> aggregateColumns() {
        return aggregateColumns;
    }

    /**
     * For responses, this returns true if the service returned a value for the JoinColumns property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasJoinColumns() {
        return joinColumns != null && !(joinColumns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The columns to join on.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasJoinColumns} method.
     * </p>
     * 
     * @return The columns to join on.
     */
    public final List<String> joinColumns() {
        return joinColumns;
    }

    /**
     * <p>
     * Join required
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #joinRequired} will
     * return {@link JoinRequiredOption#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #joinRequiredAsString}.
     * </p>
     * 
     * @return Join required
     * @see JoinRequiredOption
     */
    public final JoinRequiredOption joinRequired() {
        return JoinRequiredOption.fromValue(joinRequired);
    }

    /**
     * <p>
     * Join required
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #joinRequired} will
     * return {@link JoinRequiredOption#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #joinRequiredAsString}.
     * </p>
     * 
     * @return Join required
     * @see JoinRequiredOption
     */
    public final String joinRequiredAsString() {
        return joinRequired;
    }

    /**
     * <p>
     * The allowed join operators.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAllowedJoinOperators} method.
     * </p>
     * 
     * @return The allowed join operators.
     */
    public final List<JoinOperator> allowedJoinOperators() {
        return JoinOperatorsListCopier.copyStringToEnum(allowedJoinOperators);
    }

    /**
     * For responses, this returns true if the service returned a value for the AllowedJoinOperators property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAllowedJoinOperators() {
        return allowedJoinOperators != null && !(allowedJoinOperators instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The allowed join operators.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAllowedJoinOperators} method.
     * </p>
     * 
     * @return The allowed join operators.
     */
    public final List<String> allowedJoinOperatorsAsStrings() {
        return allowedJoinOperators;
    }

    /**
     * For responses, this returns true if the service returned a value for the DimensionColumns property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasDimensionColumns() {
        return dimensionColumns != null && !(dimensionColumns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The dimension columns of the consolidated policy aggregation.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDimensionColumns} method.
     * </p>
     * 
     * @return The dimension columns of the consolidated policy aggregation.
     */
    public final List<String> dimensionColumns() {
        return dimensionColumns;
    }

    /**
     * <p>
     * The scalar functions.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasScalarFunctions} method.
     * </p>
     * 
     * @return The scalar functions.
     */
    public final List<ScalarFunctions> scalarFunctions() {
        return ScalarFunctionsListCopier.copyStringToEnum(scalarFunctions);
    }

    /**
     * For responses, this returns true if the service returned a value for the ScalarFunctions property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasScalarFunctions() {
        return scalarFunctions != null && !(scalarFunctions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The scalar functions.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasScalarFunctions} method.
     * </p>
     * 
     * @return The scalar functions.
     */
    public final List<String> scalarFunctionsAsStrings() {
        return scalarFunctions;
    }

    /**
     * For responses, this returns true if the service returned a value for the OutputConstraints property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasOutputConstraints() {
        return outputConstraints != null && !(outputConstraints instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The output constraints of the consolidated policy aggregation.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasOutputConstraints} method.
     * </p>
     * 
     * @return The output constraints of the consolidated policy aggregation.
     */
    public final List<AggregationConstraint> outputConstraints() {
        return outputConstraints;
    }

    /**
     * <p>
     * Additional analyses for the consolidated policy aggregation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #additionalAnalyses} will return {@link AdditionalAnalyses#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #additionalAnalysesAsString}.
     * </p>
     * 
     * @return Additional analyses for the consolidated policy aggregation.
     * @see AdditionalAnalyses
     */
    public final AdditionalAnalyses additionalAnalyses() {
        return AdditionalAnalyses.fromValue(additionalAnalyses);
    }

    /**
     * <p>
     * Additional analyses for the consolidated policy aggregation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #additionalAnalyses} will return {@link AdditionalAnalyses#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #additionalAnalysesAsString}.
     * </p>
     * 
     * @return Additional analyses for the consolidated policy aggregation.
     * @see AdditionalAnalyses
     */
    public final String additionalAnalysesAsString() {
        return additionalAnalyses;
    }

    /**
     * For responses, this returns true if the service returned a value for the AllowedResultReceivers property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasAllowedResultReceivers() {
        return allowedResultReceivers != null && !(allowedResultReceivers instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The allowed result receivers.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAllowedResultReceivers} method.
     * </p>
     * 
     * @return The allowed result receivers.
     */
    public final List<String> allowedResultReceivers() {
        return allowedResultReceivers;
    }

    /**
     * For responses, this returns true if the service returned a value for the AllowedAdditionalAnalyses property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasAllowedAdditionalAnalyses() {
        return allowedAdditionalAnalyses != null && !(allowedAdditionalAnalyses instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The additional analyses allowed by the consolidated policy aggregation.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAllowedAdditionalAnalyses} method.
     * </p>
     * 
     * @return The additional analyses allowed by the consolidated policy aggregation.
     */
    public final List<String> allowedAdditionalAnalyses() {
        return allowedAdditionalAnalyses;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasAggregateColumns() ? aggregateColumns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasJoinColumns() ? joinColumns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(joinRequiredAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasAllowedJoinOperators() ? allowedJoinOperatorsAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasDimensionColumns() ? dimensionColumns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasScalarFunctions() ? scalarFunctionsAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasOutputConstraints() ? outputConstraints() : null);
        hashCode = 31 * hashCode + Objects.hashCode(additionalAnalysesAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasAllowedResultReceivers() ? allowedResultReceivers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasAllowedAdditionalAnalyses() ? allowedAdditionalAnalyses() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConsolidatedPolicyAggregation)) {
            return false;
        }
        ConsolidatedPolicyAggregation other = (ConsolidatedPolicyAggregation) obj;
        return hasAggregateColumns() == other.hasAggregateColumns()
                && Objects.equals(aggregateColumns(), other.aggregateColumns()) && hasJoinColumns() == other.hasJoinColumns()
                && Objects.equals(joinColumns(), other.joinColumns())
                && Objects.equals(joinRequiredAsString(), other.joinRequiredAsString())
                && hasAllowedJoinOperators() == other.hasAllowedJoinOperators()
                && Objects.equals(allowedJoinOperatorsAsStrings(), other.allowedJoinOperatorsAsStrings())
                && hasDimensionColumns() == other.hasDimensionColumns()
                && Objects.equals(dimensionColumns(), other.dimensionColumns())
                && hasScalarFunctions() == other.hasScalarFunctions()
                && Objects.equals(scalarFunctionsAsStrings(), other.scalarFunctionsAsStrings())
                && hasOutputConstraints() == other.hasOutputConstraints()
                && Objects.equals(outputConstraints(), other.outputConstraints())
                && Objects.equals(additionalAnalysesAsString(), other.additionalAnalysesAsString())
                && hasAllowedResultReceivers() == other.hasAllowedResultReceivers()
                && Objects.equals(allowedResultReceivers(), other.allowedResultReceivers())
                && hasAllowedAdditionalAnalyses() == other.hasAllowedAdditionalAnalyses()
                && Objects.equals(allowedAdditionalAnalyses(), other.allowedAdditionalAnalyses());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ConsolidatedPolicyAggregation")
                .add("AggregateColumns", hasAggregateColumns() ? aggregateColumns() : null)
                .add("JoinColumns", hasJoinColumns() ? joinColumns() : null).add("JoinRequired", joinRequiredAsString())
                .add("AllowedJoinOperators", hasAllowedJoinOperators() ? allowedJoinOperatorsAsStrings() : null)
                .add("DimensionColumns", hasDimensionColumns() ? dimensionColumns() : null)
                .add("ScalarFunctions", hasScalarFunctions() ? scalarFunctionsAsStrings() : null)
                .add("OutputConstraints", hasOutputConstraints() ? outputConstraints() : null)
                .add("AdditionalAnalyses", additionalAnalysesAsString())
                .add("AllowedResultReceivers", hasAllowedResultReceivers() ? allowedResultReceivers() : null)
                .add("AllowedAdditionalAnalyses", hasAllowedAdditionalAnalyses() ? allowedAdditionalAnalyses() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "aggregateColumns":
            return Optional.ofNullable(clazz.cast(aggregateColumns()));
        case "joinColumns":
            return Optional.ofNullable(clazz.cast(joinColumns()));
        case "joinRequired":
            return Optional.ofNullable(clazz.cast(joinRequiredAsString()));
        case "allowedJoinOperators":
            return Optional.ofNullable(clazz.cast(allowedJoinOperatorsAsStrings()));
        case "dimensionColumns":
            return Optional.ofNullable(clazz.cast(dimensionColumns()));
        case "scalarFunctions":
            return Optional.ofNullable(clazz.cast(scalarFunctionsAsStrings()));
        case "outputConstraints":
            return Optional.ofNullable(clazz.cast(outputConstraints()));
        case "additionalAnalyses":
            return Optional.ofNullable(clazz.cast(additionalAnalysesAsString()));
        case "allowedResultReceivers":
            return Optional.ofNullable(clazz.cast(allowedResultReceivers()));
        case "allowedAdditionalAnalyses":
            return Optional.ofNullable(clazz.cast(allowedAdditionalAnalyses()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("aggregateColumns", AGGREGATE_COLUMNS_FIELD);
        map.put("joinColumns", JOIN_COLUMNS_FIELD);
        map.put("joinRequired", JOIN_REQUIRED_FIELD);
        map.put("allowedJoinOperators", ALLOWED_JOIN_OPERATORS_FIELD);
        map.put("dimensionColumns", DIMENSION_COLUMNS_FIELD);
        map.put("scalarFunctions", SCALAR_FUNCTIONS_FIELD);
        map.put("outputConstraints", OUTPUT_CONSTRAINTS_FIELD);
        map.put("additionalAnalyses", ADDITIONAL_ANALYSES_FIELD);
        map.put("allowedResultReceivers", ALLOWED_RESULT_RECEIVERS_FIELD);
        map.put("allowedAdditionalAnalyses", ALLOWED_ADDITIONAL_ANALYSES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ConsolidatedPolicyAggregation, T> g) {
        return obj -> g.apply((ConsolidatedPolicyAggregation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ConsolidatedPolicyAggregation> {
        /**
         * <p>
         * Aggregate columns in consolidated policy aggregation.
         * </p>
         * 
         * @param aggregateColumns
         *        Aggregate columns in consolidated policy aggregation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder aggregateColumns(Collection<AggregateColumn> aggregateColumns);

        /**
         * <p>
         * Aggregate columns in consolidated policy aggregation.
         * </p>
         * 
         * @param aggregateColumns
         *        Aggregate columns in consolidated policy aggregation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder aggregateColumns(AggregateColumn... aggregateColumns);

        /**
         * <p>
         * Aggregate columns in consolidated policy aggregation.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.cleanrooms.model.AggregateColumn.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.cleanrooms.model.AggregateColumn#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.cleanrooms.model.AggregateColumn.Builder#build()} is called
         * immediately and its result is passed to {@link #aggregateColumns(List<AggregateColumn>)}.
         * 
         * @param aggregateColumns
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.cleanrooms.model.AggregateColumn.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #aggregateColumns(java.util.Collection<AggregateColumn>)
         */
        Builder aggregateColumns(Consumer<AggregateColumn.Builder>... aggregateColumns);

        /**
         * <p>
         * The columns to join on.
         * </p>
         * 
         * @param joinColumns
         *        The columns to join on.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder joinColumns(Collection<String> joinColumns);

        /**
         * <p>
         * The columns to join on.
         * </p>
         * 
         * @param joinColumns
         *        The columns to join on.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder joinColumns(String... joinColumns);

        /**
         * <p>
         * Join required
         * </p>
         * 
         * @param joinRequired
         *        Join required
         * @see JoinRequiredOption
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see JoinRequiredOption
         */
        Builder joinRequired(String joinRequired);

        /**
         * <p>
         * Join required
         * </p>
         * 
         * @param joinRequired
         *        Join required
         * @see JoinRequiredOption
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see JoinRequiredOption
         */
        Builder joinRequired(JoinRequiredOption joinRequired);

        /**
         * <p>
         * The allowed join operators.
         * </p>
         * 
         * @param allowedJoinOperators
         *        The allowed join operators.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowedJoinOperatorsWithStrings(Collection<String> allowedJoinOperators);

        /**
         * <p>
         * The allowed join operators.
         * </p>
         * 
         * @param allowedJoinOperators
         *        The allowed join operators.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowedJoinOperatorsWithStrings(String... allowedJoinOperators);

        /**
         * <p>
         * The allowed join operators.
         * </p>
         * 
         * @param allowedJoinOperators
         *        The allowed join operators.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowedJoinOperators(Collection<JoinOperator> allowedJoinOperators);

        /**
         * <p>
         * The allowed join operators.
         * </p>
         * 
         * @param allowedJoinOperators
         *        The allowed join operators.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowedJoinOperators(JoinOperator... allowedJoinOperators);

        /**
         * <p>
         * The dimension columns of the consolidated policy aggregation.
         * </p>
         * 
         * @param dimensionColumns
         *        The dimension columns of the consolidated policy aggregation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dimensionColumns(Collection<String> dimensionColumns);

        /**
         * <p>
         * The dimension columns of the consolidated policy aggregation.
         * </p>
         * 
         * @param dimensionColumns
         *        The dimension columns of the consolidated policy aggregation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dimensionColumns(String... dimensionColumns);

        /**
         * <p>
         * The scalar functions.
         * </p>
         * 
         * @param scalarFunctions
         *        The scalar functions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scalarFunctionsWithStrings(Collection<String> scalarFunctions);

        /**
         * <p>
         * The scalar functions.
         * </p>
         * 
         * @param scalarFunctions
         *        The scalar functions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scalarFunctionsWithStrings(String... scalarFunctions);

        /**
         * <p>
         * The scalar functions.
         * </p>
         * 
         * @param scalarFunctions
         *        The scalar functions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scalarFunctions(Collection<ScalarFunctions> scalarFunctions);

        /**
         * <p>
         * The scalar functions.
         * </p>
         * 
         * @param scalarFunctions
         *        The scalar functions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scalarFunctions(ScalarFunctions... scalarFunctions);

        /**
         * <p>
         * The output constraints of the consolidated policy aggregation.
         * </p>
         * 
         * @param outputConstraints
         *        The output constraints of the consolidated policy aggregation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputConstraints(Collection<AggregationConstraint> outputConstraints);

        /**
         * <p>
         * The output constraints of the consolidated policy aggregation.
         * </p>
         * 
         * @param outputConstraints
         *        The output constraints of the consolidated policy aggregation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputConstraints(AggregationConstraint... outputConstraints);

        /**
         * <p>
         * The output constraints of the consolidated policy aggregation.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.cleanrooms.model.AggregationConstraint.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.cleanrooms.model.AggregationConstraint#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.cleanrooms.model.AggregationConstraint.Builder#build()} is called
         * immediately and its result is passed to {@link #outputConstraints(List<AggregationConstraint>)}.
         * 
         * @param outputConstraints
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.cleanrooms.model.AggregationConstraint.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #outputConstraints(java.util.Collection<AggregationConstraint>)
         */
        Builder outputConstraints(Consumer<AggregationConstraint.Builder>... outputConstraints);

        /**
         * <p>
         * Additional analyses for the consolidated policy aggregation.
         * </p>
         * 
         * @param additionalAnalyses
         *        Additional analyses for the consolidated policy aggregation.
         * @see AdditionalAnalyses
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AdditionalAnalyses
         */
        Builder additionalAnalyses(String additionalAnalyses);

        /**
         * <p>
         * Additional analyses for the consolidated policy aggregation.
         * </p>
         * 
         * @param additionalAnalyses
         *        Additional analyses for the consolidated policy aggregation.
         * @see AdditionalAnalyses
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AdditionalAnalyses
         */
        Builder additionalAnalyses(AdditionalAnalyses additionalAnalyses);

        /**
         * <p>
         * The allowed result receivers.
         * </p>
         * 
         * @param allowedResultReceivers
         *        The allowed result receivers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowedResultReceivers(Collection<String> allowedResultReceivers);

        /**
         * <p>
         * The allowed result receivers.
         * </p>
         * 
         * @param allowedResultReceivers
         *        The allowed result receivers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowedResultReceivers(String... allowedResultReceivers);

        /**
         * <p>
         * The additional analyses allowed by the consolidated policy aggregation.
         * </p>
         * 
         * @param allowedAdditionalAnalyses
         *        The additional analyses allowed by the consolidated policy aggregation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowedAdditionalAnalyses(Collection<String> allowedAdditionalAnalyses);

        /**
         * <p>
         * The additional analyses allowed by the consolidated policy aggregation.
         * </p>
         * 
         * @param allowedAdditionalAnalyses
         *        The additional analyses allowed by the consolidated policy aggregation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowedAdditionalAnalyses(String... allowedAdditionalAnalyses);
    }

    static final class BuilderImpl implements Builder {
        private List<AggregateColumn> aggregateColumns = DefaultSdkAutoConstructList.getInstance();

        private List<String> joinColumns = DefaultSdkAutoConstructList.getInstance();

        private String joinRequired;

        private List<String> allowedJoinOperators = DefaultSdkAutoConstructList.getInstance();

        private List<String> dimensionColumns = DefaultSdkAutoConstructList.getInstance();

        private List<String> scalarFunctions = DefaultSdkAutoConstructList.getInstance();

        private List<AggregationConstraint> outputConstraints = DefaultSdkAutoConstructList.getInstance();

        private String additionalAnalyses;

        private List<String> allowedResultReceivers = DefaultSdkAutoConstructList.getInstance();

        private List<String> allowedAdditionalAnalyses = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ConsolidatedPolicyAggregation model) {
            aggregateColumns(model.aggregateColumns);
            joinColumns(model.joinColumns);
            joinRequired(model.joinRequired);
            allowedJoinOperatorsWithStrings(model.allowedJoinOperators);
            dimensionColumns(model.dimensionColumns);
            scalarFunctionsWithStrings(model.scalarFunctions);
            outputConstraints(model.outputConstraints);
            additionalAnalyses(model.additionalAnalyses);
            allowedResultReceivers(model.allowedResultReceivers);
            allowedAdditionalAnalyses(model.allowedAdditionalAnalyses);
        }

        public final List<AggregateColumn.Builder> getAggregateColumns() {
            List<AggregateColumn.Builder> result = ConsolidatedPolicyAggregationAggregateColumnsListCopier
                    .copyToBuilder(this.aggregateColumns);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAggregateColumns(Collection<AggregateColumn.BuilderImpl> aggregateColumns) {
            this.aggregateColumns = ConsolidatedPolicyAggregationAggregateColumnsListCopier.copyFromBuilder(aggregateColumns);
        }

        @Override
        public final Builder aggregateColumns(Collection<AggregateColumn> aggregateColumns) {
            this.aggregateColumns = ConsolidatedPolicyAggregationAggregateColumnsListCopier.copy(aggregateColumns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder aggregateColumns(AggregateColumn... aggregateColumns) {
            aggregateColumns(Arrays.asList(aggregateColumns));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder aggregateColumns(Consumer<AggregateColumn.Builder>... aggregateColumns) {
            aggregateColumns(Stream.of(aggregateColumns).map(c -> AggregateColumn.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getJoinColumns() {
            if (joinColumns instanceof SdkAutoConstructList) {
                return null;
            }
            return joinColumns;
        }

        public final void setJoinColumns(Collection<String> joinColumns) {
            this.joinColumns = AnalysisRuleColumnListCopier.copy(joinColumns);
        }

        @Override
        public final Builder joinColumns(Collection<String> joinColumns) {
            this.joinColumns = AnalysisRuleColumnListCopier.copy(joinColumns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder joinColumns(String... joinColumns) {
            joinColumns(Arrays.asList(joinColumns));
            return this;
        }

        public final String getJoinRequired() {
            return joinRequired;
        }

        public final void setJoinRequired(String joinRequired) {
            this.joinRequired = joinRequired;
        }

        @Override
        public final Builder joinRequired(String joinRequired) {
            this.joinRequired = joinRequired;
            return this;
        }

        @Override
        public final Builder joinRequired(JoinRequiredOption joinRequired) {
            this.joinRequired(joinRequired == null ? null : joinRequired.toString());
            return this;
        }

        public final Collection<String> getAllowedJoinOperators() {
            if (allowedJoinOperators instanceof SdkAutoConstructList) {
                return null;
            }
            return allowedJoinOperators;
        }

        public final void setAllowedJoinOperators(Collection<String> allowedJoinOperators) {
            this.allowedJoinOperators = JoinOperatorsListCopier.copy(allowedJoinOperators);
        }

        @Override
        public final Builder allowedJoinOperatorsWithStrings(Collection<String> allowedJoinOperators) {
            this.allowedJoinOperators = JoinOperatorsListCopier.copy(allowedJoinOperators);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder allowedJoinOperatorsWithStrings(String... allowedJoinOperators) {
            allowedJoinOperatorsWithStrings(Arrays.asList(allowedJoinOperators));
            return this;
        }

        @Override
        public final Builder allowedJoinOperators(Collection<JoinOperator> allowedJoinOperators) {
            this.allowedJoinOperators = JoinOperatorsListCopier.copyEnumToString(allowedJoinOperators);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder allowedJoinOperators(JoinOperator... allowedJoinOperators) {
            allowedJoinOperators(Arrays.asList(allowedJoinOperators));
            return this;
        }

        public final Collection<String> getDimensionColumns() {
            if (dimensionColumns instanceof SdkAutoConstructList) {
                return null;
            }
            return dimensionColumns;
        }

        public final void setDimensionColumns(Collection<String> dimensionColumns) {
            this.dimensionColumns = AnalysisRuleColumnListCopier.copy(dimensionColumns);
        }

        @Override
        public final Builder dimensionColumns(Collection<String> dimensionColumns) {
            this.dimensionColumns = AnalysisRuleColumnListCopier.copy(dimensionColumns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dimensionColumns(String... dimensionColumns) {
            dimensionColumns(Arrays.asList(dimensionColumns));
            return this;
        }

        public final Collection<String> getScalarFunctions() {
            if (scalarFunctions instanceof SdkAutoConstructList) {
                return null;
            }
            return scalarFunctions;
        }

        public final void setScalarFunctions(Collection<String> scalarFunctions) {
            this.scalarFunctions = ScalarFunctionsListCopier.copy(scalarFunctions);
        }

        @Override
        public final Builder scalarFunctionsWithStrings(Collection<String> scalarFunctions) {
            this.scalarFunctions = ScalarFunctionsListCopier.copy(scalarFunctions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scalarFunctionsWithStrings(String... scalarFunctions) {
            scalarFunctionsWithStrings(Arrays.asList(scalarFunctions));
            return this;
        }

        @Override
        public final Builder scalarFunctions(Collection<ScalarFunctions> scalarFunctions) {
            this.scalarFunctions = ScalarFunctionsListCopier.copyEnumToString(scalarFunctions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scalarFunctions(ScalarFunctions... scalarFunctions) {
            scalarFunctions(Arrays.asList(scalarFunctions));
            return this;
        }

        public final List<AggregationConstraint.Builder> getOutputConstraints() {
            List<AggregationConstraint.Builder> result = AggregationConstraintsCopier.copyToBuilder(this.outputConstraints);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOutputConstraints(Collection<AggregationConstraint.BuilderImpl> outputConstraints) {
            this.outputConstraints = AggregationConstraintsCopier.copyFromBuilder(outputConstraints);
        }

        @Override
        public final Builder outputConstraints(Collection<AggregationConstraint> outputConstraints) {
            this.outputConstraints = AggregationConstraintsCopier.copy(outputConstraints);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputConstraints(AggregationConstraint... outputConstraints) {
            outputConstraints(Arrays.asList(outputConstraints));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputConstraints(Consumer<AggregationConstraint.Builder>... outputConstraints) {
            outputConstraints(Stream.of(outputConstraints).map(c -> AggregationConstraint.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getAdditionalAnalyses() {
            return additionalAnalyses;
        }

        public final void setAdditionalAnalyses(String additionalAnalyses) {
            this.additionalAnalyses = additionalAnalyses;
        }

        @Override
        public final Builder additionalAnalyses(String additionalAnalyses) {
            this.additionalAnalyses = additionalAnalyses;
            return this;
        }

        @Override
        public final Builder additionalAnalyses(AdditionalAnalyses additionalAnalyses) {
            this.additionalAnalyses(additionalAnalyses == null ? null : additionalAnalyses.toString());
            return this;
        }

        public final Collection<String> getAllowedResultReceivers() {
            if (allowedResultReceivers instanceof SdkAutoConstructList) {
                return null;
            }
            return allowedResultReceivers;
        }

        public final void setAllowedResultReceivers(Collection<String> allowedResultReceivers) {
            this.allowedResultReceivers = AllowedResultReceiversCopier.copy(allowedResultReceivers);
        }

        @Override
        public final Builder allowedResultReceivers(Collection<String> allowedResultReceivers) {
            this.allowedResultReceivers = AllowedResultReceiversCopier.copy(allowedResultReceivers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder allowedResultReceivers(String... allowedResultReceivers) {
            allowedResultReceivers(Arrays.asList(allowedResultReceivers));
            return this;
        }

        public final Collection<String> getAllowedAdditionalAnalyses() {
            if (allowedAdditionalAnalyses instanceof SdkAutoConstructList) {
                return null;
            }
            return allowedAdditionalAnalyses;
        }

        public final void setAllowedAdditionalAnalyses(Collection<String> allowedAdditionalAnalyses) {
            this.allowedAdditionalAnalyses = AllowedAdditionalAnalysesCopier.copy(allowedAdditionalAnalyses);
        }

        @Override
        public final Builder allowedAdditionalAnalyses(Collection<String> allowedAdditionalAnalyses) {
            this.allowedAdditionalAnalyses = AllowedAdditionalAnalysesCopier.copy(allowedAdditionalAnalyses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder allowedAdditionalAnalyses(String... allowedAdditionalAnalyses) {
            allowedAdditionalAnalyses(Arrays.asList(allowedAdditionalAnalyses));
            return this;
        }

        @Override
        public ConsolidatedPolicyAggregation build() {
            return new ConsolidatedPolicyAggregation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
