/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cleanrooms.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configured table summary for the objects listed by the request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ConfiguredTableSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<ConfiguredTableSummary.Builder, ConfiguredTableSummary> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(ConfiguredTableSummary::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(ConfiguredTableSummary::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(ConfiguredTableSummary::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<Instant> CREATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("createTime").getter(getter(ConfiguredTableSummary::createTime)).setter(setter(Builder::createTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createTime").build()).build();

    private static final SdkField<Instant> UPDATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("updateTime").getter(getter(ConfiguredTableSummary::updateTime)).setter(setter(Builder::updateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updateTime").build()).build();

    private static final SdkField<List<String>> ANALYSIS_RULE_TYPES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("analysisRuleTypes")
            .getter(getter(ConfiguredTableSummary::analysisRuleTypesAsStrings))
            .setter(setter(Builder::analysisRuleTypesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("analysisRuleTypes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> ANALYSIS_METHOD_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("analysisMethod").getter(getter(ConfiguredTableSummary::analysisMethodAsString))
            .setter(setter(Builder::analysisMethod))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("analysisMethod").build()).build();

    private static final SdkField<List<String>> SELECTED_ANALYSIS_METHODS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("selectedAnalysisMethods")
            .getter(getter(ConfiguredTableSummary::selectedAnalysisMethodsAsStrings))
            .setter(setter(Builder::selectedAnalysisMethodsWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("selectedAnalysisMethods").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, ARN_FIELD,
            NAME_FIELD, CREATE_TIME_FIELD, UPDATE_TIME_FIELD, ANALYSIS_RULE_TYPES_FIELD, ANALYSIS_METHOD_FIELD,
            SELECTED_ANALYSIS_METHODS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String id;

    private final String arn;

    private final String name;

    private final Instant createTime;

    private final Instant updateTime;

    private final List<String> analysisRuleTypes;

    private final String analysisMethod;

    private final List<String> selectedAnalysisMethods;

    private ConfiguredTableSummary(BuilderImpl builder) {
        this.id = builder.id;
        this.arn = builder.arn;
        this.name = builder.name;
        this.createTime = builder.createTime;
        this.updateTime = builder.updateTime;
        this.analysisRuleTypes = builder.analysisRuleTypes;
        this.analysisMethod = builder.analysisMethod;
        this.selectedAnalysisMethods = builder.selectedAnalysisMethods;
    }

    /**
     * <p>
     * The unique ID of the configured table.
     * </p>
     * 
     * @return The unique ID of the configured table.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The unique ARN of the configured table.
     * </p>
     * 
     * @return The unique ARN of the configured table.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The name of the configured table.
     * </p>
     * 
     * @return The name of the configured table.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The time the configured table was created.
     * </p>
     * 
     * @return The time the configured table was created.
     */
    public final Instant createTime() {
        return createTime;
    }

    /**
     * <p>
     * The time the configured table was last updated.
     * </p>
     * 
     * @return The time the configured table was last updated.
     */
    public final Instant updateTime() {
        return updateTime;
    }

    /**
     * <p>
     * The types of analysis rules associated with this configured table.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAnalysisRuleTypes} method.
     * </p>
     * 
     * @return The types of analysis rules associated with this configured table.
     */
    public final List<ConfiguredTableAnalysisRuleType> analysisRuleTypes() {
        return ConfiguredTableAnalysisRuleTypeListCopier.copyStringToEnum(analysisRuleTypes);
    }

    /**
     * For responses, this returns true if the service returned a value for the AnalysisRuleTypes property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAnalysisRuleTypes() {
        return analysisRuleTypes != null && !(analysisRuleTypes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The types of analysis rules associated with this configured table.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAnalysisRuleTypes} method.
     * </p>
     * 
     * @return The types of analysis rules associated with this configured table.
     */
    public final List<String> analysisRuleTypesAsStrings() {
        return analysisRuleTypes;
    }

    /**
     * <p>
     * The analysis method for the configured tables.
     * </p>
     * <p>
     * <code>DIRECT_QUERY</code> allows SQL queries to be run directly on this table.
     * </p>
     * <p>
     * <code>DIRECT_JOB</code> allows PySpark jobs to be run directly on this table.
     * </p>
     * <p>
     * <code>MULTIPLE</code> allows both SQL queries and PySpark jobs to be run directly on this table.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #analysisMethod}
     * will return {@link AnalysisMethod#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #analysisMethodAsString}.
     * </p>
     * 
     * @return The analysis method for the configured tables. </p>
     *         <p>
     *         <code>DIRECT_QUERY</code> allows SQL queries to be run directly on this table.
     *         </p>
     *         <p>
     *         <code>DIRECT_JOB</code> allows PySpark jobs to be run directly on this table.
     *         </p>
     *         <p>
     *         <code>MULTIPLE</code> allows both SQL queries and PySpark jobs to be run directly on this table.
     * @see AnalysisMethod
     */
    public final AnalysisMethod analysisMethod() {
        return AnalysisMethod.fromValue(analysisMethod);
    }

    /**
     * <p>
     * The analysis method for the configured tables.
     * </p>
     * <p>
     * <code>DIRECT_QUERY</code> allows SQL queries to be run directly on this table.
     * </p>
     * <p>
     * <code>DIRECT_JOB</code> allows PySpark jobs to be run directly on this table.
     * </p>
     * <p>
     * <code>MULTIPLE</code> allows both SQL queries and PySpark jobs to be run directly on this table.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #analysisMethod}
     * will return {@link AnalysisMethod#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #analysisMethodAsString}.
     * </p>
     * 
     * @return The analysis method for the configured tables. </p>
     *         <p>
     *         <code>DIRECT_QUERY</code> allows SQL queries to be run directly on this table.
     *         </p>
     *         <p>
     *         <code>DIRECT_JOB</code> allows PySpark jobs to be run directly on this table.
     *         </p>
     *         <p>
     *         <code>MULTIPLE</code> allows both SQL queries and PySpark jobs to be run directly on this table.
     * @see AnalysisMethod
     */
    public final String analysisMethodAsString() {
        return analysisMethod;
    }

    /**
     * <p>
     * The selected analysis methods for the configured table summary.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSelectedAnalysisMethods} method.
     * </p>
     * 
     * @return The selected analysis methods for the configured table summary.
     */
    public final List<SelectedAnalysisMethod> selectedAnalysisMethods() {
        return SelectedAnalysisMethodsCopier.copyStringToEnum(selectedAnalysisMethods);
    }

    /**
     * For responses, this returns true if the service returned a value for the SelectedAnalysisMethods property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasSelectedAnalysisMethods() {
        return selectedAnalysisMethods != null && !(selectedAnalysisMethods instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The selected analysis methods for the configured table summary.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSelectedAnalysisMethods} method.
     * </p>
     * 
     * @return The selected analysis methods for the configured table summary.
     */
    public final List<String> selectedAnalysisMethodsAsStrings() {
        return selectedAnalysisMethods;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(createTime());
        hashCode = 31 * hashCode + Objects.hashCode(updateTime());
        hashCode = 31 * hashCode + Objects.hashCode(hasAnalysisRuleTypes() ? analysisRuleTypesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(analysisMethodAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasSelectedAnalysisMethods() ? selectedAnalysisMethodsAsStrings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConfiguredTableSummary)) {
            return false;
        }
        ConfiguredTableSummary other = (ConfiguredTableSummary) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(arn(), other.arn()) && Objects.equals(name(), other.name())
                && Objects.equals(createTime(), other.createTime()) && Objects.equals(updateTime(), other.updateTime())
                && hasAnalysisRuleTypes() == other.hasAnalysisRuleTypes()
                && Objects.equals(analysisRuleTypesAsStrings(), other.analysisRuleTypesAsStrings())
                && Objects.equals(analysisMethodAsString(), other.analysisMethodAsString())
                && hasSelectedAnalysisMethods() == other.hasSelectedAnalysisMethods()
                && Objects.equals(selectedAnalysisMethodsAsStrings(), other.selectedAnalysisMethodsAsStrings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ConfiguredTableSummary").add("Id", id()).add("Arn", arn()).add("Name", name())
                .add("CreateTime", createTime()).add("UpdateTime", updateTime())
                .add("AnalysisRuleTypes", hasAnalysisRuleTypes() ? analysisRuleTypesAsStrings() : null)
                .add("AnalysisMethod", analysisMethodAsString())
                .add("SelectedAnalysisMethods", hasSelectedAnalysisMethods() ? selectedAnalysisMethodsAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "createTime":
            return Optional.ofNullable(clazz.cast(createTime()));
        case "updateTime":
            return Optional.ofNullable(clazz.cast(updateTime()));
        case "analysisRuleTypes":
            return Optional.ofNullable(clazz.cast(analysisRuleTypesAsStrings()));
        case "analysisMethod":
            return Optional.ofNullable(clazz.cast(analysisMethodAsString()));
        case "selectedAnalysisMethods":
            return Optional.ofNullable(clazz.cast(selectedAnalysisMethodsAsStrings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("id", ID_FIELD);
        map.put("arn", ARN_FIELD);
        map.put("name", NAME_FIELD);
        map.put("createTime", CREATE_TIME_FIELD);
        map.put("updateTime", UPDATE_TIME_FIELD);
        map.put("analysisRuleTypes", ANALYSIS_RULE_TYPES_FIELD);
        map.put("analysisMethod", ANALYSIS_METHOD_FIELD);
        map.put("selectedAnalysisMethods", SELECTED_ANALYSIS_METHODS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ConfiguredTableSummary, T> g) {
        return obj -> g.apply((ConfiguredTableSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ConfiguredTableSummary> {
        /**
         * <p>
         * The unique ID of the configured table.
         * </p>
         * 
         * @param id
         *        The unique ID of the configured table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The unique ARN of the configured table.
         * </p>
         * 
         * @param arn
         *        The unique ARN of the configured table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The name of the configured table.
         * </p>
         * 
         * @param name
         *        The name of the configured table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The time the configured table was created.
         * </p>
         * 
         * @param createTime
         *        The time the configured table was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createTime(Instant createTime);

        /**
         * <p>
         * The time the configured table was last updated.
         * </p>
         * 
         * @param updateTime
         *        The time the configured table was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updateTime(Instant updateTime);

        /**
         * <p>
         * The types of analysis rules associated with this configured table.
         * </p>
         * 
         * @param analysisRuleTypes
         *        The types of analysis rules associated with this configured table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder analysisRuleTypesWithStrings(Collection<String> analysisRuleTypes);

        /**
         * <p>
         * The types of analysis rules associated with this configured table.
         * </p>
         * 
         * @param analysisRuleTypes
         *        The types of analysis rules associated with this configured table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder analysisRuleTypesWithStrings(String... analysisRuleTypes);

        /**
         * <p>
         * The types of analysis rules associated with this configured table.
         * </p>
         * 
         * @param analysisRuleTypes
         *        The types of analysis rules associated with this configured table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder analysisRuleTypes(Collection<ConfiguredTableAnalysisRuleType> analysisRuleTypes);

        /**
         * <p>
         * The types of analysis rules associated with this configured table.
         * </p>
         * 
         * @param analysisRuleTypes
         *        The types of analysis rules associated with this configured table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder analysisRuleTypes(ConfiguredTableAnalysisRuleType... analysisRuleTypes);

        /**
         * <p>
         * The analysis method for the configured tables.
         * </p>
         * <p>
         * <code>DIRECT_QUERY</code> allows SQL queries to be run directly on this table.
         * </p>
         * <p>
         * <code>DIRECT_JOB</code> allows PySpark jobs to be run directly on this table.
         * </p>
         * <p>
         * <code>MULTIPLE</code> allows both SQL queries and PySpark jobs to be run directly on this table.
         * </p>
         * 
         * @param analysisMethod
         *        The analysis method for the configured tables. </p>
         *        <p>
         *        <code>DIRECT_QUERY</code> allows SQL queries to be run directly on this table.
         *        </p>
         *        <p>
         *        <code>DIRECT_JOB</code> allows PySpark jobs to be run directly on this table.
         *        </p>
         *        <p>
         *        <code>MULTIPLE</code> allows both SQL queries and PySpark jobs to be run directly on this table.
         * @see AnalysisMethod
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AnalysisMethod
         */
        Builder analysisMethod(String analysisMethod);

        /**
         * <p>
         * The analysis method for the configured tables.
         * </p>
         * <p>
         * <code>DIRECT_QUERY</code> allows SQL queries to be run directly on this table.
         * </p>
         * <p>
         * <code>DIRECT_JOB</code> allows PySpark jobs to be run directly on this table.
         * </p>
         * <p>
         * <code>MULTIPLE</code> allows both SQL queries and PySpark jobs to be run directly on this table.
         * </p>
         * 
         * @param analysisMethod
         *        The analysis method for the configured tables. </p>
         *        <p>
         *        <code>DIRECT_QUERY</code> allows SQL queries to be run directly on this table.
         *        </p>
         *        <p>
         *        <code>DIRECT_JOB</code> allows PySpark jobs to be run directly on this table.
         *        </p>
         *        <p>
         *        <code>MULTIPLE</code> allows both SQL queries and PySpark jobs to be run directly on this table.
         * @see AnalysisMethod
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AnalysisMethod
         */
        Builder analysisMethod(AnalysisMethod analysisMethod);

        /**
         * <p>
         * The selected analysis methods for the configured table summary.
         * </p>
         * 
         * @param selectedAnalysisMethods
         *        The selected analysis methods for the configured table summary.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder selectedAnalysisMethodsWithStrings(Collection<String> selectedAnalysisMethods);

        /**
         * <p>
         * The selected analysis methods for the configured table summary.
         * </p>
         * 
         * @param selectedAnalysisMethods
         *        The selected analysis methods for the configured table summary.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder selectedAnalysisMethodsWithStrings(String... selectedAnalysisMethods);

        /**
         * <p>
         * The selected analysis methods for the configured table summary.
         * </p>
         * 
         * @param selectedAnalysisMethods
         *        The selected analysis methods for the configured table summary.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder selectedAnalysisMethods(Collection<SelectedAnalysisMethod> selectedAnalysisMethods);

        /**
         * <p>
         * The selected analysis methods for the configured table summary.
         * </p>
         * 
         * @param selectedAnalysisMethods
         *        The selected analysis methods for the configured table summary.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder selectedAnalysisMethods(SelectedAnalysisMethod... selectedAnalysisMethods);
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private String arn;

        private String name;

        private Instant createTime;

        private Instant updateTime;

        private List<String> analysisRuleTypes = DefaultSdkAutoConstructList.getInstance();

        private String analysisMethod;

        private List<String> selectedAnalysisMethods = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ConfiguredTableSummary model) {
            id(model.id);
            arn(model.arn);
            name(model.name);
            createTime(model.createTime);
            updateTime(model.updateTime);
            analysisRuleTypesWithStrings(model.analysisRuleTypes);
            analysisMethod(model.analysisMethod);
            selectedAnalysisMethodsWithStrings(model.selectedAnalysisMethods);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Instant getCreateTime() {
            return createTime;
        }

        public final void setCreateTime(Instant createTime) {
            this.createTime = createTime;
        }

        @Override
        public final Builder createTime(Instant createTime) {
            this.createTime = createTime;
            return this;
        }

        public final Instant getUpdateTime() {
            return updateTime;
        }

        public final void setUpdateTime(Instant updateTime) {
            this.updateTime = updateTime;
        }

        @Override
        public final Builder updateTime(Instant updateTime) {
            this.updateTime = updateTime;
            return this;
        }

        public final Collection<String> getAnalysisRuleTypes() {
            if (analysisRuleTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return analysisRuleTypes;
        }

        public final void setAnalysisRuleTypes(Collection<String> analysisRuleTypes) {
            this.analysisRuleTypes = ConfiguredTableAnalysisRuleTypeListCopier.copy(analysisRuleTypes);
        }

        @Override
        public final Builder analysisRuleTypesWithStrings(Collection<String> analysisRuleTypes) {
            this.analysisRuleTypes = ConfiguredTableAnalysisRuleTypeListCopier.copy(analysisRuleTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder analysisRuleTypesWithStrings(String... analysisRuleTypes) {
            analysisRuleTypesWithStrings(Arrays.asList(analysisRuleTypes));
            return this;
        }

        @Override
        public final Builder analysisRuleTypes(Collection<ConfiguredTableAnalysisRuleType> analysisRuleTypes) {
            this.analysisRuleTypes = ConfiguredTableAnalysisRuleTypeListCopier.copyEnumToString(analysisRuleTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder analysisRuleTypes(ConfiguredTableAnalysisRuleType... analysisRuleTypes) {
            analysisRuleTypes(Arrays.asList(analysisRuleTypes));
            return this;
        }

        public final String getAnalysisMethod() {
            return analysisMethod;
        }

        public final void setAnalysisMethod(String analysisMethod) {
            this.analysisMethod = analysisMethod;
        }

        @Override
        public final Builder analysisMethod(String analysisMethod) {
            this.analysisMethod = analysisMethod;
            return this;
        }

        @Override
        public final Builder analysisMethod(AnalysisMethod analysisMethod) {
            this.analysisMethod(analysisMethod == null ? null : analysisMethod.toString());
            return this;
        }

        public final Collection<String> getSelectedAnalysisMethods() {
            if (selectedAnalysisMethods instanceof SdkAutoConstructList) {
                return null;
            }
            return selectedAnalysisMethods;
        }

        public final void setSelectedAnalysisMethods(Collection<String> selectedAnalysisMethods) {
            this.selectedAnalysisMethods = SelectedAnalysisMethodsCopier.copy(selectedAnalysisMethods);
        }

        @Override
        public final Builder selectedAnalysisMethodsWithStrings(Collection<String> selectedAnalysisMethods) {
            this.selectedAnalysisMethods = SelectedAnalysisMethodsCopier.copy(selectedAnalysisMethods);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder selectedAnalysisMethodsWithStrings(String... selectedAnalysisMethods) {
            selectedAnalysisMethodsWithStrings(Arrays.asList(selectedAnalysisMethods));
            return this;
        }

        @Override
        public final Builder selectedAnalysisMethods(Collection<SelectedAnalysisMethod> selectedAnalysisMethods) {
            this.selectedAnalysisMethods = SelectedAnalysisMethodsCopier.copyEnumToString(selectedAnalysisMethods);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder selectedAnalysisMethods(SelectedAnalysisMethod... selectedAnalysisMethods) {
            selectedAnalysisMethods(Arrays.asList(selectedAnalysisMethods));
            return this;
        }

        @Override
        public ConfiguredTableSummary build() {
            return new ConfiguredTableSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
