/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cleanrooms.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A configured table analysis rule, which limits how data for this table can be used.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ConfiguredTableAnalysisRule implements SdkPojo, Serializable,
        ToCopyableBuilder<ConfiguredTableAnalysisRule.Builder, ConfiguredTableAnalysisRule> {
    private static final SdkField<String> CONFIGURED_TABLE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("configuredTableId").getter(getter(ConfiguredTableAnalysisRule::configuredTableId))
            .setter(setter(Builder::configuredTableId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configuredTableId").build()).build();

    private static final SdkField<String> CONFIGURED_TABLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("configuredTableArn").getter(getter(ConfiguredTableAnalysisRule::configuredTableArn))
            .setter(setter(Builder::configuredTableArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configuredTableArn").build())
            .build();

    private static final SdkField<ConfiguredTableAnalysisRulePolicy> POLICY_FIELD = SdkField
            .<ConfiguredTableAnalysisRulePolicy> builder(MarshallingType.SDK_POJO).memberName("policy")
            .getter(getter(ConfiguredTableAnalysisRule::policy)).setter(setter(Builder::policy))
            .constructor(ConfiguredTableAnalysisRulePolicy::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("policy").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(ConfiguredTableAnalysisRule::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final SdkField<Instant> CREATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("createTime").getter(getter(ConfiguredTableAnalysisRule::createTime)).setter(setter(Builder::createTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createTime").build()).build();

    private static final SdkField<Instant> UPDATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("updateTime").getter(getter(ConfiguredTableAnalysisRule::updateTime)).setter(setter(Builder::updateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updateTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFIGURED_TABLE_ID_FIELD,
            CONFIGURED_TABLE_ARN_FIELD, POLICY_FIELD, TYPE_FIELD, CREATE_TIME_FIELD, UPDATE_TIME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String configuredTableId;

    private final String configuredTableArn;

    private final ConfiguredTableAnalysisRulePolicy policy;

    private final String type;

    private final Instant createTime;

    private final Instant updateTime;

    private ConfiguredTableAnalysisRule(BuilderImpl builder) {
        this.configuredTableId = builder.configuredTableId;
        this.configuredTableArn = builder.configuredTableArn;
        this.policy = builder.policy;
        this.type = builder.type;
        this.createTime = builder.createTime;
        this.updateTime = builder.updateTime;
    }

    /**
     * <p>
     * The unique ID for the configured table.
     * </p>
     * 
     * @return The unique ID for the configured table.
     */
    public final String configuredTableId() {
        return configuredTableId;
    }

    /**
     * <p>
     * The unique ARN for the configured table.
     * </p>
     * 
     * @return The unique ARN for the configured table.
     */
    public final String configuredTableArn() {
        return configuredTableArn;
    }

    /**
     * <p>
     * The policy that controls SQL query rules.
     * </p>
     * 
     * @return The policy that controls SQL query rules.
     */
    public final ConfiguredTableAnalysisRulePolicy policy() {
        return policy;
    }

    /**
     * <p>
     * The type of configured table analysis rule.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link ConfiguredTableAnalysisRuleType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #typeAsString}.
     * </p>
     * 
     * @return The type of configured table analysis rule.
     * @see ConfiguredTableAnalysisRuleType
     */
    public final ConfiguredTableAnalysisRuleType type() {
        return ConfiguredTableAnalysisRuleType.fromValue(type);
    }

    /**
     * <p>
     * The type of configured table analysis rule.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link ConfiguredTableAnalysisRuleType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #typeAsString}.
     * </p>
     * 
     * @return The type of configured table analysis rule.
     * @see ConfiguredTableAnalysisRuleType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The time the configured table analysis rule was created.
     * </p>
     * 
     * @return The time the configured table analysis rule was created.
     */
    public final Instant createTime() {
        return createTime;
    }

    /**
     * <p>
     * The time the configured table analysis rule was last updated.
     * </p>
     * 
     * @return The time the configured table analysis rule was last updated.
     */
    public final Instant updateTime() {
        return updateTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(configuredTableId());
        hashCode = 31 * hashCode + Objects.hashCode(configuredTableArn());
        hashCode = 31 * hashCode + Objects.hashCode(policy());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(createTime());
        hashCode = 31 * hashCode + Objects.hashCode(updateTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConfiguredTableAnalysisRule)) {
            return false;
        }
        ConfiguredTableAnalysisRule other = (ConfiguredTableAnalysisRule) obj;
        return Objects.equals(configuredTableId(), other.configuredTableId())
                && Objects.equals(configuredTableArn(), other.configuredTableArn()) && Objects.equals(policy(), other.policy())
                && Objects.equals(typeAsString(), other.typeAsString()) && Objects.equals(createTime(), other.createTime())
                && Objects.equals(updateTime(), other.updateTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ConfiguredTableAnalysisRule").add("ConfiguredTableId", configuredTableId())
                .add("ConfiguredTableArn", configuredTableArn()).add("Policy", policy()).add("Type", typeAsString())
                .add("CreateTime", createTime()).add("UpdateTime", updateTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "configuredTableId":
            return Optional.ofNullable(clazz.cast(configuredTableId()));
        case "configuredTableArn":
            return Optional.ofNullable(clazz.cast(configuredTableArn()));
        case "policy":
            return Optional.ofNullable(clazz.cast(policy()));
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "createTime":
            return Optional.ofNullable(clazz.cast(createTime()));
        case "updateTime":
            return Optional.ofNullable(clazz.cast(updateTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("configuredTableId", CONFIGURED_TABLE_ID_FIELD);
        map.put("configuredTableArn", CONFIGURED_TABLE_ARN_FIELD);
        map.put("policy", POLICY_FIELD);
        map.put("type", TYPE_FIELD);
        map.put("createTime", CREATE_TIME_FIELD);
        map.put("updateTime", UPDATE_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ConfiguredTableAnalysisRule, T> g) {
        return obj -> g.apply((ConfiguredTableAnalysisRule) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ConfiguredTableAnalysisRule> {
        /**
         * <p>
         * The unique ID for the configured table.
         * </p>
         * 
         * @param configuredTableId
         *        The unique ID for the configured table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configuredTableId(String configuredTableId);

        /**
         * <p>
         * The unique ARN for the configured table.
         * </p>
         * 
         * @param configuredTableArn
         *        The unique ARN for the configured table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configuredTableArn(String configuredTableArn);

        /**
         * <p>
         * The policy that controls SQL query rules.
         * </p>
         * 
         * @param policy
         *        The policy that controls SQL query rules.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policy(ConfiguredTableAnalysisRulePolicy policy);

        /**
         * <p>
         * The policy that controls SQL query rules.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link ConfiguredTableAnalysisRulePolicy.Builder} avoiding the need to create one manually via
         * {@link ConfiguredTableAnalysisRulePolicy#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ConfiguredTableAnalysisRulePolicy.Builder#build()} is called
         * immediately and its result is passed to {@link #policy(ConfiguredTableAnalysisRulePolicy)}.
         * 
         * @param policy
         *        a consumer that will call methods on {@link ConfiguredTableAnalysisRulePolicy.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #policy(ConfiguredTableAnalysisRulePolicy)
         */
        default Builder policy(Consumer<ConfiguredTableAnalysisRulePolicy.Builder> policy) {
            return policy(ConfiguredTableAnalysisRulePolicy.builder().applyMutation(policy).build());
        }

        /**
         * <p>
         * The type of configured table analysis rule.
         * </p>
         * 
         * @param type
         *        The type of configured table analysis rule.
         * @see ConfiguredTableAnalysisRuleType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConfiguredTableAnalysisRuleType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of configured table analysis rule.
         * </p>
         * 
         * @param type
         *        The type of configured table analysis rule.
         * @see ConfiguredTableAnalysisRuleType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConfiguredTableAnalysisRuleType
         */
        Builder type(ConfiguredTableAnalysisRuleType type);

        /**
         * <p>
         * The time the configured table analysis rule was created.
         * </p>
         * 
         * @param createTime
         *        The time the configured table analysis rule was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createTime(Instant createTime);

        /**
         * <p>
         * The time the configured table analysis rule was last updated.
         * </p>
         * 
         * @param updateTime
         *        The time the configured table analysis rule was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updateTime(Instant updateTime);
    }

    static final class BuilderImpl implements Builder {
        private String configuredTableId;

        private String configuredTableArn;

        private ConfiguredTableAnalysisRulePolicy policy;

        private String type;

        private Instant createTime;

        private Instant updateTime;

        private BuilderImpl() {
        }

        private BuilderImpl(ConfiguredTableAnalysisRule model) {
            configuredTableId(model.configuredTableId);
            configuredTableArn(model.configuredTableArn);
            policy(model.policy);
            type(model.type);
            createTime(model.createTime);
            updateTime(model.updateTime);
        }

        public final String getConfiguredTableId() {
            return configuredTableId;
        }

        public final void setConfiguredTableId(String configuredTableId) {
            this.configuredTableId = configuredTableId;
        }

        @Override
        public final Builder configuredTableId(String configuredTableId) {
            this.configuredTableId = configuredTableId;
            return this;
        }

        public final String getConfiguredTableArn() {
            return configuredTableArn;
        }

        public final void setConfiguredTableArn(String configuredTableArn) {
            this.configuredTableArn = configuredTableArn;
        }

        @Override
        public final Builder configuredTableArn(String configuredTableArn) {
            this.configuredTableArn = configuredTableArn;
            return this;
        }

        public final ConfiguredTableAnalysisRulePolicy.Builder getPolicy() {
            return policy != null ? policy.toBuilder() : null;
        }

        public final void setPolicy(ConfiguredTableAnalysisRulePolicy.BuilderImpl policy) {
            this.policy = policy != null ? policy.build() : null;
        }

        @Override
        public final Builder policy(ConfiguredTableAnalysisRulePolicy policy) {
            this.policy = policy;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(ConfiguredTableAnalysisRuleType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final Instant getCreateTime() {
            return createTime;
        }

        public final void setCreateTime(Instant createTime) {
            this.createTime = createTime;
        }

        @Override
        public final Builder createTime(Instant createTime) {
            this.createTime = createTime;
            return this;
        }

        public final Instant getUpdateTime() {
            return updateTime;
        }

        public final void setUpdateTime(Instant updateTime) {
            this.updateTime = updateTime;
        }

        @Override
        public final Builder updateTime(Instant updateTime) {
            this.updateTime = updateTime;
            return this;
        }

        @Override
        public ConfiguredTableAnalysisRule build() {
            return new ConfiguredTableAnalysisRule(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
