/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cleanrooms.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents a request to modify a collaboration. Change requests enable structured modifications to collaborations
 * after they have been created.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CollaborationChangeRequest implements SdkPojo, Serializable,
        ToCopyableBuilder<CollaborationChangeRequest.Builder, CollaborationChangeRequest> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(CollaborationChangeRequest::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> COLLABORATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("collaborationId").getter(getter(CollaborationChangeRequest::collaborationId))
            .setter(setter(Builder::collaborationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("collaborationId").build()).build();

    private static final SdkField<Instant> CREATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("createTime").getter(getter(CollaborationChangeRequest::createTime)).setter(setter(Builder::createTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createTime").build()).build();

    private static final SdkField<Instant> UPDATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("updateTime").getter(getter(CollaborationChangeRequest::updateTime)).setter(setter(Builder::updateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updateTime").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(CollaborationChangeRequest::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<Boolean> IS_AUTO_APPROVED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("isAutoApproved").getter(getter(CollaborationChangeRequest::isAutoApproved))
            .setter(setter(Builder::isAutoApproved))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isAutoApproved").build()).build();

    private static final SdkField<List<Change>> CHANGES_FIELD = SdkField
            .<List<Change>> builder(MarshallingType.LIST)
            .memberName("changes")
            .getter(getter(CollaborationChangeRequest::changes))
            .setter(setter(Builder::changes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("changes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Change> builder(MarshallingType.SDK_POJO)
                                            .constructor(Change::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD,
            COLLABORATION_ID_FIELD, CREATE_TIME_FIELD, UPDATE_TIME_FIELD, STATUS_FIELD, IS_AUTO_APPROVED_FIELD, CHANGES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String id;

    private final String collaborationId;

    private final Instant createTime;

    private final Instant updateTime;

    private final String status;

    private final Boolean isAutoApproved;

    private final List<Change> changes;

    private CollaborationChangeRequest(BuilderImpl builder) {
        this.id = builder.id;
        this.collaborationId = builder.collaborationId;
        this.createTime = builder.createTime;
        this.updateTime = builder.updateTime;
        this.status = builder.status;
        this.isAutoApproved = builder.isAutoApproved;
        this.changes = builder.changes;
    }

    /**
     * <p>
     * The unique identifier for the change request.
     * </p>
     * 
     * @return The unique identifier for the change request.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The unique identifier for the collaboration being modified.
     * </p>
     * 
     * @return The unique identifier for the collaboration being modified.
     */
    public final String collaborationId() {
        return collaborationId;
    }

    /**
     * <p>
     * The time when the change request was created.
     * </p>
     * 
     * @return The time when the change request was created.
     */
    public final Instant createTime() {
        return createTime;
    }

    /**
     * <p>
     * The time when the change request was last updated.
     * </p>
     * 
     * @return The time when the change request was last updated.
     */
    public final Instant updateTime() {
        return updateTime;
    }

    /**
     * <p>
     * The current status of the change request. Valid values are <code>PENDING</code>, <code>APPROVED</code>,
     * <code>DENIED</code>, <code>COMMITTED</code>, and <code>CANCELLED</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ChangeRequestStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the change request. Valid values are <code>PENDING</code>, <code>APPROVED</code>,
     *         <code>DENIED</code>, <code>COMMITTED</code>, and <code>CANCELLED</code>.
     * @see ChangeRequestStatus
     */
    public final ChangeRequestStatus status() {
        return ChangeRequestStatus.fromValue(status);
    }

    /**
     * <p>
     * The current status of the change request. Valid values are <code>PENDING</code>, <code>APPROVED</code>,
     * <code>DENIED</code>, <code>COMMITTED</code>, and <code>CANCELLED</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ChangeRequestStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the change request. Valid values are <code>PENDING</code>, <code>APPROVED</code>,
     *         <code>DENIED</code>, <code>COMMITTED</code>, and <code>CANCELLED</code>.
     * @see ChangeRequestStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * Whether the change request was automatically approved based on the collaboration's auto-approval settings.
     * </p>
     * 
     * @return Whether the change request was automatically approved based on the collaboration's auto-approval
     *         settings.
     */
    public final Boolean isAutoApproved() {
        return isAutoApproved;
    }

    /**
     * For responses, this returns true if the service returned a value for the Changes property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasChanges() {
        return changes != null && !(changes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of changes specified in this change request.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasChanges} method.
     * </p>
     * 
     * @return The list of changes specified in this change request.
     */
    public final List<Change> changes() {
        return changes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(collaborationId());
        hashCode = 31 * hashCode + Objects.hashCode(createTime());
        hashCode = 31 * hashCode + Objects.hashCode(updateTime());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(isAutoApproved());
        hashCode = 31 * hashCode + Objects.hashCode(hasChanges() ? changes() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CollaborationChangeRequest)) {
            return false;
        }
        CollaborationChangeRequest other = (CollaborationChangeRequest) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(collaborationId(), other.collaborationId())
                && Objects.equals(createTime(), other.createTime()) && Objects.equals(updateTime(), other.updateTime())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(isAutoApproved(), other.isAutoApproved()) && hasChanges() == other.hasChanges()
                && Objects.equals(changes(), other.changes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CollaborationChangeRequest").add("Id", id()).add("CollaborationId", collaborationId())
                .add("CreateTime", createTime()).add("UpdateTime", updateTime()).add("Status", statusAsString())
                .add("IsAutoApproved", isAutoApproved()).add("Changes", hasChanges() ? changes() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "collaborationId":
            return Optional.ofNullable(clazz.cast(collaborationId()));
        case "createTime":
            return Optional.ofNullable(clazz.cast(createTime()));
        case "updateTime":
            return Optional.ofNullable(clazz.cast(updateTime()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "isAutoApproved":
            return Optional.ofNullable(clazz.cast(isAutoApproved()));
        case "changes":
            return Optional.ofNullable(clazz.cast(changes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("id", ID_FIELD);
        map.put("collaborationId", COLLABORATION_ID_FIELD);
        map.put("createTime", CREATE_TIME_FIELD);
        map.put("updateTime", UPDATE_TIME_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("isAutoApproved", IS_AUTO_APPROVED_FIELD);
        map.put("changes", CHANGES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CollaborationChangeRequest, T> g) {
        return obj -> g.apply((CollaborationChangeRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CollaborationChangeRequest> {
        /**
         * <p>
         * The unique identifier for the change request.
         * </p>
         * 
         * @param id
         *        The unique identifier for the change request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The unique identifier for the collaboration being modified.
         * </p>
         * 
         * @param collaborationId
         *        The unique identifier for the collaboration being modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder collaborationId(String collaborationId);

        /**
         * <p>
         * The time when the change request was created.
         * </p>
         * 
         * @param createTime
         *        The time when the change request was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createTime(Instant createTime);

        /**
         * <p>
         * The time when the change request was last updated.
         * </p>
         * 
         * @param updateTime
         *        The time when the change request was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updateTime(Instant updateTime);

        /**
         * <p>
         * The current status of the change request. Valid values are <code>PENDING</code>, <code>APPROVED</code>,
         * <code>DENIED</code>, <code>COMMITTED</code>, and <code>CANCELLED</code>.
         * </p>
         * 
         * @param status
         *        The current status of the change request. Valid values are <code>PENDING</code>, <code>APPROVED</code>
         *        , <code>DENIED</code>, <code>COMMITTED</code>, and <code>CANCELLED</code>.
         * @see ChangeRequestStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChangeRequestStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The current status of the change request. Valid values are <code>PENDING</code>, <code>APPROVED</code>,
         * <code>DENIED</code>, <code>COMMITTED</code>, and <code>CANCELLED</code>.
         * </p>
         * 
         * @param status
         *        The current status of the change request. Valid values are <code>PENDING</code>, <code>APPROVED</code>
         *        , <code>DENIED</code>, <code>COMMITTED</code>, and <code>CANCELLED</code>.
         * @see ChangeRequestStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChangeRequestStatus
         */
        Builder status(ChangeRequestStatus status);

        /**
         * <p>
         * Whether the change request was automatically approved based on the collaboration's auto-approval settings.
         * </p>
         * 
         * @param isAutoApproved
         *        Whether the change request was automatically approved based on the collaboration's auto-approval
         *        settings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isAutoApproved(Boolean isAutoApproved);

        /**
         * <p>
         * The list of changes specified in this change request.
         * </p>
         * 
         * @param changes
         *        The list of changes specified in this change request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder changes(Collection<Change> changes);

        /**
         * <p>
         * The list of changes specified in this change request.
         * </p>
         * 
         * @param changes
         *        The list of changes specified in this change request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder changes(Change... changes);

        /**
         * <p>
         * The list of changes specified in this change request.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.cleanrooms.model.Change.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.cleanrooms.model.Change#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.cleanrooms.model.Change.Builder#build()} is called immediately and its
         * result is passed to {@link #changes(List<Change>)}.
         * 
         * @param changes
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.cleanrooms.model.Change.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #changes(java.util.Collection<Change>)
         */
        Builder changes(Consumer<Change.Builder>... changes);
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private String collaborationId;

        private Instant createTime;

        private Instant updateTime;

        private String status;

        private Boolean isAutoApproved;

        private List<Change> changes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CollaborationChangeRequest model) {
            id(model.id);
            collaborationId(model.collaborationId);
            createTime(model.createTime);
            updateTime(model.updateTime);
            status(model.status);
            isAutoApproved(model.isAutoApproved);
            changes(model.changes);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getCollaborationId() {
            return collaborationId;
        }

        public final void setCollaborationId(String collaborationId) {
            this.collaborationId = collaborationId;
        }

        @Override
        public final Builder collaborationId(String collaborationId) {
            this.collaborationId = collaborationId;
            return this;
        }

        public final Instant getCreateTime() {
            return createTime;
        }

        public final void setCreateTime(Instant createTime) {
            this.createTime = createTime;
        }

        @Override
        public final Builder createTime(Instant createTime) {
            this.createTime = createTime;
            return this;
        }

        public final Instant getUpdateTime() {
            return updateTime;
        }

        public final void setUpdateTime(Instant updateTime) {
            this.updateTime = updateTime;
        }

        @Override
        public final Builder updateTime(Instant updateTime) {
            this.updateTime = updateTime;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ChangeRequestStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Boolean getIsAutoApproved() {
            return isAutoApproved;
        }

        public final void setIsAutoApproved(Boolean isAutoApproved) {
            this.isAutoApproved = isAutoApproved;
        }

        @Override
        public final Builder isAutoApproved(Boolean isAutoApproved) {
            this.isAutoApproved = isAutoApproved;
            return this;
        }

        public final List<Change.Builder> getChanges() {
            List<Change.Builder> result = ChangeListCopier.copyToBuilder(this.changes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setChanges(Collection<Change.BuilderImpl> changes) {
            this.changes = ChangeListCopier.copyFromBuilder(changes);
        }

        @Override
        public final Builder changes(Collection<Change> changes) {
            this.changes = ChangeListCopier.copy(changes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder changes(Change... changes) {
            changes(Arrays.asList(changes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder changes(Consumer<Change.Builder>... changes) {
            changes(Stream.of(changes).map(c -> Change.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public CollaborationChangeRequest build() {
            return new CollaborationChangeRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
