/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cleanrooms.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies a change to apply to a collaboration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ChangeInput implements SdkPojo, Serializable, ToCopyableBuilder<ChangeInput.Builder, ChangeInput> {
    private static final SdkField<String> SPECIFICATION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("specificationType").getter(getter(ChangeInput::specificationTypeAsString))
            .setter(setter(Builder::specificationType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("specificationType").build()).build();

    private static final SdkField<ChangeSpecification> SPECIFICATION_FIELD = SdkField
            .<ChangeSpecification> builder(MarshallingType.SDK_POJO).memberName("specification")
            .getter(getter(ChangeInput::specification)).setter(setter(Builder::specification))
            .constructor(ChangeSpecification::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("specification").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SPECIFICATION_TYPE_FIELD,
            SPECIFICATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String specificationType;

    private final ChangeSpecification specification;

    private ChangeInput(BuilderImpl builder) {
        this.specificationType = builder.specificationType;
        this.specification = builder.specification;
    }

    /**
     * <p>
     * The type of specification for the change. Currently supports <code>MEMBER</code> for member-related changes.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #specificationType}
     * will return {@link ChangeSpecificationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #specificationTypeAsString}.
     * </p>
     * 
     * @return The type of specification for the change. Currently supports <code>MEMBER</code> for member-related
     *         changes.
     * @see ChangeSpecificationType
     */
    public final ChangeSpecificationType specificationType() {
        return ChangeSpecificationType.fromValue(specificationType);
    }

    /**
     * <p>
     * The type of specification for the change. Currently supports <code>MEMBER</code> for member-related changes.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #specificationType}
     * will return {@link ChangeSpecificationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #specificationTypeAsString}.
     * </p>
     * 
     * @return The type of specification for the change. Currently supports <code>MEMBER</code> for member-related
     *         changes.
     * @see ChangeSpecificationType
     */
    public final String specificationTypeAsString() {
        return specificationType;
    }

    /**
     * <p>
     * The specification details for the change. The structure depends on the specification type.
     * </p>
     * 
     * @return The specification details for the change. The structure depends on the specification type.
     */
    public final ChangeSpecification specification() {
        return specification;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(specificationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(specification());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ChangeInput)) {
            return false;
        }
        ChangeInput other = (ChangeInput) obj;
        return Objects.equals(specificationTypeAsString(), other.specificationTypeAsString())
                && Objects.equals(specification(), other.specification());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ChangeInput").add("SpecificationType", specificationTypeAsString())
                .add("Specification", specification()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "specificationType":
            return Optional.ofNullable(clazz.cast(specificationTypeAsString()));
        case "specification":
            return Optional.ofNullable(clazz.cast(specification()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("specificationType", SPECIFICATION_TYPE_FIELD);
        map.put("specification", SPECIFICATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ChangeInput, T> g) {
        return obj -> g.apply((ChangeInput) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ChangeInput> {
        /**
         * <p>
         * The type of specification for the change. Currently supports <code>MEMBER</code> for member-related changes.
         * </p>
         * 
         * @param specificationType
         *        The type of specification for the change. Currently supports <code>MEMBER</code> for member-related
         *        changes.
         * @see ChangeSpecificationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChangeSpecificationType
         */
        Builder specificationType(String specificationType);

        /**
         * <p>
         * The type of specification for the change. Currently supports <code>MEMBER</code> for member-related changes.
         * </p>
         * 
         * @param specificationType
         *        The type of specification for the change. Currently supports <code>MEMBER</code> for member-related
         *        changes.
         * @see ChangeSpecificationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChangeSpecificationType
         */
        Builder specificationType(ChangeSpecificationType specificationType);

        /**
         * <p>
         * The specification details for the change. The structure depends on the specification type.
         * </p>
         * 
         * @param specification
         *        The specification details for the change. The structure depends on the specification type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder specification(ChangeSpecification specification);

        /**
         * <p>
         * The specification details for the change. The structure depends on the specification type.
         * </p>
         * This is a convenience method that creates an instance of the {@link ChangeSpecification.Builder} avoiding the
         * need to create one manually via {@link ChangeSpecification#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ChangeSpecification.Builder#build()} is called immediately and
         * its result is passed to {@link #specification(ChangeSpecification)}.
         * 
         * @param specification
         *        a consumer that will call methods on {@link ChangeSpecification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #specification(ChangeSpecification)
         */
        default Builder specification(Consumer<ChangeSpecification.Builder> specification) {
            return specification(ChangeSpecification.builder().applyMutation(specification).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String specificationType;

        private ChangeSpecification specification;

        private BuilderImpl() {
        }

        private BuilderImpl(ChangeInput model) {
            specificationType(model.specificationType);
            specification(model.specification);
        }

        public final String getSpecificationType() {
            return specificationType;
        }

        public final void setSpecificationType(String specificationType) {
            this.specificationType = specificationType;
        }

        @Override
        public final Builder specificationType(String specificationType) {
            this.specificationType = specificationType;
            return this;
        }

        @Override
        public final Builder specificationType(ChangeSpecificationType specificationType) {
            this.specificationType(specificationType == null ? null : specificationType.toString());
            return this;
        }

        public final ChangeSpecification.Builder getSpecification() {
            return specification != null ? specification.toBuilder() : null;
        }

        public final void setSpecification(ChangeSpecification.BuilderImpl specification) {
            this.specification = specification != null ? specification.build() : null;
        }

        @Override
        public final Builder specification(ChangeSpecification specification) {
            this.specification = specification;
            return this;
        }

        @Override
        public ChangeInput build() {
            return new ChangeInput(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
