/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cleanrooms.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The analysis template artifacts.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AnalysisTemplateArtifacts implements SdkPojo, Serializable,
        ToCopyableBuilder<AnalysisTemplateArtifacts.Builder, AnalysisTemplateArtifacts> {
    private static final SdkField<AnalysisTemplateArtifact> ENTRY_POINT_FIELD = SdkField
            .<AnalysisTemplateArtifact> builder(MarshallingType.SDK_POJO).memberName("entryPoint")
            .getter(getter(AnalysisTemplateArtifacts::entryPoint)).setter(setter(Builder::entryPoint))
            .constructor(AnalysisTemplateArtifact::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("entryPoint").build()).build();

    private static final SdkField<List<AnalysisTemplateArtifact>> ADDITIONAL_ARTIFACTS_FIELD = SdkField
            .<List<AnalysisTemplateArtifact>> builder(MarshallingType.LIST)
            .memberName("additionalArtifacts")
            .getter(getter(AnalysisTemplateArtifacts::additionalArtifacts))
            .setter(setter(Builder::additionalArtifacts))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("additionalArtifacts").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AnalysisTemplateArtifact> builder(MarshallingType.SDK_POJO)
                                            .constructor(AnalysisTemplateArtifact::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("roleArn").getter(getter(AnalysisTemplateArtifacts::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENTRY_POINT_FIELD,
            ADDITIONAL_ARTIFACTS_FIELD, ROLE_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final AnalysisTemplateArtifact entryPoint;

    private final List<AnalysisTemplateArtifact> additionalArtifacts;

    private final String roleArn;

    private AnalysisTemplateArtifacts(BuilderImpl builder) {
        this.entryPoint = builder.entryPoint;
        this.additionalArtifacts = builder.additionalArtifacts;
        this.roleArn = builder.roleArn;
    }

    /**
     * <p>
     * The entry point for the analysis template artifacts.
     * </p>
     * 
     * @return The entry point for the analysis template artifacts.
     */
    public final AnalysisTemplateArtifact entryPoint() {
        return entryPoint;
    }

    /**
     * For responses, this returns true if the service returned a value for the AdditionalArtifacts property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAdditionalArtifacts() {
        return additionalArtifacts != null && !(additionalArtifacts instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Additional artifacts for the analysis template.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAdditionalArtifacts} method.
     * </p>
     * 
     * @return Additional artifacts for the analysis template.
     */
    public final List<AnalysisTemplateArtifact> additionalArtifacts() {
        return additionalArtifacts;
    }

    /**
     * <p>
     * The role ARN for the analysis template artifacts.
     * </p>
     * 
     * @return The role ARN for the analysis template artifacts.
     */
    public final String roleArn() {
        return roleArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(entryPoint());
        hashCode = 31 * hashCode + Objects.hashCode(hasAdditionalArtifacts() ? additionalArtifacts() : null);
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AnalysisTemplateArtifacts)) {
            return false;
        }
        AnalysisTemplateArtifacts other = (AnalysisTemplateArtifacts) obj;
        return Objects.equals(entryPoint(), other.entryPoint()) && hasAdditionalArtifacts() == other.hasAdditionalArtifacts()
                && Objects.equals(additionalArtifacts(), other.additionalArtifacts())
                && Objects.equals(roleArn(), other.roleArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AnalysisTemplateArtifacts").add("EntryPoint", entryPoint())
                .add("AdditionalArtifacts", hasAdditionalArtifacts() ? additionalArtifacts() : null).add("RoleArn", roleArn())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "entryPoint":
            return Optional.ofNullable(clazz.cast(entryPoint()));
        case "additionalArtifacts":
            return Optional.ofNullable(clazz.cast(additionalArtifacts()));
        case "roleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("entryPoint", ENTRY_POINT_FIELD);
        map.put("additionalArtifacts", ADDITIONAL_ARTIFACTS_FIELD);
        map.put("roleArn", ROLE_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AnalysisTemplateArtifacts, T> g) {
        return obj -> g.apply((AnalysisTemplateArtifacts) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AnalysisTemplateArtifacts> {
        /**
         * <p>
         * The entry point for the analysis template artifacts.
         * </p>
         * 
         * @param entryPoint
         *        The entry point for the analysis template artifacts.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entryPoint(AnalysisTemplateArtifact entryPoint);

        /**
         * <p>
         * The entry point for the analysis template artifacts.
         * </p>
         * This is a convenience method that creates an instance of the {@link AnalysisTemplateArtifact.Builder}
         * avoiding the need to create one manually via {@link AnalysisTemplateArtifact#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AnalysisTemplateArtifact.Builder#build()} is called immediately
         * and its result is passed to {@link #entryPoint(AnalysisTemplateArtifact)}.
         * 
         * @param entryPoint
         *        a consumer that will call methods on {@link AnalysisTemplateArtifact.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #entryPoint(AnalysisTemplateArtifact)
         */
        default Builder entryPoint(Consumer<AnalysisTemplateArtifact.Builder> entryPoint) {
            return entryPoint(AnalysisTemplateArtifact.builder().applyMutation(entryPoint).build());
        }

        /**
         * <p>
         * Additional artifacts for the analysis template.
         * </p>
         * 
         * @param additionalArtifacts
         *        Additional artifacts for the analysis template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder additionalArtifacts(Collection<AnalysisTemplateArtifact> additionalArtifacts);

        /**
         * <p>
         * Additional artifacts for the analysis template.
         * </p>
         * 
         * @param additionalArtifacts
         *        Additional artifacts for the analysis template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder additionalArtifacts(AnalysisTemplateArtifact... additionalArtifacts);

        /**
         * <p>
         * Additional artifacts for the analysis template.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.cleanrooms.model.AnalysisTemplateArtifact.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.cleanrooms.model.AnalysisTemplateArtifact#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.cleanrooms.model.AnalysisTemplateArtifact.Builder#build()} is called
         * immediately and its result is passed to {@link #additionalArtifacts(List<AnalysisTemplateArtifact>)}.
         * 
         * @param additionalArtifacts
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.cleanrooms.model.AnalysisTemplateArtifact.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #additionalArtifacts(java.util.Collection<AnalysisTemplateArtifact>)
         */
        Builder additionalArtifacts(Consumer<AnalysisTemplateArtifact.Builder>... additionalArtifacts);

        /**
         * <p>
         * The role ARN for the analysis template artifacts.
         * </p>
         * 
         * @param roleArn
         *        The role ARN for the analysis template artifacts.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);
    }

    static final class BuilderImpl implements Builder {
        private AnalysisTemplateArtifact entryPoint;

        private List<AnalysisTemplateArtifact> additionalArtifacts = DefaultSdkAutoConstructList.getInstance();

        private String roleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(AnalysisTemplateArtifacts model) {
            entryPoint(model.entryPoint);
            additionalArtifacts(model.additionalArtifacts);
            roleArn(model.roleArn);
        }

        public final AnalysisTemplateArtifact.Builder getEntryPoint() {
            return entryPoint != null ? entryPoint.toBuilder() : null;
        }

        public final void setEntryPoint(AnalysisTemplateArtifact.BuilderImpl entryPoint) {
            this.entryPoint = entryPoint != null ? entryPoint.build() : null;
        }

        @Override
        public final Builder entryPoint(AnalysisTemplateArtifact entryPoint) {
            this.entryPoint = entryPoint;
            return this;
        }

        public final List<AnalysisTemplateArtifact.Builder> getAdditionalArtifacts() {
            List<AnalysisTemplateArtifact.Builder> result = AnalysisTemplateArtifactListCopier
                    .copyToBuilder(this.additionalArtifacts);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAdditionalArtifacts(Collection<AnalysisTemplateArtifact.BuilderImpl> additionalArtifacts) {
            this.additionalArtifacts = AnalysisTemplateArtifactListCopier.copyFromBuilder(additionalArtifacts);
        }

        @Override
        public final Builder additionalArtifacts(Collection<AnalysisTemplateArtifact> additionalArtifacts) {
            this.additionalArtifacts = AnalysisTemplateArtifactListCopier.copy(additionalArtifacts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder additionalArtifacts(AnalysisTemplateArtifact... additionalArtifacts) {
            additionalArtifacts(Arrays.asList(additionalArtifacts));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder additionalArtifacts(Consumer<AnalysisTemplateArtifact.Builder>... additionalArtifacts) {
            additionalArtifacts(Stream.of(additionalArtifacts)
                    .map(c -> AnalysisTemplateArtifact.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        @Override
        public AnalysisTemplateArtifacts build() {
            return new AnalysisTemplateArtifacts(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
