/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cleanrooms.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The analysis template artifact metadata.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AnalysisTemplateArtifactMetadata implements SdkPojo, Serializable,
        ToCopyableBuilder<AnalysisTemplateArtifactMetadata.Builder, AnalysisTemplateArtifactMetadata> {
    private static final SdkField<Hash> ENTRY_POINT_HASH_FIELD = SdkField.<Hash> builder(MarshallingType.SDK_POJO)
            .memberName("entryPointHash").getter(getter(AnalysisTemplateArtifactMetadata::entryPointHash))
            .setter(setter(Builder::entryPointHash)).constructor(Hash::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("entryPointHash").build()).build();

    private static final SdkField<List<Hash>> ADDITIONAL_ARTIFACT_HASHES_FIELD = SdkField
            .<List<Hash>> builder(MarshallingType.LIST)
            .memberName("additionalArtifactHashes")
            .getter(getter(AnalysisTemplateArtifactMetadata::additionalArtifactHashes))
            .setter(setter(Builder::additionalArtifactHashes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("additionalArtifactHashes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Hash> builder(MarshallingType.SDK_POJO)
                                            .constructor(Hash::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENTRY_POINT_HASH_FIELD,
            ADDITIONAL_ARTIFACT_HASHES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Hash entryPointHash;

    private final List<Hash> additionalArtifactHashes;

    private AnalysisTemplateArtifactMetadata(BuilderImpl builder) {
        this.entryPointHash = builder.entryPointHash;
        this.additionalArtifactHashes = builder.additionalArtifactHashes;
    }

    /**
     * <p>
     * The hash of the entry point for the analysis template artifact metadata.
     * </p>
     * 
     * @return The hash of the entry point for the analysis template artifact metadata.
     */
    public final Hash entryPointHash() {
        return entryPointHash;
    }

    /**
     * For responses, this returns true if the service returned a value for the AdditionalArtifactHashes property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasAdditionalArtifactHashes() {
        return additionalArtifactHashes != null && !(additionalArtifactHashes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Additional artifact hashes for the analysis template.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAdditionalArtifactHashes} method.
     * </p>
     * 
     * @return Additional artifact hashes for the analysis template.
     */
    public final List<Hash> additionalArtifactHashes() {
        return additionalArtifactHashes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(entryPointHash());
        hashCode = 31 * hashCode + Objects.hashCode(hasAdditionalArtifactHashes() ? additionalArtifactHashes() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AnalysisTemplateArtifactMetadata)) {
            return false;
        }
        AnalysisTemplateArtifactMetadata other = (AnalysisTemplateArtifactMetadata) obj;
        return Objects.equals(entryPointHash(), other.entryPointHash())
                && hasAdditionalArtifactHashes() == other.hasAdditionalArtifactHashes()
                && Objects.equals(additionalArtifactHashes(), other.additionalArtifactHashes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AnalysisTemplateArtifactMetadata").add("EntryPointHash", entryPointHash())
                .add("AdditionalArtifactHashes", hasAdditionalArtifactHashes() ? additionalArtifactHashes() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "entryPointHash":
            return Optional.ofNullable(clazz.cast(entryPointHash()));
        case "additionalArtifactHashes":
            return Optional.ofNullable(clazz.cast(additionalArtifactHashes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("entryPointHash", ENTRY_POINT_HASH_FIELD);
        map.put("additionalArtifactHashes", ADDITIONAL_ARTIFACT_HASHES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AnalysisTemplateArtifactMetadata, T> g) {
        return obj -> g.apply((AnalysisTemplateArtifactMetadata) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AnalysisTemplateArtifactMetadata> {
        /**
         * <p>
         * The hash of the entry point for the analysis template artifact metadata.
         * </p>
         * 
         * @param entryPointHash
         *        The hash of the entry point for the analysis template artifact metadata.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entryPointHash(Hash entryPointHash);

        /**
         * <p>
         * The hash of the entry point for the analysis template artifact metadata.
         * </p>
         * This is a convenience method that creates an instance of the {@link Hash.Builder} avoiding the need to create
         * one manually via {@link Hash#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Hash.Builder#build()} is called immediately and its result is
         * passed to {@link #entryPointHash(Hash)}.
         * 
         * @param entryPointHash
         *        a consumer that will call methods on {@link Hash.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #entryPointHash(Hash)
         */
        default Builder entryPointHash(Consumer<Hash.Builder> entryPointHash) {
            return entryPointHash(Hash.builder().applyMutation(entryPointHash).build());
        }

        /**
         * <p>
         * Additional artifact hashes for the analysis template.
         * </p>
         * 
         * @param additionalArtifactHashes
         *        Additional artifact hashes for the analysis template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder additionalArtifactHashes(Collection<Hash> additionalArtifactHashes);

        /**
         * <p>
         * Additional artifact hashes for the analysis template.
         * </p>
         * 
         * @param additionalArtifactHashes
         *        Additional artifact hashes for the analysis template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder additionalArtifactHashes(Hash... additionalArtifactHashes);

        /**
         * <p>
         * Additional artifact hashes for the analysis template.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.cleanrooms.model.Hash.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.cleanrooms.model.Hash#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.cleanrooms.model.Hash.Builder#build()} is called immediately and its
         * result is passed to {@link #additionalArtifactHashes(List<Hash>)}.
         * 
         * @param additionalArtifactHashes
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.cleanrooms.model.Hash.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #additionalArtifactHashes(java.util.Collection<Hash>)
         */
        Builder additionalArtifactHashes(Consumer<Hash.Builder>... additionalArtifactHashes);
    }

    static final class BuilderImpl implements Builder {
        private Hash entryPointHash;

        private List<Hash> additionalArtifactHashes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AnalysisTemplateArtifactMetadata model) {
            entryPointHash(model.entryPointHash);
            additionalArtifactHashes(model.additionalArtifactHashes);
        }

        public final Hash.Builder getEntryPointHash() {
            return entryPointHash != null ? entryPointHash.toBuilder() : null;
        }

        public final void setEntryPointHash(Hash.BuilderImpl entryPointHash) {
            this.entryPointHash = entryPointHash != null ? entryPointHash.build() : null;
        }

        @Override
        public final Builder entryPointHash(Hash entryPointHash) {
            this.entryPointHash = entryPointHash;
            return this;
        }

        public final List<Hash.Builder> getAdditionalArtifactHashes() {
            List<Hash.Builder> result = HashListCopier.copyToBuilder(this.additionalArtifactHashes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAdditionalArtifactHashes(Collection<Hash.BuilderImpl> additionalArtifactHashes) {
            this.additionalArtifactHashes = HashListCopier.copyFromBuilder(additionalArtifactHashes);
        }

        @Override
        public final Builder additionalArtifactHashes(Collection<Hash> additionalArtifactHashes) {
            this.additionalArtifactHashes = HashListCopier.copy(additionalArtifactHashes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder additionalArtifactHashes(Hash... additionalArtifactHashes) {
            additionalArtifactHashes(Arrays.asList(additionalArtifactHashes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder additionalArtifactHashes(Consumer<Hash.Builder>... additionalArtifactHashes) {
            additionalArtifactHashes(Stream.of(additionalArtifactHashes).map(c -> Hash.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public AnalysisTemplateArtifactMetadata build() {
            return new AnalysisTemplateArtifactMetadata(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
