/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cleanrooms.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Constraint on query output removing output rows that do not meet a minimum number of distinct values of a specified
 * column.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AggregationConstraint implements SdkPojo, Serializable,
        ToCopyableBuilder<AggregationConstraint.Builder, AggregationConstraint> {
    private static final SdkField<String> COLUMN_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("columnName").getter(getter(AggregationConstraint::columnName)).setter(setter(Builder::columnName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("columnName").build()).build();

    private static final SdkField<Integer> MINIMUM_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("minimum").getter(getter(AggregationConstraint::minimum)).setter(setter(Builder::minimum))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("minimum").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(AggregationConstraint::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COLUMN_NAME_FIELD,
            MINIMUM_FIELD, TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String columnName;

    private final Integer minimum;

    private final String type;

    private AggregationConstraint(BuilderImpl builder) {
        this.columnName = builder.columnName;
        this.minimum = builder.minimum;
        this.type = builder.type;
    }

    /**
     * <p>
     * Column in aggregation constraint for which there must be a minimum number of distinct values in an output row for
     * it to be in the query output.
     * </p>
     * 
     * @return Column in aggregation constraint for which there must be a minimum number of distinct values in an output
     *         row for it to be in the query output.
     */
    public final String columnName() {
        return columnName;
    }

    /**
     * <p>
     * The minimum number of distinct values that an output row must be an aggregation of. Minimum threshold of distinct
     * values for a specified column that must exist in an output row for it to be in the query output.
     * </p>
     * 
     * @return The minimum number of distinct values that an output row must be an aggregation of. Minimum threshold of
     *         distinct values for a specified column that must exist in an output row for it to be in the query output.
     */
    public final Integer minimum() {
        return minimum;
    }

    /**
     * <p>
     * The type of aggregation the constraint allows. The only valid value is currently `COUNT_DISTINCT`.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link AggregationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of aggregation the constraint allows. The only valid value is currently `COUNT_DISTINCT`.
     * @see AggregationType
     */
    public final AggregationType type() {
        return AggregationType.fromValue(type);
    }

    /**
     * <p>
     * The type of aggregation the constraint allows. The only valid value is currently `COUNT_DISTINCT`.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link AggregationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of aggregation the constraint allows. The only valid value is currently `COUNT_DISTINCT`.
     * @see AggregationType
     */
    public final String typeAsString() {
        return type;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(columnName());
        hashCode = 31 * hashCode + Objects.hashCode(minimum());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AggregationConstraint)) {
            return false;
        }
        AggregationConstraint other = (AggregationConstraint) obj;
        return Objects.equals(columnName(), other.columnName()) && Objects.equals(minimum(), other.minimum())
                && Objects.equals(typeAsString(), other.typeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AggregationConstraint").add("ColumnName", columnName()).add("Minimum", minimum())
                .add("Type", typeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "columnName":
            return Optional.ofNullable(clazz.cast(columnName()));
        case "minimum":
            return Optional.ofNullable(clazz.cast(minimum()));
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("columnName", COLUMN_NAME_FIELD);
        map.put("minimum", MINIMUM_FIELD);
        map.put("type", TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AggregationConstraint, T> g) {
        return obj -> g.apply((AggregationConstraint) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AggregationConstraint> {
        /**
         * <p>
         * Column in aggregation constraint for which there must be a minimum number of distinct values in an output row
         * for it to be in the query output.
         * </p>
         * 
         * @param columnName
         *        Column in aggregation constraint for which there must be a minimum number of distinct values in an
         *        output row for it to be in the query output.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder columnName(String columnName);

        /**
         * <p>
         * The minimum number of distinct values that an output row must be an aggregation of. Minimum threshold of
         * distinct values for a specified column that must exist in an output row for it to be in the query output.
         * </p>
         * 
         * @param minimum
         *        The minimum number of distinct values that an output row must be an aggregation of. Minimum threshold
         *        of distinct values for a specified column that must exist in an output row for it to be in the query
         *        output.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minimum(Integer minimum);

        /**
         * <p>
         * The type of aggregation the constraint allows. The only valid value is currently `COUNT_DISTINCT`.
         * </p>
         * 
         * @param type
         *        The type of aggregation the constraint allows. The only valid value is currently `COUNT_DISTINCT`.
         * @see AggregationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AggregationType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of aggregation the constraint allows. The only valid value is currently `COUNT_DISTINCT`.
         * </p>
         * 
         * @param type
         *        The type of aggregation the constraint allows. The only valid value is currently `COUNT_DISTINCT`.
         * @see AggregationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AggregationType
         */
        Builder type(AggregationType type);
    }

    static final class BuilderImpl implements Builder {
        private String columnName;

        private Integer minimum;

        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(AggregationConstraint model) {
            columnName(model.columnName);
            minimum(model.minimum);
            type(model.type);
        }

        public final String getColumnName() {
            return columnName;
        }

        public final void setColumnName(String columnName) {
            this.columnName = columnName;
        }

        @Override
        public final Builder columnName(String columnName) {
            this.columnName = columnName;
            return this;
        }

        public final Integer getMinimum() {
            return minimum;
        }

        public final void setMinimum(Integer minimum) {
            this.minimum = minimum;
        }

        @Override
        public final Builder minimum(Integer minimum) {
            this.minimum = minimum;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(AggregationType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        @Override
        public AggregationConstraint build() {
            return new AggregationConstraint(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
