/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cleanrooms.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Column in configured table that can be used in aggregate function in query.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AggregateColumn implements SdkPojo, Serializable, ToCopyableBuilder<AggregateColumn.Builder, AggregateColumn> {
    private static final SdkField<List<String>> COLUMN_NAMES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("columnNames")
            .getter(getter(AggregateColumn::columnNames))
            .setter(setter(Builder::columnNames))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("columnNames").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> FUNCTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("function").getter(getter(AggregateColumn::functionAsString)).setter(setter(Builder::function))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("function").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COLUMN_NAMES_FIELD,
            FUNCTION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<String> columnNames;

    private final String function;

    private AggregateColumn(BuilderImpl builder) {
        this.columnNames = builder.columnNames;
        this.function = builder.function;
    }

    /**
     * For responses, this returns true if the service returned a value for the ColumnNames property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasColumnNames() {
        return columnNames != null && !(columnNames instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Column names in configured table of aggregate columns.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasColumnNames} method.
     * </p>
     * 
     * @return Column names in configured table of aggregate columns.
     */
    public final List<String> columnNames() {
        return columnNames;
    }

    /**
     * <p>
     * Aggregation function that can be applied to aggregate column in query.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #function} will
     * return {@link AggregateFunctionName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #functionAsString}.
     * </p>
     * 
     * @return Aggregation function that can be applied to aggregate column in query.
     * @see AggregateFunctionName
     */
    public final AggregateFunctionName function() {
        return AggregateFunctionName.fromValue(function);
    }

    /**
     * <p>
     * Aggregation function that can be applied to aggregate column in query.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #function} will
     * return {@link AggregateFunctionName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #functionAsString}.
     * </p>
     * 
     * @return Aggregation function that can be applied to aggregate column in query.
     * @see AggregateFunctionName
     */
    public final String functionAsString() {
        return function;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasColumnNames() ? columnNames() : null);
        hashCode = 31 * hashCode + Objects.hashCode(functionAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AggregateColumn)) {
            return false;
        }
        AggregateColumn other = (AggregateColumn) obj;
        return hasColumnNames() == other.hasColumnNames() && Objects.equals(columnNames(), other.columnNames())
                && Objects.equals(functionAsString(), other.functionAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AggregateColumn").add("ColumnNames", hasColumnNames() ? columnNames() : null)
                .add("Function", functionAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "columnNames":
            return Optional.ofNullable(clazz.cast(columnNames()));
        case "function":
            return Optional.ofNullable(clazz.cast(functionAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("columnNames", COLUMN_NAMES_FIELD);
        map.put("function", FUNCTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AggregateColumn, T> g) {
        return obj -> g.apply((AggregateColumn) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AggregateColumn> {
        /**
         * <p>
         * Column names in configured table of aggregate columns.
         * </p>
         * 
         * @param columnNames
         *        Column names in configured table of aggregate columns.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder columnNames(Collection<String> columnNames);

        /**
         * <p>
         * Column names in configured table of aggregate columns.
         * </p>
         * 
         * @param columnNames
         *        Column names in configured table of aggregate columns.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder columnNames(String... columnNames);

        /**
         * <p>
         * Aggregation function that can be applied to aggregate column in query.
         * </p>
         * 
         * @param function
         *        Aggregation function that can be applied to aggregate column in query.
         * @see AggregateFunctionName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AggregateFunctionName
         */
        Builder function(String function);

        /**
         * <p>
         * Aggregation function that can be applied to aggregate column in query.
         * </p>
         * 
         * @param function
         *        Aggregation function that can be applied to aggregate column in query.
         * @see AggregateFunctionName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AggregateFunctionName
         */
        Builder function(AggregateFunctionName function);
    }

    static final class BuilderImpl implements Builder {
        private List<String> columnNames = DefaultSdkAutoConstructList.getInstance();

        private String function;

        private BuilderImpl() {
        }

        private BuilderImpl(AggregateColumn model) {
            columnNames(model.columnNames);
            function(model.function);
        }

        public final Collection<String> getColumnNames() {
            if (columnNames instanceof SdkAutoConstructList) {
                return null;
            }
            return columnNames;
        }

        public final void setColumnNames(Collection<String> columnNames) {
            this.columnNames = AggregateColumnColumnNamesListCopier.copy(columnNames);
        }

        @Override
        public final Builder columnNames(Collection<String> columnNames) {
            this.columnNames = AggregateColumnColumnNamesListCopier.copy(columnNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder columnNames(String... columnNames) {
            columnNames(Arrays.asList(columnNames));
            return this;
        }

        public final String getFunction() {
            return function;
        }

        public final void setFunction(String function) {
            this.function = function;
        }

        @Override
        public final Builder function(String function) {
            this.function = function;
            return this;
        }

        @Override
        public final Builder function(AggregateFunctionName function) {
            this.function(function == null ? null : function.toString());
            return this;
        }

        @Override
        public AggregateColumn build() {
            return new AggregateColumn(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
